
use strict;
use warnings;

use 5.008001;

use ExtUtils::MakeMaker 6.17;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Dist::Zilla configuration the way ODYNIEC does it",
  "AUTHOR" => "David Golden <dagolden\@cpan.org>, Michal Wojciechowski <odyniec\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.17"
  },
  "DISTNAME" => "Dist-Zilla-PluginBundle-ODYNIEC",
  "EXE_FILES" => [],
  "LICENSE" => "apache",
  "NAME" => "Dist::Zilla::PluginBundle::ODYNIEC",
  "PREREQ_PM" => {
    "Dist::Zilla" => 5,
    "Dist::Zilla::Plugin::Bugtracker" => "1.110",
    "Dist::Zilla::Plugin::CPANFile" => 0,
    "Dist::Zilla::Plugin::CheckChangesHasContent" => 0,
    "Dist::Zilla::Plugin::CheckExtraTests" => 0,
    "Dist::Zilla::Plugin::CheckMetaResources" => "0.001",
    "Dist::Zilla::Plugin::CheckPrereqsIndexed" => "0.002",
    "Dist::Zilla::Plugin::ContributorsFromGit" => "0.004",
    "Dist::Zilla::Plugin::CopyFilesFromBuild" => 0,
    "Dist::Zilla::Plugin::Git::NextVersion" => 0,
    "Dist::Zilla::Plugin::GithubMeta" => "0.36",
    "Dist::Zilla::Plugin::InsertCopyright" => "0.001",
    "Dist::Zilla::Plugin::MetaNoIndex" => 0,
    "Dist::Zilla::Plugin::MetaProvides::Package" => "1.14",
    "Dist::Zilla::Plugin::MinimumPerl" => 0,
    "Dist::Zilla::Plugin::OurPkgVersion" => "0.004",
    "Dist::Zilla::Plugin::PodWeaver" => 0,
    "Dist::Zilla::Plugin::ReadmeAnyFromPod" => 0,
    "Dist::Zilla::Plugin::TaskWeaver" => "0.101620",
    "Dist::Zilla::Plugin::Test::CPAN::Changes" => 0,
    "Dist::Zilla::Plugin::Test::Compile" => "2.036",
    "Dist::Zilla::Plugin::Test::MinimumVersion" => "2.000003",
    "Dist::Zilla::Plugin::Test::Perl::Critic" => 0,
    "Dist::Zilla::Plugin::Test::PodSpelling" => "2.006001",
    "Dist::Zilla::Plugin::Test::Portability" => 0,
    "Dist::Zilla::Plugin::Test::ReportPrereqs" => "0.008",
    "Dist::Zilla::Plugin::Test::Version" => 0,
    "Dist::Zilla::PluginBundle::Filter" => 0,
    "Dist::Zilla::PluginBundle::Git" => "1.121010",
    "Dist::Zilla::Role::PluginBundle::Config::Slicer" => 0,
    "Dist::Zilla::Role::PluginBundle::Easy" => 0,
    "Dist::Zilla::Role::PluginBundle::PluginRemover" => 0,
    "Moose" => "0.99",
    "Moose::Autobox" => 0,
    "Pod::Elemental::Transformer::List" => "0.101620",
    "Pod::Weaver" => 4,
    "Pod::Weaver::Config::Assembler" => 0,
    "Pod::Weaver::Plugin::WikiDoc" => 0,
    "Pod::Weaver::Section::Contributors" => "0.001",
    "Pod::Weaver::Section::Support" => "1.001",
    "Test::Portability::Files" => "0.06",
    "autodie" => "2.00",
    "namespace::autoclean" => "0.09",
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "File::Spec::Functions" => 0,
    "File::Temp" => 0,
    "File::pushd" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "List::Util" => 0,
    "Path::Tiny" => 0,
    "Test::DZil" => 0,
    "Test::More" => "0.96"
  },
  "VERSION" => "0.020",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "Dist::Zilla" => 5,
  "Dist::Zilla::Plugin::Bugtracker" => "1.110",
  "Dist::Zilla::Plugin::CPANFile" => 0,
  "Dist::Zilla::Plugin::CheckChangesHasContent" => 0,
  "Dist::Zilla::Plugin::CheckExtraTests" => 0,
  "Dist::Zilla::Plugin::CheckMetaResources" => "0.001",
  "Dist::Zilla::Plugin::CheckPrereqsIndexed" => "0.002",
  "Dist::Zilla::Plugin::ContributorsFromGit" => "0.004",
  "Dist::Zilla::Plugin::CopyFilesFromBuild" => 0,
  "Dist::Zilla::Plugin::Git::NextVersion" => 0,
  "Dist::Zilla::Plugin::GithubMeta" => "0.36",
  "Dist::Zilla::Plugin::InsertCopyright" => "0.001",
  "Dist::Zilla::Plugin::MetaNoIndex" => 0,
  "Dist::Zilla::Plugin::MetaProvides::Package" => "1.14",
  "Dist::Zilla::Plugin::MinimumPerl" => 0,
  "Dist::Zilla::Plugin::OurPkgVersion" => "0.004",
  "Dist::Zilla::Plugin::PodWeaver" => 0,
  "Dist::Zilla::Plugin::ReadmeAnyFromPod" => 0,
  "Dist::Zilla::Plugin::TaskWeaver" => "0.101620",
  "Dist::Zilla::Plugin::Test::CPAN::Changes" => 0,
  "Dist::Zilla::Plugin::Test::Compile" => "2.036",
  "Dist::Zilla::Plugin::Test::MinimumVersion" => "2.000003",
  "Dist::Zilla::Plugin::Test::Perl::Critic" => 0,
  "Dist::Zilla::Plugin::Test::PodSpelling" => "2.006001",
  "Dist::Zilla::Plugin::Test::Portability" => 0,
  "Dist::Zilla::Plugin::Test::ReportPrereqs" => "0.008",
  "Dist::Zilla::Plugin::Test::Version" => 0,
  "Dist::Zilla::PluginBundle::Filter" => 0,
  "Dist::Zilla::PluginBundle::Git" => "1.121010",
  "Dist::Zilla::Role::PluginBundle::Config::Slicer" => 0,
  "Dist::Zilla::Role::PluginBundle::Easy" => 0,
  "Dist::Zilla::Role::PluginBundle::PluginRemover" => 0,
  "ExtUtils::MakeMaker" => 0,
  "File::Spec" => 0,
  "File::Spec::Functions" => 0,
  "File::Temp" => 0,
  "File::pushd" => 0,
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "List::Util" => 0,
  "Moose" => "0.99",
  "Moose::Autobox" => 0,
  "Path::Tiny" => 0,
  "Pod::Elemental::Transformer::List" => "0.101620",
  "Pod::Weaver" => 4,
  "Pod::Weaver::Config::Assembler" => 0,
  "Pod::Weaver::Plugin::WikiDoc" => 0,
  "Pod::Weaver::Section::Contributors" => "0.001",
  "Pod::Weaver::Section::Support" => "1.001",
  "Test::DZil" => 0,
  "Test::More" => "0.96",
  "Test::Portability::Files" => "0.06",
  "autodie" => "2.00",
  "namespace::autoclean" => "0.09",
  "strict" => 0,
  "warnings" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



