#===============================================================================
#      PODNAME:  Net::IP::Identifier::Plugin::Hotmail
#     ABSTRACT:  identify Hotmail owned IP addresses
#
#       AUTHOR:  Reid Augustin (REID)
#        EMAIL:  reid@hellosix.com
#      CREATED:  Sun Oct 12 19:32:46 PDT 2014
#===============================================================================

use 5.008;
use strict;
use warnings;

package Net::IP::Identifier::Plugin::Hotmail;

use Role::Tiny::With;
with qw( Net::IP::Identifier_Role );

our $VERSION = '0.106'; # VERSION

sub new {
    my ($class, %opts) = @_;

    my $self = {};
    bless $self, (ref $class || $class);

    # List of known Hotmail IP blocks as of May 2015
    $self->ips(
        '64.4.0.0/18',
        '65.52.0.0/14',
        # extending 157.54.0.0/15 to include 157.56.0.0/14
        # extending 157.54.0.0-157.59.255.255 to include 157.60.0.0/16
        '157.54.0.0-157.60.255.255',
        '207.46.0.0/16',
        # 4 Network Blocks
    );
    return $self;
}

sub name {
    return 'Hotmail';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::IP::Identifier::Plugin::Hotmail - identify Hotmail owned IP addresses

=head1 VERSION

version 0.106

=head1 SYNOPSIS

 use Net::IP::Identifier::Plugin::Hotmail;

=head1 DESCRIPTION

Net::IP::Identifier::Plugin::Hotmail identifies Hotmail host IPs.

=head2 Methods

=over

=item new

Creates a new Net::IP::Identifier::Plugin::Hotmail object.

=back

=head1 SEE ALSO

=over

=item IP::Net

=item IP::Net::Identifier

=item IP::Net::Identifier_Role

=back

=head1 AUTHOR

Reid Augustin <reid@hellosix.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Reid Augustin.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
