#!/usr/bin/perl

use strict;
use warnings;

use Test::Deep;
use Test::More;

use FusionInventory::Agent::Tools::Solaris;

my %prtconf_tests = (
    sparc1 => {
        'Memory size' => '16384 Megabyte',
        'System Configuration' => 'Sun Microsystems  sun4u',
        'SUNW,Sun-Fire' => {
            '#size-cells' => '00000002',
            'device_type' => 'gptwo',
            'compatible' => 'SUNW,Serengeti',
            'node#' => '00000000',
            'stick-frequency' => '00bebc20',
            'banner-name' => 'Sun Fire E6900',
            'scsi-initiator-id' => '00000007',
            'idprom' => '01840014.4f4162cb.45255cf4.4162cb16.55555555.55555555.55555555.55555555',
            'clock-frequency' => '08f0d180',
            'breakpoint-trap' => '0000007f',
            'newio-addr' => '00000001'
        }
    },
    sparc2 => {
        'Memory size' => '32768 Megabytes',
        'System Configuration' => 'Sun Microsystems  sun4u',
        'SUNW,Sun-Fire-V890' => {
            'breakpoint-trap' => '0000007f',
            'packages' => {
                'SUNW,fru-device' => {},
                'terminal-emulator' => {},
                'ufs-file-system' => {},
                'SUNW,debug' => {},
                'kbd-translator' => {},
                'disk-label' => {},
                'dropins' => {
                    'source' => '/flashprom:'
                },
                'deblocker' => {},
                'hsfs-file-system' => {},
                'obp-tftp' => {},
                'SUNW,builtin-drivers' => {},
                'SUNW,i2c-ram-device' => {}
            },
            'chosen' => {
                'bootfs' => 'fff31e10',
                'bootargs' => '-v',
                'elfheader-address' => '50000000',
                'elfheader-length' => '0015c000',
                'memory' => 'fff73538',
                'stdout-#lines' => 'ffffffff',
                'stdout' => 'fff30e58',
                'mmu' => 'fff73328',
                'archive-fstype' => 'hsfs',
                'fstype' => 'ufs',
                'bootarchive' => '/ramdisk-root',
                'archfs' => 'fff30f48',
                'whoami' => '/platform/sun4u/kernel/sparcv9/unix',
                'bootpath' => '/pci@8,600000/SUNW,qlc@2/fp@0,0/disk@w21000014c34173c0,0:a',
                'impl-arch-name' => 'SUNW,Sun-Fire-V890',
                'stdin' => 'fff30f68',
                'fs-package' => 'hsfs-file-system'
            },
            'pci' => {
                '#size-cells' => '00000002',
                'device_type' => 'pci',
                'version#' => '00000007',
                'portid' => '00000009',
                'bus-range' => '00000000.00000000',
                'no-probe-list' => '0',
                'clock-frequency' => '03ef1480',
                '#interrupt-cells' => '00000001',
                'ino-bitmap' => '0000001f.00170080',
                'available' => '81000000.00000000.00000300.00000000.0000fd00.82000000.00000000.00100000.00000000.7ef00000',
                'interrupt-map-mask' => '00fff800.00000000.00000000.00000007',
                'compatible' => 'pci108e,8001',
                'implementation#' => '0000002b',
                'interrupts' => '00000032.00000030.00000031.00000034',
                'ranges' => '00000000.00000000.00000000.000007ff.e8000000.00000000.01000000.01000000.00000000.00000000.000007ff.e9000000.00000000.01000000.02000000.00000000.00000000.000007fb.00000000.00000001.00000000.03000000.00000000.00000000.000007fb.00000000.00000001.00000000',
                'interrupt-map' => '00000800.00000000.00000000.00000001.f0096a70.00000000.00000800.00000000.00000000.00000002.f0096a70.00000001.00000800.00000000.00000000.00000003.f0096a70.00000002.00000800.00000000.00000000.00000004.f0096a70.00000003.00001000.00000000.00000000.00000001.f0096a70.00000004.00001000.00000000.00000000.00000002.f0096a70.00000005.00001000.00000000.00000000.00000003.f0096a70.00000006.00001000.00000000.00000000.00000004.f0096a70.00000007',
                'slot-names' => '00000006.50434920.38005043.49203700',
                '#address-cells' => '00000003',
                'reg' => '00000400.04e00000.00000000.00018000.00000400.04c10000.00000000.00000050.000007ff.e8000000.00000000.00000100'
            },
            'idprom' => '01830003.bace77fb.07232005.ce77fb3a.00000000.00000000.00000000.00000000',
            'openprom' => {
                'client-services' => {},
                'version' => 'OBP 4.15.6 2005/01/06 04:25',
                'model' => 'SUNW,4.15.6'
            },
            'memory' => {
                'available' => '000000d1.ffada000.00000000.00028000.000000d1.ff962000.00000000.00164000.000000d1.ff916000.00000000.00048000.000000d1.ff8d4000.00000000.00002000.000000d1.ff800000.00000000.000d2000.000000d1.fa564000.00000000.04a9a000.000000d0.00000000.00000001.d16a2000.000000c0.00000000.00000002.00000000.000000b0.00000000.00000002.00000000.000000a0.00000000.00000002.00000000',
                'reg' => '000000a0.00000000.00000002.00000000.000000b0.00000000.00000002.00000000.000000c0.00000000.00000002.00000000.000000d0.00000000.00000002.00000000'
            },
            'os-io' => {
                'device_type' => 'console'
            },
            'options' => {
                'diag-script' => 'none',
                'ttyb-mode' => '9600,8,n,1,-',
                'input-device' => 'rsc-console',
                'output-device' => 'rsc-console',
                'oem-logo?' => 'false',
                'diag-passes' => '1',
                'ttya-rts-dtr-off' => 'false',
                'service-mode?' => 'false',
                'boot-device' => '/pci@8,600000/SUNW,qlc@2/fp@0,0/disk@w21000014c34173c0,0:a',
                'screen-#columns' => '80',
                'load-base' => '16384',
                'verbosity' => 'normal',
                'auto-boot-on-error?' => 'true',
                'screen-#rows' => '34',
                'error-reset-recovery' => 'sync',
                'diag-level' => 'off',
                'diag-out-console' => 'true',
                'auto-boot?' => 'true',
                'security-#badlogins' => '0',
                'ttyb-rts-dtr-off' => 'false',
                'oem-banner?' => 'false',
                'diag-trigger' => 'none',
                'security-mode' => 'none',
                'fcode-debug?' => 'false',
                'ttyb-ignore-cd' => 'true',
                'use-nvramrc?' => 'false',
                'scsi-initiator-id' => '7',
                'diag-device' => 'net',
                'ansi-terminal?' => 'true',
                'boot-command' => 'boot',
                'ttya-mode' => '9600,8,n,1,-',
                'ttya-ignore-cd' => 'true',
                'local-mac-address?' => 'false',
                'diag-switch?' => 'false'
            },
            'banner-name' => 'Sun Fire V890',
            'virtual-memory' => {
                'existing' => '00000000.00000000.00000800.00000000.fffff800.00000000.00000800.00000000',
                'available' => 'fffff800.00000000.000007fc.00000000.00000700.26400000.000000ff.d9c00000.00000300.0191a000.000003ff.fe6e6000.00000300.00800000.00000000.00800000.00000300.00538000.00000000.00010000.00000300.004d6000.00000000.00028000.00000300.00496000.00000000.0003c000.00000300.003da000.00000000.0003e000.00000300.00352000.00000000.00004000.00000300.00316000.00000000.00012000.00000300.0003c000.00000000.00006000.00000001.00000000.000002ff.00002000.00000000.ffff0000.00000000.0000e000.00000000.70224000.00000000.7fddc000.00000000.03840000.00000000.6c7c0000.00000000.01c00000.00000000.00400000.00000000.01400000.00000000.00400000.00000000.00000000.00000000.01000000.00000000.fff24000.00000000.00002000.00000000.fff20000.00000000.00002000.00000000.fff14000.00000000.00008000.00000000.fef6a000.00000000.00002000.00000000.fef50000.00000000.00002000.00000000.fef36000.00000000.00002000.00000000.fecfc000.00000000.00020000.00000000.f0800000.00000000.0e4bc000',
                'page-size' => '00002000',
                'translations' => '00000000.00002000.00000000.009fe000.800000a0.00002036.00000000.01000000.00000000.00400000.800000d1.ff400036.00000000.01800000.00000000.00400000.800000d1.ff000036.00000000.02000000.00000000.01000000.800000d1.f9000036.00000000.03000000.00000000.00040000.800000d1.fa500036.00000000.03040000.00000000.00800000.800000d1.f8800036.00000000.70000000.00000000.00002000.800000d1.fa4ce036.00000000.70002000.00000000.00002000.800000d1.fa000036.00000000.70004000.00000000.0000c000.800000d1.fa54c036.00000000.70010000.00000000.00002000.800000d1.fa236036.00000000.70012000.00000000.0007c000.800000d1.fa0a2036.00000000.7008e000.00000000.00004000.800000d1.fa092036.00000000.70092000.00000000.00006000.800000d1.fa084036.00000000.70098000.00000000.00026000.800000d1.d1e2a036.00000000.700be000.00000000.0000a000.800000d1.d1e08036.00000000.700c8000.00000000.0000e000.800000d1.d1dc0036.00000000.700d6000.00000000.00014000.800000d1.d1d6e036.00000000.700ea000.00000000.00008000.800000d1.d1d66036.00000000.700f2000.00000000.0000c000.800000d1.d1d2e036.00000000.700fe000.00000000.00016000.800000d1.d1ce2036.00000000.70114000.00000000.000c6000.800000d1.d1c0c036.00000000.701da000.00000000.0003a000.800000d1.d1b98036.00000000.70214000.00000000.00010000.800000d1.d1b76036.00000000.f0000000.00000000.00400000.800000d1.ffc000b6.00000000.fecbc000.00000000.00002000.800000d1.fa5600b6.00000000.fecbe000.00000000.0003e000.800000d1.ff8d60b6.00000000.fed1c000.00000000.00200000.800007fc.7d00008e.00000000.fef1c000.00000000.00002000.800007ff.e800008e.00000000.fef1e000.00000000.00004000.800000d1.ffb2c0b6.00000000.fef22000.00000000.00002000.80000400.04c0008e.00000000.fef24000.00000000.00002000.80000400.04c1008e.00000000.fef26000.00000000.00010000.80000400.04e0008e.00000000.fef38000.00000000.00004000.800000d1.ffb300b6.00000000.fef3c000.00000000.00002000.80000400.04c0008e.00000000.fef3e000.00000000.00002000.80000400.04c1008e.00000000.fef40000.00000000.00010000.80000400.04f0008e.00000000.fef52000.00000000.00004000.800000d1.ffb340b6.00000000.fef56000.00000000.00002000.80000400.0440008e.00000000.fef58000.00000000.00002000.80000400.0441008e.00000000.fef5a000.00000000.00010000.80000400.0460008e.00000000.fef6c000.00000000.00004000.800000d1.ffb380b6.00000000.fef70000.00000000.00090000.800000d1.ffb580b6.00000000.fff00000.00000000.00002000.80000400.0440008e.00000000.fff02000.00000000.00002000.80000400.0441008e.00000000.fff04000.00000000.00010000.80000400.0470008e.00000000.fff1c000.00000000.00002000.800000d1.ffb460b6.00000000.fff1e000.00000000.00002000.800000d1.ffb4a0b6.00000000.fff22000.00000000.00002000.800007fc.7e30808e.00000000.fff26000.00000000.0000c000.800000d1.ffb120b6.00000000.fff32000.00000000.00008000.800000d1.ffb200b6.00000000.fff3a000.00000000.00002000.800007ff.ee00008e.00000000.fff3c000.00000000.00002000.800000d1.ffb280b6.00000000.fff3e000.00000000.00002000.800007fc.7e30008e.00000000.fff40000.00000000.00002000.800007fc.7e50008e.00000000.fff42000.00000000.00002000.800007fc.7e50008e.00000000.fff44000.00000000.00002000.800007fc.7e50008e.00000000.fff46000.00000000.00002000.800007fc.7e50008e.00000000.fff48000.00000000.00002000.800000d1.ffb2a0b6.00000000.fff4a000.00000000.00002000.800007fc.7e00008e.00000000.fff4c000.00000000.00002000.800007fc.7e00008e.00000000.fff4e000.00000000.00002000.800000d1.ffb3c0b6.00000000.fff50000.00000000.00002000.800007fc.7e00008e.00000000.fff52000.00000000.00002000.800007fc.7e30008e.00000000.fff54000.00000000.00002000.800007ff.ec00008e.00000000.fff56000.00000000.00002000.800007fc.7e30008e.00000000.fff58000.00000000.00002000.800007fc.7e00008e.00000000.fff5a000.00000000.00002000.800000d1.ffb420b6.00000000.fff5c000.00000000.00002000.800007ff.ea00008e.00000000.fff5e000.00000000.00002000.800000d1.ffb3e0b6.00000000.fff64000.00000000.00002000.800000d1.feffe0b6.00000000.fff66000.00000000.0000a000.800000d1.ffb4c0b6.00000000.fff70000.00000000.00010000.800000d1.ffbf00b6.00000300.00002000.00000000.00002000.800000d1.fa54a036.00000300.00004000.00000000.00002000.800000d1.fa544036.00000300.00006000.00000000.00002000.800000d1.fa542036.00000300.00008000.00000000.00002000.800000d1.fa540036.00000300.0000a000.00000000.00002000.800000d1.fa4fe036.00000300.0000c000.00000000.00004000.800000d1.fa4fa036.00000300.00010000.00000000.00004000.800000d1.fa4ec036.00000300.00014000.00000000.00004000.800000d1.fa4de036.00000300.00018000.00000000.00002000.800000d1.fa4d0036.00000300.0001a000.00000000.00002000.800000d1.fa4ca036.00000300.0001c000.00000000.00002000.800000d1.fa4c8036.00000300.0001e000.00000000.00002000.800000d1.fa3c0036.00000300.00020000.00000000.00002000.800000d1.fa38e036.00000300.00022000.00000000.00002000.800000d1.fa382036.00000300.00024000.00000000.00002000.800000d1.fa380036.00000300.00026000.00000000.00002000.800000d1.fa37c036.00000300.00028000.00000000.00002000.800000d1.fa362036.00000300.0002a000.00000000.00002000.800000d1.fa354036.00000300.0002c000.00000000.00002000.800000d1.fa1a4036.00000300.0002e000.00000000.00002000.800000d1.fa1a0036.00000300.00030000.00000000.00002000.800000d1.fa09e036.00000300.00032000.00000000.00002000.800000d1.fa09c036.00000300.00034000.00000000.00002000.800000d1.fa008036.00000300.00036000.00000000.00002000.800000d1.d1d00036.00000300.00038000.00000000.00002000.800000d1.d16a6036.00000300.0003a000.00000000.00002000.800000d1.d16a2036.00000300.00042000.00000000.00002000.800000d1.fa4f8036.00000300.00044000.00000000.00002000.800000d1.fa4f6036.00000300.00046000.00000000.00002000.800000d1.fa4f4036.00000300.00048000.00000000.00002000.800000d1.fa4f2036.00000300.0004a000.00000000.00002000.800000d1.fa4f0036.00000300.0004c000.00000000.00002000.800000d1.fa4ea036.00000300.0004e000.00000000.00002000.800000d1.fa4e8036.00000300.00050000.00000000.00002000.800000d1.fa4e6036.00000300.00052000.00000000.00002000.800000d1.fa4e4036.00000300.00054000.00000000.00002000.800000d1.fa4e2036.00000300.00056000.00000000.00002000.800000d1.fa4dc036.00000300.00058000.00000000.00002000.800000d1.fa4da036.00000300.0005a000.00000000.00002000.800000d1.fa4d8036.00000300.0005c000.00000000.00002000.800000d1.fa4d6036.00000300.0005e000.00000000.00002000.800000d1.fa4d4036.00000300.00060000.00000000.00002000.800000d1.fa4d2036.00000300.00062000.00000000.00002000.800000d1.fa3c4036.00000300.00064000.00000000.00002000.800000d1.fa3c2036.00000300.00066000.00000000.00002000.800000d1.fa3be036.00000300.00068000.00000000.00002000.800000d1.fa3bc036.00000300.0006a000.00000000.00002000.800000d1.fa3ba036.00000300.0006c000.00000000.00002000.800000d1.fa396036.00000300.0006e000.00000000.00002000.800000d1.fa394036.00000300.00070000.00000000.00002000.800000d1.fa38a036.00000300.00072000.00000000.00002000.800000d1.fa37a036.00000300.00074000.00000000.00002000.800000d1.fa378036.00000300.00076000.00000000.00002000.800000d1.fa36c036.00000300.00078000.00000000.00002000.800000d1.fa368036.00000300.0007a000.00000000.00002000.800000d1.fa366036.00000300.0007c000.00000000.00002000.800000d1.fa314036.00000300.0007e000.00000000.00002000.800000d1.fa1a8036.00000300.00080000.00000000.00002000.800000d1.fa1a2036.00000300.00082000.00000000.00002000.800000d1.fa4cc036.00000300.00084000.00000000.00002000.800000d1.fa4c6036.00000300.00086000.00000000.00080000.800000d1.fa446036.00000300.00106000.00000000.00080000.800000d1.fa3c6036.00000300.00186000.00000000.00002000.800000d1.fa356036.00000300.00188000.00000000.00002000.800000d1.fa364036.00000300.0018a000.00000000.00002000.800000d1.fa36a036.00000300.0018c000.00000000.0000a000.800000d1.fa36e036.00000300.00196000.00000000.00002000.800000d1.fa37e036.00000300.00198000.00000000.00006000.800000d1.fa384036.00000300.0019e000.00000000.00002000.800000d1.fa38c036.00000300.001a0000.00000000.00004000.800000d1.fa390036.00000300.001a4000.00000000.00022000.800000d1.fa398036.00000300.001c6000.00000000.0000a000.800000d1.fa358036.00000300.001d0000.00000000.00016000.800000d1.fa034036.00000300.001e6000.00000000.00004000.800000d1.fa050036.00000300.001ea000.00000000.00004000.800000d1.fa05a036.00000300.001ee000.00000000.00002000.800000d1.fa06e036.00000300.001f0000.00000000.00002000.800000d1.fa082036.00000300.001f2000.00000000.00002000.800000d1.fa09a036.00000300.001f4000.00000000.00002000.800000d1.fa0a0036.00000300.001f6000.00000000.00002000.800000d1.fa1a6036.00000300.001f8000.00000000.0000a000.800000d1.fa22c036.00000300.00202000.00000000.00004000.800000d1.fa238036.00000300.00206000.00000000.00008000.800000d1.fa242036.00000300.0020e000.00000000.00002000.800000d1.fa352036.00000300.00210000.00000000.0003c000.800000d1.fa316036.00000300.0024c000.00000000.00010000.800000d1.fa304036.00000300.0025c000.00000000.0005a000.800000d1.fa2aa036.00000300.002b6000.00000000.00048000.800000d1.fa262036.00000300.002fe000.00000000.00008000.800000d1.fa25a036.00000300.00306000.00000000.00006000.800000d1.fa254036.00000300.0030c000.00000000.0000a000.800000d1.fa24a036.00000300.00328000.00000000.00006000.800000d1.d1b42036.00000300.0032e000.00000000.00006000.800000d1.d1b4a036.00000300.00334000.00000000.0000c000.800000d1.d1dac036.00000300.00340000.00000000.0000c000.800000d1.fa076036.00000300.0034c000.00000000.00006000.800000d1.fa23c036.00000300.00356000.00000000.00082000.800000d1.fa1aa036.00000300.003d8000.00000000.00002000.800000d1.fa19e036.00000300.00418000.00000000.00002000.800000d1.fa19c036.00000300.0041a000.00000000.0007c000.800000d1.fa11e036.00000300.004d2000.00000000.00004000.800000d1.fa096036.00000300.004fe000.00000000.00008000.800000d1.d1d48036.00000300.00506000.00000000.00008000.800000d1.d1db8036.00000300.0050e000.00000000.00008000.800000d1.fa08a036.00000300.00516000.00000000.00006000.800000d1.fa070036.00000300.0051c000.00000000.00008000.800000d1.fa066036.00000300.00524000.00000000.00002000.800000d1.fa064036.00000300.00526000.00000000.00006000.800000d1.fa05e036.00000300.0052c000.00000000.00006000.800000d1.fa054036.00000300.00532000.00000000.00006000.800000d1.fa04a036.00000300.00548000.00000000.00004000.800000d1.d1b3e036.00000300.0054c000.00000000.00002000.800000d1.d1b48036.00000300.0054e000.00000000.00002000.800000d1.d1b62036.00000300.00550000.00000000.00002000.800000d1.d1ce0036.00000300.00552000.00000000.00002000.800000d1.d1df2036.00000300.00554000.00000000.00002000.800000d1.d1e06036.00000300.00556000.00000000.00002000.800000d1.d1e28036.00000300.00558000.00000000.00008000.800000d1.d1e76036.00000300.00560000.00000000.00006000.800000d1.fa002036.00000300.00566000.00000000.00002000.800000d1.fa00a036.00000300.00568000.00000000.00010000.800000d1.fa024036.00000300.00578000.00000000.00018000.800000d1.fa00c036.00000300.00590000.00000000.00182000.800000d1.d1e7e036.00000300.00712000.00000000.00026000.800000d1.d1e50036.00000300.00738000.00000000.0000c000.800000d1.d1e1c036.00000300.00744000.00000000.0000a000.800000d1.d1e12036.00000300.0074e000.00000000.00008000.800000d1.d1dfe036.00000300.00756000.00000000.0000a000.800000d1.d1df4036.00000300.00760000.00000000.00006000.800000d1.d1dec036.00000300.00766000.00000000.00006000.800000d1.d1de6036.00000300.0076c000.00000000.00006000.800000d1.d1de0036.00000300.00772000.00000000.00002000.800000d1.d1dde036.00000300.00774000.00000000.00010000.800000d1.d1dce036.00000300.00784000.00000000.00002000.800000d1.d1daa036.00000300.00786000.00000000.00006000.800000d1.d1da4036.00000300.0078c000.00000000.00004000.800000d1.d1da0036.00000300.00790000.00000000.00008000.800000d1.d1d98036.00000300.00798000.00000000.00016000.800000d1.d1d82036.00000300.007ae000.00000000.00016000.800000d1.d1d50036.00000300.007c4000.00000000.0000e000.800000d1.d1d3a036.00000300.007d2000.00000000.00004000.800000d1.d1d2a036.00000300.007d6000.00000000.0000e000.800000d1.d1d1c036.00000300.007e4000.00000000.00004000.800000d1.d1d18036.00000300.007e8000.00000000.00010000.800000d1.d1d08036.00000300.007f8000.00000000.00006000.800000d1.d1d02036.00000300.007fe000.00000000.00002000.800000d1.d16a4036.00000300.01000000.00000000.00400000.800000d1.d2000036.00000300.01400000.00000000.00008000.800000d1.d1cf8036.00000300.01408000.00000000.0000e000.800000d1.d1cd2036.00000300.01416000.00000000.0003a000.800000d1.d1bd2036.00000300.01450000.00000000.00012000.800000d1.d1b86036.00000300.01462000.00000000.00012000.800000d1.d1b64036.00000300.01474000.00000000.00006000.800000d1.d1b5c036.00000300.0147a000.00000000.00008000.800000d1.d1b54036.00000300.01482000.00000000.00004000.800000d1.d1b50036.00000300.01486000.00000000.00004000.800000d1.d1b3a036.00000300.0148a000.00000000.00006000.800000d1.d1b34036.00000300.01490000.00000000.00006000.800000d1.d1b2e036.00000300.01496000.00000000.00006000.800000d1.d1b28036.00000300.0149c000.00000000.00006000.800000d1.d1b22036.00000300.014a2000.00000000.00478000.800000d1.d16aa036'
                },
                'clock-frequency' => '08f0d180',
                'memory-controller' => {
                'compatible' => [
                    'SUNW,UltraSPARC-III,mc',
                    'SUNW,mc'
                ],
                'memory-layout' => '4a373930.30000000.4a373930.31000000.4a383030.31000000.4a383030.30000000.4a383130.30000000.4a383130.31000000.4a383230.31000000.4a383230.30000000.01aaaaaa.aaaaaaaa.aaaaffff.ffffffff.ff555555.55555555.00000000.00000000.00ffd57f.55aaaaaa.aaaaaaaa.aaaaffff.ffffffff.ff555555.55555555.00000000.00000000.00ffd57f.55aaaaaa.aaaaaaaa.aaaaffff.ffffffff.ff555555.55555555.00000000.00000000.00ffd57f.55aaaaaa.aaaaaaaa.aaaaffff.ffffffff.ff555555.55555555.00000000.00000000.00ffd57f.5556ca6f.e3207607.997bbb25.7bca2a6a.564cc051.c560d465.d956ca5b.cf6ade6f.e32a9e47.bb027607.7b209425.99168a1b.8f0c8011.854cc051.c560d465.d96ade5b.cf2a9e47.02760720.94168a1b.8f0c8011.854cc051.c560d465.d95bcfde.6fe39e47.bb029425.99168a1b.8f0c8011.854cc051.c560d465.d956ca5b.cf6ade6f.e32a9e47.bb027607.7b209425.99168a1b.8f0c8011.8557cb70.e4217708.9a7cbc26.7ccb2b6b.574dc152.c661d566.da57cb5c.d06bdf70.e42b9f48.bc037708.7c219526.9a178b1c.900d8112.864dc152.c661d566.da6bdf5c.d02b9f48.03770821.95178b1c.900d8112.864dc152.c661d566.da5cd0df.70e49f48.bc039526.9a178b1c.900d8112.864dc152.c661d566.da57cb5c.d06bdf70.e42b9f48.bc037708.7c219526.9a178b1c.900d8112.8658cc71.e5227809.9b7dbd27.7dcc2c6c.584ec253.c762d667.db58cc5d.d16ce071.e52ca049.bd047809.7d229627.9b188c1d.910e8213.874ec253.c762d667.db6ce05d.d12ca049.04780922.96188c1d.910e8213.874ec253.c762d667.db5dd1e0.71e5a049.bd049627.9b188c1d.910e8213.874ec253.c762d667.db58cc5d.d16ce071.e52ca049.bd047809.7d229627.9b188c1d.910e8213.8759cd72.e623790a.9c7ebe28.7ecd2d6d.594fc354.c863d768.dc59cd5e.d26de172.e62da14a.be05790a.7e239728.9c198d1e.920f8314.884fc354.c863d768.dc6de15e.d22da14a.05790a23.97198d1e.920f8314.884fc354.c863d768.dc5ed2e1.72e6a14a.be059728.9c198d1e.920f8314.884fc354.c863d768.dc59cd5e.d26de172.e62da14a.be05790a.7e239728.9c198d1e.920f8314.88',
                'reg' => '00000400.03c00000.00000000.00000048',
                'portid' => '00000007',
                'device_type' => 'memory-controller'
                },
                'ramdisk-root' => {
                'address' => '51000000',
                'compatible' => 'SUNW,ramdisk',
                'device_type' => 'block',
                'size' => '04902000',
                'alloc-size' => '00000000'
                },
                'aliases' => {
                'rsc-console' => '/pci@9,700000/ebus@1/rsc-console@1,3083f8',
                'disk0' => '/pci@8,600000/SUNW,qlc@2/fp@0,0/disk@0,0',
                'i2c2' => '/pci@9,700000/ebus@1/i2c@1,50002e',
                'i2c0' => '/pci@9,700000/ebus@1/i2c@1,2e',
                'ttyb' => '/pci@9,700000/ebus@1/serial@1,400000:b',
                'nvram' => '/pci@9,700000/ebus@1/i2c@1,500030/nvram@0,a0',
                'screen' => '/pci@9,700000/SUNW,XVR-100@3',
                'net' => '/pci@9,700000/network@1,1',
                'ide' => '/pci@8,700000/ide@1',
                'disk4' => '/pci@8,600000/SUNW,qlc@2/fp@0,0/disk@4,0',
                'bbc0' => '/pci@9,700000/ebus@1/bbc@1,0',
                'ebus' => '/pci@9,700000/ebus@1',
                'disk10' => '/pci@8,600000/SUNW,qlc@2/fp@0,0/disk@c,0',
                'disk6' => '/pci@8,600000/SUNW,qlc@2/fp@0,0/disk@8,0',
                'ttya' => '/pci@9,700000/ebus@1/serial@1,400000:a',
                'disk2' => '/pci@8,600000/SUNW,qlc@2/fp@0,0/disk@2,0',
                'i2c1' => '/pci@9,700000/ebus@1/i2c@1,30',
                'disk8' => '/pci@8,600000/SUNW,qlc@2/fp@0,0/disk@a,0',
                'pci8a' => '/pci@8,600000',
                'pci9b' => '/pci@9,700000',
                'cdrom' => '/pci@8,700000/ide@1/cdrom@0,0:f',
                'disk5' => '/pci@8,600000/SUNW,qlc@2/fp@0,0/disk@5,0',
                'bbc1' => '/pci@9,700000/ebus@1/bbc@1,500000',
                'pci8b' => '/pci@8,700000',
                'disk9' => '/pci@8,600000/SUNW,qlc@2/fp@0,0/disk@b,0',
                'disk' => '/pci@8,600000/SUNW,qlc@2/fp@0,0/disk@0,0',
                'disk11' => '/pci@8,600000/SUNW,qlc@2/fp@0,0/disk@d,0',
                'disk1' => '/pci@8,600000/SUNW,qlc@2/fp@0,0/disk@1,0',
                'disk7' => '/pci@8,600000/SUNW,qlc@2/fp@0,0/disk@9,0',
                'disk3' => '/pci@8,600000/SUNW,qlc@2/fp@0,0/disk@3,0',
                'rsc-control' => '/pci@9,700000/ebus@1/rsc-control@1,3062f8',
                'scsi' => '/pci@8,600000/SUNW,qlc@2',
                'i2c3' => '/pci@9,700000/ebus@1/i2c@1,500030',
                'gem' => '/pci@8,600000/network@1',
                'flash' => '/pci@9,700000/ebus@1/flashprom@0,0',
                'idprom' => '/pci@9,700000/ebus@1/i2c@1,500030/idprom@0,a0',
                'pci9a' => '/pci@9,600000'
                },
                'stick-frequency' => '00989680',
                'cmp' => {
                'portid' => '00000007',
                '#size-cells' => '00000000',
                'reg' => '00000400.03800000.00000000.00010000',
                '#address-cells' => '00000001',
                'cpu' => {
                    'l2-cache-associativity' => '00000002',
                    'l1-dcache-associativity' => '00000004',
                    'clock-frequency' => '50775d80',
                    'l2-cache-sharing' => '00000000.00000002',
                    'sparc-version' => '00000009',
                    'device_type' => 'cpu',
                    'l2-cache-size' => '00800000',
                    'l1-dcache-size' => '00010000',
                    'l1-icache-line-size' => '00000020',
                    'mask#' => '00000031',
                    'l1-icache-size' => '00008000',
                    'l1-icache-associativity' => '00000004',
                    'cpuid' => '00000017',
                    'reg' => '00000001',
                    '#itlb-entries' => '00000010',
                    'l1-dcache-line-size' => '00000020',
                    'compatible' => 'SUNW,UltraSPARC-IV',
                    'manufacturer#' => '0000003e',
                    '#dtlb-entries' => '00000010',
                    'l2-cache-line-size' => '00000080',
                    'implementation#' => '00000018'
                }
            },
            'scsi-initiator-id' => '00000007',
            'device_type' => 'gptwo',
            'model' => 'SUNW,501-7199',
            'reset-reason' => 'SPOR Software/User',
            '#size-cells' => '00000002'
        }
    },
    sparc3 => {
        'Memory size' => '4096 Megabytes',
        'System Configuration' => 'Oracle Corporation  sun4u',
        'SUNW,Sun-Fire-V215'   => {
            'chosen' => {
                'bootargs' => '00',
                'bootfs' => 'fff11ed0',
                'elfheader-length' => '0017c000',
                'elfheader-address' => '50000000',
                'stdout' => 'fff11f20',
                'stdout-#lines' => 'ffffffff',
                'memory' => 'fff74290',
                'fstype' => 'zfs',
                'mmu' => 'fff74080',
                'archive-fstype' => 'hsfs',
                'archfs' => 'fff17f00',
                'whoami' => '/platform/sun4u/kernel/sparcv9/unix',
                'bootarchive' => '/ramdisk-root',
                'fs-package' => 'hsfs-file-system',
                'stdin' => 'fff0a1a8',
                'zfs-bootfs' => 'rpool/59',
                'bootpath' => '/pci@1e,600000/pci@0/pci@a/pci@0/pci@8/scsi@1/disk@1,0:a',
                'impl-arch-name' => 'SUNW,Sun-Fire-V215'
            },
            'packages' => {
                'SUNW,i2c-ram-device' => {},
                'SUNW,builtin-drivers' => {},
                'obp-tftp' => {},
                'zfs-file-system' => {},
                'hsfs-file-system' => {},
                'deblocker' => {},
                'dropins' => {
                    'source' => '/flashprom:'
                },
                'disk-label' => {},
                'kbd-translator' => {},
                'SUNW,asr' => {
                    'maximum-reason-length' => '000000fa'
                },
                'terminal-emulator' => {},
                'SUNW,fru-device' => {}
            },
            'breakpoint-trap' => '0000007f',
            'pci' => {
                'reg' => '00000400.0ff00000.00000000.000f0000.00000400.0fc10000.00000000.00064000',
                '#address-cells' => '00000003',
                'msi-data-mask' => '000000ff',
                'interrupt-map' => '00000000.00000000.00000000.00000001.f00705d0.00000014.00000000.00000000.00000000.00000002.f00705d0.00000015.00000000.00000000.00000000.00000003.f00705d0.00000016.00000000.00000000.00000000.00000004.f00705d0.00000017',
                'msi-ranges' => '00000000.00000100',
                'ranges' => '00000000.00000000.00000000.000007f6.00000000.00000000.10000000.01000000.00000000.00000000.000007f6.10000000.00000000.10000000.02000000.00000000.00000000.000007f7.00000000.00000000.80000000.03000000.00000000.00000000.000007f4.00000000.00000000.80000000',
                'compatible' => 'pciex108e,80f0',
                'interrupt-map-mask' => '00000000.00000000.00000000.00000007',
                '#msi' => '00000100',
                'available' => '81000000.00000000.00000000.00000000.00010000.82000000.00000000.00100000.00000000.bff00000.82000000.00000000.e0000000.00000000.00000000',
                'module-manufacturer#' => '00000036',
                'interrupts' => '0000003f.0000003e',
                'ino-bitmap' => 'fff3c77d.ffffffff',
                'msi-address-ranges' => '00000000.7fff0000.00010000.00000003.ffff0000.00010000',
                '#interrupt-cells' => '00000001',
                'msi-eq-size' => '00000080',
                '#msi-eqs' => '00000024',
                'msi-eq-devino' => '00000000.00000024.00000018',
                'portid' => '0000001f',
                'bus-range' => '00000002.000000ff',
                'module-revision#' => '00000003',
                'msix-data-width' => '00000020',
                '#size-cells' => '00000002',
                'device_type' => 'pciex',
                'fire-revision#' => '00000004'
            },
            'idprom' => '01840014.4f7aa3f2.00000000.7aa3f2de.f1010a00.00000000.00000000.000000fa',
            'SUNW,UltraSPARC-IIIi' => {
                'icache-size' => '00008000',
                'dcache-associativity' => '00000004',
                '#itlb-entries' => '00000010',
                '#dtlb-entries' => '00000010',
                'manufacturer#' => '0000003e',
                'ecache-associativity' => '00000004',
                'icache-associativity' => '00000004',
                'implementation#' => '00000016',
                'mask#' => '00000034',
                'reg' => '00000400.00800000.00000000.00010000',
                'ecache-size' => '00100000',
                'cpuid' => '00000001',
                'sparc-version' => '00000009',
                'dcache-size' => '00010000',
                'clock-divisors' => '00000001.00000002.00000020',
                'device_type' => 'cpu',
                'ecache-line-size' => '00000040',
                'portid' => '00000001',
                'icache-line-size' => '00000020',
                'dcache-line-size' => '00000020',
                'clock-frequency' => '59a53800'
            },
            'os-io' => {
                'device_type' => 'console'
            },
            'interrupt-map' => '00000400.0fd30000.00000001.f0067c2c.0000003d.00000400.0fd20000.00000001.f0067c2c.0000003c',
            'memory' => {
                'available' => '00000012.3ff06000.00000000.00002000.00000012.3ff00000.00000000.00002000.00000012.3fee0000.00000000.00008000.00000012.3fe9a000.00000000.00006000.00000012.3fe70000.00000000.00010000.00000012.3fe5c000.00000000.00008000.00000012.3fe0a000.00000000.0004e000.00000012.3fe06000.00000000.00002000.00000012.3fdea000.00000000.0001a000.00000012.3f6ea000.00000000.006fc000.00000012.3f422000.00000000.00286000.00000012.39d9e000.00000000.05260000.00000012.00000000.00000000.32c42000.00000010.00000000.00000000.40000000.00000002.00000000.00000000.40000000.00000000.00000000.00000000.40000000',
                'reg' => '00000000.00000000.00000000.40000000.00000002.00000000.00000000.40000000.00000010.00000000.00000000.40000000.00000012.00000000.00000000.40000000'
            },
            'openprom' => {
                'client-services' => {},
                'model' => 'SUNW,4.25.10',
                'version' => 'OBP 4.25.10 2007/09/18 09:56'
            },
            'banner-name' => 'Sun Fire V215',
            'options' => {
                'asr-policy' => 'normal',
                'ttyb-ignore-cd' => 'true',
                'use-nvramrc?' => 'false',
                'scsi-initiator-id' => '7',
                'diag-device' => 'disk0 disk1',
                'ansi-terminal?' => 'true',
                'boot-command' => 'boot',
                'ttya-mode' => '9600,8,n,1,-',
                'diag-switch?' => 'false',
                'local-mac-address?' => 'true',
                'ttya-ignore-cd' => 'true',
                'diag-level' => 'max',
                'security-#badlogins' => '0',
                'auto-boot?' => 'true',
                'oem-banner?' => 'false',
                'ttyb-rts-dtr-off' => 'false',
                'diag-trigger' => 'error-reset power-on-reset ',
                'security-mode' => 'none',
                'fcode-debug?' => 'false',
                'load-base' => '16384',
                'verbosity' => 'normal',
                'auto-boot-on-error?' => 'true',
                'screen-#rows' => '34',
                'error-reset-recovery' => 'sync',
                'diag-script' => 'normal',
                'nvramrc' => 'devalias rootmirror /pci@1e,600000/pci@0/pci@a/pci@0/pci@8/scsi@1/disk@1,0',
                'ttyb-mode' => '9600,8,n,1,-',
                'output-device' => 'screen',
                'input-device' => 'keyboard',
                'diag-passes' => '1',
                'oem-logo?' => 'false',
                'ttya-rts-dtr-off' => 'false',
                'boot-device' => 'disk1:a disk',
                'service-mode?' => 'false',
                'screen-#columns' => '80'
            },
            'interrupt-map-mask' => '00000fff.0fff0000.00000003',
            'i2c' => {
                'sasbp-fru-prom' => {
                    'device_type' => 'fru-prom',
                    'compatible' => 'i2c-at24c64',
                    'reg' => '00000000.00000064'
                },
                'compatible' => 'fire-i2c',
                'interrupt-map-mask' => '000000ff.000000ff.00000003',
                'interrupts' => '00000001',
                'motherboard-fru-prom' => {
                    'reg' => '00000000.000000a2',
                    'compatible' => 'i2c-at24c64',
                    'device_type' => 'fru-prom'
                },
                'dimm-spd' => {
                    'compatible' => 'i2c-at34c02',
                    'reg' => '00000000.000000ee'
                },
                'pdb-fru-prom' => {
                    'device_type' => 'fru-prom',
                    'compatible' => 'i2c-at24c64',
                    'reg' => '00000000.00000032'
                },
                'rscrtc' => {
                    'reg' => '00000000.000000d0',
                    'compatible' => 'i2c-ds1307'
                },
                'ioexp' => {
                    'compatible' => 'i2c-pcf8574',
                    'reg' => '00000000.0000007e'
                },
                '#address-cells' => '00000002',
                'reg' => '00000400.0fd30000.00000000.00000040',
                'interrupt-map' => '00000000.000000d0.00000001.f00705d0.00000006',
                'idprom' => {
                    'device_type' => 'idprom',
                    'reg' => '00000000.000000a6'
                },
                'power-supply-fru-prom' => {
                    'reg' => '00000000.0000006e',
                    'compatible' => 'i2c-at34c02'
                },
                'i2c-clock-val' => '0000000f',
                '#size-cells' => '00000000',
                'riser-fru-prom' => {
                    'device_type' => 'fru-prom',
                    'reg' => '00000000.000000aa',
                    'compatible' => 'i2c-at24c64'
                },
                'clock-generator' => {
                    'compatible' => 'i2c-ics9fg108',
                    'reg' => '00000000.000000dc'
                },
                'device_type' => 'i2c',
                'gpio' => {
                    'compatible' => 'i2c-pca9555',
                    'reg' => '00000000.00000080'
                },
                '#interrupt-cells' => '00000001',
                'nvram' => {
                    'reg' => '00000000.000000a6',
                    'compatible' => 'i2c-at24c64',
                    'device_type' => 'nvram'
                },
                'hardware-monitor' => {
                    'compatible' => 'i2c-adt7462',
                    'reg' => '00000000.000000b0'
                },
                'portid' => '0000001f'
            },
            'ebus' => {
                'portid' => '0000001f',
                'env-monitor' => {
                    'compatible' => 'epic',
                    'reg' => '00000003.00000000.00000081',
                    'version' => '5.10'
                },
                '#interrupt-cells' => '00000001',
                'gpio' => {
                    'gpio-device-type' => 'SUNW,cpld',
                    'reg' => '00000002.000000c0.00000001',
                    'compatible' => 'pmugpio'
                },
                '#size-cells' => '00000001',
                'power' => {
                    'power-device-type' => 'SUNW,pic18lf65j10',
                    'reg' => '00000003.00000040.00000082',
                    'interrupts' => '00000001'
                },
                'device_type' => 'ebus',
                'rmc-comm' => {
                    'compatible' => 'rmc_comm',
                    'reg' => '00000002.00000000.00000008',
                    'interrupts' => '00000001',
                    'device_type' => 'serial'
                },
                'ranges' => '00000000.00000000.000007ff.f0000000.01000000.00000001.00000000.000007ff.f1000000.01000000.00000002.00000000.000007ff.f2000000.01000000.00000003.00000000.000007ff.f3000000.01000000',
                'interrupt-map' => '00000002.00000080.00000001.f00705d0.00000008.00000002.00000040.00000001.f00705d0.00000009.00000002.00000000.00000001.f00705d0.0000000a.00000003.00000000.00000001.f00705d0.00000000.00000003.00000040.00000001.f00705d0.00000003',
                'serial' => {
                    'device_type' => 'serial',
                    'compatible' => [
                        'su16552',
                        'su16550',
                        'su'
                    ],
                    'interrupts' => '00000001',
                    'reg' => '00000002.00000040.00000008'
                },
                '#address-cells' => '00000002',
                'reg' => '00000400.0fc64000.00000000.00000020',
                'flashprom' => {
                    'reg' => '00000000.00000000.00200000',
                    'model' => 'SUNW,525-2320',
                    'version' => [
                        'OBP 4.25.10 2007/09/18 09:56 Sun Fire V215/V245',
                        'POST 4.25.10 2007/09/18 10:18',
                        'OBDIAG 4.25.10 2007/09/18 10:09  '
                    ]
                },
                'revision' => '00000000',
                'interrupt-map-mask' => '00000003.000fffff.00000003',
                'compatible' => 'jbus-ebus'
            },
            'virtual-memory' => {
                'page-size' => '00002000',
                'available' => 'fffff800.00000000.000007fc.00000000.00000700.05400000.000000ff.fac00000.00000300.0165e000.000003ff.fe9a2000.00000300.01478000.00000000.00008000.00000300.01440000.00000000.0002a000.00000300.013cc000.00000000.00004000.00000300.01390000.00000000.00024000.00000300.012e0000.00000000.00030000.00000300.01140000.00000000.00008000.00000300.01100000.00000000.00038000.00000300.00400000.00000000.00800000.00000300.002bc000.00000000.00004000.00000300.00280000.00000000.00024000.00000300.00240000.00000000.0003c000.00000300.00120000.00000000.00004000.00000300.000e4000.00000000.00014000.00000300.0006e000.00000000.00014000.00000300.0003a000.00000000.00008000.00000001.00000000.000002ff.00002000.00000000.ffff0000.00000000.0000e000.00000000.7be8c000.00000000.74174000.00000000.701d4000.00000000.0bc2c000.00000000.02a00000.00000000.6d600000.00000000.01c00000.00000000.00400000.00000000.01400000.00000000.00400000.00000000.00000000.00000000.01000000.00000000.fff20000.00000000.00002000.00000000.fff1c000.00000000.00002000.00000000.fff00000.00000000.00006000.00000000.fefc0000.00000000.00040000.00000000.fef00000.00000000.0007a000.00000000.f0800000.00000000.0e320000',
                'translations' => '00000000.00002000.00000000.009fe000.80000000.00002036.00000000.01000000.00000000.00400000.80000012.39800036.00000000.01800000.00000000.00400000.80000012.39400036.00000000.02000000.00000000.00800000.80000012.38800036.00000000.02800000.00000000.00200000.80000012.3f21a036.00000000.70000000.00000000.00002000.80000012.3f1da036.00000000.70002000.00000000.00002000.80000012.3f000036.00000000.70004000.00000000.0000c000.80000012.3f20c036.00000000.70010000.00000000.00004000.80000012.3f046036.00000000.70014000.00000000.0007c000.80000012.39004036.00000000.70090000.00000000.00008000.80000012.39c16036.00000000.70098000.00000000.00002000.80000012.3f002036.00000000.7009a000.00000000.00006000.80000012.332f4036.00000000.700a0000.00000000.00012000.80000012.332ba036.00000000.700b2000.00000000.00090000.80000012.330d0036.00000000.70142000.00000000.00016000.80000012.3307a036.00000000.70158000.00000000.0000e000.80000012.3306c036.00000000.70166000.00000000.00014000.80000012.33058036.00000000.7017a000.00000000.00010000.80000012.33032036.00000000.7018a000.00000000.0000a000.80000012.33018036.00000000.70194000.00000000.00018000.80000012.32ebc036.00000000.701ac000.00000000.0000c000.80000012.32ea2036.00000000.701b8000.00000000.0001c000.80000012.32e2c036.00000000.7be00000.00000000.00022000.80000012.32f1e036.00000000.7be22000.00000000.0001e000.80000012.32eec036.00000000.7be40000.00000000.0002a000.80000012.32e66036.00000000.7be6a000.00000000.00004000.80000012.32de6036.00000000.7be6e000.00000000.00004000.80000012.32dd8036.00000000.7be72000.00000000.0001a000.80000012.32db4036.00000000.f0000000.00000000.00080000.80000012.3ff800b6.00000000.f0080000.00000000.00010000.80000012.3ff200b6.00000000.f0090000.00000000.00010000.80000012.3ff100b6.00000000.f00a0000.00000000.00010000.80000012.3fef00b6.00000000.f00b0000.00000000.00010000.80000012.3fed00b6.00000000.f00c0000.00000000.00010000.80000012.3fec00b6.00000000.f00d0000.00000000.00010000.80000012.3feb00b6.00000000.f00e0000.00000000.00010000.80000012.3fea00b6.00000000.f00f0000.00000000.00010000.80000012.3fe800b6.00000000.f0100000.00000000.00010000.80000012.39c000b6.00000000.feb20000.00000000.00200000.800007ff.f000008e.00000000.fed20000.00000000.000f0000.80000400.0ff0008e.00000000.fee10000.00000000.000f0000.80000400.0f60008e.00000000.fef7a000.00000000.00004000.80000012.3f41c0b6.00000000.fef7e000.00000000.00042000.80000012.3f6a80b6.00000000.fff06000.00000000.00002000.800007f8.1000008e.00000000.fff08000.00000000.00002000.800007f9.0020408e.00000000.fff0a000.00000000.00004000.80000012.3fee80b6.00000000.fff0e000.00000000.00002000.800007f9.0020008e.00000000.fff10000.00000000.00004000.80000012.3feec0b6.00000000.fff14000.00000000.00002000.800007f9.0020008e.00000000.fff16000.00000000.00004000.80000012.3fde60b6.00000000.fff1a000.00000000.00002000.800007f9.0020008e.00000000.fff1e000.00000000.00002000.80000012.3ff080b6.00000000.fff22000.00000000.00002000.800007ff.f200008e.00000000.fff24000.00000000.00002000.80000012.3ff300b6.00000000.fff26000.00000000.00002000.80000012.3ff0e0b6.00000000.fff28000.00000000.00002000.800007ff.f100008e.00000000.fff2a000.00000000.00002000.80000012.3ff400b6.00000000.fff2c000.00000000.00002000.80000012.3ff460b6.00000000.fff2e000.00000000.00006000.80000012.3ff320b6.00000000.fff34000.00000000.00002000.800007ff.f300008e.00000000.fff36000.00000000.00002000.80000012.3effe0b6.00000000.fff38000.00000000.00002000.800007f6.0000008e.00000000.fff3a000.00000000.00004000.80000012.3ff380b6.00000000.fff3e000.00000000.00002000.80000400.0fc0008e.00000000.fff40000.00000000.00002000.800007f8.00d0808e.00000000.fff42000.00000000.00004000.80000012.3ff3c0b6.00000000.fff46000.00000000.00002000.80000400.0f40008e.00000000.fff48000.00000000.00004000.80000012.3ff420b6.00000000.fff4c000.00000000.00002000.80000400.0fd3008e.00000000.fff4e000.00000000.00002000.80000012.3ff600b6.00000000.fff54000.00000000.00016000.80000012.3ff480b6.00000000.fff6a000.00000000.00006000.80000012.3ff620b6.00000000.fff70000.00000000.00010000.80000012.3ff700b6.00000300.00002000.00000000.00002000.80000012.3f20a036.00000300.00004000.00000000.00002000.80000012.3f204036.00000300.00006000.00000000.00002000.80000012.3f202036.00000300.00008000.00000000.00002000.80000012.3f200036.00000300.0000a000.00000000.00002000.80000012.3f1fe036.00000300.0000c000.00000000.00004000.80000012.3f1fa036.00000300.00010000.00000000.00004000.80000012.3f1f0036.00000300.00014000.00000000.00002000.80000012.3f1e0036.00000300.00016000.00000000.00004000.80000012.3f1dc036.00000300.0001a000.00000000.00002000.80000012.3f1d8036.00000300.0001c000.00000000.00002000.80000012.3f1d6036.00000300.0001e000.00000000.00002000.80000012.3f1a4036.00000300.00020000.00000000.00002000.80000012.3f196036.00000300.00022000.00000000.00002000.80000012.3f194036.00000300.00024000.00000000.00002000.80000012.3f190036.00000300.00026000.00000000.00002000.80000012.3f17c036.00000300.00028000.00000000.00002000.80000012.3f16e036.00000300.0002a000.00000000.00002000.80000012.3f024036.00000300.0002c000.00000000.00002000.80000012.3f022036.00000300.0002e000.00000000.00002000.80000012.3f012036.00000300.00030000.00000000.00002000.80000012.3f010036.00000300.00032000.00000000.00002000.80000012.33266036.00000300.00034000.00000000.00002000.80000012.32f6c036.00000300.00036000.00000000.00002000.80000012.32ddc036.00000300.00038000.00000000.00002000.80000012.32c44036.00000300.00042000.00000000.00002000.80000012.3f1f8036.00000300.00044000.00000000.00002000.80000012.3f1f6036.00000300.00046000.00000000.00002000.80000012.3f1f4036.00000300.00048000.00000000.00002000.80000012.3f1ee036.00000300.0004a000.00000000.00002000.80000012.3f1ec036.00000300.0004c000.00000000.00002000.80000012.3f1ea036.00000300.0004e000.00000000.00002000.80000012.3f1e8036.00000300.00050000.00000000.00002000.80000012.3f1e6036.00000300.00052000.00000000.00002000.80000012.3f1e4036.00000300.00054000.00000000.00002000.80000012.3f1e2036.00000300.00056000.00000000.00002000.80000012.3f1b2036.00000300.00058000.00000000.00002000.80000012.3f1b0036.00000300.0005a000.00000000.00002000.80000012.3f1ae036.00000300.0005c000.00000000.00002000.80000012.3f1ac036.00000300.0005e000.00000000.00002000.80000012.3f192036.00000300.00060000.00000000.00002000.80000012.3f18e036.00000300.00062000.00000000.00002000.80000012.3f184036.00000300.00064000.00000000.00002000.80000012.3f180036.00000300.00066000.00000000.00002000.80000012.3f17e036.00000300.00068000.00000000.00002000.80000012.3f12a036.00000300.0006a000.00000000.00002000.80000012.3f02a036.00000300.0006c000.00000000.00002000.80000012.3f01c036.00000300.00082000.00000000.00002000.80000012.3f1d4036.00000300.00084000.00000000.00010000.80000012.3f1c4036.00000300.00094000.00000000.00010000.80000012.3f1b4036.00000300.000a4000.00000000.00002000.80000012.3f00e036.00000300.000a6000.00000000.00004000.80000012.3f014036.00000300.000aa000.00000000.00002000.80000012.3f01e036.00000300.000ac000.00000000.00004000.80000012.3f026036.00000300.000b0000.00000000.0000e000.80000012.3f02c036.00000300.000be000.00000000.00006000.80000012.3f040036.00000300.000c4000.00000000.00002000.80000012.3f16c036.00000300.000c6000.00000000.00002000.80000012.3f170036.00000300.000c8000.00000000.00002000.80000012.3f182036.00000300.000ca000.00000000.00008000.80000012.3f186036.00000300.000d2000.00000000.0000c000.80000012.3f198036.00000300.000de000.00000000.00006000.80000012.3f1a6036.00000300.000f8000.00000000.00014000.80000012.32e18036.00000300.0010c000.00000000.0000a000.80000012.33022036.00000300.00116000.00000000.0000a000.80000012.3f172036.00000300.00124000.00000000.00040000.80000012.3f12c036.00000300.00164000.00000000.00012000.80000012.3f118036.00000300.00176000.00000000.00062000.80000012.3f0b6036.00000300.001d8000.00000000.00050000.80000012.3f066036.00000300.00228000.00000000.00008000.80000012.3f05e036.00000300.00230000.00000000.00006000.80000012.3f058036.00000300.00236000.00000000.0000a000.80000012.3f04e036.00000300.0027c000.00000000.00004000.80000012.3f04a036.00000300.002a4000.00000000.00006000.80000012.3302c036.00000300.002aa000.00000000.00006000.80000012.332fa036.00000300.002b0000.00000000.00006000.80000012.39c10036.00000300.002b6000.00000000.00006000.80000012.3f03a036.00000300.002c0000.00000000.00100000.80000012.39c9e036.00000300.003c0000.00000000.00002000.80000012.3f020036.00000300.003c2000.00000000.00006000.80000012.332ee036.00000300.003c8000.00000000.00008000.80000012.332e6036.00000300.003d0000.00000000.00002000.80000012.39000036.00000300.003d2000.00000000.00006000.80000012.332e0036.00000300.003d8000.00000000.00014000.80000012.332cc036.00000300.003ec000.00000000.00004000.80000012.332b6036.00000300.003f0000.00000000.00008000.80000012.332ae036.00000300.003f8000.00000000.00006000.80000012.332a4036.00000300.003fe000.00000000.00002000.80000012.32fb8036.00000300.00c00000.00000000.00380000.80000012.39080036.00000300.00f80000.00000000.00100000.80000012.33300036.00000300.01080000.00000000.00080000.80000012.39c1e036.00000300.01138000.00000000.00008000.80000012.3f006036.00000300.01148000.00000000.00002000.80000012.32dce036.00000300.0114a000.00000000.00002000.80000012.32f4e036.00000300.0114c000.00000000.00002000.80000012.32fae036.00000300.0114e000.00000000.00002000.80000012.33006036.00000300.01150000.00000000.00006000.80000012.33052036.00000300.01156000.00000000.00006000.80000012.33260036.00000300.0115c000.00000000.00002000.80000012.33268036.00000300.0115e000.00000000.00018000.80000012.33282036.00000300.01176000.00000000.00002000.80000012.332a2036.00000300.01178000.00000000.00004000.80000012.332aa036.00000300.0117c000.00000000.00002000.80000012.39002036.00000300.0117e000.00000000.00002000.80000012.3f004036.00000300.01180000.00000000.00008000.80000012.3329a036.00000300.01188000.00000000.00018000.80000012.3326a036.00000300.011a0000.00000000.00100000.80000012.33160036.00000300.012a0000.00000000.00040000.80000012.33090036.00000300.01310000.00000000.00010000.80000012.33042036.00000300.01320000.00000000.00006000.80000012.33012036.00000300.01326000.00000000.0000a000.80000012.33008036.00000300.01330000.00000000.00004000.80000012.33002036.00000300.01334000.00000000.00006000.80000012.32ffc036.00000300.0133a000.00000000.00008000.80000012.32ff4036.00000300.01342000.00000000.00004000.80000012.32ff0036.00000300.01346000.00000000.00022000.80000012.32fce036.00000300.01368000.00000000.00014000.80000012.32fba036.00000300.0137c000.00000000.00008000.80000012.32fb0036.00000300.01384000.00000000.00006000.80000012.32fa8036.00000300.0138a000.00000000.00006000.80000012.32fa2036.00000300.013b4000.00000000.0000c000.80000012.32f74036.00000300.013c0000.00000000.0000c000.80000012.32f96036.00000300.013d0000.00000000.00016000.80000012.32f80036.00000300.013e6000.00000000.00006000.80000012.32f6e036.00000300.013ec000.00000000.0000c000.80000012.32f60036.00000300.013f8000.00000000.00004000.80000012.32f5c036.00000300.013fc000.00000000.0000c000.80000012.32f50036.00000300.01408000.00000000.00004000.80000012.32f4a036.00000300.0140c000.00000000.00006000.80000012.32f44036.00000300.01412000.00000000.00004000.80000012.32f40036.00000300.01416000.00000000.00006000.80000012.32f16036.00000300.0141c000.00000000.0000c000.80000012.32f0a036.00000300.01428000.00000000.00018000.80000012.32ed4036.00000300.0146a000.00000000.0000e000.80000012.32eae036.00000300.01480000.00000000.00004000.80000012.32e9e036.00000300.01484000.00000000.0000e000.80000012.32e90036.00000300.01492000.00000000.0001e000.80000012.32e48036.00000300.014b0000.00000000.00006000.80000012.32e12036.00000300.014b6000.00000000.00006000.80000012.32e0c036.00000300.014bc000.00000000.00008000.80000012.32e04036.00000300.014c4000.00000000.0000a000.80000012.32dfa036.00000300.014ce000.00000000.00006000.80000012.32df4036.00000300.014d4000.00000000.0000a000.80000012.32dea036.00000300.014de000.00000000.00008000.80000012.32dde036.00000300.014e6000.00000000.00008000.80000012.32dd0036.00000300.014ee000.00000000.00012000.80000012.32da2036.00000300.01500000.00000000.00008000.80000012.32d9a036.00000300.01508000.00000000.0000a000.80000012.32d90036.00000300.01512000.00000000.00008000.80000012.32d88036.00000300.0151a000.00000000.00142000.80000012.32c46036.00000300.0165c000.00000000.00002000.80000012.32c42036',
                'existing' => '00000000.00000000.00000800.00000000.fffff800.00000000.00000800.00000000'
            },
            '#interrupt-cells' => '00000001',
            'clock-frequency' => '0b34a700',
            'memory-controller' => {
                'reg' => '00000400.00800000.00000000.00000008',
                'memory-control-register-1' => '3000014a.3f801cb7',
                'compatible' => [
                    'SUNW,UltraSPARC-IIIi,mc',
                    'SUNW,mc'
                ],
                'memory-layout' => '42302f44.30000000.42302f44.31000000.42312f44.30000000.42312f44.31000000.01ff00ff.0000ff00.ff0000ff.ffff00ff.00800000.00000000.00001718.1c1f7275.797b2c53.545758ae.afb2b353.545758ae.afb2b348.494f50a5.a6aaab48.494f50a5.a6aaab3d.40444599.9ba1a235.37393c92.9396973d.40444599.9ba1a235.37393c92.93969702.0406085e.5f626302.0406085e.5f62630c.0d131469.6a6d6e0c.0d131469.6a6d6e21.2327287e.7f838517.181c1f72.75797b2c.2d313386.878e9021.2327287e.7f838500',
                'portid' => '00000001',
                'device_type' => 'memory-controller'
            },
            'ramdisk-root' => {
                'device_type' => 'block',
                'size' => '05260000',
                'alloc-size' => '00000000',
                'address' => '51000000',
                'compatible' => 'SUNW,ramdisk'
            },
            'aliases' => {
                'net0' => '/pci@1e,600000/pci@0/pci@9/pci@0/network@4',
                'ide' => '/pci@1e,600000/pci@0/pci@1/pci@0/ide@1f',
                'net' => '/pci@1e,600000/pci@0/pci@9/pci@0/network@4',
                'ttyb' => '/ebus@1f,464000/serial@2,40',
                'net1' => '/pci@1e,600000/pci@0/pci@9/pci@0/network@4,1',
                'cdrom' => '/pci@1e,600000/pci@0/pci@1/pci@0/ide@1f/cdrom@0,0:f',
                'disk0' => '/pci@1e,600000/pci@0/pci@a/pci@0/pci@8/scsi@1/disk@0,0',
                'sc-control' => '/ebus@1f,464000/rmc-comm@2,0',
                'disk2' => '/pci@1e,600000/pci@0/pci@a/pci@0/pci@8/scsi@1/disk@2,0',
                'scsi' => '/pci@1e,600000/pci@0/pci@a/pci@0/pci@8/scsi@1',
                'disk3' => '/pci@1e,600000/pci@0/pci@a/pci@0/pci@8/scsi@1/disk@3,0',
                'ttya' => '/ebus@1f,464000/serial@2,80',
                'disk1' => '/pci@1e,600000/pci@0/pci@a/pci@0/pci@8/scsi@1/disk@1,0',
                'net2' => '/pci@1e,600000/pci@0/pci@a/pci@0/network@4',
                'net3' => '/pci@1e,600000/pci@0/pci@a/pci@0/network@4,1',
                'disk' => '/pci@1e,600000/pci@0/pci@a/pci@0/pci@8/scsi@1/disk@0,0'
            },
            'scsi-initiator-id' => '00000007',
            'stick-frequency' => '01312d00',
            'model' => 'SUNW,375-3463',
            'device_type' => 'jbus',
            '#size-cells' => '00000002'
        },
    }
);

my %prtdiag_tests = (
    sample1 => {
        'System Configuration' => 'Sun Microsystems  sun4v SPARC Enterprise T5120',
        'Memory size' => '3968 Megabytes'
    },
    sample2 => {
        'System Configuration' => 'Sun Microsystems  sun4u Sun Fire V890',
        'Memory size' => '32768 Megabytes',
        'System clock frequency' => '150 MHz'
    },
    sample3 => {
        'BMC Configuration' => 'IPMI 2.0 (KCS: Keyboard Controller Style)',
        'System Configuration' => 'Sun Microsystems     Sun Fire X4540',
        'BIOS Configuration' => 'American Megatrends Inc. 0ABNF032 05/19/2009'
    },
    sample4 => {
        'System Configuration' => 'SUN MICROSYSTEMS       SUN FIRE X2250    ',
        'BIOS Configuration' => 'American Megatrends Inc. S86_3A16 12/03/2008',
        'BMC Configuration' => 'IPMI 2.0 (KCS: Keyboard Controller Style)'
    },
    sample5 => {
        'System Configuration' => 'VMware, Inc. VMware Virtual Platform',
        'BIOS Configuration' => 'Phoenix Technologies LTD 6.00 06/22/2012'
    },
    sample6 => {
        'System clock frequency' => '167 MHZ',
        'System Configuration' => 'Sun Microsystems  sun4u Sun Fire V210',
        'Memory size' => '4GB        ',
    },
    sample7 => {
        'System clock frequency' => '188 MHZ',
        'System Configuration' => 'Sun Microsystems  sun4u Sun Fire V215',
        'Memory size' => '2GB        '
    },
    sample8 => {
        'BMC Configuration' => 'IPMI 2.0 (KCS: Keyboard Controller Style)',
        'BIOS Configuration' => 'American Megatrends Inc. S86_3A16 12/03/2008',
        'System Configuration' => 'SUN MICROSYSTEMS       SUN FIRE X2250    '
    }
);

my %release_tests = (
    'sample1' => {
        fullname   => 'Solaris 10 5/09 s10s_u7wos_08 SPARC',
        version    => 10,
        subversion => 'u7',
        date       => '5/09',
        id         => 's10s_u7wos_08'
    },
    'sample2' => {
        fullname   => 'Solaris 9 s9_41e SPARC',
        version    => 9,
        subversion => undef,
        date       => undef,
        id         => 's9_41e'
     },
    'sample3' => {
        fullname   => 'Solaris 9 s9_50 SPARC',
        version    => 9,
        subversion => undef,
        date       => undef,
        id         => 's9_50'
     },
    'sample4' => {
        fullname => 'Solaris 8 2/02 s28s_u7wos_08a SPARC',
        version    => 8,
        subversion => 'u7',
        date       => '2/02',
        id         => 's28s_u7wos_08a',
    },
    'sample5' => {
        fullname   => 'Solaris 9 9/05 s9s_u8wos_05 SPARC',
        version    => 9,
        subversion => 'u8',
        date       => '9/05',
        id         => 's9s_u8wos_05',
    },
    'sample6' => {
        fullname   => 'Solaris 10 3/05 s10_74L2a SPARC',
        version    => 10,
        subversion => undef,
        date       => '3/05',
        id         => 's10_74L2a',
     },
    'sample7' => {
        fullname   => 'Oracle Solaris 10 1/13 s10s_u11wos_24a SPARC',
        version    => 10,
        subversion => 'u11',
        date       => '1/13',
        id         => 's10s_u11wos_24a',
     },
    'sample8' => {
        fullname   => 'Oracle Solaris 10 8/11 s10s_u10wos_17b SPARC',
        version    => 10,
        subversion => 'u10',
        date       => '8/11',
        id         => 's10s_u10wos_17b',
     },
);

plan tests => 
    scalar (keys %prtconf_tests) +
    scalar (keys %prtdiag_tests) +
    scalar (keys %release_tests);

foreach my $test (keys %prtconf_tests) {
    my $file = "resources/solaris/prtconf/$test";
    my $info = getPrtconfInfos(file => $file);
    cmp_deeply($info, $prtconf_tests{$test}, "$test prtconf parsing");
}

foreach my $test (keys %prtdiag_tests) {
    my $file = "resources/solaris/prtdiag/$test";
    my $info = getPrtconfInfos(file => $file);
    cmp_deeply($info, $prtdiag_tests{$test}, "$test prtdiag parsing");
}

foreach my $test (keys %release_tests) {
    my $file = "resources/solaris/release/$test";
    my $info = getReleaseInfo(file => $file);
    cmp_deeply($info, $release_tests{$test}, "$test /etc/release parsing");
}
