# Generated by default/object.tt
package Paws::LocationService::DevicePositionUpdate;
  use Moose;
  has DeviceId => (is => 'ro', isa => 'Str', required => 1);
  has Position => (is => 'ro', isa => 'ArrayRef[Num]', required => 1);
  has SampleTime => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LocationService::DevicePositionUpdate

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LocationService::DevicePositionUpdate object:

  $service_obj->Method(Att1 => { DeviceId => $value, ..., SampleTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LocationService::DevicePositionUpdate object:

  $result = $service_obj->Method(...);
  $result->Att1->DeviceId

=head1 DESCRIPTION

Contains the position update details for a device.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DeviceId => Str

The device associated to the position update.


=head2 B<REQUIRED> Position => ArrayRef[Num]

The latest device position defined in WGS 84
(https://earth-info.nga.mil/GandG/wgs84/index.html) format: C<[X or
longitude, Y or latitude]>.


=head2 B<REQUIRED> SampleTime => Str

The timestamp at which the device's position was determined. Uses ISO
8601 (https://www.iso.org/iso-8601-date-and-time-format.html) format:
C<YYYY-MM-DDThh:mm:ss.sssZ>



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LocationService>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

