#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Haven Park
# send your bug reports to bugs@dotslashplay.it
###

script_version=20241109.2

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='haven-park'
GAME_NAME='Haven Park'

ARCHIVE_BASE_2_NAME='haven_park_1_2_1_2_53266.sh'
ARCHIVE_BASE_2_MD5='d323146b73761aa946e599f060f4888b'
ARCHIVE_BASE_2_VERSION='1.2.1.2-gog53266'
ARCHIVE_BASE_2_SIZE='391856'
ARCHIVE_BASE_2_URL='https://www.gog.com/game/haven_park'

ARCHIVE_BASE_1_NAME='haven_park_1_0_8_49380.sh'
ARCHIVE_BASE_1_MD5='9fe66fd96d55f019e7d8767b9dea8544'
ARCHIVE_BASE_1_VERSION='1.0.8-gog49380'
ARCHIVE_BASE_1_SIZE='402142'

ARCHIVE_BASE_0_NAME='haven_park_1_0_5_49052.sh'
ARCHIVE_BASE_0_MD5='0c4fc4383682e8fc06eb0355b5e391b6'
ARCHIVE_BASE_0_VERSION='1.0.5-gog49052'
ARCHIVE_BASE_0_SIZE='400000'

UNITY3D_NAME='HavenPark'
## TODO: Check if the Steam library is required
UNITY3D_PLUGINS='
libsteam_api.so'

CONTENT_PATH_DEFAULT='data/noarch/game'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
