/*
 * RV60 decoder
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef AVCODEC_RV60VLCS_H
#define AVCODEC_RV60VLCS_H

#include <stdint.h>

static const uint8_t rv60_cbp8_lens[7][4][64] = {
  {
    {  7,  7,  7,  7,  7,  7,  8,  6,  7,  7,  7,  6,  7,  6,  6,  4,
       8,  8,  8,  7,  8,  7,  8,  6,  8,  8,  7,  6,  7,  6,  6,  3,
       9,  9,  9,  8,  9,  8,  9,  7,  9,  9,  8,  7,  8,  7,  7,  4,
       9,  9,  9,  7,  9,  7,  8,  5,  9,  8,  7,  5,  7,  5,  5,  2 },
    {  7,  4,  9,  4, 12,  6, 10,  5, 14,  9, 12,  8, 12,  7, 11,  3,
       9,  5, 11,  6, 12,  6, 11,  4, 14,  9, 13,  8, 12,  7, 11,  3,
      10,  5, 12,  6, 14,  6, 13,  6, 15, 11, 15, 10, 15,  9, 13,  5,
      11,  5, 14,  5, 13,  5, 12,  4, 15, 10, 14,  8, 14,  7, 12,  3 },
    {  5,  6,  6,  6,  6,  6,  7,  6,  6,  7,  6,  6,  6,  6,  6,  3,
       7,  7,  7,  7,  7,  7,  8,  6,  7,  8,  7,  6,  7,  6,  6,  3,
       9,  9,  9,  9,  9,  9, 10,  8,  9,  9,  9,  8,  9,  8,  8,  5,
       9,  9, 10,  8,  9,  8,  9,  7,  9,  9,  9,  7,  8,  7,  7,  2 },
    {  8,  4,  7,  4, 10,  5,  9,  4, 12,  8, 10,  7, 11,  7,  9,  4,
       9,  5, 10,  5, 10,  6, 11,  5, 14,  9, 13,  8, 12,  7, 10,  3,
      11,  6, 12,  6, 13,  7, 13,  6, 15, 11, 14,  9, 14, 10, 13,  5,
      11,  6, 12,  6, 12,  6, 13,  5, 15, 10, 14,  9, 14,  8, 12,  2 }
  },
  {
    {  7,  7,  7,  7,  7,  7,  8,  6,  7,  7,  7,  6,  7,  6,  6,  4,
       8,  8,  8,  7,  8,  7,  8,  6,  8,  8,  7,  6,  7,  6,  6,  3,
       9,  9,  9,  8,  9,  8,  9,  7,  9,  9,  8,  7,  8,  7,  7,  4,
       9,  9,  9,  7,  9,  7,  8,  5,  9,  8,  7,  5,  7,  5,  5,  2 },
    {  7,  4,  9,  4, 12,  6, 10,  5, 14,  9, 12,  8, 12,  7, 11,  3,
       9,  5, 11,  6, 12,  6, 11,  4, 14,  9, 13,  8, 12,  7, 11,  3,
      10,  5, 12,  6, 14,  6, 13,  6, 15, 11, 15, 10, 15,  9, 13,  5,
      11,  5, 14,  5, 13,  5, 12,  4, 15, 10, 14,  8, 14,  7, 12,  3 },
    {  5,  6,  6,  6,  6,  6,  7,  6,  6,  7,  6,  6,  6,  6,  6,  3,
       7,  7,  7,  7,  7,  7,  8,  6,  7,  8,  7,  6,  7,  6,  6,  3,
       9,  9,  9,  9,  9,  9, 10,  8,  9,  9,  9,  8,  9,  8,  8,  5,
       9,  9, 10,  8,  9,  8,  9,  7,  9,  9,  9,  7,  8,  7,  7,  2 },
    {  8,  4,  7,  4, 10,  5,  9,  4, 12,  8, 10,  7, 11,  7,  9,  4,
       9,  5, 10,  5, 10,  6, 11,  5, 14,  9, 13,  8, 12,  7, 10,  3,
      11,  6, 12,  6, 13,  7, 13,  6, 15, 11, 14,  9, 14, 10, 13,  5,
      11,  6, 12,  6, 12,  6, 13,  5, 15, 10, 14,  9, 14,  8, 12,  2 }
  },
  {
    {  5,  6,  6,  6,  6,  6,  7,  6,  6,  7,  6,  5,  6,  6,  5,  4,
       7,  7,  7,  7,  7,  7,  8,  6,  7,  8,  7,  6,  7,  6,  6,  4,
       8,  8,  8,  8,  8,  8,  9,  7,  8,  9,  8,  7,  8,  7,  7,  5,
       8,  8,  9,  7,  8,  7,  8,  6,  9,  8,  7,  6,  7,  6,  6,  2 },
    {  5,  2,  9,  5,  9,  5, 10,  4,  9,  7, 10,  6, 10,  6,  9,  3,
       8,  4, 11,  6,  9,  5, 11,  5, 11,  8, 12,  8, 11,  8, 11,  5,
       9,  5, 13,  7, 13,  7, 14,  7, 14, 10, 14,  9, 14,  9, 13,  6,
      10,  5, 14,  6, 12,  5, 14,  5, 14, 10, 14,  9, 14,  8, 14,  5 },
    {  4,  5,  6,  5,  5,  6,  6,  5,  5,  6,  5,  5,  5,  5,  5,  3,
       7,  7,  8,  7,  7,  7,  8,  6,  7,  8,  7,  6,  7,  6,  6,  3,
       9,  9, 10,  9,  9,  9, 10,  8,  9, 10,  9,  8,  8,  8,  8,  5,
      10, 10, 10,  9, 10,  9, 10,  7, 10, 10,  9,  7,  9,  7,  7,  4 },
    {  6,  3,  7,  4,  8,  4,  8,  4,  9,  7,  9,  6,  8,  6,  7,  3,
       9,  5, 10,  6,  9,  5, 10,  5, 12,  9, 11,  8, 10,  6,  9,  3,
      10,  5, 12,  7, 12,  7, 12,  7, 14, 11, 13,  9, 13,  9, 11,  5,
      10,  6, 12,  7, 11,  7, 13,  6, 14, 11, 13,  9, 13,  8, 11,  4 }
  },
  {
    {  4,  5,  5,  5,  6,  6,  7,  6,  5,  6,  5,  5,  6,  5,  5,  4,
       7,  7,  7,  7,  8,  7,  8,  6,  8,  8,  7,  6,  7,  6,  6,  4,
       8,  8,  8,  8,  8,  8,  9,  7,  8,  9,  7,  7,  8,  7,  7,  5,
       8,  8,  9,  7,  8,  7,  9,  6,  9,  9,  7,  6,  7,  6,  6,  3 },
    {  3,  2,  9,  4,  9,  4, 11,  5,  9,  7, 10,  7, 11,  7, 10,  5,
       7,  4, 12,  6, 10,  5, 13,  6, 13,  9, 14,  9, 13,  9, 14,  6,
       7,  4, 13,  6, 12,  6, 14,  7, 14, 10, 14, 10, 14, 10, 15,  8,
       9,  4, 13,  6, 12,  6, 15,  6, 14, 10, 15,  9, 15,  9, 14,  6 },
    {  3,  5,  5,  5,  5,  5,  6,  5,  5,  6,  5,  5,  4,  5,  5,  3,
       7,  7,  8,  7,  7,  7,  8,  6,  7,  8,  7,  7,  7,  7,  6,  4,
       8,  9,  9,  8,  9,  8,  9,  8,  9,  9,  8,  8,  8,  8,  8,  6,
      10, 10, 10,  9,  9,  8, 10,  8, 10, 10,  9,  8,  8,  8,  8,  5 },
    {  5,  2,  7,  4,  7,  4,  8,  4,  9,  6,  8,  6,  8,  5,  7,  3,
       8,  4, 10,  6,  9,  6, 10,  6, 12,  9, 11,  8, 10,  7,  9,  5,
       9,  5, 11,  7, 11,  7, 12,  7, 14, 10, 12,  9, 13,  9, 11,  6,
      10,  6, 12,  7, 11,  7, 12,  7, 14, 11, 13,  9, 13,  9, 12,  6 }
  },
  {
    {  4,  5,  5,  5,  5,  5,  6,  6,  5,  6,  5,  5,  5,  5,  5,  4,
       7,  7,  7,  7,  7,  7,  8,  6,  7,  8,  7,  6,  7,  7,  6,  4,
       7,  8,  8,  8,  8,  8,  9,  7,  8,  9,  7,  7,  8,  7,  7,  5,
       8,  8,  8,  7,  8,  7,  9,  6,  9,  8,  7,  6,  7,  6,  6,  4 },
    {  3,  1,  9,  5, 10,  5, 13,  6, 11,  9, 12,  8, 15, 10, 14,  8,
       7,  4, 13,  6, 12,  6, 15,  7, 15, 11, 15, 11, 15, 11, 15,  8,
       7,  4, 13,  7, 13,  7, 15,  8, 15, 12, 15, 11, 15, 12, 15,  9,
       9,  5, 14,  6, 13,  7, 15,  7, 15, 12, 15, 11, 15, 11, 15,  7 },
    {  3,  4,  4,  4,  4,  5,  6,  5,  4,  6,  5,  5,  4,  5,  5,  4,
       7,  8,  8,  7,  7,  7,  8,  7,  7,  8,  7,  7,  7,  7,  7,  6,
       8,  8,  8,  8,  8,  8,  9,  8,  8,  9,  8,  8,  8,  8,  8,  6,
      10, 10, 10,  9,  9,  9, 10,  9, 10, 10,  9,  9,  9,  9,  9,  7 },
    {  5,  1,  7,  4,  7,  4,  8,  5, 10,  7,  8,  6,  8,  6,  7,  4,
       8,  5, 10,  6, 10,  7, 11,  7, 12, 10, 11,  9, 11,  9, 10,  7,
       9,  5, 11,  7, 11,  7, 11,  8, 13, 11, 12,  9, 12, 10, 11,  8,
       9,  7, 11,  8, 12,  8, 13,  8, 14, 12, 13, 10, 14, 11, 12,  8 }
  },
  {
    {  3,  5,  5,  5,  5,  5,  6,  6,  4,  6,  5,  5,  5,  5,  5,  4,
       6,  7,  7,  7,  7,  7,  8,  7,  7,  8,  7,  7,  7,  7,  7,  5,
       7,  8,  8,  8,  8,  8,  9,  8,  8,  9,  7,  7,  8,  7,  7,  6,
       8,  8,  8,  7,  8,  7,  9,  6,  8,  9,  7,  7,  8,  7,  7,  4 },
    {  2,  1, 10,  5, 10,  6, 15,  8, 14, 11, 14, 10, 15, 11, 15,  9,
       7,  4, 13,  7, 13,  7, 15,  8, 15, 13, 15, 12, 15, 12, 15, 10,
       7,  5, 13,  8, 13,  8, 15, 10, 15, 14, 15, 12, 15, 13, 15, 10,
       9,  5, 14,  7, 14,  8, 15,  8, 15, 13, 15, 12, 15, 12, 15,  9 },
    {  2,  4,  4,  5,  4,  5,  6,  5,  4,  6,  5,  5,  4,  5,  5,  5,
       7,  8,  8,  8,  7,  8,  9,  8,  7,  9,  8,  8,  8,  8,  8,  7,
       7,  8,  8,  8,  8,  8,  9,  8,  8, 10,  8,  9,  8,  9,  9,  7,
       9, 10, 10, 10,  9,  9, 11,  9, 10, 11, 10, 10,  9, 10, 10,  8 },
    {  4,  1,  6,  4,  6,  4,  8,  5,  9,  8,  8,  7,  8,  7,  7,  6,
       8,  4,  9,  6,  9,  7, 11,  8, 12, 10, 11, 10, 11, 10, 11,  8,
       8,  5, 10,  7, 10,  8, 11,  9, 13, 11, 11, 10, 12, 10, 11,  9,
       9,  6, 11,  8, 12,  9, 13,  9, 14, 13, 13, 11, 14, 11, 13,  9 }
  },
  {
    {  2,  4,  4,  5,  4,  5,  6,  6,  4,  6,  5,  6,  5,  6,  5,  5,
       6,  7,  7,  7,  7,  8,  8,  8,  7,  8,  7,  8,  7,  8,  8,  7,
       7,  8,  8,  8,  8,  8,  9,  8,  8,  9,  8,  8,  8,  8,  8,  7,
       8,  8,  8,  8,  8,  8,  9,  8,  8,  9,  8,  8,  8,  8,  8,  7 },
    {  1,  2,  9,  5,  9,  6, 14,  8, 14, 11, 14, 11, 14, 11, 14, 10,
       6,  4, 12,  7, 13,  8, 14, 10, 14, 14, 14, 13, 14, 13, 14, 12,
       6,  5, 13,  8, 13,  9, 14, 11, 14, 14, 14, 13, 14, 14, 14, 12,
       7,  5, 14,  8, 14,  9, 14, 11, 14, 14, 14, 14, 14, 14, 14, 12 },
    {  1,  4,  4,  6,  4,  5,  6,  7,  4,  6,  5,  7,  5,  7,  7,  7,
       7,  8,  9,  9,  8,  9, 10, 10,  8, 10,  9, 11,  9, 10, 10, 10,
       7,  9,  9, 10,  9,  9, 10, 10,  9, 11, 10, 11, 10, 10, 10, 10,
       9, 11, 11, 11, 10, 11, 12, 12, 11, 12, 11, 12, 11, 12, 12, 11 },
    {  2,  1,  6,  4,  7,  5,  9,  8, 10,  9,  9,  8, 10,  9,  9,  8,
       8,  5, 11,  8, 11,  9, 13, 11, 14, 13, 13, 12, 14, 12, 14, 11,
       8,  5, 11,  8, 12,  9, 13, 11, 14, 13, 14, 12, 13, 13, 13, 12,
       9,  6, 12,  9, 13, 10, 14, 12, 14, 14, 14, 13, 14, 14, 14, 12 }
  }
};

static const uint8_t rv60_cbp16_lens[7][3][4][64] = {
  {
    {
      {  9,  6,  7,  4, 11,  6, 10,  5, 11,  8, 10,  6, 12,  8, 11,  5,
        10,  6,  9,  5, 12,  6, 11,  5, 12,  9, 11,  7, 13,  8, 11,  4,
        10,  7,  8,  5, 12,  7, 11,  5, 12,  9, 11,  7, 14,  9, 12,  3,
        11,  6, 10,  5, 13,  5, 13,  4, 14,  9, 13,  7, 13,  7, 12,  2 },
      {  1,  3,  6,  3,  6,  5,  8,  5,  9,  8, 10,  8,  9,  7, 10,  6,
         6,  7,  9,  6,  9,  8, 10,  8, 11, 11, 11, 10, 11,  8, 10,  7,
         6,  7, 11,  7, 11, 10, 14, 11, 15, 15, 15, 14, 15, 13, 16, 12,
        10,  9, 12,  8, 12, 10, 14,  9, 16, 14, 14, 11, 15, 11, 13,  9 },
      {  1,  3,  6,  5,  6,  5,  8,  6,  7,  8,  9,  7,  8,  7,  8,  5,
         6,  6, 10,  8,  9,  7, 10,  7, 11, 10, 12,  9, 11,  8,  9,  5,
         5,  6, 10,  9, 10,  8, 12, 10, 12, 12, 14, 12, 13, 11, 14, 10,
         9,  8, 12,  9, 11,  7, 13,  8, 13, 12, 14, 11, 14,  9, 13,  6 },
      {  1,  4,  6,  6,  4,  4,  7,  5,  7,  7,  9,  8,  7,  5,  8,  5,
         7,  8, 10,  9,  9,  6,  9,  6, 11,  9, 10,  8,  9,  5,  8,  5,
         7, 12, 13, 13, 13, 11, 13, 12, 13, 13, 13, 13, 13, 13, 13, 11,
        12, 12, 13, 12, 13, 11, 12, 10, 13, 12, 12, 10, 12, 10, 10,  8 }
    },
    {
      {  4,  6,  6,  6,  6,  6,  7,  6,  6,  6,  6,  6,  6,  6,  6,  4,
         6,  7,  7,  7,  7,  7,  7,  6,  7,  7,  7,  6,  7,  6,  6,  3,
         8,  9,  9,  9,  9,  9,  9,  8,  9,  9,  9,  8,  9,  8,  8,  5,
         8,  9,  9,  8,  9,  8,  9,  7,  9,  9,  8,  7,  8,  7,  7,  2 },
      {  4,  6,  6,  6,  6,  6,  7,  6,  5,  7,  6,  6,  6,  6,  6,  4,
         6,  7,  7,  7,  7,  7,  8,  6,  7,  8,  7,  6,  7,  6,  6,  3,
         8,  9,  9,  9,  9,  9,  9,  8,  9,  9,  9,  8,  9,  8,  8,  5,
         8,  9,  9,  8,  9,  8,  9,  7,  9,  9,  8,  7,  8,  7,  7,  2 },
      {  4,  6,  6,  6,  6,  6,  7,  6,  6,  6,  6,  6,  6,  6,  6,  4,
         6,  7,  7,  7,  7,  7,  7,  6,  7,  7,  7,  6,  7,  6,  6,  3,
         8,  9,  9,  9,  9,  9,  9,  8,  9,  9,  9,  8,  9,  8,  8,  5,
         8,  9,  9,  8,  9,  8,  9,  7,  9,  9,  8,  7,  8,  7,  7,  2 },
      {  4,  6,  6,  6,  6,  6,  7,  6,  6,  6,  6,  6,  6,  6,  6,  4,
         6,  7,  7,  7,  7,  7,  7,  6,  7,  7,  7,  6,  7,  6,  6,  3,
         8,  9,  9,  9,  9,  9,  9,  8,  9,  9,  9,  8,  9,  8,  8,  5,
         8,  9,  9,  8,  9,  8,  9,  7,  9,  9,  8,  7,  8,  7,  7,  2 }
    },
    {
      {  9,  6,  7,  4, 10,  7,  9,  5, 10,  7,  9,  6, 11,  7,  8,  3,
        10,  7,  9,  6, 10,  6, 10,  5, 12,  8, 10,  6, 11,  6,  9,  3,
        11,  8,  9,  7, 13,  8, 12,  7, 13, 10, 12,  8, 13,  9, 11,  4,
        11,  8, 10,  7, 12,  6, 11,  4, 13,  8, 12,  7, 12,  6, 10,  2 },
      {  2,  3,  6,  4,  5,  4,  7,  4,  7,  7,  9,  7,  8,  5,  8,  4,
         5,  6,  8,  7,  7,  6,  8,  6, 10,  9, 11,  9, 10,  7, 10,  5,
         7,  6, 11,  8,  9,  7, 11,  8, 13, 12, 14, 12, 13, 10, 13,  7,
         9,  8, 11,  9, 10,  8, 12,  7, 13, 12, 14, 10, 12,  9, 13,  5 },
      {  2,  3,  5,  4,  6,  5,  7,  5,  7,  7,  8,  6,  8,  7,  8,  4,
         5,  5,  7,  6,  8,  6,  9,  6,  9,  8, 10,  8, 10,  8,  9,  4,
         6,  6,  9,  7, 10,  8, 11,  8, 11, 10, 11,  9, 12, 10, 11,  7,
         9,  8, 10,  8, 10,  7, 11,  7, 12, 10, 12,  9, 12,  9, 11,  5 },
      {  1,  3,  5,  6,  5,  5,  7,  5,  7,  7,  9,  7,  8,  5,  9,  5,
         6,  8, 10, 10,  9,  7, 11,  6, 11, 10, 12,  9, 11,  6, 11,  5,
         8, 10, 12, 11, 11, 10, 13, 10, 14, 13, 14, 12, 14, 11, 14,  8,
        11, 12, 14, 13, 13, 11, 14,  9, 14, 14, 14, 12, 14, 10, 13,  6 }
    }
  },
  {
    {
      {  9,  6,  7,  4, 11,  6, 10,  5, 11,  8, 10,  6, 12,  8, 11,  5,
        10,  6,  9,  5, 12,  6, 11,  5, 12,  9, 11,  7, 13,  8, 11,  4,
        10,  7,  8,  5, 12,  7, 11,  5, 12,  9, 11,  7, 14,  9, 12,  3,
        11,  6, 10,  5, 13,  5, 13,  4, 14,  9, 13,  7, 13,  7, 12,  2 },
      {  1,  3,  6,  3,  6,  5,  8,  5,  9,  8, 10,  8,  9,  7, 10,  6,
         6,  7,  9,  6,  9,  8, 10,  8, 11, 11, 11, 10, 11,  8, 10,  7,
         6,  7, 11,  7, 11, 10, 14, 11, 15, 15, 15, 14, 15, 13, 16, 12,
        10,  9, 12,  8, 12, 10, 14,  9, 16, 14, 14, 11, 15, 11, 13,  9 },
      {  1,  3,  6,  5,  6,  5,  8,  6,  7,  8,  9,  7,  8,  7,  8,  5,
         6,  6, 10,  8,  9,  7, 10,  7, 11, 10, 12,  9, 11,  8,  9,  5,
         5,  6, 10,  9, 10,  8, 12, 10, 12, 12, 14, 12, 13, 11, 14, 10,
         9,  8, 12,  9, 11,  7, 13,  8, 13, 12, 14, 11, 14,  9, 13,  6 },
      {  1,  4,  6,  6,  4,  4,  7,  5,  7,  7,  9,  8,  7,  5,  8,  5,
         7,  8, 10,  9,  9,  6,  9,  6, 11,  9, 10,  8,  9,  5,  8,  5,
         7, 12, 13, 13, 13, 11, 13, 12, 13, 13, 13, 13, 13, 13, 13, 11,
        12, 12, 13, 12, 13, 11, 12, 10, 13, 12, 12, 10, 12, 10, 10,  8 }
    },
    {
      {  4,  6,  6,  6,  6,  6,  7,  6,  6,  6,  6,  6,  6,  6,  6,  4,
         6,  7,  7,  7,  7,  7,  7,  6,  7,  7,  7,  6,  7,  6,  6,  3,
         8,  9,  9,  9,  9,  9,  9,  8,  9,  9,  9,  8,  9,  8,  8,  5,
         8,  9,  9,  8,  9,  8,  9,  7,  9,  9,  8,  7,  8,  7,  7,  2 },
      {  4,  6,  6,  6,  6,  6,  7,  6,  5,  7,  6,  6,  6,  6,  6,  4,
         6,  7,  7,  7,  7,  7,  8,  6,  7,  8,  7,  6,  7,  6,  6,  3,
         8,  9,  9,  9,  9,  9,  9,  8,  9,  9,  9,  8,  9,  8,  8,  5,
         8,  9,  9,  8,  9,  8,  9,  7,  9,  9,  8,  7,  8,  7,  7,  2 },
      {  4,  6,  6,  6,  6,  6,  7,  6,  6,  6,  6,  6,  6,  6,  6,  4,
         6,  7,  7,  7,  7,  7,  7,  6,  7,  7,  7,  6,  7,  6,  6,  3,
         8,  9,  9,  9,  9,  9,  9,  8,  9,  9,  9,  8,  9,  8,  8,  5,
         8,  9,  9,  8,  9,  8,  9,  7,  9,  9,  8,  7,  8,  7,  7,  2 },
      {  4,  6,  6,  6,  6,  6,  7,  6,  6,  6,  6,  6,  6,  6,  6,  4,
         6,  7,  7,  7,  7,  7,  7,  6,  7,  7,  7,  6,  7,  6,  6,  3,
         8,  9,  9,  9,  9,  9,  9,  8,  9,  9,  9,  8,  9,  8,  8,  5,
         8,  9,  9,  8,  9,  8,  9,  7,  9,  9,  8,  7,  8,  7,  7,  2 }
    },
    {
      {  9,  6,  7,  4, 10,  7,  9,  5, 10,  7,  9,  6, 11,  7,  8,  3,
        10,  7,  9,  6, 10,  6, 10,  5, 12,  8, 10,  6, 11,  6,  9,  3,
        11,  8,  9,  7, 13,  8, 12,  7, 13, 10, 12,  8, 13,  9, 11,  4,
        11,  8, 10,  7, 12,  6, 11,  4, 13,  8, 12,  7, 12,  6, 10,  2 },
      {  2,  3,  6,  4,  5,  4,  7,  4,  7,  7,  9,  7,  8,  5,  8,  4,
         5,  6,  8,  7,  7,  6,  8,  6, 10,  9, 11,  9, 10,  7, 10,  5,
         7,  6, 11,  8,  9,  7, 11,  8, 13, 12, 14, 12, 13, 10, 13,  7,
         9,  8, 11,  9, 10,  8, 12,  7, 13, 12, 14, 10, 12,  9, 13,  5 },
      {  2,  3,  5,  4,  6,  5,  7,  5,  7,  7,  8,  6,  8,  7,  8,  4,
         5,  5,  7,  6,  8,  6,  9,  6,  9,  8, 10,  8, 10,  8,  9,  4,
         6,  6,  9,  7, 10,  8, 11,  8, 11, 10, 11,  9, 12, 10, 11,  7,
         9,  8, 10,  8, 10,  7, 11,  7, 12, 10, 12,  9, 12,  9, 11,  5 },
      {  1,  3,  5,  6,  5,  5,  7,  5,  7,  7,  9,  7,  8,  5,  9,  5,
         6,  8, 10, 10,  9,  7, 11,  6, 11, 10, 12,  9, 11,  6, 11,  5,
         8, 10, 12, 11, 11, 10, 13, 10, 14, 13, 14, 12, 14, 11, 14,  8,
        11, 12, 14, 13, 13, 11, 14,  9, 14, 14, 14, 12, 14, 10, 13,  6 }
    }
  },
  {
    {
      {  7,  4,  7,  4,  9,  5, 10,  4,  9,  7, 10,  7, 11,  7, 12,  5,
         7,  4,  9,  5,  8,  5, 10,  4,  9,  8, 11,  7, 10,  7, 11,  5,
         8,  5, 10,  6, 10,  6, 12,  5, 12,  9, 14,  8, 12,  8, 13,  5,
         9,  5, 11,  5, 10,  5, 11,  3, 11,  8, 12,  7, 11,  7, 14,  4 },
      {  1,  3,  4,  4,  4,  5,  6,  6,  6,  8,  7,  8,  8,  8,  8,  7,
         6,  7,  8,  7,  8,  8, 10,  8,  9, 10, 10, 11, 10, 10, 11, 10,
         8,  9, 12,  9, 12, 11, 14, 11, 14, 14, 14, 14, 14, 13, 14, 13,
        10,  9, 13,  9, 14, 10, 14, 10, 14, 14, 14, 13, 14, 13, 14, 10 },
      {  1,  3,  5,  5,  5,  5,  7,  7,  6,  7,  7,  7,  7,  7,  7,  7,
         6,  6,  8,  8,  7,  6,  8,  6,  8,  8,  9,  8,  8,  6,  8,  6,
         7,  8, 11, 11, 11, 10, 14, 12, 13, 14, 14, 12, 14, 13, 14, 11,
        10,  9, 13, 11, 11,  8, 13,  9, 14, 13, 14, 12, 13, 10, 14,  9 },
      {  1,  3,  5,  6,  3,  4,  7,  7,  6,  7,  9, 10,  7,  7, 10,  9,
         5,  7,  8,  9,  7,  7,  9, 10,  8,  9, 10, 11,  9,  9, 12, 10,
        11, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
        13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 13 }
    },
    {
      {  3,  4,  5,  5,  4,  5,  6,  5,  5,  6,  5,  5,  5,  5,  5,  4,
         6,  7,  7,  7,  7,  7,  8,  6,  7,  8,  7,  7,  7,  7,  7,  4,
         8,  9,  9,  8,  9,  9, 10,  8,  9, 10,  9,  8,  9,  8,  8,  6,
         9, 10, 10,  8, 10,  8, 10,  7, 10, 10,  9,  8,  9,  8,  8,  4 },
      {  3,  5,  4,  5,  5,  5,  6,  5,  4,  6,  5,  5,  5,  5,  5,  4,
         6,  7,  7,  7,  7,  7,  8,  7,  7,  8,  7,  6,  7,  7,  7,  4,
         8,  9,  9,  9,  9,  9, 10,  8,  9, 10,  9,  8,  9,  8,  8,  6,
         9, 10, 10,  8, 10,  9, 10,  7, 10, 10,  9,  7,  9,  8,  8,  4 },
      {  3,  4,  5,  5,  4,  5,  6,  5,  5,  6,  5,  5,  5,  5,  5,  4,
         6,  7,  7,  7,  7,  7,  8,  7,  7,  8,  7,  7,  7,  7,  7,  4,
         7,  9,  9,  9,  9,  9, 10,  8,  9, 10,  9,  8,  8,  8,  8,  6,
         9,  9, 10,  9,  9,  9, 10,  7, 10, 10,  9,  8,  8,  7,  8,  4 },
      {  3,  5,  4,  5,  5,  5,  6,  6,  4,  6,  5,  5,  5,  5,  5,  4,
         6,  7,  7,  7,  7,  7,  8,  7,  7,  8,  7,  7,  7,  7,  6,  4,
         7,  9,  9,  9,  9,  9, 10,  8,  9, 10,  9,  8,  9,  8,  8,  5,
         9, 10, 10,  9, 10,  9, 10,  8, 10, 10,  9,  8,  8,  8,  7,  4 }
    },
    {
      {  7,  4,  6,  4,  8,  5,  8,  4,  9,  6,  8,  5,  9,  6,  7,  3,
         8,  4,  9,  5,  9,  5,  9,  5, 10,  7, 10,  6, 10,  7,  9,  4,
         9,  6, 10,  7, 11,  6, 11,  5, 13,  9, 11,  8, 12,  8, 10,  5,
         9,  6, 11,  6, 10,  6, 11,  5, 13,  8, 12,  7, 12,  7, 11,  4 },
      {  1,  3,  5,  5,  4,  4,  8,  5,  8,  8,  9,  7,  8,  7,  9,  5,
         6,  7,  9,  8,  8,  7, 11,  8, 11, 10, 12, 11, 11,  9, 12,  7,
         8,  9, 13, 10, 11,  9, 13, 10, 14, 14, 15, 13, 14, 11, 14,  8,
        10, 10, 12,  9, 12, 10, 13,  9, 15, 14, 15, 11, 15, 11, 14,  7 },
      {  1,  3,  5,  5,  6,  6,  7,  6,  6,  7,  7,  6,  7,  7,  7,  5,
         6,  6,  9,  8,  9,  7,  9,  7, 10,  9, 10,  8,  9,  7,  8,  5,
         7,  8, 11, 10, 11,  9, 13, 10, 11, 12, 11, 11, 13, 11, 12,  8,
         9,  8, 12, 10, 11,  8, 12,  9, 14, 12, 14, 11, 13, 10, 12,  7 },
      {  1,  3,  6,  6,  4,  3,  7,  5,  7,  7,  9,  8,  8,  6,  9,  6,
         7,  8, 10, 10,  8,  7, 10,  8, 10,  9, 12, 10, 10,  8, 11,  7,
        10, 11, 13, 12, 11, 10, 14, 11, 14, 14, 14, 13, 14, 12, 13,  9,
        13, 13, 14, 13, 14, 11, 14, 11, 14, 13, 14, 13, 14, 11, 14,  9 }
    }
  },
  {
    {
      {  7,  3,  7,  4,  9,  4, 11,  4, 10,  8, 11,  7, 13,  7, 13,  5,
         6,  4,  9,  5,  9,  5, 12,  5, 11,  9, 13,  8, 13,  8, 15,  6,
         8,  5, 11,  5, 12,  6, 14,  6, 14, 10, 15,  9, 15,  9, 15,  6,
         8,  4, 12,  4, 12,  4, 15,  4, 13,  9, 15,  8, 15,  8, 15,  5 },
      {  1,  3,  4,  3,  5,  5,  7,  5,  8,  9,  8,  8,  9,  8,  9,  7,
         6,  7, 10,  7, 10,  8, 13,  9, 12, 13, 13, 13, 13, 13, 13, 11,
         9,  9, 12,  9, 12, 11, 13, 12, 13, 13, 13, 13, 13, 13, 13, 12,
        11,  9, 12,  9, 13, 11, 13, 10, 13, 13, 13, 13, 13, 13, 13, 11 },
      {  1,  3,  5,  5,  5,  5,  7,  7,  5,  7,  7,  7,  7,  8,  7,  8,
         4,  6,  8,  8,  6,  6,  9,  9,  8,  9, 11, 10,  9,  9, 11,  9,
         7,  9, 13, 12, 12,  9, 13, 12, 13, 14, 13, 12, 14, 14, 14, 12,
        10,  9, 13, 11, 12,  9, 13, 11, 13, 13, 13, 13, 13, 12, 13, 11 },
      {  1,  3,  5,  6,  3,  4,  7,  7,  6,  7, 10,  9,  8,  7, 10,  8,
         4,  9, 11, 11,  8, 10, 11, 12, 10, 11, 12, 12, 12, 12, 12, 11,
        12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
        12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12 }
    },
    {
      {  2,  4,  4,  5,  4,  5,  6,  5,  5,  6,  5,  5,  5,  6,  6,  4,
         6,  7,  7,  7,  7,  7,  8,  7,  7,  8,  8,  7,  7,  7,  8,  6,
         7,  9,  9,  8,  9,  9, 10,  8,  9, 10,  9,  9,  9,  9,  9,  6,
         9, 10, 10,  9, 10,  9, 10,  8, 10, 10,  9,  9,  9,  9,  9,  6 },
      {  2,  4,  4,  5,  5,  5,  6,  5,  4,  6,  5,  5,  5,  6,  5,  4,
         6,  7,  7,  7,  8,  8,  9,  7,  8,  9,  8,  7,  7,  8,  7,  6,
         7,  9,  9,  9,  9,  9, 10,  9,  9, 10,  9,  8,  9,  9,  8,  6,
         9, 10, 10,  9, 10,  9, 10,  9, 10, 10,  9,  8,  9,  9,  9,  6 },
      {  2,  4,  4,  5,  4,  5,  6,  5,  4,  6,  5,  6,  5,  5,  6,  4,
         6,  7,  8,  7,  7,  8,  9,  7,  8,  9,  8,  8,  7,  7,  8,  6,
         7,  9,  9,  9,  9,  9, 10,  9,  9, 10,  9,  9,  9,  8,  9,  7,
         9, 10, 10,  9, 10,  9, 11,  9, 10, 11, 10,  9,  9,  8,  9,  6 },
      {  2,  5,  4,  5,  4,  5,  6,  6,  4,  6,  5,  5,  5,  6,  5,  4,
         6,  7,  7,  8,  7,  8,  8,  8,  7,  8,  8,  8,  7,  8,  7,  5,
         7,  9,  9,  9,  9,  9, 10,  9,  9, 10,  9,  8,  9,  9,  8,  6,
         9, 10, 10,  9, 10,  9, 10,  9, 10, 10,  9,  9,  9,  9,  8,  6 }
    },
    {
      {  6,  2,  6,  4,  7,  4,  8,  4,  9,  6,  8,  6,  9,  6,  8,  4,
         7,  4,  9,  5,  9,  5, 10,  6, 11,  8, 10,  7, 11,  7, 10,  5,
         8,  5, 10,  6, 10,  6, 11,  6, 12,  9, 12,  8, 12,  9, 11,  6,
         9,  6, 11,  7, 10,  6, 11,  6, 12, 10, 12,  8, 12,  9, 11,  6 },
      {  1,  3,  5,  4,  4,  5,  6,  5,  7,  8,  9,  7,  8,  7,  8,  5,
         6,  7, 10,  8,  9,  8, 11,  8, 12, 12, 13, 10, 13, 10, 12,  8,
         8,  9, 12,  9, 11, 10, 13,  9, 14, 14, 14, 11, 14, 12, 13,  9,
        10, 10, 11,  9, 12, 11, 13,  9, 14, 14, 14, 11, 14, 12, 13,  8 },
      {  1,  3,  5,  5,  5,  5,  7,  6,  6,  7,  6,  6,  7,  7,  7,  5,
         6,  6,  9,  8,  7,  7,  9,  7,  9,  9, 10,  9,  9,  8,  9,  7,
         7,  9, 11, 11, 11,  9, 12, 11, 11, 12, 12, 11, 13, 11, 12,  9,
         9,  8, 12, 11, 10,  9, 13, 10, 13, 13, 13, 12, 13, 11, 12,  9 },
      {  1,  3,  5,  6,  3,  4,  7,  5,  7,  7,  9,  8,  8,  6,  9,  6,
         6,  8, 11, 11,  9,  9, 12, 10, 11, 10, 13, 11, 12, 11, 12,  9,
         9, 11, 12, 11, 11, 10, 13, 11, 13, 13, 12, 12, 12, 12, 12, 10,
        12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 10 }
    }
  },
  {
    {
      {  8,  2,  7,  4,  9,  4, 12,  4, 12,  9, 14,  8, 14,  8, 15,  5,
         7,  4, 10,  5, 11,  5, 14,  5, 13, 10, 15,  9, 15,  9, 15,  6,
         8,  4, 12,  6, 12,  6, 15,  6, 15, 11, 15, 10, 15, 10, 15,  7,
         9,  4, 13,  5, 13,  5, 15,  5, 15, 10, 15,  9, 15,  8, 15,  5 },
      {  1,  2,  4,  4,  5,  6,  8,  6, 10, 10, 11,  9, 11, 10, 12,  8,
         7,  7, 11,  8, 12,  9, 13,  9, 13, 13, 13, 13, 13, 13, 13,  9,
         8,  8, 12,  9, 13, 11, 13, 10, 13, 13, 13, 13, 13, 13, 13, 12,
        10,  9, 13,  9, 13, 10, 13, 10, 13, 13, 13, 13, 13, 12, 13, 11 },
      {  1,  2,  5,  5,  5,  5,  9,  7,  6,  8,  8,  8,  8,  9, 10,  8,
         6,  6, 11,  9,  8,  7, 12,  9, 13, 11, 13, 11, 12, 10, 13,  9,
         7,  8, 13, 11, 13,  9, 13, 11, 13, 13, 13, 11, 13, 12, 13, 11,
        10,  9, 13, 11, 13,  9, 13, 10, 13, 13, 13, 13, 13, 12, 13, 11 },
      {  1,  2,  6,  7,  3,  5,  9,  7,  8, 10, 10, 10, 10,  9, 11,  9,
         7, 11, 11, 11, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
        10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
        10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 10 }
    },
    {
      {  2,  4,  4,  5,  4,  5,  6,  5,  4,  6,  5,  5,  5,  5,  5,  4,
         6,  7,  8,  7,  8,  8,  9,  8,  8,  9,  8,  8,  8,  8,  8,  7,
         7,  8,  9,  8,  8,  8, 10,  8,  8, 10,  9,  9,  9,  9,  9,  7,
         9, 10, 10,  9, 10,  9, 11,  9, 10, 11, 10, 10, 10, 10, 10,  8 },
      {  2,  4,  4,  4,  4,  5,  6,  5,  4,  6,  5,  5,  5,  6,  5,  4,
         6,  8,  8,  8,  8,  8,  9,  8,  8,  9,  8,  8,  8,  8,  8,  7,
         7,  8,  8,  8,  9,  9, 10,  9,  9, 10,  9,  9,  9,  9,  9,  7,
         9, 10, 10, 10, 10, 10, 11, 10, 10, 11, 10,  9, 10, 10, 10,  8 },
      {  2,  4,  4,  5,  4,  5,  6,  5,  4,  6,  5,  6,  4,  5,  5,  4,
         6,  8,  8,  8,  8,  8,  9,  8,  8,  9,  8,  8,  8,  8,  8,  7,
         7,  8,  9,  9,  8,  8, 10,  9,  9, 10,  9,  9,  9,  9,  9,  7,
         9, 10, 10, 10, 10,  9, 11, 10, 10, 11, 10, 10, 10, 10, 10,  8 },
      {  2,  4,  4,  5,  4,  5,  6,  5,  4,  6,  5,  5,  4,  6,  5,  4,
         6,  8,  8,  8,  8,  8,  9,  8,  8,  9,  8,  8,  8,  8,  8,  7,
         7,  9,  9,  9,  8,  9, 10,  9,  8, 10,  9,  9,  9,  9,  8,  7,
         9, 10, 10, 10, 10, 10, 11, 10, 10, 11, 10, 10, 10, 10,  9,  8 }
    },
    {
      {  7,  1,  7,  4,  7,  4,  9,  5,  9,  7,  9,  6, 10,  7,  9,  5,
         7,  4,  9,  6,  9,  6, 10,  7, 11,  9, 11,  8, 11,  9, 11,  7,
         8,  5, 10,  7, 10,  7, 11,  7, 12, 10, 11,  9, 12, 10, 11,  7,
         9,  6, 11,  7, 11,  8, 12,  8, 13, 10, 12,  9, 13, 10, 12,  8 },
      {  1,  3,  4,  4,  4,  5,  6,  5,  8,  8,  8,  7,  9,  8,  8,  6,
         7,  8,  9,  8, 10,  9, 11,  8, 13, 12, 12, 10, 13, 11, 12,  8,
         7,  9, 10,  8, 11, 10, 12,  9, 14, 14, 13, 10, 14, 12, 12,  9,
         9, 10, 11,  9, 12, 11, 14,  9, 14, 14, 14, 11, 14, 12, 13,  9 },
      {  1,  3,  4,  5,  5,  5,  7,  6,  6,  7,  6,  6,  7,  7,  7,  5,
         6,  6,  9,  8,  8,  8, 11,  9, 10, 10, 11, 10, 11, 10, 11,  9,
         7,  8, 10, 11, 10,  9, 13, 11, 11, 12, 12, 12, 12, 11, 12, 10,
         8,  9, 12, 11, 10,  9, 13, 12, 13, 13, 13, 13, 13, 12, 13, 11 },
      {  1,  2,  5,  6,  4,  4,  7,  7,  7,  8,  8,  8,  8,  7,  8,  7,
         8, 10, 12, 12, 12, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 10,
         9, 11, 12, 12, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 11,
        12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12 }
    }
  },
  {
    {
      {  9,  2,  7,  4,  9,  4, 13,  5, 12, 10, 14,  9, 14,  9, 15,  6,
         7,  3, 11,  5, 12,  5, 15,  6, 15, 11, 15, 10, 15, 10, 15,  7,
         7,  4, 12,  6, 12,  6, 15,  7, 15, 11, 15, 11, 15, 11, 15,  8,
         9,  3, 13,  5, 13,  5, 15,  6, 15, 11, 15, 10, 15, 10, 15,  6 },
      {  1,  2,  4,  4,  6,  5,  9,  6, 10, 11, 12, 10, 11,  9, 12,  8,
         8,  7, 10,  8, 12,  9, 12,  9, 12, 12, 12, 12, 12, 12, 12, 10,
         7,  8, 12,  9, 12, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
        10,  9, 12,  8, 12, 11, 12, 11, 12, 12, 12, 12, 12, 12, 12, 12 },
      {  1,  2,  5,  5,  6,  4, 10,  7,  8,  9,  9,  8, 10, 11, 11,  7,
         6,  6, 10,  9, 10,  8, 11, 10, 11, 11, 11, 10, 11, 11, 11, 10,
         7,  8, 11, 10, 11, 10, 11, 11, 11, 11, 10, 11, 11, 11, 11, 11,
        10,  8, 11, 10, 11,  9, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11 },
      {  1,  3,  7,  5,  4,  5,  8,  7,  8,  7,  8,  8,  8,  8,  8,  7,
         7,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
         8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
         8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8 }
    },
    {
      {  1,  4,  4,  5,  4,  5,  6,  6,  5,  7,  6,  7,  5,  7,  7,  6,
         6,  8,  8,  8,  8,  9, 10,  9,  8, 10,  9, 10,  9,  9,  9,  9,
         7,  9,  9,  9,  9,  9, 11,  9,  9, 10, 10, 10, 10, 10, 10,  9,
         9, 10, 10, 10, 10, 10, 12, 10, 11, 12, 11, 11, 11, 11, 11, 10 },
      {  1,  4,  4,  5,  5,  6,  6,  6,  4,  7,  5,  6,  5,  7,  6,  6,
         7,  8,  8,  9,  9,  9, 10,  9,  8, 10,  9,  9,  9, 10, 10,  9,
         7,  9,  9,  9,  9, 10, 10, 10,  9, 11,  9, 10, 10, 10, 10,  9,
         9, 10, 10, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 10 },
      {  1,  4,  5,  5,  4,  5,  7,  6,  4,  7,  6,  7,  5,  6,  6,  6,
         6,  8,  9,  9,  8,  9, 10,  9,  8, 10,  9, 10,  9,  9, 10,  9,
         7,  9,  9, 10,  9,  9, 11, 10,  9, 11, 10, 10,  9, 10, 10,  9,
         9, 10, 11, 11, 10, 10, 12, 11, 11, 12, 11, 11, 11, 11, 11, 10 },
      {  1,  4,  4,  5,  5,  6,  6,  7,  4,  7,  5,  6,  5,  7,  6,  6,
         6,  8,  8,  9,  8,  9, 10, 10,  8, 10,  9, 10,  9, 10,  9,  9,
         7,  9,  9, 10,  9, 10, 10, 10,  9, 11,  9, 10,  9, 10, 10,  9,
         9, 11, 11, 11, 11, 11, 12, 11, 10, 12, 11, 12, 11, 12, 11, 10 }
    },
    {
      {  6,  1,  6,  4,  7,  4,  8,  5,  9,  7,  9,  6, 10,  7,  9,  6,
         6,  4,  9,  6,  9,  6, 10,  7, 11,  9, 11,  9, 12,  9, 11,  7,
         7,  5,  9,  7, 10,  7, 11,  8, 12, 10, 11,  9, 12, 10, 12,  8,
         8,  6, 10,  8, 10,  8, 12,  8, 12, 10, 12, 10, 13, 11, 13,  9 },
      {  1,  3,  4,  3,  5,  5,  7,  6,  8,  9,  8,  7,  9,  9,  9,  7,
         7,  7,  9,  7, 10,  9, 11,  9, 12, 12, 12, 10, 13, 12, 12, 10,
         7,  8, 10,  8, 11, 10, 12, 10, 13, 13, 12, 10, 13, 13, 12, 10,
         8,  9, 10,  8, 12, 12, 13, 10, 13, 13, 13, 11, 13, 13, 13, 11 },
      {  1,  3,  4,  6,  5,  4,  7,  7,  5,  7,  7,  7,  7,  7,  7,  6,
         5,  6,  9, 10,  9,  8, 12, 11, 10, 11, 11, 11, 12, 11, 11, 10,
         6,  9, 11, 12, 10, 10, 13, 11, 11, 13, 12, 12, 12, 11, 12, 11,
         8,  9, 12, 13, 11, 10, 13, 12, 13, 13, 13, 13, 13, 12, 13, 12 },
      {  1,  2,  5,  6,  4,  5,  7,  7,  7,  7,  8,  7,  7,  7,  8,  6,
         8, 10, 11, 11, 11, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
         8, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
        11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11 }
    }
  },
  {
    {
      {  9,  1,  8,  5,  8,  4, 14,  7, 13, 10, 13, 10, 15, 10, 15,  8,
         6,  3, 12,  7, 11,  6, 15,  8, 14, 12, 15, 11, 15, 11, 15,  9,
         6,  4, 12,  7, 12,  7, 15,  9, 15, 12, 15, 11, 15, 12, 15, 10,
         7,  4, 13,  6, 12,  6, 15,  8, 15, 12, 15, 11, 15, 11, 15,  8 },
      {  1,  2,  5,  4,  6,  5, 10,  6, 10, 10, 10, 10, 10, 10, 10, 10,
         7,  7, 10,  9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
         6,  8, 10,  9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
        10,  8, 10,  8, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11 },
      {  1,  2,  5,  5,  6,  5,  9,  8,  8,  8,  8,  8,  9,  8,  9,  8,
         6,  6,  9,  9,  9,  9,  9,  9,  9,  9, 10, 10, 10, 10, 10, 10,
         6,  8, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
         8,  8, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10 },
      {  1,  4,  7,  8,  6,  7,  8,  8,  8,  7,  7,  7,  7,  7,  7,  7,
         7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
         7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
         7,  7,  8,  8,  8,  8,  8,  8,  8,  8,  7,  7,  7,  7,  8,  8 }
    },
    {
      {  1,  3,  4,  5,  4,  6,  7,  7,  4,  7,  6,  8,  6,  8,  8,  8,
         6,  9,  9, 10,  9,  9, 11, 11,  9, 11, 10, 11, 10, 11, 11, 11,
         6,  9,  9, 10,  9, 10, 12, 11,  9, 11, 10, 12, 11, 11, 12, 11,
         8, 11, 11, 10, 11, 11, 12, 12, 11, 13, 12, 13, 12, 13, 13, 12 },
      {  1,  4,  4,  5,  4,  6,  6,  7,  4,  7,  5,  7,  5,  7,  7,  7,
         6,  8,  8,  9,  9,  9, 11, 10,  9, 11,  9, 11, 10, 11, 11, 11,
         6,  9,  9, 10,  9, 10, 11, 11,  9, 11, 10, 11, 10, 12, 12, 11,
         8, 11, 10, 11, 11, 11, 13, 12, 11, 12, 11, 12, 12, 13, 12, 11 },
      {  1,  4,  4,  5,  4,  5,  7,  7,  4,  7,  6,  7,  5,  7,  7,  7,
         6,  8,  9, 10,  8,  9, 11, 10,  8, 11, 10, 11,  9, 11, 11, 10,
         6,  8,  9, 10,  8, 10, 11, 11,  9, 11, 10, 12, 10, 10, 11, 11,
         8, 10, 11, 11, 10, 11, 12, 12, 10, 12, 11, 12, 11, 11, 12, 11 },
      {  1,  4,  4,  5,  4,  6,  6,  7,  4,  7,  5,  7,  5,  7,  7,  7,
         6,  9,  9, 10,  8, 10, 11, 11,  8, 12,  9, 11,  9, 11, 10, 11,
         6,  9,  9, 10,  9, 10, 11, 11,  9, 11, 10, 11, 10, 11, 11, 11,
         8, 11, 11, 12, 10, 11, 12, 12, 10, 12, 11, 12, 11, 12, 12, 11 }
    },
    {
      {  6,  1,  6,  4,  6,  4,  9,  6,  9,  8, 10,  8, 10,  8, 11,  8,
         5,  4,  9,  7,  9,  7, 11,  9, 11, 10, 12, 10, 12, 11, 14, 10,
         5,  4,  9,  7,  9,  7, 12,  9, 12, 10, 13, 11, 13, 12, 14, 11,
         7,  5, 10,  8, 10,  8, 13, 10, 12, 11, 13, 11, 14, 12, 14, 11 },
      {  1,  2,  4,  4,  5,  7,  8,  8,  8,  9,  8,  8,  9,  9,  9,  8,
         6,  8, 10,  8, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12,
         7,  9, 10,  9, 12, 12, 12, 12, 12, 12, 12, 11, 11, 11, 11, 11,
         9, 11, 11, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11 },
      {  1,  2,  5,  7,  5,  5,  9,  9,  5,  7,  6,  7,  7,  7,  8,  8,
         6,  8, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
         6, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
         9, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11 },
      {  1,  3,  5,  6,  4,  5,  7,  7,  7,  8,  8,  8,  8,  8,  8,  8,
         8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
         8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
         8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  9,  9 }
    }
  }
};

typedef struct {
    uint8_t l0[2][864];
    uint8_t l12[2][108];
    uint8_t l3[2][108];
    uint8_t esc[32];
} CoeffLens;

static const CoeffLens rv60_intra_lens[5] = {
  {
    {
      {  0,  7,  5,  7,  5,  7,  6,  6,  7,  9,  7,  8,  8,  9,  7,  7,
        10, 13, 10, 12, 11, 12, 10, 10,  6,  9,  6,  8,  7,  8,  7,  7,
         9, 11,  8,  9,  9, 10,  8,  8, 12, 14, 12, 13, 13, 13, 11, 10,
         9, 12,  9, 11, 10, 11,  9,  9, 12, 14, 10, 11, 12, 12, 10,  9,
        12, 15, 12, 13, 13, 14, 11, 10,  6,  9,  7,  8,  7,  8,  7,  7,
         8, 11,  9,  9,  9,  9,  8,  8, 12, 14, 12, 13, 12, 13, 11, 10,
         8, 10,  8,  9,  9,  9,  8,  7, 10, 12, 10, 10, 10, 10,  9,  8,
        14, 15, 13, 13, 13, 13, 11, 10, 11, 13, 11, 11, 12, 12, 10,  9,
        13, 15, 11, 12, 13, 13, 11, 10, 15, 15, 13, 13, 14, 15, 12, 10,
         9, 12, 10, 11,  9, 11,  9,  9, 12, 14, 12, 12, 11, 12, 10,  9,
        12, 15, 12, 14, 12, 13, 11, 10, 11, 14, 11, 12, 11, 12, 10,  9,
        13, 15, 12, 13, 12, 12, 11, 10, 15, 15, 14, 14, 13, 14, 12, 10,
        12, 15, 12, 13, 12, 13, 11, 10, 14, 15, 13, 13, 13, 14, 11, 10,
        14, 15, 13, 14, 14, 14, 11,  9,  5,  8,  6,  7,  7,  8,  7,  7,
         8, 10,  8,  9,  9,  9,  8,  8, 12, 14, 11, 12, 12, 13, 11, 10,
         6, 10,  7,  8,  8,  9,  8,  7,  9, 11,  9, 10, 10, 10,  9,  8,
        13, 15, 12, 13, 13, 13, 11, 10, 10, 13, 10, 11, 11, 12, 10,  9,
        12, 14, 11, 11, 12, 13, 10,  9, 14, 15, 12, 13, 14, 14, 12, 10,
         7, 10,  8,  9,  8,  9,  8,  7,  9, 11,  9, 10,  9, 10,  9,  8,
        13, 15, 13, 13, 13, 13, 11, 10,  8, 11,  9, 10,  9, 10,  8,  8,
        10, 12, 10, 11, 10, 11,  9,  8, 14, 15, 13, 13, 13, 14, 12, 11,
        11, 14, 11, 11, 12, 12, 10,  9, 12, 15, 11, 12, 12, 13, 10,  9,
        15, 15, 13, 13, 14, 15, 12, 10, 10, 13, 11, 12, 10, 11, 10,  9,
        12, 14, 12, 13, 11, 12, 10, 10, 14, 15, 13, 14, 13, 13, 12, 10,
        11, 14, 12, 12, 11, 12, 10,  9, 12, 15, 12, 13, 12, 12, 11, 10,
        15, 15, 14, 14, 13, 13, 11, 10, 13, 15, 12, 13, 13, 13, 11, 10,
        14, 15, 13, 13, 13, 13, 11, 10, 15, 15, 13, 13, 13, 14, 10,  9,
         7, 10,  8, 10,  9, 10,  9,  8, 10, 12, 10, 11, 11, 11, 10,  9,
        12, 15, 12, 14, 13, 14, 12, 11,  9, 12,  9, 10, 10, 11,  9,  9,
        11, 13, 11, 11, 11, 12, 10,  9, 15, 15, 14, 14, 14, 14, 13, 11,
        11, 14, 10, 12, 11, 12, 10,  9, 13, 15, 12, 12, 13, 13, 11, 10,
        14, 15, 13, 14, 14, 15, 12, 10,  9, 12,  9, 10, 10, 11,  9,  9,
        11, 13, 11, 11, 11, 12, 10,  9, 15, 15, 14, 14, 14, 14, 13, 11,
        10, 12, 10, 11, 10, 11, 10,  9, 11, 14, 11, 12, 11, 12, 11, 10,
        15, 15, 14, 14, 14, 15, 12, 11, 12, 15, 11, 12, 12, 13, 11, 10,
        13, 15, 12, 13, 13, 13, 11, 10, 15, 15, 13, 14, 15, 15, 12, 10,
        11, 14, 11, 12, 11, 12, 10, 10, 13, 15, 13, 13, 12, 13, 11, 10,
        14, 15, 14, 15, 13, 14, 12, 11, 12, 15, 12, 13, 11, 13, 11, 10,
        13, 15, 13, 13, 12, 13, 11, 10, 15, 15, 14, 15, 13, 14, 12, 10,
        13, 15, 12, 13, 13, 13, 11, 10, 14, 15, 13, 13, 13, 14, 11, 10,
        15, 15, 13, 13, 13, 14, 10,  9, 10, 13, 10, 11, 11, 11, 10,  9,
        12, 14, 12, 12, 12, 12, 10,  9, 15, 15, 14, 14, 14, 14, 12, 10,
        10, 13, 10, 11, 10, 11, 10,  9, 12, 14, 12, 12, 12, 12, 10,  9,
        15, 15, 14, 14, 14, 14, 12, 10, 11, 14, 11, 11, 11, 12, 10,  8,
        13, 15, 11, 12, 12, 12, 10,  9, 15, 15, 13, 13, 13, 14, 10,  8,
        10, 13, 10, 11, 11, 12, 10,  9, 12, 14, 11, 12, 12, 12, 10,  9,
        15, 15, 14, 14, 14, 14, 12, 10, 10, 13, 10, 11, 11, 12, 10,  9,
        12, 15, 11, 12, 12, 12, 10,  9, 15, 15, 14, 14, 14, 14, 12, 10,
        11, 14, 11, 11, 11, 12, 10,  8, 12, 15, 11, 12, 12, 12, 10,  8,
        15, 15, 12, 12, 13, 13, 10,  8, 11, 14, 11, 12, 11, 12, 10,  9,
        13, 15, 12, 12, 12, 12, 10,  9, 15, 15, 13, 14, 13, 13, 10,  9,
        11, 14, 11, 12, 11, 12, 10,  9, 12, 15, 12, 12, 11, 12, 10,  9,
        15, 15, 13, 13, 12, 13, 10,  8, 12, 14, 11, 11, 11, 12,  9,  8,
        11, 14, 10, 11, 11, 12,  9,  7, 13, 15, 10, 11, 10, 11,  8,  6 },
      {  0,  7,  4,  8,  5,  9,  8,  9,  6, 10,  8, 10,  9, 12, 10, 11,
        14, 15, 14, 14, 15, 15, 14, 13,  5, 10,  6, 10,  8, 11,  9, 10,
         9, 12,  9, 11, 11, 13, 11, 11, 15, 15, 14, 15, 15, 15, 14, 14,
        10, 14, 10, 12, 12, 14, 11, 12, 12, 15, 11, 13, 14, 15, 12, 13,
        15, 15, 14, 15, 15, 15, 14, 14,  5, 10,  8, 10,  7, 11,  9, 10,
         9, 12, 10, 11, 10, 13, 11, 11, 15, 15, 14, 15, 15, 15, 14, 14,
         8, 12,  9, 11, 10, 12, 10, 11, 10, 14, 11, 12, 11, 14, 11, 12,
        15, 15, 14, 15, 15, 15, 14, 14, 12, 15, 11, 13, 13, 15, 12, 13,
        13, 15, 12, 14, 14, 15, 13, 13, 15, 15, 15, 15, 15, 15, 14, 14,
        10, 14, 12, 13, 10, 13, 11, 12, 12, 15, 13, 14, 12, 14, 12, 13,
        15, 15, 15, 15, 15, 15, 14, 14, 12, 15, 12, 14, 12, 14, 12, 13,
        13, 15, 13, 14, 12, 15, 13, 13, 15, 15, 15, 15, 15, 15, 14, 14,
        14, 15, 14, 15, 14, 15, 13, 13, 15, 15, 14, 15, 14, 15, 13, 14,
        15, 15, 15, 15, 15, 15, 14, 13,  2,  8,  5,  9,  6, 10,  8, 10,
         7, 11,  8, 10,  9, 12, 10, 11, 15, 15, 14, 14, 14, 15, 13, 13,
         5, 10,  7, 10,  8, 11,  9, 10,  9, 12,  9, 11, 11, 13, 11, 11,
        15, 15, 14, 14, 15, 15, 14, 14, 10, 14,  9, 12, 12, 14, 11, 12,
        12, 15, 11, 13, 13, 15, 12, 13, 15, 15, 14, 15, 15, 15, 14, 14,
         5, 10,  8, 10,  8, 11,  9, 10,  9, 13, 10, 12, 10, 13, 11, 11,
        15, 15, 14, 15, 15, 15, 14, 14,  7, 12,  9, 11, 10, 12, 10, 11,
        10, 14, 10, 12, 11, 13, 11, 12, 15, 15, 14, 15, 15, 15, 14, 14,
        11, 15, 11, 13, 13, 15, 12, 12, 13, 15, 12, 14, 14, 15, 12, 13,
        15, 15, 14, 15, 15, 15, 14, 14, 10, 14, 12, 13, 10, 13, 11, 12,
        12, 15, 13, 14, 12, 14, 12, 13, 15, 15, 15, 15, 14, 15, 14, 14,
        11, 15, 12, 13, 12, 14, 12, 12, 13, 15, 13, 14, 12, 14, 12, 13,
        15, 15, 15, 15, 14, 15, 14, 14, 14, 15, 14, 15, 14, 15, 13, 13,
        14, 15, 14, 15, 14, 15, 13, 13, 15, 15, 15, 15, 15, 15, 13, 13,
         4, 10,  7, 10,  8, 11,  9, 10,  9, 12, 10, 12, 10, 13, 11, 11,
        15, 15, 14, 15, 15, 15, 14, 14,  7, 12,  8, 11, 10, 12, 10, 11,
        10, 13, 10, 12, 12, 14, 11, 12, 15, 15, 15, 15, 15, 15, 14, 14,
        10, 15, 10, 13, 12, 15, 12, 12, 12, 15, 12, 13, 14, 15, 13, 13,
        15, 15, 15, 15, 15, 15, 14, 14,  7, 12,  9, 11,  9, 12, 10, 11,
        10, 14, 11, 12, 11, 13, 11, 12, 15, 15, 15, 15, 15, 15, 14, 14,
         8, 13, 10, 12, 10, 13, 11, 12, 10, 14, 11, 13, 12, 14, 12, 12,
        15, 15, 15, 15, 15, 15, 14, 14, 11, 15, 11, 13, 13, 15, 12, 13,
        12, 15, 12, 14, 14, 15, 13, 13, 15, 15, 14, 15, 15, 15, 14, 14,
        10, 15, 12, 13, 10, 14, 12, 12, 12, 15, 13, 14, 12, 14, 12, 13,
        15, 15, 15, 15, 15, 15, 14, 14, 11, 15, 12, 14, 12, 14, 12, 13,
        12, 15, 13, 15, 12, 15, 13, 13, 15, 15, 15, 15, 14, 15, 14, 14,
        14, 15, 14, 15, 14, 15, 13, 13, 14, 15, 14, 15, 14, 15, 13, 13,
        15, 15, 14, 15, 14, 15, 13, 13,  7, 11,  8, 11,  9, 12, 10, 10,
        10, 13, 10, 12, 11, 13, 11, 11, 15, 15, 14, 14, 14, 15, 13, 13,
         8, 12,  9, 11, 10, 12, 10, 11, 10, 14, 11, 12, 11, 13, 11, 12,
        15, 15, 14, 14, 14, 15, 13, 13, 10, 14, 10, 12, 11, 13, 10, 11,
        12, 15, 11, 13, 12, 14, 11, 12, 15, 15, 14, 14, 14, 15, 12, 12,
         8, 12,  9, 11,  9, 12, 10, 11, 10, 14, 11, 12, 11, 13, 11, 12,
        15, 15, 14, 14, 14, 15, 13, 13,  8, 13, 10, 12, 10, 13, 10, 11,
        10, 14, 11, 12, 11, 14, 11, 12, 15, 15, 14, 15, 14, 15, 13, 13,
        10, 14, 10, 12, 11, 14, 11, 11, 11, 15, 11, 13, 12, 14, 11, 11,
        15, 15, 13, 14, 14, 15, 12, 12,  9, 14, 10, 12, 10, 13, 10, 11,
        12, 15, 12, 13, 11, 13, 11, 11, 15, 15, 14, 15, 13, 14, 12, 12,
        10, 14, 11, 13, 10, 13, 10, 11, 11, 15, 12, 13, 11, 13, 11, 11,
        14, 15, 14, 15, 13, 14, 12, 12, 11, 15, 11, 13, 11, 13, 10, 10,
        11, 15, 11, 13, 11, 13, 10, 10, 13, 15, 11, 12, 11, 12, 10,  9 }
    },
    {
      {  0,  4,  7,  3,  5,  9,  6,  8,  9,  3,  5,  9,  5,  6,  9,  8,
         9, 10,  6,  8,  9,  7,  9, 10,  9, 10, 10,  3,  5,  8,  4,  6,
         9,  7,  8, 10,  5,  6,  9,  6,  7, 10,  8,  9, 10,  7,  8, 10,
         8,  9, 10,  9, 10, 10,  6,  8,  9,  7,  8, 11,  8,  9, 10,  7,
         8, 11,  8,  9, 11,  9, 10, 11,  8, 10, 10,  9, 10, 11, 10, 10,
        10,  8,  9, 10,  8,  9, 10,  8,  9,  9,  8,  9, 11,  8,  9, 10,
         8,  9,  9,  9,  9, 10,  9,  9,  9,  8,  8,  7 },
      {  0,  4, 10,  2,  6, 10,  7,  9, 12,  3,  6, 10,  6,  8, 11,  9,
        10, 12,  8,  9, 12,  9, 10, 13, 12, 12, 13,  2,  6, 10,  4,  7,
        11,  8, 10, 12,  5,  7, 11,  6,  8, 11,  9, 10, 13,  8, 10, 12,
        10, 11, 13, 12, 12, 13,  6,  8, 12,  7,  9, 12,  9, 11, 13,  7,
         9, 12,  8, 10, 13, 10, 11, 13, 10, 11, 13, 11, 11, 13, 12, 12,
        13,  8, 10, 12,  9, 10, 13, 10, 11, 12,  9, 11, 13,  9, 11, 13,
        10, 11, 12, 10, 11, 13, 11, 11, 13, 11, 11, 12 }
    },
    {
      {  0,  4,  6,  3,  5,  8,  5,  8,  9,  4,  6,  8,  5,  7,  9,  8,
         9, 11,  6,  9,  9,  8,  9, 10,  9, 10, 10,  2,  5,  8,  4,  6,
         9,  7,  9, 10,  5,  7,  9,  6,  7, 10,  9,  9, 11,  8,  9, 10,
         9, 10, 11, 10, 11, 11,  5,  8,  9,  7,  9, 11,  8, 10, 11,  7,
         9, 11,  8,  9, 11, 10, 11, 12,  8, 11, 11, 10, 11, 12, 10, 11,
        11,  8, 10, 11,  9, 10, 11, 10, 10, 11,  9, 10, 11, 10, 10, 11,
        10, 10, 11, 10, 11, 11, 10, 11, 11, 10, 10,  9 },
      {  0,  5, 12,  2,  7, 13,  8, 11, 15,  4,  8, 13,  7,  9, 13, 11,
        12, 15, 10, 12, 15, 11, 12, 15, 13, 13, 15,  1,  7, 12,  4,  8,
        13,  9, 12, 15,  6,  9, 13,  8, 10, 13, 11, 12, 15, 11, 12, 15,
        11, 13, 15, 13, 14, 14,  7,  9, 13,  8, 10, 14, 11, 13, 15,  9,
        11, 14, 10, 11, 14, 12, 13, 15, 12, 13, 15, 12, 13, 15, 14, 14,
        15, 11, 11, 13, 11, 12, 14, 13, 14, 15, 12, 12, 14, 12, 13, 14,
        13, 14, 15, 13, 14, 15, 13, 14, 15, 14, 14, 14 }
    },
    {  1,  2,  4,  4,  5,  6,  6,  6,  7,  7,  8,  8,  8,  8,  9,  9,
       9,  9, 10, 10, 10, 11, 11, 11, 10, 10, 10, 12, 13, 15, 15, 14 }
  },
  {
    {
      {  0,  6,  4,  7,  5,  7,  6,  6,  6,  9,  7,  9,  8,  9,  8,  8,
        12, 15, 13, 14, 13, 14, 12, 11,  5,  9,  6,  8,  7,  8,  7,  7,
         8, 11,  8, 10,  9, 10,  9,  9, 14, 15, 13, 14, 14, 14, 12, 12,
        10, 13,  9, 11, 11, 12, 10, 10, 12, 15, 10, 12, 12, 13, 11, 10,
        15, 15, 13, 13, 14, 15, 12, 11,  5,  9,  7,  8,  7,  8,  7,  7,
         8, 11,  9, 10,  9, 10,  8,  9, 14, 15, 13, 14, 13, 14, 12, 11,
         7, 11,  8, 10,  8, 10,  8,  8,  9, 12, 10, 11, 10, 11,  9,  9,
        15, 15, 13, 14, 13, 14, 12, 11, 11, 14, 11, 12, 12, 13, 11, 10,
        12, 15, 11, 13, 13, 14, 11, 11, 15, 15, 13, 14, 14, 15, 12, 11,
        10, 13, 11, 12,  9, 11, 10, 10, 12, 14, 12, 13, 10, 12, 11, 10,
        14, 15, 14, 15, 13, 13, 12, 11, 12, 14, 12, 13, 11, 12, 10, 10,
        12, 15, 12, 14, 11, 13, 11, 11, 15, 15, 14, 15, 13, 14, 12, 10,
        13, 15, 13, 14, 13, 14, 11, 10, 14, 15, 13, 14, 13, 14, 11, 10,
        15, 15, 13, 14, 13, 14, 11,  9,  4,  8,  6,  8,  6,  8,  7,  7,
         8, 10,  8, 10,  9, 10,  8,  8, 14, 15, 13, 14, 13, 14, 12, 11,
         6, 10,  7,  9,  8,  9,  8,  8,  9, 12,  9, 11, 10, 11,  9,  9,
        15, 15, 13, 14, 14, 14, 12, 11, 10, 13, 10, 11, 11, 13, 10, 10,
        12, 15, 11, 12, 12, 13, 11, 10, 15, 15, 13, 14, 14, 15, 12, 11,
         6, 10,  8,  9,  7,  9,  8,  8,  9, 12,  9, 11,  9, 11,  9,  9,
        15, 15, 14, 14, 13, 14, 12, 11,  8, 11,  9, 10,  9, 10,  9,  9,
        10, 12, 10, 11, 10, 11, 10, 10, 15, 15, 13, 14, 13, 14, 12, 11,
        11, 14, 11, 12, 12, 13, 10, 10, 12, 15, 11, 12, 12, 14, 11, 10,
        15, 15, 12, 14, 14, 15, 11, 10, 10, 14, 11, 12, 10, 11, 10, 10,
        12, 15, 12, 13, 11, 12, 11, 10, 15, 15, 14, 15, 13, 13, 12, 11,
        11, 14, 12, 13, 11, 12, 11, 10, 12, 15, 12, 13, 11, 13, 11, 10,
        15, 15, 14, 15, 12, 13, 11, 10, 13, 15, 13, 14, 13, 14, 11, 10,
        14, 15, 12, 14, 12, 14, 11, 10, 15, 15, 13, 14, 13, 14, 10,  9,
         7, 11,  8, 10,  9, 11,  9,  9, 10, 13, 10, 12, 11, 12, 10, 10,
        15, 15, 14, 15, 14, 15, 13, 12,  8, 12,  9, 11,  9, 11, 10, 10,
        11, 13, 11, 12, 11, 12, 11, 10, 15, 15, 14, 15, 15, 15, 13, 12,
        11, 14, 10, 12, 12, 13, 11, 10, 12, 15, 11, 13, 13, 14, 11, 11,
        15, 15, 13, 14, 15, 15, 12, 11,  9, 12, 10, 11,  9, 11, 10, 10,
        11, 14, 11, 12, 11, 12, 11, 10, 15, 15, 15, 15, 14, 15, 13, 12,
         9, 13, 10, 12, 10, 12, 10, 10, 11, 14, 11, 13, 11, 13, 11, 11,
        15, 15, 14, 15, 14, 15, 13, 12, 12, 15, 11, 13, 12, 13, 11, 11,
        12, 15, 11, 13, 13, 14, 11, 11, 15, 15, 13, 14, 14, 15, 12, 11,
        11, 15, 12, 13, 11, 12, 11, 10, 12, 15, 13, 14, 11, 13, 11, 11,
        15, 15, 15, 15, 13, 14, 12, 11, 12, 15, 12, 14, 11, 13, 11, 11,
        12, 15, 13, 14, 11, 13, 11, 11, 15, 15, 14, 15, 13, 14, 12, 11,
        13, 15, 13, 14, 13, 14, 11, 10, 13, 15, 12, 14, 12, 14, 11, 10,
        15, 15, 12, 13, 13, 14, 10,  9, 10, 13, 10, 11, 10, 12, 10, 10,
        12, 15, 12, 13, 12, 13, 11, 10, 15, 15, 14, 14, 14, 15, 12, 11,
        10, 13, 10, 12, 10, 12, 10, 10, 12, 15, 11, 12, 11, 13, 11, 10,
        15, 15, 14, 14, 14, 14, 12, 11, 11, 14, 10, 12, 11, 12, 10,  9,
        12, 15, 11, 12, 11, 13, 10,  9, 15, 15, 13, 13, 13, 14, 10,  9,
        10, 14, 10, 12, 10, 12, 10, 10, 12, 15, 11, 13, 12, 13, 11, 10,
        15, 15, 14, 14, 14, 14, 12, 11, 10, 14, 10, 12, 10, 12, 10, 10,
        11, 15, 11, 13, 11, 13, 11, 10, 15, 15, 14, 14, 14, 14, 12, 10,
        11, 14, 10, 12, 11, 12, 10,  9, 11, 15, 10, 12, 11, 13, 10,  9,
        14, 15, 11, 13, 13, 14, 10,  9, 11, 14, 11, 12, 10, 12, 10,  9,
        12, 15, 11, 13, 11, 12, 10,  9, 15, 15, 13, 14, 13, 13, 10,  9,
        11, 15, 11, 12, 10, 12, 10,  9, 12, 15, 11, 13, 11, 12, 10,  9,
        14, 15, 13, 13, 12, 13, 10,  9, 11, 15, 10, 12, 10, 12,  9,  8,
        11, 15, 10, 12, 10, 12,  9,  8, 12, 15,  9, 11, 10, 11,  8,  6 },
      {  0,  8,  5,  9,  5, 10,  8, 10,  7, 11,  8, 11,  9, 12, 11, 12,
        14, 15, 14, 15, 15, 15, 15, 15,  4, 10,  6, 10,  9, 12, 10, 11,
         9, 13,  9, 12, 11, 14, 12, 13, 15, 15, 15, 15, 15, 15, 15, 15,
        10, 15, 10, 13, 12, 15, 12, 14, 12, 15, 12, 15, 14, 15, 13, 14,
        15, 15, 15, 15, 15, 15, 15, 15,  4, 11,  8, 11,  7, 11, 10, 11,
         9, 13, 10, 13, 10, 13, 11, 13, 15, 15, 15, 15, 15, 15, 15, 15,
         7, 12,  9, 12, 10, 13, 11, 13, 10, 14, 11, 14, 11, 14, 12, 13,
        15, 15, 15, 15, 15, 15, 14, 15, 11, 15, 12, 15, 13, 15, 13, 14,
        13, 15, 12, 15, 14, 15, 13, 14, 15, 15, 15, 15, 15, 15, 14, 15,
        10, 15, 12, 14, 10, 14, 12, 14, 12, 15, 13, 15, 11, 14, 13, 14,
        15, 15, 15, 15, 14, 15, 15, 15, 11, 15, 13, 15, 12, 15, 13, 14,
        12, 15, 14, 15, 12, 15, 13, 14, 15, 15, 15, 15, 14, 15, 14, 15,
        14, 15, 14, 15, 14, 15, 13, 14, 15, 15, 14, 15, 14, 15, 13, 14,
        15, 15, 15, 15, 15, 15, 14, 14,  2,  9,  6,  9,  6, 11,  9, 11,
         7, 11,  9, 11, 10, 12, 11, 12, 15, 15, 15, 15, 15, 15, 14, 15,
         5, 11,  7, 11,  9, 12, 10, 12,  9, 13, 10, 12, 11, 14, 12, 13,
        15, 15, 15, 15, 15, 15, 15, 15,  9, 15,  9, 14, 12, 15, 12, 13,
        12, 15, 11, 14, 14, 15, 13, 14, 15, 15, 14, 15, 15, 15, 15, 15,
         5, 11,  8, 11,  7, 12, 10, 12,  9, 13, 10, 13, 10, 13, 11, 13,
        15, 15, 15, 15, 15, 15, 15, 15,  7, 13,  9, 12, 10, 13, 11, 13,
         9, 14, 10, 14, 11, 14, 12, 13, 15, 15, 14, 15, 15, 15, 14, 15,
        11, 15, 11, 14, 13, 15, 13, 14, 12, 15, 12, 15, 14, 15, 13, 14,
        15, 15, 14, 15, 15, 15, 14, 15,  9, 15, 12, 14,  9, 14, 12, 13,
        12, 15, 13, 15, 11, 14, 13, 14, 15, 15, 15, 15, 14, 15, 14, 15,
        11, 15, 13, 15, 11, 15, 12, 14, 12, 15, 13, 15, 11, 15, 13, 14,
        15, 15, 15, 15, 14, 15, 14, 14, 14, 15, 14, 15, 14, 15, 13, 14,
        14, 15, 14, 15, 14, 15, 13, 14, 15, 15, 14, 15, 14, 15, 13, 13,
         4, 11,  7, 11,  8, 12, 10, 12,  9, 13, 10, 12, 10, 13, 12, 13,
        15, 15, 15, 15, 15, 15, 15, 15,  6, 12,  8, 12,  9, 13, 11, 12,
        10, 14, 11, 13, 11, 14, 12, 13, 15, 15, 15, 15, 15, 15, 15, 15,
         9, 15, 10, 14, 12, 15, 12, 13, 12, 15, 12, 15, 14, 15, 13, 14,
        15, 15, 15, 15, 15, 15, 15, 15,  6, 12,  9, 12,  8, 13, 11, 12,
        10, 14, 11, 14, 11, 14, 12, 14, 15, 15, 15, 15, 15, 15, 15, 15,
         8, 13, 10, 13, 10, 14, 11, 13, 10, 14, 11, 14, 11, 14, 12, 14,
        15, 15, 15, 15, 15, 15, 15, 15, 11, 15, 11, 15, 13, 15, 13, 14,
        12, 15, 12, 15, 14, 15, 13, 14, 15, 15, 14, 15, 15, 15, 14, 14,
        10, 15, 12, 15, 10, 14, 12, 13, 12, 15, 13, 15, 11, 15, 13, 14,
        15, 15, 15, 15, 14, 15, 15, 15, 11, 15, 13, 15, 11, 15, 13, 14,
        12, 15, 13, 15, 11, 15, 13, 14, 15, 15, 15, 15, 14, 15, 14, 14,
        13, 15, 13, 15, 14, 15, 13, 14, 13, 15, 14, 15, 13, 15, 13, 14,
        15, 15, 14, 15, 14, 15, 13, 13,  6, 12,  8, 12,  9, 12, 10, 12,
        10, 14, 10, 13, 11, 13, 11, 13, 15, 15, 14, 15, 14, 15, 13, 13,
         7, 13,  9, 13,  9, 13, 10, 12, 10, 14, 11, 13, 11, 14, 11, 13,
        15, 15, 14, 15, 14, 15, 13, 13,  9, 15,  9, 13, 10, 13, 11, 12,
        11, 15, 11, 14, 12, 14, 11, 12, 15, 15, 14, 15, 14, 15, 13, 12,
         7, 13,  9, 12,  9, 13, 10, 12, 10, 14, 11, 14, 11, 14, 11, 13,
        15, 15, 14, 15, 14, 15, 13, 13,  8, 13, 10, 13, 10, 13, 11, 12,
        10, 14, 11, 14, 11, 14, 11, 13, 15, 15, 14, 15, 14, 15, 13, 13,
         9, 15, 10, 13, 11, 14, 11, 12, 10, 15, 10, 13, 11, 14, 11, 12,
        14, 15, 13, 14, 14, 15, 12, 12,  9, 14, 10, 13,  9, 13, 10, 12,
        11, 15, 12, 14, 11, 14, 11, 12, 15, 15, 14, 15, 13, 15, 13, 12,
         9, 15, 11, 14, 10, 13, 11, 12, 10, 15, 11, 14, 10, 13, 11, 12,
        14, 15, 14, 15, 12, 14, 12, 12, 10, 15, 11, 13, 11, 13, 10, 11,
        10, 14, 11, 13, 10, 13, 10, 11, 12, 14, 11, 12, 11, 12, 10, 10 }
    },
    {
      {  0,  4,  9,  3,  5, 10,  7,  9, 10,  3,  5, 10,  5,  6, 10,  8,
         9, 10,  7,  8, 10,  8,  9, 10, 10, 10, 10,  3,  5, 10,  4,  6,
        10,  7,  8, 10,  4,  6, 10,  6,  7, 10,  8,  9, 10,  7,  9, 10,
         8,  9, 10,  9, 10,  9,  6,  8, 11,  7,  8, 11,  8,  9, 11,  7,
         8, 11,  8,  9, 11,  9,  9, 10,  9, 10, 11,  9, 10, 10, 10, 10,
         9,  8,  9, 10,  8,  9, 10,  8,  8,  9,  8,  9, 10,  8,  9, 10,
         8,  8,  9,  8,  9,  9,  8,  9,  9,  8,  8,  7 },
      {  0,  5, 12,  3,  7, 13,  8, 11, 14,  3,  7, 13,  6,  9, 14, 11,
        12, 14,  9, 11, 15, 11, 12, 15, 13, 14, 15,  1,  6, 13,  4,  8,
        13,  9, 11, 14,  5,  8, 13,  7,  9, 13, 11, 11, 14, 10, 12, 14,
        11, 12, 15, 13, 13, 15,  6,  9, 13,  8, 10, 14, 10, 12, 14,  8,
        11, 14,  9, 11, 14, 11, 12, 15, 11, 13, 15, 12, 13, 15, 13, 13,
        15,  9, 11, 13, 10, 11, 13, 11, 12, 14, 10, 11, 14, 10, 12, 14,
        11, 12, 14, 11, 13, 15, 12, 13, 14, 12, 13, 14 }
    },
    {
      {  0,  4,  9,  3,  5, 10,  7,  9, 11,  3,  5, 10,  5,  7, 11,  9,
        10, 12,  8,  9, 11,  9, 10, 11, 10, 11, 11,  2,  5, 10,  4,  7,
        11,  8,  9, 11,  4,  7, 11,  6,  8, 11,  9, 10, 11,  9, 10, 11,
         9, 10, 11, 10, 10, 10,  6,  8, 11,  7,  9, 12,  9, 10, 12,  7,
         9, 12,  8,  9, 12, 10, 10, 12,  9, 10, 12, 10, 11, 12, 11, 11,
        11,  8, 10, 11,  9, 10, 11,  9, 10, 10,  9, 10, 11,  9, 10, 11,
         9, 10, 10, 10, 10, 10, 10, 10, 10,  9,  9,  9 },
      {  0,  5, 12,  2,  7, 13, 10, 12, 15,  4,  7, 14,  6,  9, 14, 11,
        12, 15, 10, 12, 15, 11, 12, 15, 13, 13, 15,  1,  6, 12,  5,  8,
        14, 10, 12, 15,  5,  8, 13,  8,  9, 13, 11, 12, 15, 11, 12, 15,
        11, 12, 15, 13, 13, 15,  7,  9, 12,  9, 11, 14, 12, 13, 15,  9,
        10, 14, 10, 11, 13, 13, 13, 15, 12, 13, 15, 12, 14, 15, 14, 15,
        15, 11, 11, 12, 12, 12, 13, 14, 15, 15, 12, 13, 14, 12, 13, 14,
        14, 14, 15, 13, 14, 15, 14, 14, 15, 14, 14, 15 }
    },
    {  1,  3,  3,  4,  4,  5,  6,  6,  6,  7,  7,  7,  8,  8,  9,  9,
       9,  9, 10, 10, 10, 11, 11, 11, 10, 10, 10, 12, 14, 14, 14, 14 }
  },
  {
    {
      {  0,  9,  5,  9,  5,  9,  8,  9,  7, 11,  8, 11,  8, 11,  9, 10,
        14, 15, 13, 14, 13, 14, 12, 11,  5, 11,  6, 10,  8, 11,  9, 10,
         8, 12,  9, 11,  9, 12, 10, 10, 14, 15, 13, 14, 13, 14, 12, 11,
         9, 15,  9, 12, 11, 14, 10, 10, 11, 15,  9, 12, 12, 14, 10, 11,
        14, 15, 12, 13, 13, 14, 11, 11,  5, 11,  8, 11,  6, 10,  9, 10,
         8, 12,  9, 12,  9, 11, 10, 10, 14, 15, 13, 14, 13, 14, 12, 11,
         7, 13,  8, 12,  9, 12,  9, 10,  9, 13,  9, 12,  9, 12, 10, 10,
        14, 15, 13, 14, 12, 14, 12, 11, 11, 15, 10, 13, 12, 14, 10, 11,
        11, 15, 10, 13, 12, 14, 10, 11, 14, 15, 12, 13, 13, 14, 11, 10,
         9, 15, 11, 13,  8, 12, 10, 10, 10, 15, 12, 14,  9, 12, 10, 11,
        14, 15, 13, 15, 12, 13, 11, 11, 11, 15, 11, 14, 10, 13, 10, 10,
        11, 15, 12, 14, 10, 13, 10, 11, 14, 15, 13, 14, 12, 13, 11, 10,
        13, 15, 12, 14, 12, 14, 11, 10, 13, 15, 12, 14, 12, 14, 10, 10,
        15, 15, 12, 13, 12, 13, 10,  9,  3, 10,  6, 10,  6, 10,  9, 10,
         8, 12,  9, 11,  9, 11, 10, 10, 14, 15, 13, 14, 13, 14, 12, 11,
         5, 12,  7, 11,  8, 11,  9, 10,  8, 13,  9, 12,  9, 12, 10, 10,
        14, 15, 13, 14, 13, 14, 12, 11,  9, 15,  9, 12, 11, 13, 10, 10,
        11, 15,  9, 12, 12, 14, 10, 11, 14, 15, 12, 13, 13, 15, 11, 10,
         6, 12,  8, 11,  7, 11,  9, 10,  8, 13, 10, 12,  9, 11, 10, 10,
        14, 15, 13, 14, 13, 13, 12, 11,  7, 13,  9, 12,  9, 12, 10, 10,
         9, 13,  9, 12,  9, 12, 10, 10, 14, 15, 13, 14, 13, 14, 12, 11,
        10, 15, 10, 13, 11, 14, 10, 10, 11, 15, 10, 12, 12, 14, 10, 10,
        14, 15, 11, 13, 13, 14, 11, 10,  9, 15, 11, 13,  8, 12, 10, 10,
        11, 15, 12, 14,  9, 12, 10, 10, 14, 15, 13, 15, 12, 13, 11, 10,
        10, 15, 11, 14, 10, 13, 10, 10, 11, 15, 11, 14, 10, 13, 10, 11,
        14, 15, 13, 14, 11, 13, 11, 10, 13, 15, 12, 14, 12, 14, 10, 10,
        13, 15, 11, 13, 12, 13, 10, 10, 14, 15, 11, 13, 12, 13, 10,  9,
         6, 13,  8, 12,  8, 12, 10, 10, 10, 14, 10, 12, 10, 12, 11, 11,
        15, 15, 14, 14, 14, 14, 12, 12,  7, 13,  8, 12,  9, 12, 10, 11,
        10, 14, 10, 12, 11, 13, 11, 11, 15, 15, 14, 14, 14, 14, 12, 12,
        10, 15,  9, 13, 11, 13, 10, 10, 11, 15, 10, 13, 12, 14, 11, 11,
        15, 15, 12, 14, 14, 15, 11, 11,  7, 13,  9, 12,  9, 12, 10, 11,
        10, 14, 10, 13, 10, 13, 11, 11, 15, 15, 14, 14, 14, 14, 12, 12,
         8, 14,  9, 12,  9, 13, 10, 11, 10, 14, 10, 13, 10, 13, 11, 11,
        15, 15, 13, 14, 13, 14, 12, 11, 10, 15, 10, 13, 11, 14, 10, 11,
        10, 15,  9, 13, 12, 14, 11, 11, 14, 15, 11, 13, 13, 15, 11, 10,
        10, 15, 11, 13,  9, 12, 10, 10, 11, 15, 12, 14, 10, 13, 11, 11,
        14, 15, 14, 15, 12, 13, 11, 11, 10, 15, 11, 14, 10, 13, 10, 11,
        10, 15, 12, 14, 10, 13, 11, 11, 14, 15, 13, 15, 11, 13, 11, 10,
        12, 15, 12, 14, 12, 14, 10, 10, 11, 15, 11, 13, 11, 13, 10, 10,
        13, 15, 11, 12, 11, 13,  9,  9,  9, 14, 10, 13, 10, 13, 10, 10,
        11, 15, 11, 13, 11, 13, 10, 11, 15, 15, 14, 14, 13, 14, 12, 10,
         9, 14, 10, 13,  9, 13, 10, 10, 11, 15, 11, 13, 11, 13, 10, 10,
        15, 15, 14, 14, 13, 14, 12, 10, 10, 14,  9, 12, 10, 12,  9,  9,
        11, 15, 10, 13, 11, 13,  9,  9, 14, 15, 12, 13, 13, 13, 10,  9,
         9, 15,  9, 13, 10, 13, 10, 10, 11, 15, 11, 13, 11, 13, 11, 11,
        15, 15, 14, 14, 13, 14, 12, 10,  8, 15,  9, 13,  9, 13, 10, 10,
        10, 15, 11, 13, 10, 13, 10, 11, 15, 15, 13, 14, 13, 14, 11, 10,
         9, 15,  9, 12, 10, 12,  9,  9, 10, 15,  9, 12, 10, 13,  9,  9,
        13, 15, 11, 12, 12, 13, 10,  9, 10, 15, 10, 12,  9, 12,  9,  9,
        11, 15, 10, 13, 10, 13,  9,  9, 14, 15, 13, 13, 12, 13, 10,  9,
        10, 15, 10, 12,  9, 12,  9,  9, 10, 15, 10, 12,  9, 12,  9,  9,
        14, 15, 12, 13, 11, 12, 10,  9, 10, 15,  9, 12, 10, 12,  8,  8,
         9, 14,  9, 11,  9, 11,  8,  8, 10, 14,  8, 10,  9, 10,  7,  6 },
      {  0, 11,  6, 13,  6, 12, 11, 14,  8, 13, 11, 14, 10, 14, 13, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  5, 14,  8, 14, 10, 15, 12, 14,
         9, 15, 11, 15, 12, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        10, 15, 11, 15, 14, 15, 14, 15, 13, 15, 13, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  4, 14, 10, 15,  8, 14, 12, 15,
         9, 15, 12, 15, 11, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         8, 15, 11, 15, 11, 15, 13, 15, 10, 15, 12, 15, 12, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 12, 15, 13, 15, 14, 15, 14, 15,
        13, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        10, 15, 14, 15, 11, 15, 14, 15, 12, 15, 15, 15, 12, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 12, 15, 14, 15, 12, 15, 14, 15,
        13, 15, 15, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  1, 12,  7, 13,  7, 13, 12, 13,
         8, 13, 11, 14, 10, 14, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         5, 14,  8, 14, 10, 15, 12, 14,  9, 15, 11, 15, 12, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 10, 15, 10, 15, 13, 15, 13, 15,
        13, 15, 12, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         5, 14, 10, 15,  8, 14, 12, 14,  9, 15, 12, 15, 11, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  7, 15, 11, 15, 10, 15, 13, 15,
         9, 15, 12, 15, 11, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        12, 15, 12, 15, 14, 15, 14, 15, 13, 15, 13, 15, 14, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 10, 15, 13, 15, 10, 15, 14, 15,
        12, 15, 15, 15, 12, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        11, 15, 14, 15, 12, 15, 14, 15, 12, 15, 15, 15, 12, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         4, 14,  9, 14,  8, 14, 12, 14,  9, 14, 11, 15, 11, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  6, 15,  9, 15, 10, 15, 13, 14,
        10, 15, 12, 15, 12, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        10, 15, 10, 15, 13, 15, 13, 15, 13, 15, 13, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  6, 15, 10, 15,  9, 15, 13, 15,
        10, 15, 13, 15, 12, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         8, 15, 11, 15, 11, 15, 13, 15, 10, 15, 12, 15, 12, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 11, 15, 12, 15, 14, 15, 14, 15,
        12, 15, 12, 15, 14, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         9, 15, 13, 15, 10, 15, 13, 15, 12, 15, 15, 15, 12, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 11, 15, 14, 15, 12, 15, 14, 15,
        12, 15, 14, 15, 12, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        14, 15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  6, 14, 10, 15,  9, 15, 12, 14,
        10, 15, 12, 15, 11, 15, 13, 14, 15, 15, 15, 15, 15, 15, 15, 15,
         7, 15, 10, 15, 10, 15, 12, 14, 11, 15, 12, 15, 12, 15, 13, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  9, 15, 10, 15, 11, 15, 12, 14,
        12, 15, 12, 15, 13, 15, 13, 14, 15, 15, 15, 15, 15, 15, 14, 15,
         7, 15, 10, 15, 10, 15, 12, 14, 11, 15, 12, 15, 11, 15, 13, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  8, 15, 11, 15, 10, 15, 12, 14,
        10, 15, 12, 15, 11, 15, 13, 14, 15, 15, 15, 15, 15, 15, 15, 15,
         9, 15, 10, 15, 12, 15, 12, 14, 11, 15, 11, 15, 12, 15, 12, 14,
        15, 15, 14, 15, 15, 15, 14, 15,  9, 15, 11, 15, 10, 15, 12, 14,
        12, 15, 13, 15, 12, 15, 13, 14, 15, 15, 15, 15, 15, 15, 14, 15,
         9, 15, 12, 15, 10, 15, 12, 14, 11, 15, 12, 15, 11, 15, 12, 14,
        15, 15, 15, 15, 14, 15, 14, 15, 11, 15, 12, 15, 12, 15, 11, 13,
        11, 15, 12, 14, 12, 14, 12, 13, 13, 15, 13, 14, 12, 14, 12, 13 }
    },
    {
      {  0,  5, 10,  3,  6, 10,  7,  8, 10,  4,  6, 10,  6,  7, 10,  8,
         8, 10,  8,  9, 10,  9,  9, 10,  9,  9, 10,  2,  6, 10,  4,  6,
        10,  7,  8, 10,  5,  7, 10,  6,  7, 10,  8,  8, 10,  8,  9, 10,
         9,  9, 10,  9,  9,  9,  5,  7, 10,  6,  8, 10,  7,  8, 10,  6,
         8, 11,  7,  8, 11,  8,  8, 10,  8,  9, 10,  9,  9, 10,  9,  9,
         9,  7,  8, 10,  7,  8, 10,  7,  8,  9,  7,  9, 10,  7,  8, 10,
         8,  8,  9,  8,  9,  9,  8,  9,  9,  8,  8,  7 },
      {  0,  6, 14,  3,  7, 15,  8, 11, 15,  3,  8, 14,  7,  9, 15, 10,
        12, 15,  9, 12, 15, 11, 13, 15, 13, 14, 14,  1,  6, 13,  4,  8,
        14,  8, 11, 15,  5,  9, 15,  7,  9, 14, 10, 12, 15, 10, 12, 15,
        11, 12, 15, 15, 15, 15,  5,  9, 14,  7, 10, 14, 10, 12, 15,  7,
        10, 15,  8, 11, 15, 11, 13, 15, 11, 13, 15, 12, 13, 15, 15, 14,
        15,  8, 11, 14,  9, 11, 15, 11, 13, 15,  9, 12, 15, 10, 12, 15,
        12, 13, 15, 12, 13, 15, 12, 13, 15, 14, 13, 15 }
    },
    {
      {  0,  5, 10,  3,  7, 10,  7,  9, 11,  3,  7, 10,  5,  7, 11,  8,
         9, 11,  8,  9, 11,  8,  9, 11,  9, 10, 10,  2,  6, 10,  4,  7,
        10,  7,  9, 11,  4,  7, 10,  6,  8, 10,  8,  9, 11,  8,  9, 11,
         8,  9, 11,  9, 10, 10,  5,  7, 10,  6,  8, 11,  8,  9, 11,  6,
         8, 11,  7,  9, 11,  9, 10, 11,  9, 10, 11,  9, 10, 11, 10, 10,
        10,  7,  8, 10,  8,  9, 10,  9, 10, 10,  8,  9, 10,  8,  9, 10,
         9, 10, 10,  9, 10, 10,  9, 10, 10,  9,  9,  9 },
      {  0,  4, 12,  3,  8, 13, 10, 14, 14,  3,  7, 14,  6,  8, 13, 10,
        12, 13,  9, 12, 14, 10, 13, 14, 12, 13, 14,  1,  5, 12,  5,  9,
        13, 11, 13, 14,  5,  8, 12,  7,  9, 14, 12, 12, 14, 10, 14, 14,
        11, 12, 13, 14, 12, 14,  6,  8, 10,  9, 10, 13, 14, 13, 13,  8,
        11, 13, 10, 12, 13, 13, 14, 14, 12, 12, 14, 12, 14, 14, 14, 14,
        14, 10, 10, 12, 14, 14, 14, 14, 14, 14, 12, 12, 13, 12, 11, 14,
        14, 14, 14, 14, 14, 14, 13, 14, 14, 14, 14, 14 }
    },
    {  1,  2,  3,  5,  5,  6,  6,  7,  7,  8,  8,  9, 10, 10, 10, 11,
      11, 11, 12, 12, 13, 13, 13, 13, 13, 13, 13, 15, 15, 15, 16, 16 }
  },
  {
    {
      {  0,  9,  5, 10,  5, 10,  8,  9,  7, 11,  8, 11,  8, 11,  9, 10,
        14, 15, 13, 14, 13, 14, 12, 12,  5, 12,  6, 10,  8, 11,  9, 10,
         8, 13,  8, 11,  9, 12, 10, 10, 14, 15, 13, 14, 13, 14, 12, 12,
         9, 15,  9, 12, 11, 14, 10, 11, 11, 15,  9, 12, 12, 14, 11, 11,
        14, 15, 12, 13, 13, 15, 11, 11,  4, 11,  8, 11,  6, 10,  9, 10,
         8, 12,  9, 12,  8, 11, 10, 10, 14, 15, 13, 14, 13, 14, 12, 12,
         7, 13,  9, 11,  9, 12,  9, 10,  8, 13,  9, 12,  9, 12, 10, 10,
        14, 15, 13, 14, 12, 14, 12, 11, 11, 15, 10, 13, 12, 14, 10, 11,
        11, 15, 10, 13, 12, 14, 11, 11, 15, 15, 12, 13, 13, 15, 11, 11,
         9, 15, 11, 14,  9, 12, 10, 10, 10, 15, 12, 14,  9, 12, 10, 11,
        14, 15, 13, 15, 12, 13, 11, 11, 11, 15, 12, 14, 10, 13, 10, 11,
        11, 15, 12, 14, 10, 13, 11, 11, 14, 15, 13, 14, 12, 13, 11, 11,
        13, 15, 12, 14, 12, 14, 11, 11, 13, 15, 12, 14, 12, 14, 11, 10,
        15, 15, 12, 14, 12, 14, 11, 10,  3, 11,  6, 10,  6, 10,  9, 10,
         8, 12,  9, 11,  9, 11, 10, 10, 15, 15, 13, 14, 13, 13, 12, 12,
         5, 12,  7, 11,  8, 11,  9, 10,  8, 13,  9, 12,  9, 12, 10, 10,
        15, 15, 13, 14, 13, 14, 12, 12,  9, 15,  9, 12, 11, 14, 10, 10,
        11, 15,  9, 12, 12, 14, 10, 11, 14, 15, 12, 13, 13, 15, 11, 11,
         5, 12,  8, 11,  7, 11,  9, 10,  8, 13, 10, 12,  9, 12, 10, 10,
        15, 15, 13, 14, 13, 13, 12, 12,  7, 13,  9, 12,  8, 12,  9, 10,
         8, 13,  9, 12,  9, 12, 10, 10, 14, 15, 12, 14, 13, 14, 12, 11,
        10, 15, 10, 13, 11, 14, 10, 11, 11, 15,  9, 12, 12, 14, 10, 11,
        14, 15, 11, 13, 13, 14, 11, 11,  9, 15, 11, 13,  8, 12, 10, 10,
        11, 15, 12, 14,  9, 12, 10, 11, 14, 15, 13, 15, 12, 13, 11, 11,
        11, 15, 11, 14, 10, 13, 10, 11, 11, 15, 11, 14,  9, 13, 10, 11,
        14, 15, 13, 14, 11, 13, 11, 11, 13, 15, 12, 14, 12, 14, 11, 10,
        12, 15, 12, 14, 12, 14, 10, 10, 14, 15, 11, 13, 12, 13, 10,  9,
         6, 13,  8, 12,  8, 12, 10, 10, 10, 14, 10, 12, 10, 12, 11, 11,
        15, 15, 14, 14, 14, 14, 12, 12,  7, 13,  8, 12,  9, 12, 10, 11,
        10, 14, 10, 12, 10, 13, 11, 11, 15, 15, 14, 14, 14, 15, 12, 12,
        10, 15,  9, 13, 11, 13, 10, 11, 11, 15, 10, 13, 12, 14, 11, 11,
        15, 15, 13, 14, 14, 15, 12, 11,  7, 14,  9, 12,  9, 12, 10, 11,
        10, 14, 10, 13, 10, 13, 11, 11, 15, 15, 14, 14, 14, 14, 13, 12,
         8, 14,  9, 12,  9, 13, 10, 11,  9, 14, 10, 13, 10, 13, 11, 11,
        15, 15, 13, 15, 13, 15, 12, 12, 10, 15, 10, 13, 11, 14, 10, 11,
        10, 15,  9, 13, 12, 14, 11, 11, 14, 15, 11, 13, 13, 15, 11, 11,
        10, 15, 11, 14,  9, 13, 10, 11, 11, 15, 12, 14, 10, 13, 11, 11,
        15, 15, 14, 15, 13, 14, 12, 11, 10, 15, 12, 14, 10, 13, 11, 11,
        10, 15, 12, 14, 10, 13, 10, 11, 14, 15, 13, 15, 12, 13, 11, 11,
        12, 15, 12, 14, 12, 14, 11, 10, 11, 15, 11, 13, 11, 14, 10, 10,
        13, 15, 11, 13, 11, 13, 10,  9,  8, 15, 10, 13, 10, 13, 10, 11,
        11, 15, 11, 13, 11, 13, 11, 11, 15, 15, 14, 14, 13, 14, 12, 11,
         9, 15, 10, 13,  9, 13, 10, 11, 11, 15, 11, 13, 11, 13, 11, 11,
        15, 15, 14, 14, 14, 14, 12, 11, 10, 15,  9, 12, 10, 13,  9, 10,
        12, 15, 10, 13, 11, 13, 10, 10, 15, 15, 13, 13, 13, 14, 10, 10,
         9, 15, 10, 13, 10, 13, 10, 11, 11, 15, 11, 13, 11, 13, 11, 11,
        15, 15, 14, 14, 14, 14, 12, 11,  8, 15, 10, 13,  9, 13, 10, 11,
        10, 15, 11, 13, 10, 13, 10, 11, 15, 15, 13, 14, 14, 14, 12, 11,
         9, 15,  9, 12, 10, 13,  9, 10, 10, 15,  9, 12, 10, 13,  9, 10,
        14, 15, 11, 12, 12, 13, 10,  9, 10, 15, 10, 13,  9, 13,  9, 10,
        11, 15, 11, 13, 10, 13, 10, 10, 14, 15, 13, 14, 12, 13, 10,  9,
        10, 15, 10, 13,  9, 13,  9, 10, 10, 15, 11, 13,  9, 13, 10, 10,
        14, 15, 13, 13, 11, 13, 10,  9, 10, 15, 10, 12, 10, 12,  8,  8,
         9, 14,  9, 11,  9, 12,  8,  8, 10, 14,  9, 10,  9, 11,  8,  7 },
      {  0, 11,  7, 13,  7, 13, 12, 14,  8, 13, 11, 15, 11, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  4, 14,  8, 15, 10, 15, 13, 15,
         9, 15, 11, 15, 12, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        10, 15, 11, 15, 14, 15, 15, 15, 13, 15, 13, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  4, 14, 10, 15,  8, 14, 13, 15,
         9, 14, 13, 15, 11, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         8, 15, 11, 15, 11, 15, 13, 15, 10, 15, 12, 15, 12, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 12, 15, 13, 15, 15, 15, 15, 15,
        14, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        10, 15, 14, 15, 11, 15, 14, 15, 13, 15, 15, 15, 13, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 12, 15, 15, 15, 13, 15, 15, 15,
        14, 15, 15, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  1, 12,  7, 13,  7, 13, 12, 14,
         8, 13, 11, 15, 11, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         5, 15,  8, 15, 10, 15, 13, 15,  9, 15, 11, 15, 12, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 10, 15, 11, 15, 14, 15, 15, 15,
        13, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         5, 15, 10, 15,  8, 14, 13, 15,  9, 15, 13, 15, 11, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  7, 15, 11, 15, 11, 15, 13, 15,
         9, 15, 12, 15, 12, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        12, 15, 13, 15, 14, 15, 14, 15, 13, 15, 13, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 10, 15, 14, 15, 10, 15, 14, 15,
        13, 15, 15, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        12, 15, 14, 15, 12, 15, 15, 15, 13, 15, 15, 15, 13, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         4, 14,  9, 15,  9, 15, 13, 15,  9, 14, 12, 15, 11, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  6, 15,  9, 15, 10, 15, 13, 15,
        10, 15, 12, 15, 13, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        10, 15, 11, 15, 13, 15, 14, 15, 13, 15, 13, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  6, 15, 10, 15,  9, 15, 13, 15,
        10, 15, 13, 15, 12, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         8, 15, 11, 15, 11, 15, 13, 15, 10, 15, 13, 15, 12, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 11, 15, 12, 15, 14, 15, 14, 15,
        12, 15, 12, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         9, 15, 13, 15, 10, 15, 14, 15, 13, 15, 15, 15, 13, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 11, 15, 14, 15, 12, 15, 15, 15,
        12, 15, 15, 15, 12, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  6, 15, 10, 15,  9, 15, 12, 15,
        10, 15, 12, 15, 11, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         7, 15, 10, 15, 10, 15, 12, 15, 11, 15, 12, 15, 12, 15, 13, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  9, 15, 10, 15, 12, 15, 12, 15,
        12, 15, 12, 15, 13, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         7, 15, 10, 15, 10, 15, 12, 15, 11, 15, 12, 15, 12, 15, 13, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  8, 15, 11, 15, 10, 15, 12, 15,
        10, 15, 12, 15, 12, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        10, 15, 11, 15, 12, 15, 12, 15, 11, 15, 11, 15, 13, 15, 13, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  9, 15, 12, 15, 10, 15, 12, 15,
        12, 15, 14, 15, 12, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        10, 15, 12, 15, 11, 15, 13, 15, 11, 15, 13, 15, 11, 15, 13, 15,
        15, 15, 15, 15, 14, 15, 15, 15, 11, 15, 12, 15, 12, 15, 12, 14,
        11, 15, 12, 15, 12, 15, 12, 14, 14, 15, 13, 15, 13, 15, 13, 14 }
    },
    {
      {  0,  5, 10,  3,  6, 10,  7,  8, 11,  4,  6, 10,  6,  7, 10,  8,
         9, 10,  8,  9, 10,  9,  9, 10, 10, 10, 10,  2,  6, 10,  4,  6,
        10,  7,  8, 10,  4,  7, 10,  6,  7, 10,  8,  8, 10,  8,  9, 10,
         8,  9, 10, 10,  9, 10,  5,  7, 10,  6,  8, 11,  7,  9, 11,  6,
         8, 11,  7,  8, 11,  8,  9, 11,  8,  9, 11,  9,  9, 11, 10,  9,
        10,  7,  8, 10,  7,  9, 10,  8,  9, 10,  7,  9, 10,  8,  8, 10,
         8,  8,  9,  8,  9, 10,  8,  9, 10,  8,  8,  8 },
      {  0,  6, 14,  3,  7, 14,  8, 11, 14,  3,  8, 14,  7,  9, 14, 10,
        12, 14,  9, 12, 14, 11, 13, 14, 14, 14, 14,  1,  6, 13,  4,  8,
        14,  9, 11, 14,  5,  8, 14,  7,  9, 14, 11, 12, 14,  9, 12, 14,
        12, 13, 14, 14, 14, 14,  5,  8, 14,  7, 10, 14, 10, 13, 14,  7,
        10, 14,  9, 11, 14, 12, 12, 14, 11, 13, 14, 12, 14, 14, 14, 14,
        14,  8, 11, 14,  9, 12, 14, 11, 14, 14,  9, 12, 14, 10, 12, 14,
        13, 13, 14, 12, 14, 14, 13, 14, 14, 14, 13, 14 }
    },
    {
      {  0,  5, 10,  3,  6, 11,  7,  9, 12,  3,  6, 11,  5,  7, 11,  8,
         9, 11,  8,  9, 11,  8,  9, 11, 10, 10, 11,  2,  5, 10,  4,  7,
        10,  8,  9, 12,  4,  7, 11,  6,  7, 11,  8,  9, 11,  8,  9, 11,
         9,  9, 11, 10, 10, 11,  5,  7, 10,  6,  8, 11,  9, 10, 12,  6,
         8, 11,  7,  9, 11,  9, 10, 12,  9, 10, 12,  9, 10, 12, 10, 11,
        11,  8,  9, 10,  8,  9, 11, 10, 10, 11,  8,  9, 11,  9, 10, 11,
        10, 10, 11, 10, 10, 11, 10, 10, 11, 10, 10, 10 },
      {  0,  4, 14,  3,  7, 14, 11, 15, 15,  3,  7, 15,  6,  9, 12, 11,
        12, 15, 11, 14, 14, 12, 14, 14, 14, 14, 14,  1,  5,  9,  5,  9,
        14, 11, 14, 14,  5,  8, 14,  7,  9, 14, 12, 14, 14, 14, 12, 14,
        14, 14, 14, 12, 14, 14,  6,  7, 10,  8, 10, 14, 12, 12, 14,  9,
        11, 14, 11, 12, 14, 14, 14, 14, 12, 14, 14, 11, 14, 14, 14, 14,
        14, 12, 10, 12, 12, 12, 14, 14, 14, 14, 14, 12, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14 }
    },
    {  1,  2,  3,  4,  5,  6,  8,  8,  9,  9, 10, 10, 11, 12, 12, 12,
      13, 13, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 15 }
  },
  {
    {
      {  0,  9,  5, 10,  5, 10,  9, 10,  7, 11,  8, 11,  8, 11, 10, 11,
        15, 15, 14, 15, 14, 14, 13, 13,  4, 12,  6, 11,  8, 11,  9, 10,
         8, 13,  9, 12,  9, 12, 10, 11, 15, 15, 13, 14, 14, 15, 13, 13,
        10, 15,  9, 13, 12, 14, 11, 12, 11, 15, 10, 13, 12, 15, 11, 12,
        15, 15, 13, 14, 14, 15, 13, 13,  4, 11,  8, 11,  6, 11,  9, 10,
         8, 12,  9, 12,  9, 11, 10, 11, 15, 15, 14, 15, 14, 14, 13, 13,
         7, 13,  9, 12,  9, 12, 10, 11,  8, 13,  9, 12,  9, 12, 10, 11,
        14, 15, 13, 15, 13, 14, 12, 13, 11, 15, 11, 14, 12, 15, 11, 12,
        12, 15, 10, 14, 12, 15, 11, 12, 15, 15, 13, 14, 14, 15, 13, 13,
         9, 15, 12, 14,  9, 13, 11, 11, 11, 15, 13, 15, 10, 13, 11, 12,
        15, 15, 15, 15, 13, 14, 13, 13, 11, 15, 12, 14, 10, 14, 11, 12,
        12, 15, 13, 15, 11, 14, 11, 12, 15, 15, 15, 15, 13, 14, 12, 12,
        14, 15, 13, 15, 13, 15, 12, 12, 14, 15, 13, 15, 13, 15, 12, 12,
        15, 15, 14, 15, 14, 15, 12, 12,  2, 11,  6, 11,  6, 10,  9, 10,
         8, 12,  9, 12,  9, 11, 10, 11, 15, 15, 14, 14, 14, 14, 13, 13,
         5, 12,  7, 11,  8, 11,  9, 10,  8, 13,  9, 12, 10, 12, 10, 11,
        15, 15, 13, 14, 14, 15, 13, 13,  9, 15,  9, 13, 11, 14, 10, 11,
        11, 15, 10, 13, 12, 14, 11, 12, 15, 15, 13, 14, 15, 15, 13, 12,
         5, 12,  8, 12,  7, 11,  9, 10,  8, 13, 10, 12,  9, 12, 10, 11,
        15, 15, 14, 15, 13, 14, 13, 13,  7, 13,  9, 12,  9, 12, 10, 11,
         8, 13,  9, 12,  9, 12, 10, 11, 15, 15, 13, 14, 13, 15, 12, 13,
        11, 15, 10, 14, 12, 14, 11, 12, 11, 15, 10, 13, 12, 14, 11, 12,
        15, 15, 12, 14, 14, 15, 12, 12,  9, 15, 12, 14,  8, 13, 10, 11,
        11, 15, 12, 15, 10, 13, 11, 12, 15, 15, 15, 15, 13, 14, 13, 12,
        11, 15, 12, 14, 10, 14, 11, 12, 11, 15, 12, 15, 10, 13, 11, 12,
        15, 15, 14, 15, 12, 14, 12, 12, 13, 15, 13, 15, 13, 15, 12, 12,
        13, 15, 12, 14, 13, 15, 12, 12, 15, 15, 13, 14, 13, 14, 12, 11,
         6, 13,  8, 12,  8, 12, 10, 11, 10, 14, 10, 13, 10, 13, 11, 12,
        15, 15, 15, 15, 14, 15, 13, 13,  7, 14,  8, 13,  9, 13, 10, 11,
        10, 15, 10, 13, 11, 13, 11, 12, 15, 15, 14, 15, 15, 15, 14, 13,
        10, 15,  9, 13, 11, 14, 11, 12, 12, 15, 11, 14, 13, 15, 12, 12,
        15, 15, 14, 15, 15, 15, 13, 13,  7, 14,  9, 13,  9, 13, 10, 11,
        10, 14, 11, 14, 10, 13, 11, 12, 15, 15, 15, 15, 14, 15, 13, 13,
         8, 14, 10, 13,  9, 13, 11, 12,  9, 15, 10, 13, 10, 13, 11, 12,
        15, 15, 14, 15, 14, 15, 13, 13, 10, 15, 10, 14, 12, 14, 11, 12,
        10, 15,  9, 14, 12, 14, 11, 12, 15, 15, 12, 14, 15, 15, 13, 12,
        10, 15, 11, 14,  9, 13, 11, 11, 12, 15, 13, 15, 11, 14, 11, 12,
        15, 15, 15, 15, 14, 15, 13, 13, 11, 15, 12, 15, 10, 14, 11, 12,
        11, 15, 12, 15, 10, 13, 11, 12, 15, 15, 15, 15, 13, 14, 13, 12,
        13, 15, 13, 15, 13, 15, 12, 12, 12, 15, 12, 14, 12, 14, 12, 12,
        13, 15, 12, 13, 12, 14, 11, 11,  8, 15, 10, 14, 10, 14, 11, 12,
        11, 15, 12, 14, 11, 14, 11, 12, 15, 15, 15, 15, 14, 15, 13, 12,
         9, 15, 10, 14, 10, 13, 11, 12, 11, 15, 11, 14, 11, 14, 11, 12,
        15, 15, 15, 15, 15, 15, 13, 12, 10, 15, 10, 13, 11, 13, 10, 11,
        12, 15, 11, 14, 11, 14, 11, 11, 15, 15, 14, 14, 14, 15, 12, 11,
         9, 15, 10, 14, 10, 14, 11, 12, 12, 15, 11, 14, 11, 14, 11, 12,
        15, 15, 15, 15, 15, 15, 13, 12,  9, 15, 10, 14, 10, 14, 11, 12,
        11, 15, 11, 14, 11, 14, 11, 12, 15, 15, 14, 15, 14, 15, 13, 12,
         9, 15,  9, 13, 11, 13, 10, 11, 11, 15,  9, 13, 11, 14, 10, 11,
        15, 15, 12, 14, 13, 14, 12, 11, 10, 15, 11, 13, 10, 14, 10, 11,
        12, 15, 12, 14, 11, 14, 11, 11, 15, 15, 14, 15, 14, 14, 12, 11,
        10, 15, 11, 14, 10, 14, 10, 11, 11, 15, 11, 14, 10, 14, 10, 11,
        15, 15, 14, 14, 13, 14, 12, 11, 10, 15, 10, 13, 11, 13,  9, 10,
        10, 15, 10, 12, 10, 13, 10, 10, 12, 15, 11, 11, 11, 12, 10,  9 },
      {  0, 12,  7, 14,  7, 14, 13, 14,  8, 13, 11, 14, 11, 15, 14, 15,
        15, 15, 14, 14, 14, 14, 14, 14,  5, 14,  8, 14, 11, 14, 14, 14,
        10, 14, 12, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        11, 14, 11, 14, 14, 14, 14, 14, 13, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 15, 15, 15,  4, 15, 11, 15,  8, 15, 14, 15,
        10, 15, 13, 15, 12, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         8, 15, 12, 15, 12, 15, 13, 15, 10, 15, 13, 15, 13, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 13, 15, 14, 15, 15, 15, 15, 15,
        14, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        10, 15, 15, 15, 11, 15, 15, 15, 14, 15, 15, 15, 13, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 13, 15, 15, 15, 13, 15, 15, 15,
        14, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  1, 13,  8, 14,  7, 15, 13, 15,
         8, 13, 12, 15, 11, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         5, 15,  9, 15, 10, 15, 13, 15, 10, 15, 12, 15, 13, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 10, 15, 11, 15, 15, 15, 15, 15,
        14, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         5, 15, 11, 15,  8, 15, 14, 15, 10, 15, 13, 15, 12, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  8, 15, 12, 15, 11, 15, 14, 15,
         9, 15, 13, 15, 12, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        12, 15, 13, 15, 15, 15, 15, 15, 13, 15, 13, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 10, 15, 15, 15, 11, 15, 15, 15,
        13, 15, 15, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        12, 15, 15, 15, 13, 15, 15, 15, 13, 15, 15, 15, 13, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         3, 15,  9, 15,  9, 15, 13, 15,  9, 14, 12, 15, 12, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  6, 15, 10, 15, 10, 15, 14, 15,
        11, 15, 13, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        10, 15, 11, 15, 14, 15, 15, 15, 13, 15, 14, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  6, 15, 11, 15,  9, 15, 13, 15,
        11, 15, 14, 15, 12, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         8, 15, 12, 15, 11, 15, 14, 15, 10, 15, 13, 15, 13, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 12, 15, 13, 15, 15, 15, 15, 15,
        13, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        10, 15, 15, 15, 10, 15, 15, 15, 13, 15, 15, 15, 13, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 12, 15, 15, 15, 12, 15, 15, 15,
        12, 15, 15, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        14, 15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  6, 15, 10, 15, 10, 15, 13, 15,
        10, 15, 12, 15, 12, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         7, 15, 10, 15, 10, 15, 13, 15, 11, 15, 13, 15, 12, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 10, 15, 11, 15, 12, 15, 13, 15,
        14, 15, 13, 15, 13, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         7, 15, 11, 15, 10, 15, 13, 15, 11, 15, 13, 15, 12, 15, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14,  8, 14, 11, 14, 10, 14, 13, 14,
        11, 14, 13, 14, 12, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        10, 14, 11, 14, 13, 14, 13, 14, 12, 14, 12, 14, 13, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14,  9, 14, 12, 14, 10, 14, 13, 14,
        13, 14, 14, 14, 12, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        10, 14, 13, 14, 11, 14, 13, 14, 12, 14, 13, 14, 11, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 11, 14, 13, 14, 13, 14, 13, 14,
        12, 14, 14, 14, 12, 14, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14 }
    },
    {
      {  0,  6, 12,  3,  7, 12,  8, 10, 13,  4,  7, 12,  6,  8, 12,  9,
        10, 12,  9, 10, 12, 10, 10, 12, 11, 12, 13,  1,  6, 11,  4,  7,
        12,  8,  9, 13,  5,  8, 12,  6,  8, 12,  9, 10, 12,  8, 10, 12,
        10, 10, 12, 11, 11, 12,  6,  8, 12,  7,  9, 12,  9, 10, 13,  7,
         9, 12,  7,  9, 12, 10, 10, 13,  9, 11, 12, 10, 10, 13, 11, 11,
        12,  8, 10, 12,  9, 10, 12,  9, 10, 12,  9, 10, 12,  9, 10, 12,
        10, 10, 12, 10, 11, 12, 10, 10, 12, 10, 11, 11 },
      {  0,  6, 14,  3,  8, 15,  9, 12, 15,  3,  8, 15,  7,  9, 15, 11,
        12, 15, 10, 13, 14, 12, 14, 15, 15, 15, 15,  1,  7, 12,  4,  8,
        13, 10, 12, 13,  4,  9, 15,  8,  9, 15, 12, 13, 15, 10, 13, 15,
        12, 14, 15, 14, 15, 14,  5,  9, 13,  7, 10, 15, 11, 12, 13,  7,
        11, 15,  9, 12, 15, 12, 15, 15, 10, 13, 14, 13, 13, 14, 13, 15,
        15,  9, 11, 14, 10, 13, 15, 11, 13, 14,  9, 13, 15, 11, 12, 15,
        13, 15, 15, 13, 13, 15, 12, 13, 14, 14, 14, 14 }
    },
    {
      {  0,  5, 12,  3,  7, 12,  9, 11, 13,  3,  7, 12,  6,  8, 12,  9,
        11, 13,  9, 10, 13, 10, 10, 14, 11, 12, 13,  1,  6, 11,  5,  7,
        12,  9, 11, 13,  5,  8, 11,  6,  8, 12, 10, 11, 13,  9, 11, 13,
        10, 11, 13, 12, 12, 13,  6,  8, 12,  8,  9, 12, 10, 12, 13,  8,
         9, 12,  8, 10, 12, 11, 12, 14, 10, 12, 13, 11, 12, 13, 12, 13,
        14,  9, 10, 12, 10, 11, 12, 13, 13, 13, 10, 11, 12, 11, 12, 13,
        12, 13, 13, 12, 12, 13, 12, 12, 14, 12, 13, 13 },
      {  0,  5, 14,  3, 10, 14, 14, 14, 14,  3,  8, 14,  6,  8, 14,  9,
        14, 14,  9, 14, 14, 14, 14, 14, 14, 14, 14,  1,  5, 14,  5,  9,
        14,  8, 14, 14,  4,  9, 14,  7, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14,  5,  7, 14,  9,  9, 14, 14, 14, 14, 14,
        14, 14, 10, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 10, 14, 14, 14, 14, 14,
        15, 15, 15, 15, 15, 15, 15, 15, 14, 14, 14, 14 }
    },
    {  1,  2,  3,  4,  5,  6,  8,  8,  9,  9, 10, 10, 11, 12, 12, 14,
      14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 14 }
  }
};

static const CoeffLens rv60_inter_lens[7] = {
  {
    {
      {  0,  6,  4,  6,  5,  6,  5,  5,  6,  8,  7,  8,  7,  8,  7,  6,
        11, 13, 11, 11, 12, 11, 10,  8,  6,  8,  6,  7,  7,  8,  7,  6,
         8, 10,  8,  9,  9,  9,  8,  7, 13, 14, 12, 12, 13, 12, 11,  9,
        10, 12,  9, 10, 11, 11,  9,  8, 12, 14, 11, 11, 12, 12, 10,  9,
        14, 15, 13, 13, 14, 14, 12, 10,  6,  8,  7,  8,  7,  8,  7,  6,
         8, 10,  9,  9,  9,  9,  8,  7, 13, 14, 12, 12, 13, 12, 11,  9,
         8, 10,  8,  9,  9,  9,  8,  7, 10, 12, 10, 10, 10, 10,  9,  8,
        14, 15, 13, 12, 13, 13, 11,  9, 12, 14, 11, 11, 12, 12, 10,  9,
        14, 15, 12, 12, 13, 13, 11,  9, 15, 15, 14, 14, 14, 14, 12, 10,
        10, 12, 10, 11, 10, 11,  9,  8, 12, 14, 12, 12, 12, 12, 10,  9,
        14, 15, 13, 13, 14, 13, 11,  9, 12, 14, 11, 12, 12, 12, 10,  9,
        14, 15, 13, 12, 13, 12, 11,  9, 15, 15, 14, 14, 14, 14, 12, 10,
        13, 15, 12, 13, 13, 13, 11,  9, 15, 15, 14, 14, 14, 14, 12, 10,
        15, 15, 14, 14, 15, 14, 12,  9,  5,  8,  6,  7,  6,  8,  7,  6,
         8, 10,  8,  9,  9,  9,  8,  7, 12, 14, 12, 12, 12, 12, 11,  9,
         7, 10,  8,  9,  8,  9,  8,  7, 10, 12, 10, 10, 10, 10,  9,  8,
        14, 15, 12, 12, 13, 13, 11,  9, 11, 13, 10, 11, 12, 12, 10,  9,
        13, 15, 12, 12, 13, 13, 11,  9, 15, 15, 13, 13, 14, 14, 12, 10,
         7, 10,  8,  9,  8,  9,  8,  7, 10, 12, 10, 10, 10, 10,  9,  8,
        14, 15, 13, 13, 13, 13, 11,  9,  9, 11,  9, 10, 10, 10,  9,  8,
        11, 13, 11, 11, 11, 11, 10,  8, 15, 15, 13, 13, 14, 13, 12, 10,
        13, 14, 11, 12, 13, 13, 11,  9, 14, 15, 12, 13, 13, 13, 11,  9,
        15, 15, 14, 14, 15, 14, 12, 10, 11, 13, 11, 11, 11, 11, 10,  8,
        13, 15, 12, 12, 12, 12, 11,  9, 15, 15, 14, 14, 14, 13, 12, 10,
        13, 15, 12, 12, 12, 12, 11,  9, 14, 15, 13, 13, 13, 13, 11,  9,
        15, 15, 14, 14, 14, 14, 12, 10, 14, 15, 13, 13, 14, 14, 12, 10,
        15, 15, 14, 14, 14, 14, 12, 10, 15, 15, 14, 14, 15, 14, 12,  9,
         8, 11,  9, 10,  9, 10,  9,  8, 11, 13, 11, 11, 11, 12, 10,  9,
        14, 15, 13, 13, 14, 14, 12, 10, 10, 12, 10, 11, 11, 11, 10,  9,
        13, 14, 12, 12, 12, 12, 11,  9, 15, 15, 14, 14, 15, 14, 12, 10,
        12, 15, 11, 12, 13, 13, 11, 10, 14, 15, 13, 13, 14, 14, 12, 10,
        15, 15, 14, 14, 15, 15, 13, 11, 10, 13, 11, 11, 10, 11, 10,  9,
        13, 14, 12, 12, 12, 12, 11,  9, 15, 15, 14, 14, 15, 14, 12, 10,
        12, 14, 11, 12, 12, 12, 11,  9, 13, 15, 13, 13, 13, 13, 11, 10,
        15, 15, 15, 14, 15, 14, 13, 11, 14, 15, 12, 13, 14, 14, 12, 10,
        15, 15, 13, 13, 14, 14, 12, 10, 15, 15, 15, 15, 15, 15, 13, 10,
        12, 15, 12, 13, 12, 12, 11, 10, 14, 15, 14, 14, 13, 13, 12, 10,
        15, 15, 15, 15, 15, 14, 13, 10, 14, 15, 13, 13, 13, 13, 12, 10,
        15, 15, 14, 14, 14, 14, 12, 10, 15, 15, 15, 15, 15, 15, 13, 10,
        15, 15, 14, 14, 14, 14, 12, 10, 15, 15, 14, 14, 15, 15, 12, 10,
        15, 15, 15, 14, 15, 15, 12, 10, 11, 13, 11, 12, 11, 12, 11, 10,
        13, 15, 13, 13, 13, 13, 12, 10, 15, 15, 14, 14, 15, 15, 13, 11,
        12, 14, 12, 12, 12, 13, 11, 10, 14, 15, 13, 13, 14, 14, 12, 10,
        15, 15, 15, 15, 15, 15, 13, 11, 13, 15, 12, 13, 13, 14, 11, 10,
        15, 15, 13, 13, 14, 14, 12, 10, 15, 15, 14, 14, 15, 15, 12, 10,
        12, 14, 12, 13, 12, 13, 11, 10, 14, 15, 13, 14, 13, 13, 12, 10,
        15, 15, 15, 15, 15, 15, 13, 11, 13, 15, 13, 13, 13, 13, 12, 10,
        15, 15, 14, 14, 14, 14, 12, 11, 15, 15, 15, 15, 15, 15, 13, 11,
        14, 15, 13, 13, 14, 14, 12, 10, 15, 15, 13, 14, 15, 14, 12, 10,
        15, 15, 14, 14, 15, 15, 12, 10, 13, 15, 13, 14, 12, 13, 11, 10,
        15, 15, 14, 14, 13, 13, 12, 10, 15, 15, 15, 15, 15, 14, 12, 10,
        14, 15, 14, 14, 13, 13, 12, 10, 15, 15, 14, 14, 14, 14, 12, 10,
        15, 15, 15, 15, 15, 14, 12, 10, 15, 15, 13, 14, 14, 14, 11,  9,
        15, 15, 14, 14, 14, 14, 11,  9, 15, 15, 13, 13, 14, 13, 11,  8 },
      {  0,  6,  3,  7,  4,  7,  6,  7,  5,  9,  7,  9,  8, 10,  8,  9,
        13, 15, 13, 13, 14, 14, 12, 12,  4,  9,  6,  8,  7, 10,  8,  9,
         8, 11,  9, 10, 10, 11, 10, 10, 15, 15, 14, 14, 14, 15, 13, 12,
        11, 14, 11, 12, 13, 14, 11, 11, 13, 15, 12, 13, 14, 15, 12, 12,
        15, 15, 15, 15, 15, 15, 15, 14,  5,  9,  7,  9,  7,  9,  8,  9,
         8, 11,  9, 10, 10, 11, 10, 10, 15, 15, 14, 14, 14, 15, 13, 12,
         8, 11,  9, 10, 10, 11, 10, 10, 11, 13, 11, 11, 11, 12, 11, 11,
        15, 15, 14, 14, 15, 15, 13, 13, 13, 15, 12, 13, 14, 15, 12, 12,
        15, 15, 14, 14, 15, 15, 13, 13, 15, 15, 15, 15, 15, 15, 15, 14,
        12, 14, 12, 13, 11, 13, 12, 11, 14, 15, 13, 14, 13, 14, 13, 12,
        15, 15, 15, 15, 15, 15, 15, 14, 13, 15, 13, 14, 13, 14, 12, 12,
        15, 15, 14, 14, 14, 15, 13, 13, 15, 15, 15, 15, 15, 15, 15, 14,
        15, 15, 15, 15, 15, 15, 14, 14, 15, 15, 15, 15, 15, 15, 15, 14,
        15, 15, 15, 15, 15, 15, 15, 15,  2,  8,  5,  8,  6,  9,  7,  8,
         7, 10,  8, 10,  9, 10,  9,  9, 14, 15, 13, 13, 14, 14, 13, 12,
         6, 10,  7,  9,  8, 10,  9,  9,  9, 12, 10, 11, 11, 12, 10, 10,
        15, 15, 14, 14, 15, 15, 13, 12, 12, 14, 11, 12, 13, 14, 12, 11,
        14, 15, 13, 13, 14, 15, 13, 12, 15, 15, 15, 15, 15, 15, 15, 14,
         6, 10,  8, 10,  8, 10,  9,  9,  9, 12, 10, 11, 10, 12, 10, 10,
        15, 15, 14, 14, 15, 15, 13, 13,  9, 12,  9, 11, 10, 12, 10, 10,
        11, 13, 11, 12, 12, 13, 11, 11, 15, 15, 14, 14, 15, 15, 14, 13,
        14, 15, 13, 13, 14, 15, 13, 12, 15, 15, 13, 14, 15, 15, 13, 13,
        15, 15, 15, 15, 15, 15, 15, 14, 12, 15, 12, 13, 11, 13, 12, 12,
        14, 15, 14, 14, 13, 14, 13, 12, 15, 15, 15, 15, 15, 15, 15, 14,
        14, 15, 13, 14, 13, 14, 13, 12, 15, 15, 14, 15, 14, 15, 13, 13,
        15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 14, 14,
        15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 14,
         7, 11,  9, 10,  9, 11, 10, 10, 11, 13, 11, 12, 12, 13, 11, 11,
        15, 15, 15, 15, 15, 15, 14, 13,  9, 13, 10, 11, 11, 13, 11, 11,
        12, 14, 12, 13, 13, 14, 12, 12, 15, 15, 15, 15, 15, 15, 14, 14,
        13, 15, 12, 14, 14, 15, 13, 12, 15, 15, 14, 14, 15, 15, 14, 13,
        15, 15, 15, 15, 15, 15, 15, 15, 10, 13, 10, 12, 10, 12, 11, 11,
        12, 14, 12, 13, 12, 13, 12, 12, 15, 15, 15, 15, 15, 15, 14, 14,
        11, 14, 12, 12, 12, 13, 12, 11, 13, 15, 13, 13, 13, 14, 12, 12,
        15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 14, 14, 15, 15, 14, 13,
        15, 15, 14, 15, 15, 15, 14, 13, 15, 15, 15, 15, 15, 15, 15, 14,
        13, 15, 14, 14, 12, 14, 13, 12, 15, 15, 15, 15, 14, 15, 14, 13,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 14, 15, 13, 13,
        15, 15, 15, 15, 14, 15, 14, 13, 15, 15, 15, 15, 15, 15, 15, 14,
        15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 14,
        15, 15, 15, 15, 15, 15, 15, 14, 10, 14, 11, 13, 12, 14, 12, 12,
        13, 15, 13, 14, 14, 15, 13, 12, 15, 15, 15, 15, 15, 15, 15, 14,
        12, 15, 12, 13, 13, 14, 12, 12, 14, 15, 14, 14, 14, 15, 13, 13,
        15, 15, 15, 15, 15, 15, 15, 14, 14, 15, 13, 14, 15, 15, 13, 13,
        15, 15, 14, 15, 15, 15, 14, 13, 15, 15, 15, 15, 15, 15, 15, 14,
        12, 15, 13, 13, 12, 14, 12, 12, 14, 15, 14, 14, 14, 15, 13, 13,
        15, 15, 15, 15, 15, 15, 15, 14, 13, 15, 13, 14, 13, 15, 13, 13,
        15, 15, 14, 15, 15, 15, 13, 13, 15, 15, 15, 15, 15, 15, 15, 14,
        14, 15, 14, 15, 15, 15, 14, 13, 15, 15, 14, 15, 15, 15, 14, 13,
        15, 15, 15, 15, 15, 15, 15, 14, 13, 15, 14, 15, 12, 15, 13, 13,
        15, 15, 15, 15, 14, 15, 14, 13, 15, 15, 15, 15, 15, 15, 15, 14,
        14, 15, 15, 15, 14, 15, 13, 13, 15, 15, 15, 15, 14, 15, 14, 13,
        15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 14, 13,
        15, 15, 15, 15, 15, 15, 14, 13, 15, 15, 15, 15, 15, 15, 13, 12 }
    },
    {
      {  0,  4,  7,  3,  5,  8,  6,  8,  9,  3,  5,  8,  5,  6,  8,  8,
         8,  9,  6,  7,  9,  7,  8,  9,  8,  9,  9,  3,  5,  8,  4,  6,
         9,  7,  8,  9,  5,  6,  8,  6,  7,  9,  8,  9,  9,  7,  8,  9,
         8,  9,  9,  9,  9,  9,  6,  8,  9,  7,  8, 10,  8,  9, 10,  7,
         8, 10,  8,  9, 10,  9, 10, 10,  8,  9, 10,  9, 10, 10, 10, 10,
        10,  8, 10, 10,  9, 10, 11,  9, 10, 10,  9, 10, 10,  9, 10, 11,
        10, 10, 10,  9, 10, 10,  9, 10, 10,  9,  9,  9 },
      {  0,  4,  9,  2,  6, 10,  8,  9, 12,  3,  6, 10,  5,  7, 10,  9,
        10, 12,  8,  9, 11,  9, 10, 12, 11, 12, 13,  2,  5, 10,  4,  7,
        10,  8, 10, 12,  5,  7, 10,  6,  8, 11, 10, 10, 12,  8, 10, 12,
         9, 10, 12, 12, 12, 13,  7,  9, 11,  8,  9, 12, 10, 11, 13,  8,
         9, 12,  9, 10, 12, 11, 12, 13, 10, 11, 13, 11, 12, 13, 13, 13,
        13, 10, 11, 13, 11, 12, 14, 12, 13, 14, 10, 12, 13, 11, 12, 14,
        12, 13, 14, 11, 12, 14, 12, 13, 14, 13, 13, 13 }
    },
    {
      {  0,  4,  7,  3,  5,  8,  6,  8,  9,  3,  5,  8,  5,  6,  9,  7,
         8,  9,  6,  8,  9,  8,  8,  9,  8,  9,  9,  3,  5,  8,  4,  6,
         8,  7,  8,  9,  5,  6,  8,  6,  7,  9,  8,  9, 10,  7,  8,  9,
         8,  9, 10,  9, 10,  9,  5,  8,  9,  7,  8, 10,  8,  9, 10,  7,
         8, 10,  8,  9, 10,  9, 10, 10,  8, 10, 10,  9, 10, 10, 10, 10,
        10,  8, 10, 11,  9, 10, 11,  9, 10, 10,  9, 10, 11, 10, 10, 11,
        10, 10, 10, 10, 11, 11, 10, 11, 11, 10, 10,  9 },
      {  0,  3, 10,  2,  6, 11,  7, 10, 13,  3,  6, 11,  5,  8, 12,  9,
        11, 14,  9, 10, 13, 10, 11, 14, 13, 13, 15,  2,  6, 11,  4,  7,
        12,  8, 10, 14,  5,  8, 12,  7,  9, 12, 10, 11, 14, 10, 11, 14,
        11, 12, 14, 13, 14, 15,  7,  9, 12,  8, 10, 13, 11, 13, 15,  9,
        10, 13, 10, 11, 14, 12, 13, 15, 12, 13, 15, 12, 13, 15, 14, 14,
        15, 11, 12, 14, 12, 13, 15, 14, 14, 15, 12, 13, 15, 13, 14, 15,
        14, 15, 15, 14, 14, 15, 14, 14, 15, 15, 15, 15 }
    },
    {  1,  2,  3,  4,  6,  6,  7,  7,  8,  9,  9,  9, 10, 10, 11, 11,
      11, 12, 12, 12, 12, 12, 13, 13, 12, 12, 12, 13, 15, 15, 15, 15 }
  },
  {
    {
      {  0,  6,  4,  6,  5,  6,  5,  5,  6,  8,  7,  8,  7,  8,  7,  6,
        11, 13, 11, 11, 12, 11, 10,  8,  6,  8,  6,  7,  7,  8,  7,  6,
         8, 10,  8,  9,  9,  9,  8,  7, 13, 14, 12, 12, 13, 12, 11,  9,
        10, 12,  9, 10, 11, 11,  9,  8, 12, 14, 11, 11, 12, 12, 10,  9,
        14, 15, 13, 13, 14, 14, 12, 10,  6,  8,  7,  8,  7,  8,  7,  6,
         8, 10,  9,  9,  9,  9,  8,  7, 13, 14, 12, 12, 13, 12, 11,  9,
         8, 10,  8,  9,  9,  9,  8,  7, 10, 12, 10, 10, 10, 10,  9,  8,
        14, 15, 13, 12, 13, 13, 11,  9, 12, 14, 11, 11, 12, 12, 10,  9,
        14, 15, 12, 12, 13, 13, 11,  9, 15, 15, 14, 14, 14, 14, 12, 10,
        10, 12, 10, 11, 10, 11,  9,  8, 12, 14, 12, 12, 12, 12, 10,  9,
        14, 15, 13, 13, 14, 13, 11,  9, 12, 14, 11, 12, 12, 12, 10,  9,
        14, 15, 13, 12, 13, 12, 11,  9, 15, 15, 14, 14, 14, 14, 12, 10,
        13, 15, 12, 13, 13, 13, 11,  9, 15, 15, 14, 14, 14, 14, 12, 10,
        15, 15, 14, 14, 15, 14, 12,  9,  5,  8,  6,  7,  6,  8,  7,  6,
         8, 10,  8,  9,  9,  9,  8,  7, 12, 14, 12, 12, 12, 12, 11,  9,
         7, 10,  8,  9,  8,  9,  8,  7, 10, 12, 10, 10, 10, 10,  9,  8,
        14, 15, 12, 12, 13, 13, 11,  9, 11, 13, 10, 11, 12, 12, 10,  9,
        13, 15, 12, 12, 13, 13, 11,  9, 15, 15, 13, 13, 14, 14, 12, 10,
         7, 10,  8,  9,  8,  9,  8,  7, 10, 12, 10, 10, 10, 10,  9,  8,
        14, 15, 13, 13, 13, 13, 11,  9,  9, 11,  9, 10, 10, 10,  9,  8,
        11, 13, 11, 11, 11, 11, 10,  8, 15, 15, 13, 13, 14, 13, 12, 10,
        13, 14, 11, 12, 13, 13, 11,  9, 14, 15, 12, 13, 13, 13, 11,  9,
        15, 15, 14, 14, 15, 14, 12, 10, 11, 13, 11, 11, 11, 11, 10,  8,
        13, 15, 12, 12, 12, 12, 11,  9, 15, 15, 14, 14, 14, 13, 12, 10,
        13, 15, 12, 12, 12, 12, 11,  9, 14, 15, 13, 13, 13, 13, 11,  9,
        15, 15, 14, 14, 14, 14, 12, 10, 14, 15, 13, 13, 14, 14, 12, 10,
        15, 15, 14, 14, 14, 14, 12, 10, 15, 15, 14, 14, 15, 14, 12,  9,
         8, 11,  9, 10,  9, 10,  9,  8, 11, 13, 11, 11, 11, 12, 10,  9,
        14, 15, 13, 13, 14, 14, 12, 10, 10, 12, 10, 11, 11, 11, 10,  9,
        13, 14, 12, 12, 12, 12, 11,  9, 15, 15, 14, 14, 15, 14, 12, 10,
        12, 15, 11, 12, 13, 13, 11, 10, 14, 15, 13, 13, 14, 14, 12, 10,
        15, 15, 14, 14, 15, 15, 13, 11, 10, 13, 11, 11, 10, 11, 10,  9,
        13, 14, 12, 12, 12, 12, 11,  9, 15, 15, 14, 14, 15, 14, 12, 10,
        12, 14, 11, 12, 12, 12, 11,  9, 13, 15, 13, 13, 13, 13, 11, 10,
        15, 15, 15, 14, 15, 14, 13, 11, 14, 15, 12, 13, 14, 14, 12, 10,
        15, 15, 13, 13, 14, 14, 12, 10, 15, 15, 15, 15, 15, 15, 13, 10,
        12, 15, 12, 13, 12, 12, 11, 10, 14, 15, 14, 14, 13, 13, 12, 10,
        15, 15, 15, 15, 15, 14, 13, 10, 14, 15, 13, 13, 13, 13, 12, 10,
        15, 15, 14, 14, 14, 14, 12, 10, 15, 15, 15, 15, 15, 15, 13, 10,
        15, 15, 14, 14, 14, 14, 12, 10, 15, 15, 14, 14, 15, 15, 12, 10,
        15, 15, 15, 14, 15, 15, 12, 10, 11, 13, 11, 12, 11, 12, 11, 10,
        13, 15, 13, 13, 13, 13, 12, 10, 15, 15, 14, 14, 15, 15, 13, 11,
        12, 14, 12, 12, 12, 13, 11, 10, 14, 15, 13, 13, 14, 14, 12, 10,
        15, 15, 15, 15, 15, 15, 13, 11, 13, 15, 12, 13, 13, 14, 11, 10,
        15, 15, 13, 13, 14, 14, 12, 10, 15, 15, 14, 14, 15, 15, 12, 10,
        12, 14, 12, 13, 12, 13, 11, 10, 14, 15, 13, 14, 13, 13, 12, 10,
        15, 15, 15, 15, 15, 15, 13, 11, 13, 15, 13, 13, 13, 13, 12, 10,
        15, 15, 14, 14, 14, 14, 12, 11, 15, 15, 15, 15, 15, 15, 13, 11,
        14, 15, 13, 13, 14, 14, 12, 10, 15, 15, 13, 14, 15, 14, 12, 10,
        15, 15, 14, 14, 15, 15, 12, 10, 13, 15, 13, 14, 12, 13, 11, 10,
        15, 15, 14, 14, 13, 13, 12, 10, 15, 15, 15, 15, 15, 14, 12, 10,
        14, 15, 14, 14, 13, 13, 12, 10, 15, 15, 14, 14, 14, 14, 12, 10,
        15, 15, 15, 15, 15, 14, 12, 10, 15, 15, 13, 14, 14, 14, 11,  9,
        15, 15, 14, 14, 14, 14, 11,  9, 15, 15, 13, 13, 14, 13, 11,  8 },
      {  0,  6,  3,  7,  4,  7,  6,  7,  5,  9,  7,  9,  8, 10,  8,  9,
        13, 15, 13, 13, 14, 14, 12, 12,  4,  9,  6,  8,  7, 10,  8,  9,
         8, 11,  9, 10, 10, 11, 10, 10, 15, 15, 14, 14, 14, 15, 13, 12,
        11, 14, 11, 12, 13, 14, 11, 11, 13, 15, 12, 13, 14, 15, 12, 12,
        15, 15, 15, 15, 15, 15, 15, 14,  5,  9,  7,  9,  7,  9,  8,  9,
         8, 11,  9, 10, 10, 11, 10, 10, 15, 15, 14, 14, 14, 15, 13, 12,
         8, 11,  9, 10, 10, 11, 10, 10, 11, 13, 11, 11, 11, 12, 11, 11,
        15, 15, 14, 14, 15, 15, 13, 13, 13, 15, 12, 13, 14, 15, 12, 12,
        15, 15, 14, 14, 15, 15, 13, 13, 15, 15, 15, 15, 15, 15, 15, 14,
        12, 14, 12, 13, 11, 13, 12, 11, 14, 15, 13, 14, 13, 14, 13, 12,
        15, 15, 15, 15, 15, 15, 15, 14, 13, 15, 13, 14, 13, 14, 12, 12,
        15, 15, 14, 14, 14, 15, 13, 13, 15, 15, 15, 15, 15, 15, 15, 14,
        15, 15, 15, 15, 15, 15, 14, 14, 15, 15, 15, 15, 15, 15, 15, 14,
        15, 15, 15, 15, 15, 15, 15, 15,  2,  8,  5,  8,  6,  9,  7,  8,
         7, 10,  8, 10,  9, 10,  9,  9, 14, 15, 13, 13, 14, 14, 13, 12,
         6, 10,  7,  9,  8, 10,  9,  9,  9, 12, 10, 11, 11, 12, 10, 10,
        15, 15, 14, 14, 15, 15, 13, 12, 12, 14, 11, 12, 13, 14, 12, 11,
        14, 15, 13, 13, 14, 15, 13, 12, 15, 15, 15, 15, 15, 15, 15, 14,
         6, 10,  8, 10,  8, 10,  9,  9,  9, 12, 10, 11, 10, 12, 10, 10,
        15, 15, 14, 14, 15, 15, 13, 13,  9, 12,  9, 11, 10, 12, 10, 10,
        11, 13, 11, 12, 12, 13, 11, 11, 15, 15, 14, 14, 15, 15, 14, 13,
        14, 15, 13, 13, 14, 15, 13, 12, 15, 15, 13, 14, 15, 15, 13, 13,
        15, 15, 15, 15, 15, 15, 15, 14, 12, 15, 12, 13, 11, 13, 12, 12,
        14, 15, 14, 14, 13, 14, 13, 12, 15, 15, 15, 15, 15, 15, 15, 14,
        14, 15, 13, 14, 13, 14, 13, 12, 15, 15, 14, 15, 14, 15, 13, 13,
        15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 14, 14,
        15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 14,
         7, 11,  9, 10,  9, 11, 10, 10, 11, 13, 11, 12, 12, 13, 11, 11,
        15, 15, 15, 15, 15, 15, 14, 13,  9, 13, 10, 11, 11, 13, 11, 11,
        12, 14, 12, 13, 13, 14, 12, 12, 15, 15, 15, 15, 15, 15, 14, 14,
        13, 15, 12, 14, 14, 15, 13, 12, 15, 15, 14, 14, 15, 15, 14, 13,
        15, 15, 15, 15, 15, 15, 15, 15, 10, 13, 10, 12, 10, 12, 11, 11,
        12, 14, 12, 13, 12, 13, 12, 12, 15, 15, 15, 15, 15, 15, 14, 14,
        11, 14, 12, 12, 12, 13, 12, 11, 13, 15, 13, 13, 13, 14, 12, 12,
        15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 14, 14, 15, 15, 14, 13,
        15, 15, 14, 15, 15, 15, 14, 13, 15, 15, 15, 15, 15, 15, 15, 14,
        13, 15, 14, 14, 12, 14, 13, 12, 15, 15, 15, 15, 14, 15, 14, 13,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 14, 15, 13, 13,
        15, 15, 15, 15, 14, 15, 14, 13, 15, 15, 15, 15, 15, 15, 15, 14,
        15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 14,
        15, 15, 15, 15, 15, 15, 15, 14, 10, 14, 11, 13, 12, 14, 12, 12,
        13, 15, 13, 14, 14, 15, 13, 12, 15, 15, 15, 15, 15, 15, 15, 14,
        12, 15, 12, 13, 13, 14, 12, 12, 14, 15, 14, 14, 14, 15, 13, 13,
        15, 15, 15, 15, 15, 15, 15, 14, 14, 15, 13, 14, 15, 15, 13, 13,
        15, 15, 14, 15, 15, 15, 14, 13, 15, 15, 15, 15, 15, 15, 15, 14,
        12, 15, 13, 13, 12, 14, 12, 12, 14, 15, 14, 14, 14, 15, 13, 13,
        15, 15, 15, 15, 15, 15, 15, 14, 13, 15, 13, 14, 13, 15, 13, 13,
        15, 15, 14, 15, 15, 15, 13, 13, 15, 15, 15, 15, 15, 15, 15, 14,
        14, 15, 14, 15, 15, 15, 14, 13, 15, 15, 14, 15, 15, 15, 14, 13,
        15, 15, 15, 15, 15, 15, 15, 14, 13, 15, 14, 15, 12, 15, 13, 13,
        15, 15, 15, 15, 14, 15, 14, 13, 15, 15, 15, 15, 15, 15, 15, 14,
        14, 15, 15, 15, 14, 15, 13, 13, 15, 15, 15, 15, 14, 15, 14, 13,
        15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 14, 13,
        15, 15, 15, 15, 15, 15, 14, 13, 15, 15, 15, 15, 15, 15, 13, 12 }
    },
    {
      {  0,  4,  7,  3,  5,  8,  6,  8,  9,  3,  5,  8,  5,  6,  8,  8,
         8,  9,  6,  7,  9,  7,  8,  9,  8,  9,  9,  3,  5,  8,  4,  6,
         9,  7,  8,  9,  5,  6,  8,  6,  7,  9,  8,  9,  9,  7,  8,  9,
         8,  9,  9,  9,  9,  9,  6,  8,  9,  7,  8, 10,  8,  9, 10,  7,
         8, 10,  8,  9, 10,  9, 10, 10,  8,  9, 10,  9, 10, 10, 10, 10,
        10,  8, 10, 10,  9, 10, 11,  9, 10, 10,  9, 10, 10,  9, 10, 11,
        10, 10, 10,  9, 10, 10,  9, 10, 10,  9,  9,  9 },
      {  0,  4,  9,  2,  6, 10,  8,  9, 12,  3,  6, 10,  5,  7, 10,  9,
        10, 12,  8,  9, 11,  9, 10, 12, 11, 12, 13,  2,  5, 10,  4,  7,
        10,  8, 10, 12,  5,  7, 10,  6,  8, 11, 10, 10, 12,  8, 10, 12,
         9, 10, 12, 12, 12, 13,  7,  9, 11,  8,  9, 12, 10, 11, 13,  8,
         9, 12,  9, 10, 12, 11, 12, 13, 10, 11, 13, 11, 12, 13, 13, 13,
        13, 10, 11, 13, 11, 12, 14, 12, 13, 14, 10, 12, 13, 11, 12, 14,
        12, 13, 14, 11, 12, 14, 12, 13, 14, 13, 13, 13 }
    },
    {
      {  0,  4,  7,  3,  5,  8,  6,  8,  9,  3,  5,  8,  5,  6,  9,  7,
         8,  9,  6,  8,  9,  8,  8,  9,  8,  9,  9,  3,  5,  8,  4,  6,
         8,  7,  8,  9,  5,  6,  8,  6,  7,  9,  8,  9, 10,  7,  8,  9,
         8,  9, 10,  9, 10,  9,  5,  8,  9,  7,  8, 10,  8,  9, 10,  7,
         8, 10,  8,  9, 10,  9, 10, 10,  8, 10, 10,  9, 10, 10, 10, 10,
        10,  8, 10, 11,  9, 10, 11,  9, 10, 10,  9, 10, 11, 10, 10, 11,
        10, 10, 10, 10, 11, 11, 10, 11, 11, 10, 10,  9 },
      {  0,  3, 10,  2,  6, 11,  7, 10, 13,  3,  6, 11,  5,  8, 12,  9,
        11, 14,  9, 10, 13, 10, 11, 14, 13, 13, 15,  2,  6, 11,  4,  7,
        12,  8, 10, 14,  5,  8, 12,  7,  9, 12, 10, 11, 14, 10, 11, 14,
        11, 12, 14, 13, 14, 15,  7,  9, 12,  8, 10, 13, 11, 13, 15,  9,
        10, 13, 10, 11, 14, 12, 13, 15, 12, 13, 15, 12, 13, 15, 14, 14,
        15, 11, 12, 14, 12, 13, 15, 14, 14, 15, 12, 13, 15, 13, 14, 15,
        14, 15, 15, 14, 14, 15, 14, 14, 15, 15, 15, 15 }
    },
    {  1,  2,  3,  4,  6,  6,  7,  7,  8,  9,  9,  9, 10, 10, 11, 11,
      11, 12, 12, 12, 12, 12, 13, 13, 12, 12, 12, 13, 15, 15, 15, 15 }
  },
  {
    {
      {  0,  5,  4,  5,  4,  5,  5,  5,  6,  8,  7,  8,  7,  8,  7,  6,
        12, 14, 12, 12, 12, 12, 11, 10,  5,  8,  6,  7,  7,  8,  7,  6,
         8, 10,  8,  9,  9,  9,  8,  8, 13, 15, 13, 13, 13, 13, 12, 10,
        11, 13, 10, 11, 11, 12, 10,  9, 13, 15, 12, 12, 13, 13, 11, 10,
        15, 15, 14, 14, 15, 15, 13, 11,  5,  8,  6,  8,  6,  7,  7,  6,
         8, 10,  9,  9,  9,  9,  8,  8, 13, 15, 13, 13, 13, 13, 12, 10,
         8, 10,  8,  9,  9,  9,  8,  8, 10, 12, 10, 11, 10, 11, 10,  9,
        15, 15, 14, 14, 14, 14, 12, 11, 12, 15, 12, 12, 13, 13, 11, 10,
        14, 15, 13, 13, 14, 14, 12, 11, 15, 15, 15, 15, 15, 15, 13, 11,
        11, 13, 11, 12, 10, 11, 10,  9, 13, 14, 12, 13, 12, 12, 11, 10,
        15, 15, 14, 14, 14, 14, 13, 11, 12, 15, 12, 13, 12, 12, 11, 10,
        14, 15, 13, 13, 13, 13, 12, 11, 15, 15, 15, 15, 15, 15, 13, 11,
        15, 15, 14, 14, 14, 15, 13, 11, 15, 15, 15, 15, 15, 15, 13, 11,
        15, 15, 15, 15, 15, 15, 13, 11,  4,  8,  6,  7,  6,  7,  7,  6,
         8, 10,  8,  9,  9,  9,  8,  8, 13, 15, 13, 13, 13, 13, 12, 10,
         7, 10,  8,  9,  8,  9,  8,  8, 10, 12, 10, 10, 10, 11,  9,  9,
        14, 15, 14, 14, 14, 14, 12, 11, 11, 14, 10, 12, 12, 13, 11, 10,
        13, 15, 12, 13, 13, 14, 12, 10, 15, 15, 15, 15, 15, 15, 13, 11,
         7, 10,  8,  9,  8,  9,  8,  8, 10, 12, 10, 11, 10, 10,  9,  9,
        14, 15, 14, 14, 14, 14, 12, 11,  9, 12, 10, 10, 10, 10,  9,  9,
        11, 13, 11, 12, 11, 12, 10,  9, 15, 15, 14, 14, 14, 14, 13, 11,
        13, 15, 12, 13, 13, 13, 12, 10, 14, 15, 13, 13, 14, 14, 12, 11,
        15, 15, 15, 15, 15, 15, 13, 11, 12, 14, 12, 12, 11, 12, 11, 10,
        13, 15, 13, 13, 12, 13, 12, 10, 15, 15, 15, 15, 15, 14, 13, 11,
        13, 15, 13, 13, 12, 13, 11, 10, 14, 15, 14, 14, 13, 13, 12, 11,
        15, 15, 15, 15, 15, 15, 13, 11, 15, 15, 14, 15, 15, 15, 13, 11,
        15, 15, 15, 15, 15, 15, 13, 11, 15, 15, 15, 15, 15, 15, 13, 11,
         8, 11,  9, 11, 10, 11, 10,  9, 11, 14, 11, 12, 12, 12, 11, 10,
        15, 15, 15, 15, 15, 15, 14, 12, 10, 13, 10, 12, 11, 12, 11, 10,
        13, 15, 12, 13, 13, 13, 12, 11, 15, 15, 15, 15, 15, 15, 14, 12,
        13, 15, 12, 13, 14, 14, 12, 11, 15, 15, 13, 14, 15, 15, 13, 12,
        15, 15, 15, 15, 15, 15, 14, 12, 10, 13, 11, 12, 11, 12, 11, 10,
        13, 15, 13, 13, 12, 13, 12, 11, 15, 15, 15, 15, 15, 15, 14, 12,
        12, 14, 12, 13, 12, 13, 11, 11, 13, 15, 13, 14, 13, 14, 12, 11,
        15, 15, 15, 15, 15, 15, 14, 12, 14, 15, 13, 14, 14, 15, 13, 12,
        15, 15, 14, 14, 15, 15, 13, 12, 15, 15, 15, 15, 15, 15, 14, 12,
        13, 15, 13, 14, 12, 13, 12, 11, 15, 15, 14, 15, 13, 14, 13, 11,
        15, 15, 15, 15, 15, 15, 14, 12, 14, 15, 14, 15, 13, 14, 13, 11,
        15, 15, 15, 15, 14, 14, 13, 12, 15, 15, 15, 15, 15, 15, 14, 12,
        15, 15, 15, 15, 15, 15, 13, 12, 15, 15, 15, 15, 15, 15, 13, 12,
        15, 15, 15, 15, 15, 15, 13, 11, 11, 13, 11, 13, 12, 13, 11, 11,
        13, 15, 13, 14, 13, 14, 12, 12, 15, 15, 15, 15, 15, 15, 14, 12,
        12, 15, 12, 13, 13, 14, 12, 11, 14, 15, 14, 14, 14, 14, 13, 12,
        15, 15, 15, 15, 15, 15, 14, 12, 13, 15, 12, 13, 14, 14, 12, 11,
        15, 15, 13, 14, 15, 15, 13, 11, 15, 15, 15, 15, 15, 15, 13, 11,
        12, 15, 13, 14, 12, 13, 12, 11, 14, 15, 14, 15, 14, 14, 13, 12,
        15, 15, 15, 15, 15, 15, 14, 12, 13, 15, 13, 14, 13, 14, 12, 12,
        15, 15, 14, 15, 14, 15, 13, 12, 15, 15, 15, 15, 15, 15, 14, 12,
        14, 15, 13, 14, 14, 15, 12, 11, 15, 15, 14, 14, 15, 15, 13, 11,
        15, 15, 15, 15, 15, 15, 13, 11, 13, 15, 14, 14, 12, 13, 12, 11,
        15, 15, 15, 15, 13, 14, 12, 11, 15, 15, 15, 15, 15, 15, 13, 11,
        14, 15, 14, 15, 13, 14, 12, 11, 15, 15, 15, 15, 13, 14, 13, 11,
        15, 15, 15, 15, 15, 15, 13, 11, 15, 15, 14, 14, 14, 14, 12, 10,
        15, 15, 14, 14, 14, 14, 12, 10, 15, 15, 13, 14, 14, 14, 11,  9 },
      {  0,  5,  3,  7,  4,  7,  6,  8,  5,  9,  7,  9,  8, 10,  9, 10,
        13, 15, 13, 14, 14, 15, 14, 14,  4,  9,  6,  9,  7, 10,  8,  9,
         8, 11,  9, 11, 10, 12, 10, 11, 15, 15, 14, 15, 15, 15, 15, 15,
        11, 14, 11, 13, 13, 15, 13, 13, 14, 15, 13, 15, 15, 15, 14, 14,
        15, 15, 15, 15, 15, 15, 15, 15,  4,  9,  7,  9,  7,  9,  8,  9,
         8, 11,  9, 11,  9, 11, 10, 11, 15, 15, 14, 15, 15, 15, 14, 15,
         8, 11,  9, 11, 10, 12, 10, 11, 10, 13, 11, 13, 11, 13, 12, 12,
        15, 15, 15, 15, 15, 15, 15, 15, 14, 15, 13, 15, 14, 15, 14, 14,
        15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        12, 15, 12, 14, 11, 14, 12, 13, 14, 15, 14, 15, 13, 15, 14, 14,
        15, 15, 15, 15, 15, 15, 15, 15, 14, 15, 14, 15, 13, 15, 14, 14,
        15, 15, 15, 15, 14, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  2,  8,  5,  8,  6,  9,  7,  9,
         7, 10,  8, 10,  9, 11, 10, 11, 14, 15, 14, 15, 15, 15, 14, 14,
         6, 10,  7, 10,  9, 11,  9, 10,  9, 12, 10, 12, 11, 13, 11, 12,
        15, 15, 15, 15, 15, 15, 15, 15, 12, 15, 11, 14, 14, 15, 13, 13,
        14, 15, 13, 15, 15, 15, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15,
         6, 10,  8, 10,  8, 11,  9, 10,  9, 12, 10, 12, 10, 12, 11, 12,
        15, 15, 15, 15, 15, 15, 15, 15,  9, 12, 10, 12, 10, 12, 11, 12,
        11, 14, 11, 13, 12, 14, 12, 13, 15, 15, 15, 15, 15, 15, 15, 15,
        14, 15, 13, 15, 15, 15, 14, 15, 15, 15, 14, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 12, 15, 13, 15, 11, 14, 13, 13,
        14, 15, 15, 15, 13, 15, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15,
        14, 15, 14, 15, 13, 15, 14, 14, 15, 15, 15, 15, 14, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         7, 11,  9, 11,  9, 12, 10, 11, 10, 13, 11, 13, 12, 13, 12, 13,
        15, 15, 15, 15, 15, 15, 15, 15,  9, 13, 10, 12, 11, 13, 11, 12,
        12, 15, 12, 14, 13, 15, 13, 14, 15, 15, 15, 15, 15, 15, 15, 15,
        13, 15, 12, 15, 14, 15, 14, 14, 15, 15, 14, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  9, 13, 10, 13, 10, 13, 11, 12,
        12, 15, 13, 14, 12, 14, 13, 14, 15, 15, 15, 15, 15, 15, 15, 15,
        11, 15, 12, 14, 12, 14, 13, 13, 12, 15, 13, 15, 13, 15, 13, 14,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15,
        15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        13, 15, 14, 15, 12, 15, 13, 14, 15, 15, 15, 15, 14, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 14, 15, 14, 15,
        15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 10, 14, 12, 14, 12, 14, 13, 13,
        13, 15, 13, 15, 14, 15, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15,
        11, 15, 12, 15, 13, 15, 13, 14, 14, 15, 14, 15, 14, 15, 14, 14,
        15, 15, 15, 15, 15, 15, 15, 15, 13, 15, 13, 15, 14, 15, 14, 14,
        15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        11, 15, 13, 15, 12, 15, 13, 14, 14, 15, 14, 15, 14, 15, 14, 14,
        15, 15, 15, 15, 15, 15, 15, 15, 12, 15, 13, 15, 13, 15, 14, 14,
        14, 15, 14, 15, 14, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        14, 15, 14, 15, 15, 15, 14, 14, 15, 15, 14, 15, 15, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 12, 15, 14, 15, 12, 15, 13, 14,
        15, 15, 15, 15, 14, 15, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15,
        13, 15, 15, 15, 13, 15, 14, 14, 14, 15, 15, 15, 13, 15, 14, 14,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 14,
        14, 15, 15, 15, 14, 15, 14, 14, 15, 15, 15, 15, 14, 15, 14, 13 }
    },
    {
      {  0,  3,  8,  3,  5,  9,  7,  9, 10,  3,  5,  9,  5,  7,  9,  9,
         9, 11,  7,  8, 10,  8,  9, 10, 10, 11, 11,  2,  5,  9,  5,  7,
        10,  8,  9, 11,  5,  6,  9,  6,  7, 10,  9, 10, 11,  8,  9, 10,
         9,  9, 11, 10, 11, 11,  7,  8, 11,  8,  9, 11,  9, 10, 12,  8,
         9, 11,  9, 10, 11, 10, 11, 12,  9, 10, 11, 10, 11, 11, 11, 11,
        11,  9, 11, 12, 10, 11, 12, 10, 11, 11, 10, 11, 12, 10, 11, 12,
        11, 11, 11, 10, 11, 11, 10, 11, 11, 11, 10, 10 },
      {  0,  3, 10,  2,  6, 11,  9, 10, 14,  3,  6, 11,  6,  8, 12, 10,
        12, 14,  8, 10, 13, 10, 11, 14, 13, 14, 15,  2,  5, 11,  5,  7,
        12,  9, 11, 14,  4,  7, 12,  7,  8, 12, 11, 12, 14,  9, 11, 13,
        11, 11, 14, 13, 14, 15,  7,  9, 13,  9, 11, 14, 11, 13, 15,  8,
        10, 14, 10, 11, 14, 12, 13, 15, 10, 12, 14, 12, 13, 14, 14, 14,
        14, 11, 12, 14, 12, 13, 14, 13, 14, 14, 11, 13, 14, 12, 13, 14,
        13, 14, 15, 12, 14, 15, 13, 14, 14, 14, 14, 14 }
    },
    {
      {  0,  3,  8,  3,  5,  9,  7,  9, 10,  3,  5,  9,  5,  7, 10,  9,
        10, 11,  7,  9, 10,  9, 10, 11, 10, 11, 11,  2,  5,  9,  4,  7,
        10,  8,  9, 11,  5,  7, 10,  6,  8, 10,  9, 10, 11,  8,  9, 11,
         9, 10, 11, 11, 11, 11,  6,  9, 11,  8,  9, 11, 10, 11, 12,  8,
        10, 11,  9, 10, 12, 11, 11, 12, 10, 11, 12, 11, 11, 12, 12, 12,
        12, 10, 11, 12, 11, 11, 12, 11, 12, 12, 11, 12, 13, 11, 12, 13,
        12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 11 },
      {  0,  5, 12,  2,  7, 13, 10, 12, 16,  3,  8, 13,  7, 10, 14, 12,
        13, 16, 11, 12, 16, 12, 14, 16, 15, 16, 16,  1,  7, 13,  5,  9,
        14, 11, 13, 16,  6,  9, 14,  8, 11, 15, 13, 14, 16, 12, 13, 16,
        13, 14, 16, 15, 15, 16,  9, 11, 14, 11, 12, 16, 14, 15, 16, 11,
        13, 16, 12, 13, 16, 15, 16, 16, 14, 15, 16, 15, 15, 16, 16, 16,
        16, 14, 15, 16, 15, 15, 16, 16, 16, 16, 15, 16, 16, 15, 16, 16,
        16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15 }
    },
    {  1,  2,  3,  4,  6,  6,  7,  7,  8,  9,  9,  9, 10, 10, 11, 11,
      11, 12, 12, 12, 12, 13, 13, 13, 12, 12, 12, 13, 14, 14, 14, 14 }
  },
  {
    {
      {  0,  5,  3,  5,  4,  5,  5,  5,  5,  8,  6,  8,  7,  8,  7,  7,
        13, 14, 12, 13, 13, 13, 12, 11,  5,  8,  6,  7,  7,  8,  7,  7,
         8, 10,  8, 10,  9, 10,  9,  9, 14, 15, 13, 14, 14, 14, 12, 11,
        11, 14, 10, 12, 12, 13, 11, 10, 13, 15, 12, 13, 13, 14, 12, 11,
        15, 15, 14, 15, 15, 15, 13, 12,  5,  8,  6,  8,  6,  7,  7,  7,
         8, 10,  9, 10,  9,  9,  9,  9, 14, 15, 13, 13, 13, 13, 12, 11,
         8, 10,  8, 10,  9, 10,  9,  9, 10, 12, 10, 11, 10, 11, 10, 10,
        15, 15, 14, 14, 14, 14, 13, 12, 12, 15, 12, 13, 13, 14, 12, 11,
        14, 15, 13, 14, 14, 15, 12, 12, 15, 15, 15, 15, 15, 15, 13, 12,
        11, 13, 11, 12, 10, 11, 10, 10, 12, 15, 13, 13, 12, 12, 11, 11,
        15, 15, 14, 15, 14, 14, 13, 12, 12, 15, 13, 13, 12, 13, 12, 11,
        14, 15, 13, 14, 13, 14, 12, 11, 15, 15, 15, 15, 15, 15, 13, 12,
        15, 15, 14, 15, 14, 15, 13, 12, 15, 15, 15, 15, 15, 15, 13, 12,
        15, 15, 15, 15, 15, 15, 13, 12,  4,  7,  6,  7,  6,  8,  7,  7,
         8, 10,  8, 10,  9, 10,  9,  9, 14, 15, 13, 14, 14, 14, 13, 11,
         7, 10,  7,  9,  8, 10,  8,  8, 10, 12, 10, 11, 10, 11, 10, 10,
        15, 15, 14, 14, 14, 14, 13, 12, 11, 14, 10, 12, 12, 13, 11, 11,
        13, 15, 12, 13, 14, 14, 12, 11, 15, 15, 15, 15, 15, 15, 13, 12,
         7, 10,  8, 10,  8,  9,  8,  8, 10, 12, 10, 11, 10, 11, 10, 10,
        15, 15, 14, 14, 14, 14, 13, 12,  9, 12, 10, 11, 10, 11, 10, 10,
        11, 13, 11, 12, 11, 12, 11, 10, 15, 15, 14, 15, 14, 15, 13, 12,
        13, 15, 12, 13, 13, 14, 12, 11, 14, 15, 13, 14, 14, 15, 13, 12,
        15, 15, 15, 15, 15, 15, 13, 12, 11, 14, 12, 13, 10, 12, 11, 11,
        13, 15, 13, 14, 12, 13, 12, 11, 15, 15, 15, 15, 15, 15, 13, 12,
        13, 15, 13, 14, 12, 13, 12, 11, 14, 15, 14, 15, 13, 14, 12, 12,
        15, 15, 15, 15, 15, 15, 13, 12, 15, 15, 14, 15, 14, 15, 13, 12,
        15, 15, 15, 15, 15, 15, 13, 12, 15, 15, 15, 15, 15, 15, 13, 11,
         8, 12,  9, 11, 10, 11, 10, 10, 11, 14, 12, 13, 12, 13, 12, 11,
        15, 15, 15, 15, 15, 15, 14, 13, 10, 13, 10, 12, 11, 12, 11, 11,
        12, 15, 12, 13, 13, 14, 12, 12, 15, 15, 15, 15, 15, 15, 14, 13,
        12, 15, 11, 13, 13, 15, 12, 12, 14, 15, 13, 14, 15, 15, 13, 12,
        15, 15, 15, 15, 15, 15, 14, 13, 10, 13, 11, 12, 10, 12, 11, 11,
        12, 15, 13, 14, 12, 13, 12, 12, 15, 15, 15, 15, 15, 15, 14, 13,
        11, 14, 12, 13, 12, 13, 12, 11, 13, 15, 13, 14, 13, 14, 13, 12,
        15, 15, 15, 15, 15, 15, 14, 13, 14, 15, 13, 14, 14, 15, 13, 12,
        14, 15, 13, 15, 15, 15, 13, 12, 15, 15, 15, 15, 15, 15, 14, 13,
        12, 15, 13, 14, 11, 13, 12, 11, 14, 15, 14, 15, 13, 14, 13, 12,
        15, 15, 15, 15, 15, 15, 14, 13, 14, 15, 14, 15, 13, 14, 13, 12,
        14, 15, 15, 15, 13, 14, 13, 12, 15, 15, 15, 15, 15, 15, 14, 12,
        15, 15, 15, 15, 15, 15, 14, 12, 15, 15, 15, 15, 15, 15, 13, 12,
        15, 15, 14, 15, 15, 15, 13, 11, 10, 13, 11, 13, 11, 13, 12, 12,
        13, 15, 13, 14, 13, 14, 13, 12, 15, 15, 15, 15, 15, 15, 14, 13,
        11, 15, 12, 14, 12, 14, 12, 12, 14, 15, 13, 15, 14, 15, 13, 12,
        15, 15, 15, 15, 15, 15, 14, 13, 12, 15, 12, 14, 13, 15, 12, 11,
        15, 15, 13, 14, 14, 15, 13, 12, 15, 15, 15, 15, 15, 15, 13, 12,
        11, 15, 12, 14, 12, 13, 12, 12, 14, 15, 14, 15, 13, 14, 13, 12,
        15, 15, 15, 15, 15, 15, 14, 13, 12, 15, 13, 14, 13, 14, 13, 12,
        14, 15, 14, 15, 14, 15, 13, 13, 15, 15, 15, 15, 15, 15, 14, 13,
        13, 15, 13, 14, 14, 15, 12, 12, 14, 15, 13, 14, 14, 15, 13, 12,
        15, 15, 14, 15, 15, 15, 13, 11, 12, 15, 13, 15, 11, 13, 12, 11,
        14, 15, 14, 15, 13, 14, 12, 12, 15, 15, 15, 15, 15, 15, 13, 11,
        13, 15, 14, 15, 12, 14, 12, 11, 14, 15, 14, 15, 13, 14, 12, 12,
        15, 15, 15, 15, 14, 15, 13, 11, 14, 15, 13, 14, 13, 14, 12, 11,
        14, 15, 13, 14, 13, 14, 12, 11, 15, 15, 13, 14, 13, 13, 11,  9 },
      {  0,  6,  3,  7,  3,  7,  7,  9,  5,  9,  7, 10,  8, 10, 10, 11,
        15, 15, 15, 15, 15, 15, 15, 15,  4,  9,  6, 10,  8, 11,  9, 11,
         8, 12, 10, 12, 10, 13, 11, 13, 15, 15, 15, 15, 15, 15, 15, 15,
        12, 15, 12, 15, 14, 15, 14, 15, 14, 15, 14, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  4,  9,  7, 10,  6, 10,  9, 11,
         8, 12, 10, 13, 10, 12, 11, 13, 15, 15, 15, 15, 15, 15, 15, 15,
         8, 12, 10, 13, 10, 13, 11, 13, 10, 14, 12, 14, 12, 14, 13, 14,
        15, 15, 15, 15, 15, 15, 15, 15, 14, 15, 14, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        12, 15, 14, 15, 11, 15, 13, 15, 14, 15, 15, 15, 13, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 14, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  2,  8,  5,  9,  6,  9,  8, 10,
         7, 11,  9, 12,  9, 12, 11, 12, 15, 15, 15, 15, 15, 15, 15, 15,
         6, 11,  7, 11,  9, 12, 10, 12,  9, 13, 11, 13, 11, 14, 12, 14,
        15, 15, 15, 15, 15, 15, 15, 15, 12, 15, 12, 15, 14, 15, 14, 15,
        14, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         6, 11,  8, 12,  8, 11, 10, 12,  9, 13, 11, 14, 10, 13, 12, 13,
        15, 15, 15, 15, 15, 15, 15, 15,  9, 13, 11, 13, 10, 13, 12, 13,
        10, 15, 12, 15, 12, 14, 13, 14, 15, 15, 15, 15, 15, 15, 15, 15,
        14, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 12, 15, 14, 15, 11, 15, 13, 15,
        14, 15, 15, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        14, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         6, 12,  9, 13,  9, 13, 11, 13, 11, 14, 12, 14, 12, 14, 13, 14,
        15, 15, 15, 15, 15, 15, 15, 15,  9, 14, 10, 14, 11, 14, 12, 14,
        12, 15, 13, 15, 13, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        13, 15, 12, 15, 15, 15, 14, 15, 15, 15, 14, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  9, 14, 11, 14, 10, 14, 12, 13,
        12, 15, 13, 15, 12, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        10, 15, 12, 15, 12, 15, 13, 14, 12, 15, 13, 15, 13, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15,
        14, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        12, 15, 14, 15, 11, 15, 14, 15, 15, 15, 15, 15, 14, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 14, 15, 15, 15,
        14, 15, 15, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  9, 15, 12, 15, 12, 15, 13, 14,
        13, 15, 14, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        11, 15, 12, 15, 13, 15, 13, 14, 14, 15, 14, 15, 14, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 12, 15, 12, 15, 14, 15, 14, 15,
        15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        10, 15, 13, 15, 12, 15, 13, 14, 13, 15, 15, 15, 14, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 11, 15, 13, 15, 13, 15, 14, 15,
        14, 15, 14, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        13, 15, 14, 15, 15, 15, 15, 15, 14, 15, 14, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 11, 15, 14, 15, 11, 15, 13, 14,
        15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        12, 15, 15, 15, 13, 15, 14, 15, 14, 15, 15, 15, 13, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15,
        14, 15, 15, 15, 14, 15, 15, 15, 15, 15, 14, 15, 14, 15, 14, 14 }
    },
    {
      {  0,  3,  8,  3,  5,  9,  8,  9, 11,  3,  5,  9,  5,  7, 10,  9,
        10, 11,  7,  8, 10,  9, 10, 11, 11, 11, 11,  2,  5,  9,  5,  7,
        10,  8,  9, 11,  4,  7, 10,  6,  8, 11,  9, 10, 11,  8,  9, 11,
         9, 10, 11, 11, 11, 11,  7,  9, 11,  8,  9, 12, 10, 11, 12,  8,
         9, 12,  9, 10, 12, 10, 11, 12,  9, 10, 12, 10, 11, 12, 11, 11,
        11,  9, 11, 12, 10, 11, 12, 10, 11, 12, 10, 11, 12, 10, 11, 12,
        11, 11, 11, 10, 11, 12, 10, 11, 12, 11, 11, 10 },
      {  0,  4, 12,  3,  7, 13, 10, 12, 15,  3,  6, 13,  6,  9, 14, 12,
        13, 15,  9, 11, 14, 11, 12, 15, 15, 15, 15,  1,  6, 12,  5,  8,
        14, 10, 12, 15,  4,  8, 14,  8, 10, 14, 12, 13, 15,  9, 12, 15,
        12, 13, 15, 15, 15, 15,  8, 10, 14,  9, 12, 15, 12, 13, 15,  9,
        11, 15, 11, 12, 15, 13, 13, 15, 11, 13, 15, 13, 14, 15, 15, 15,
        15, 11, 13, 15, 13, 14, 15, 14, 15, 15, 12, 14, 15, 13, 14, 15,
        14, 15, 15, 13, 15, 15, 14, 15, 15, 15, 15, 15 }
    },
    {
      {  0,  3,  9,  2,  6, 10,  8, 10, 12,  3,  5, 10,  5,  7, 11,  9,
        10, 12,  8, 10, 12, 10, 10, 12, 11, 12, 13,  2,  6, 10,  5,  7,
        11,  9, 10, 12,  5,  7, 11,  7,  9, 11, 10, 11, 12,  9, 10, 12,
        10, 11, 12, 12, 12, 13,  7,  9, 12,  9, 10, 12, 11, 12, 13,  9,
        10, 12, 10, 11, 13, 11, 12, 13, 11, 12, 13, 12, 12, 13, 13, 13,
        13, 11, 12, 13, 11, 12, 13, 12, 13, 13, 11, 12, 13, 12, 13, 13,
        12, 13, 13, 12, 13, 13, 12, 13, 13, 13, 13, 13 },
      {  0,  4, 14,  2,  8, 15, 12, 14, 16,  3,  8, 15,  7, 11, 16, 13,
        15, 16, 12, 14, 16, 13, 15, 16, 16, 16, 16,  1,  7, 14,  6, 11,
        15, 13, 15, 16,  6, 10, 15, 10, 12, 15, 14, 16, 16, 13, 15, 16,
        14, 16, 16, 16, 16, 16, 10, 12, 15, 12, 14, 16, 15, 16, 16, 12,
        14, 16, 13, 15, 16, 16, 16, 16, 15, 16, 16, 16, 16, 16, 16, 16,
        16, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
        16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16 }
    },
    {  1,  2,  3,  4,  6,  6,  7,  7,  8,  9,  9,  9, 10, 10, 11, 11,
      11, 11, 12, 12, 12, 13, 13, 13, 13, 12, 12, 13, 15, 15, 15, 15 }
  },
  {
    {
      {  0,  5,  3,  6,  3,  6,  5,  6,  5,  8,  7,  8,  7,  8,  8,  8,
        13, 15, 13, 13, 13, 13, 12, 12,  5,  8,  6,  8,  7,  9,  8,  8,
         8, 11,  9, 10,  9, 11, 10, 10, 14, 15, 14, 14, 13, 14, 13, 12,
        11, 14, 10, 12, 12, 14, 11, 11, 12, 15, 12, 13, 13, 14, 12, 12,
        15, 15, 14, 15, 14, 15, 13, 12,  5,  8,  7,  8,  6,  8,  8,  8,
         8, 11,  9, 10,  9, 10,  9, 10, 14, 15, 13, 14, 13, 14, 13, 12,
         8, 11,  9, 10,  9, 11,  9, 10, 10, 13, 10, 12, 11, 12, 11, 11,
        15, 15, 14, 15, 14, 15, 13, 12, 12, 15, 12, 14, 13, 14, 12, 12,
        14, 15, 13, 14, 14, 15, 13, 12, 15, 15, 15, 15, 15, 15, 13, 13,
        10, 14, 12, 13, 10, 12, 11, 11, 12, 15, 13, 14, 11, 13, 12, 12,
        15, 15, 14, 15, 14, 15, 13, 12, 12, 15, 13, 14, 12, 13, 12, 12,
        13, 15, 13, 15, 13, 14, 12, 12, 15, 15, 15, 15, 14, 15, 13, 12,
        14, 15, 14, 15, 14, 15, 13, 12, 15, 15, 14, 15, 14, 15, 13, 13,
        15, 15, 15, 15, 15, 15, 13, 12,  3,  8,  6,  8,  6,  8,  7,  8,
         8, 11,  9, 10,  9, 10, 10, 10, 14, 15, 14, 14, 14, 14, 13, 12,
         6, 10,  7, 10,  8, 10,  9,  9, 10, 13, 10, 12, 11, 12, 11, 11,
        15, 15, 14, 15, 14, 15, 13, 13, 11, 15, 10, 13, 12, 14, 11, 11,
        13, 15, 12, 14, 13, 15, 12, 12, 15, 15, 15, 15, 15, 15, 14, 13,
         6, 10,  8, 10,  8, 10,  9,  9, 10, 12, 10, 12, 10, 11, 11, 11,
        15, 15, 14, 15, 14, 15, 13, 12,  9, 12, 10, 12, 10, 12, 10, 11,
        10, 14, 11, 13, 11, 13, 11, 11, 15, 15, 14, 15, 14, 15, 13, 13,
        13, 15, 12, 14, 13, 15, 12, 12, 13, 15, 12, 14, 14, 15, 13, 12,
        15, 15, 14, 15, 15, 15, 13, 13, 11, 14, 12, 14, 10, 12, 11, 11,
        13, 15, 13, 14, 12, 13, 12, 12, 15, 15, 15, 15, 14, 15, 13, 12,
        13, 15, 13, 14, 12, 14, 12, 12, 13, 15, 14, 15, 12, 14, 12, 12,
        15, 15, 15, 15, 14, 15, 13, 12, 15, 15, 14, 15, 14, 15, 13, 12,
        15, 15, 14, 15, 14, 15, 13, 12, 15, 15, 15, 15, 14, 15, 13, 12,
         7, 12,  9, 12,  9, 12, 10, 11, 11, 14, 12, 13, 11, 13, 12, 12,
        15, 15, 15, 15, 15, 15, 14, 13,  9, 13, 10, 13, 11, 13, 11, 11,
        12, 15, 12, 14, 13, 14, 12, 12, 15, 15, 15, 15, 15, 15, 14, 13,
        12, 15, 11, 14, 13, 15, 12, 12, 14, 15, 13, 15, 14, 15, 13, 13,
        15, 15, 15, 15, 15, 15, 14, 13,  9, 13, 11, 13, 10, 12, 11, 11,
        12, 15, 12, 14, 12, 14, 12, 12, 15, 15, 15, 15, 15, 15, 14, 13,
        11, 15, 12, 14, 12, 14, 12, 12, 12, 15, 13, 14, 13, 14, 13, 12,
        15, 15, 15, 15, 15, 15, 14, 13, 13, 15, 13, 15, 14, 15, 13, 13,
        14, 15, 13, 15, 14, 15, 13, 13, 15, 15, 14, 15, 15, 15, 14, 13,
        12, 15, 13, 15, 11, 13, 12, 12, 14, 15, 14, 15, 13, 14, 13, 12,
        15, 15, 15, 15, 15, 15, 14, 13, 13, 15, 14, 15, 13, 14, 13, 12,
        14, 15, 14, 15, 13, 14, 13, 13, 15, 15, 15, 15, 14, 15, 14, 13,
        15, 15, 15, 15, 15, 15, 13, 13, 14, 15, 14, 15, 14, 15, 13, 13,
        15, 15, 14, 15, 14, 15, 13, 12,  9, 14, 11, 14, 11, 13, 12, 12,
        13, 15, 13, 15, 13, 14, 13, 12, 15, 15, 15, 15, 15, 15, 14, 13,
        11, 15, 12, 14, 12, 14, 12, 12, 13, 15, 13, 15, 13, 15, 13, 13,
        15, 15, 15, 15, 15, 15, 14, 13, 12, 15, 11, 14, 13, 15, 12, 12,
        14, 15, 13, 14, 14, 15, 12, 12, 15, 15, 15, 15, 15, 15, 13, 12,
        11, 15, 12, 14, 11, 14, 12, 12, 13, 15, 14, 15, 13, 14, 13, 13,
        15, 15, 15, 15, 15, 15, 14, 13, 11, 15, 13, 15, 12, 14, 13, 12,
        13, 15, 14, 15, 13, 15, 13, 13, 15, 15, 15, 15, 15, 15, 14, 13,
        12, 15, 12, 14, 13, 15, 12, 12, 13, 15, 12, 15, 14, 15, 12, 12,
        15, 15, 14, 15, 15, 15, 13, 12, 12, 15, 13, 15, 11, 13, 12, 11,
        14, 15, 14, 15, 12, 14, 12, 12, 15, 15, 15, 15, 14, 15, 13, 12,
        12, 15, 13, 15, 12, 14, 12, 12, 13, 15, 14, 15, 12, 14, 12, 12,
        15, 15, 15, 15, 14, 15, 13, 12, 13, 15, 13, 14, 13, 14, 12, 11,
        13, 15, 12, 14, 12, 14, 12, 11, 14, 15, 12, 13, 12, 13, 11, 10 },
      {  0,  6,  4,  9,  4,  9,  8, 10,  5, 10,  9, 12,  8, 12, 11, 13,
        15, 15, 15, 15, 15, 15, 15, 15,  4, 11,  7, 11,  8, 12, 11, 13,
         9, 13, 11, 14, 11, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        13, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  4, 11,  8, 12,  7, 11, 10, 13,
         9, 13, 11, 14, 10, 14, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         8, 14, 11, 15, 11, 14, 13, 14, 11, 15, 13, 15, 13, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        12, 15, 15, 15, 12, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  1,  9,  6, 11,  6, 11, 10, 12,
         7, 11, 10, 13, 10, 13, 12, 14, 15, 15, 15, 15, 15, 15, 15, 15,
         6, 12,  8, 13, 10, 13, 12, 13, 10, 15, 12, 15, 12, 15, 13, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 13, 15, 13, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         6, 12, 10, 13,  8, 13, 11, 13, 10, 15, 12, 15, 11, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  9, 15, 12, 15, 11, 15, 13, 15,
        11, 15, 13, 15, 12, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 12, 15, 15, 15, 12, 15, 15, 15,
        15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         7, 14, 10, 14, 10, 14, 13, 14, 11, 15, 13, 15, 13, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  9, 15, 11, 15, 12, 15, 13, 15,
        12, 15, 14, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        13, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  9, 15, 12, 15, 11, 15, 13, 15,
        12, 15, 14, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        11, 15, 13, 15, 13, 15, 14, 15, 12, 15, 14, 15, 13, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15,
        14, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        12, 15, 15, 15, 12, 15, 14, 15, 15, 15, 15, 15, 14, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 14, 15, 15, 15,
        14, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  9, 15, 13, 15, 12, 15, 14, 15,
        13, 15, 14, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        11, 15, 13, 15, 13, 15, 14, 15, 14, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 12, 15, 13, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        10, 15, 13, 15, 12, 15, 14, 15, 14, 15, 15, 15, 14, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 11, 15, 14, 15, 14, 15, 15, 15,
        14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        13, 15, 14, 15, 15, 15, 15, 15, 14, 15, 14, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 11, 15, 14, 15, 12, 15, 14, 15,
        15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        12, 15, 15, 15, 13, 15, 15, 15, 14, 15, 15, 15, 14, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15,
        14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15 }
    },
    {
      {  0,  3,  9,  3,  6, 10,  8,  9, 12,  2,  6, 10,  6,  7, 11, 10,
        10, 12,  7,  9, 11,  9, 10, 12, 11, 12, 12,  2,  6, 10,  5,  7,
        11,  8, 10, 12,  5,  7, 11,  7,  8, 11, 10, 10, 12,  8, 10, 12,
        10, 10, 12, 11, 12, 12,  7,  9, 12,  8, 10, 12, 10, 11, 13,  8,
        10, 12,  9, 10, 13, 11, 11, 13,  9, 11, 13, 11, 11, 13, 12, 12,
        12,  9, 11, 12, 10, 11, 13, 10, 11, 12, 10, 11, 13, 11, 11, 13,
        11, 11, 12, 10, 11, 12, 11, 11, 12, 11, 11, 11 },
      {  0,  5, 14,  3,  8, 15, 11, 13, 15,  2,  7, 15,  7, 10, 15, 13,
        14, 15, 10, 12, 15, 13, 14, 15, 15, 15, 15,  1,  7, 14,  6, 10,
        15, 12, 14, 15,  5, 10, 15,  9, 11, 15, 13, 14, 15, 10, 13, 15,
        13, 14, 15, 15, 15, 15,  8, 11, 15, 10, 13, 15, 13, 15, 15, 10,
        13, 15, 11, 13, 15, 14, 15, 15, 12, 14, 15, 14, 15, 15, 15, 15,
        15, 12, 15, 15, 13, 15, 15, 15, 15, 15, 13, 15, 15, 14, 15, 15,
        15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15 }
    },
    {
      {  0,  3,  9,  2,  6, 10,  8, 10, 12,  3,  6, 10,  5,  7, 11,  9,
        10, 12,  8, 10, 12, 10, 11, 12, 12, 12, 13,  2,  5, 10,  5,  7,
        11,  9, 10, 12,  5,  7, 11,  7,  9, 11, 10, 11, 13,  9, 10, 12,
        10, 11, 13, 12, 12, 13,  7,  9, 12,  8, 10, 12, 11, 12, 14,  9,
        10, 12, 10, 11, 13, 12, 12, 14, 11, 12, 13, 12, 12, 13, 13, 13,
        14, 11, 12, 13, 11, 12, 13, 12, 13, 14, 11, 12, 13, 12, 13, 14,
        13, 13, 14, 12, 13, 14, 13, 13, 14, 13, 13, 13 },
      {  0,  4, 14,  2,  8, 16, 13, 16, 16,  3,  8, 16,  7, 11, 16, 14,
        16, 16, 12, 14, 16, 13, 15, 16, 16, 16, 16,  1,  7, 14,  6, 10,
        16, 13, 16, 16,  6, 10, 15, 10, 12, 16, 15, 16, 16, 14, 16, 16,
        14, 16, 16, 16, 16, 16, 10, 12, 15, 12, 14, 16, 16, 16, 16, 12,
        14, 16, 13, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
        16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
        16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16 }
    },
    {  1,  2,  3,  4,  6,  6,  7,  7,  8,  9,  9,  9, 10, 10, 11, 11,
      11, 12, 12, 12, 12, 13, 13, 13, 12, 12, 12, 13, 14, 14, 14, 14 }
  },
  {
    {
      {  0,  5,  4,  6,  3,  6,  6,  7,  5,  8,  7,  9,  7,  9,  8,  9,
        13, 15, 13, 14, 13, 14, 12, 12,  4,  9,  6,  9,  7,  9,  8,  9,
         8, 11,  9, 11,  9, 11, 10, 10, 14, 15, 14, 14, 13, 14, 13, 12,
        10, 15, 10, 13, 12, 14, 11, 12, 12, 15, 12, 13, 13, 14, 12, 12,
        15, 15, 14, 15, 14, 15, 13, 13,  4,  8,  7,  9,  6,  8,  8,  8,
         8, 11,  9, 11,  8, 10, 10, 10, 14, 15, 13, 14, 13, 14, 13, 12,
         7, 11,  9, 11,  9, 11, 10, 10,  9, 13, 10, 12, 10, 12, 11, 11,
        14, 15, 14, 15, 14, 14, 13, 13, 12, 15, 12, 14, 13, 14, 12, 12,
        13, 15, 12, 14, 13, 15, 13, 12, 15, 15, 14, 15, 14, 15, 13, 13,
        10, 14, 11, 13,  9, 12, 11, 11, 12, 15, 12, 14, 11, 13, 12, 12,
        15, 15, 14, 15, 13, 15, 13, 12, 12, 15, 13, 14, 11, 13, 12, 12,
        13, 15, 13, 15, 12, 14, 12, 12, 15, 15, 14, 15, 14, 15, 13, 13,
        14, 15, 14, 15, 14, 15, 13, 13, 15, 15, 14, 15, 14, 15, 13, 13,
        15, 15, 15, 15, 15, 15, 13, 12,  3,  8,  6,  8,  6,  8,  8,  8,
         7, 11,  9, 11,  9, 10, 10, 10, 14, 15, 14, 14, 13, 14, 13, 12,
         6, 11,  7, 10,  8, 10,  9, 10,  9, 12, 10, 12, 10, 12, 10, 11,
        15, 15, 14, 15, 14, 15, 13, 13, 10, 15, 10, 13, 12, 14, 11, 12,
        13, 15, 12, 14, 13, 15, 12, 12, 15, 15, 14, 15, 15, 15, 13, 13,
         6, 10,  8, 10,  7, 10,  9, 10,  9, 12, 10, 12, 10, 11, 10, 11,
        15, 15, 14, 15, 14, 14, 13, 13,  8, 12, 10, 12,  9, 12, 10, 11,
        10, 13, 10, 13, 10, 12, 11, 11, 15, 15, 14, 15, 14, 15, 13, 13,
        12, 15, 12, 14, 13, 14, 12, 12, 13, 15, 12, 14, 13, 15, 12, 12,
        15, 15, 14, 15, 15, 15, 13, 13, 10, 15, 12, 14,  9, 12, 11, 11,
        12, 15, 13, 14, 11, 13, 12, 12, 15, 15, 15, 15, 14, 15, 13, 12,
        12, 15, 13, 15, 11, 13, 12, 12, 12, 15, 13, 15, 12, 14, 12, 12,
        15, 15, 15, 15, 14, 15, 13, 12, 14, 15, 14, 15, 14, 15, 13, 13,
        14, 15, 14, 15, 14, 15, 13, 12, 15, 15, 14, 15, 14, 15, 13, 12,
         7, 12,  9, 12,  9, 12, 10, 11, 10, 14, 11, 13, 11, 13, 12, 12,
        15, 15, 15, 15, 15, 15, 14, 13,  8, 13, 10, 13, 10, 13, 11, 11,
        11, 15, 12, 14, 12, 14, 12, 12, 15, 15, 15, 15, 15, 15, 14, 13,
        11, 15, 11, 14, 12, 15, 12, 12, 13, 15, 12, 15, 14, 15, 13, 13,
        15, 15, 15, 15, 15, 15, 14, 13,  8, 13, 10, 13, 10, 12, 11, 11,
        11, 15, 12, 14, 11, 13, 12, 12, 15, 15, 15, 15, 15, 15, 14, 13,
        10, 14, 11, 13, 11, 13, 12, 12, 11, 15, 12, 14, 12, 14, 12, 12,
        15, 15, 15, 15, 15, 15, 14, 13, 12, 15, 12, 14, 13, 15, 12, 13,
        13, 15, 12, 15, 14, 15, 13, 13, 15, 15, 14, 15, 15, 15, 14, 13,
        11, 15, 12, 14, 10, 13, 11, 12, 13, 15, 14, 15, 12, 14, 12, 12,
        15, 15, 15, 15, 15, 15, 14, 13, 12, 15, 13, 15, 12, 14, 12, 12,
        13, 15, 14, 15, 12, 14, 13, 12, 15, 15, 15, 15, 14, 15, 13, 13,
        14, 15, 14, 15, 14, 15, 13, 13, 14, 15, 14, 15, 14, 15, 13, 13,
        15, 15, 13, 15, 13, 15, 12, 12,  9, 14, 11, 13, 10, 13, 11, 12,
        12, 15, 12, 14, 12, 14, 12, 12, 15, 15, 15, 15, 15, 15, 14, 13,
        10, 14, 11, 14, 11, 14, 12, 12, 13, 15, 13, 15, 13, 14, 13, 12,
        15, 15, 15, 15, 15, 15, 14, 13, 11, 15, 11, 14, 12, 14, 11, 12,
        13, 15, 12, 14, 13, 15, 12, 12, 15, 15, 14, 15, 15, 15, 13, 12,
        10, 14, 12, 14, 11, 13, 12, 12, 13, 15, 13, 15, 12, 14, 13, 12,
        15, 15, 15, 15, 15, 15, 14, 13, 11, 15, 12, 14, 12, 14, 12, 12,
        13, 15, 13, 15, 13, 15, 13, 13, 15, 15, 15, 15, 15, 15, 14, 13,
        11, 15, 12, 14, 12, 15, 12, 12, 13, 15, 12, 14, 13, 15, 12, 12,
        15, 15, 14, 15, 15, 15, 13, 12, 11, 15, 12, 14, 10, 13, 11, 11,
        13, 15, 13, 15, 12, 14, 12, 12, 15, 15, 15, 15, 14, 15, 13, 12,
        11, 15, 13, 14, 11, 14, 12, 12, 13, 15, 13, 15, 12, 14, 12, 12,
        15, 15, 15, 15, 14, 14, 13, 12, 12, 15, 12, 15, 12, 14, 11, 11,
        12, 15, 12, 14, 12, 14, 11, 11, 13, 15, 12, 13, 12, 13, 11, 10 },
      {  0,  7,  4,  9,  4,  9,  9, 11,  5, 10,  9, 12,  9, 12, 12, 14,
        15, 15, 15, 15, 15, 15, 15, 15,  4, 11,  7, 12,  9, 13, 11, 13,
         9, 14, 11, 14, 12, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        13, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  4, 11,  9, 13,  7, 12, 11, 13,
         9, 14, 12, 15, 11, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         9, 14, 11, 15, 11, 15, 13, 15, 11, 15, 13, 15, 13, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        12, 15, 15, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  1, 10,  6, 11,  6, 11, 10, 12,
         8, 12, 10, 14, 10, 14, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         6, 13,  8, 14, 10, 14, 12, 14, 10, 15, 12, 15, 13, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 13, 15, 13, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         5, 13, 10, 14,  8, 13, 12, 14, 10, 15, 13, 15, 12, 15, 14, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  9, 15, 12, 15, 12, 15, 14, 15,
        10, 15, 13, 15, 12, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 12, 15, 15, 15, 12, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
         6, 14, 10, 15, 10, 14, 13, 14, 11, 15, 13, 15, 13, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  9, 15, 11, 15, 12, 15, 14, 15,
        12, 15, 14, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        13, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  8, 15, 12, 15, 11, 15, 14, 15,
        12, 15, 15, 15, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        10, 15, 13, 15, 13, 15, 15, 15, 12, 15, 14, 15, 14, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        12, 15, 15, 15, 12, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15,
        14, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15,  8, 15, 12, 15, 12, 15, 14, 15,
        13, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        10, 15, 13, 15, 13, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 12, 15, 13, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        10, 15, 13, 15, 12, 15, 15, 15, 14, 15, 15, 15, 14, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 11, 15, 14, 15, 13, 15, 15, 15,
        14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        13, 15, 14, 15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 11, 15, 14, 15, 12, 15, 15, 15,
        15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        13, 15, 15, 15, 14, 15, 15, 15, 14, 15, 15, 15, 14, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15,
        14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15 }
    },
    {
      {  0,  3,  9,  3,  6, 10,  8,  9, 12,  3,  5, 10,  6,  7, 11,  9,
        10, 12,  7,  9, 11,  9, 10, 12, 11, 12, 12,  2,  5, 10,  4,  7,
        11,  8, 10, 12,  4,  7, 11,  6,  8, 11, 10, 10, 12,  8,  9, 12,
        10, 10, 12, 11, 11, 12,  6,  9, 12,  7,  9, 12,  9, 11, 13,  7,
         9, 12,  9, 10, 12, 10, 11, 13,  9, 11, 13, 10, 11, 13, 12, 12,
        12,  9, 11, 12, 10, 11, 13, 10, 11, 12,  9, 11, 12, 10, 11, 13,
        11, 11, 12, 10, 11, 12, 11, 11, 12, 11, 11, 11 },
      {  0,  5, 14,  3,  8, 15, 11, 14, 15,  2,  7, 15,  7, 10, 15, 13,
        15, 15, 10, 13, 15, 13, 15, 15, 15, 15, 15,  1,  7, 15,  6, 10,
        15, 12, 15, 15,  5, 10, 15,  9, 11, 15, 14, 14, 15, 10, 14, 15,
        14, 15, 15, 15, 15, 15,  8, 11, 15, 10, 13, 15, 13, 15, 15,  9,
        13, 15, 12, 13, 15, 15, 15, 15, 12, 15, 15, 15, 15, 15, 15, 15,
        15, 12, 15, 15, 14, 15, 15, 15, 15, 15, 13, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15 }
    },
    {
      {  0,  3,  9,  2,  6, 10,  8, 10, 12,  3,  6, 11,  5,  7, 11, 10,
        11, 13,  8, 10, 12, 10, 11, 13, 12, 12, 13,  2,  5, 10,  5,  7,
        11,  9, 11, 13,  5,  7, 11,  7,  9, 12, 10, 11, 13,  9, 10, 13,
        10, 11, 13, 12, 13, 13,  7,  9, 12,  8, 10, 13, 11, 12, 14,  8,
        10, 13,  9, 11, 13, 12, 12, 14, 11, 12, 14, 12, 12, 14, 13, 13,
        14, 10, 11, 13, 11, 12, 13, 12, 13, 14, 11, 12, 13, 12, 13, 14,
        13, 13, 14, 12, 13, 14, 13, 13, 14, 13, 13, 13 },
      {  0,  4, 14,  2,  8, 16, 13, 16, 16,  3,  8, 16,  7, 11, 16, 15,
        15, 16, 12, 15, 16, 13, 15, 16, 15, 16, 16,  1,  6, 16,  7, 10,
        16, 15, 16, 16,  6, 10, 16, 10, 13, 16, 16, 16, 16, 14, 16, 16,
        14, 16, 16, 16, 16, 16, 10, 11, 15, 12, 15, 16, 16, 16, 16, 12,
        13, 16, 13, 15, 16, 16, 16, 16, 16, 16, 16, 15, 16, 16, 16, 16,
        16, 16, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
        16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15 }
    },
    {  1,  2,  3,  4,  6,  6,  7,  7,  8,  9,  9,  9, 10, 10, 10, 11,
      11, 12, 12, 12, 13, 13, 13, 13, 13, 12, 13, 14, 14, 15, 15, 14 }
  },
  {
    {
      {  0,  6,  4,  8,  4,  7,  7,  8,  6,  9,  8, 10,  7, 10,  9, 10,
        14, 15, 14, 15, 13, 15, 13, 14,  4, 10,  6, 10,  7, 10,  9, 10,
         7, 12,  9, 12,  9, 12, 10, 11, 14, 15, 14, 15, 14, 15, 14, 14,
        10, 15, 10, 14, 12, 14, 12, 13, 12, 15, 12, 14, 13, 15, 13, 14,
        15, 15, 15, 15, 15, 15, 14, 14,  4,  9,  7, 10,  6,  9,  9, 10,
         7, 11,  9, 12,  9, 11, 10, 11, 14, 15, 14, 15, 14, 15, 14, 14,
         7, 12,  9, 12,  9, 12, 10, 11,  9, 13, 10, 13, 10, 13, 11, 12,
        15, 15, 14, 15, 14, 15, 14, 14, 12, 15, 12, 15, 13, 15, 12, 13,
        13, 15, 13, 15, 14, 15, 13, 14, 15, 15, 15, 15, 15, 15, 14, 15,
        10, 15, 12, 14, 10, 13, 11, 12, 11, 15, 13, 15, 11, 14, 13, 13,
        15, 15, 15, 15, 14, 15, 14, 14, 11, 15, 13, 15, 12, 14, 12, 13,
        13, 15, 14, 15, 12, 14, 13, 13, 15, 15, 15, 15, 15, 15, 14, 14,
        14, 15, 14, 15, 14, 15, 14, 14, 15, 15, 15, 15, 15, 15, 14, 14,
        15, 15, 15, 15, 15, 15, 14, 14,  2,  9,  6,  9,  6,  9,  8,  9,
         7, 11,  9, 11,  9, 11, 10, 11, 14, 15, 14, 15, 14, 15, 14, 14,
         5, 11,  7, 11,  8, 11,  9, 11,  9, 13, 10, 12, 10, 13, 11, 12,
        15, 15, 15, 15, 14, 15, 14, 14, 10, 15, 10, 14, 12, 15, 12, 13,
        12, 15, 12, 15, 13, 15, 13, 14, 15, 15, 15, 15, 15, 15, 15, 14,
         5, 11,  8, 11,  7, 11,  9, 11,  8, 13, 10, 13,  9, 12, 11, 12,
        15, 15, 15, 15, 14, 15, 14, 14,  7, 12,  9, 13,  9, 12, 11, 12,
         9, 13, 10, 13, 10, 13, 11, 12, 14, 15, 14, 15, 14, 15, 14, 14,
        12, 15, 12, 15, 13, 15, 13, 14, 12, 15, 11, 15, 13, 15, 13, 14,
        15, 15, 14, 15, 15, 15, 14, 14, 10, 15, 12, 14,  9, 13, 11, 12,
        12, 15, 13, 15, 11, 14, 12, 13, 15, 15, 15, 15, 14, 15, 14, 14,
        11, 15, 13, 15, 11, 14, 12, 13, 12, 15, 13, 15, 11, 14, 13, 13,
        15, 15, 15, 15, 14, 15, 14, 14, 14, 15, 14, 15, 14, 15, 14, 14,
        14, 15, 14, 15, 14, 15, 13, 14, 15, 15, 15, 15, 14, 15, 14, 14,
         6, 12,  9, 12,  8, 12, 10, 11, 10, 14, 11, 13, 11, 13, 12, 13,
        15, 15, 15, 15, 15, 15, 15, 15,  8, 14,  9, 13, 10, 13, 11, 12,
        11, 15, 12, 14, 12, 14, 12, 13, 15, 15, 15, 15, 15, 15, 15, 15,
        10, 15, 10, 14, 12, 15, 12, 13, 13, 15, 12, 15, 14, 15, 13, 14,
        15, 15, 15, 15, 15, 15, 15, 15,  8, 13, 10, 13,  9, 13, 11, 12,
        11, 15, 12, 14, 11, 14, 12, 13, 15, 15, 15, 15, 15, 15, 15, 15,
         9, 14, 11, 14, 11, 14, 12, 13, 11, 15, 12, 14, 12, 14, 12, 13,
        15, 15, 15, 15, 15, 15, 15, 15, 12, 15, 12, 15, 13, 15, 13, 14,
        12, 15, 11, 15, 13, 15, 13, 14, 15, 15, 13, 15, 15, 15, 14, 15,
        10, 15, 12, 15, 10, 14, 12, 13, 13, 15, 13, 15, 12, 14, 13, 14,
        15, 15, 15, 15, 15, 15, 15, 15, 11, 15, 13, 15, 12, 15, 13, 13,
        12, 15, 13, 15, 11, 14, 13, 14, 15, 15, 15, 15, 14, 15, 14, 14,
        14, 15, 15, 15, 14, 15, 14, 14, 13, 15, 14, 15, 14, 15, 13, 14,
        14, 15, 13, 15, 14, 15, 13, 14,  8, 14, 11, 14, 10, 14, 12, 13,
        12, 15, 12, 15, 12, 14, 13, 13, 15, 15, 15, 15, 15, 15, 15, 14,
         9, 15, 11, 14, 11, 14, 12, 13, 13, 15, 13, 15, 13, 15, 13, 13,
        15, 15, 15, 15, 15, 15, 14, 14, 10, 15, 10, 14, 12, 15, 12, 13,
        13, 15, 12, 15, 14, 15, 13, 13, 15, 15, 15, 15, 15, 15, 14, 14,
         9, 15, 12, 14, 11, 14, 12, 13, 12, 15, 13, 15, 12, 15, 13, 13,
        15, 15, 15, 15, 15, 15, 14, 14, 10, 15, 12, 15, 11, 15, 12, 13,
        12, 15, 13, 15, 13, 15, 13, 13, 15, 15, 15, 15, 15, 15, 15, 14,
        11, 15, 11, 15, 12, 15, 12, 13, 12, 15, 11, 15, 13, 15, 13, 13,
        15, 15, 14, 15, 15, 15, 14, 13, 10, 15, 12, 15, 10, 14, 11, 12,
        13, 15, 14, 15, 12, 14, 12, 13, 15, 15, 15, 15, 15, 15, 14, 14,
        11, 15, 12, 15, 11, 14, 12, 13, 12, 15, 13, 15, 12, 15, 12, 13,
        15, 15, 15, 15, 14, 15, 14, 13, 12, 15, 12, 15, 13, 15, 12, 13,
        12, 15, 12, 15, 12, 15, 12, 12, 13, 15, 12, 13, 13, 14, 12, 12 },
      {  0,  7,  5, 10,  4, 10,  9, 12,  6, 11, 10, 13, 10, 13, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14,  4, 12,  7, 13, 10, 14, 12, 14,
         9, 14, 12, 14, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14,  4, 12, 10, 14,  7, 13, 12, 14,
         9, 14, 13, 14, 12, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
         9, 14, 12, 14, 12, 14, 14, 14, 11, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        12, 14, 14, 14, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14,  1, 11,  7, 12,  6, 12, 11, 13,
         7, 12, 11, 14, 11, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
         5, 13,  9, 14, 10, 14, 13, 14, 10, 14, 12, 14, 13, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 13, 14, 13, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
         5, 14, 11, 14,  8, 14, 13, 14, 10, 14, 14, 14, 13, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14,  9, 14, 12, 14, 13, 14, 14, 14,
        10, 14, 14, 14, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 12, 14, 14, 14, 12, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
         5, 14, 10, 14,  9, 14, 13, 14, 10, 14, 13, 14, 12, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14,  8, 14, 11, 14, 12, 14, 14, 14,
        12, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        12, 14, 12, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14,  7, 14, 12, 14, 10, 14, 14, 14,
        12, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        10, 14, 14, 14, 13, 14, 14, 14, 11, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        11, 14, 14, 14, 11, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14,  7, 14, 12, 14, 11, 14, 14, 14,
        12, 14, 14, 14, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        10, 14, 12, 14, 13, 14, 14, 14, 13, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 12, 14, 12, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
         9, 14, 14, 14, 12, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 11, 14, 14, 14, 13, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 11, 14, 14, 14, 12, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        12, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 14 }
    },
    {
      {  0,  4, 11,  3,  7, 12,  9, 11, 14,  3,  7, 12,  6,  8, 13, 11,
        12, 14,  9, 10, 13, 11, 12, 14, 13, 14, 15,  1,  6, 12,  5,  8,
        13,  9, 11, 14,  5,  8, 13,  7,  9, 14, 11, 12, 14,  9, 11, 14,
        11, 12, 14, 13, 14, 15,  6,  9, 13,  8, 10, 14, 10, 12, 15,  8,
        10, 14,  9, 11, 15, 11, 12, 15, 10, 12, 15, 12, 12, 15, 14, 13,
        15, 10, 11, 14, 11, 12, 14, 11, 13, 15, 10, 12, 14, 11, 12, 15,
        12, 13, 15, 11, 13, 15, 12, 13, 14, 13, 13, 14 },
      {  0,  5, 14,  3,  7, 15, 11, 13, 15,  2,  8, 15,  7, 10, 15, 15,
        15, 15, 11, 13, 15, 14, 15, 15, 15, 15, 15,  1,  7, 13,  6,  9,
        15, 12, 14, 15,  5, 10, 15,  9, 11, 15, 14, 14, 15, 11, 14, 15,
        15, 15, 15, 15, 15, 15,  8, 10, 15, 11, 13, 15, 15, 15, 15,  9,
        11, 15, 13, 13, 15, 14, 14, 15, 12, 15, 15, 15, 15, 15, 15, 15,
        15, 14, 14, 15, 14, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15 }
    },
    {
      {  0,  4, 12,  3,  6, 12, 10, 12, 15,  3,  6, 12,  6,  8, 13, 11,
        13, 15,  9, 11, 14, 10, 12, 15, 14, 14, 15,  1,  5, 11,  5,  8,
        13, 11, 13, 15,  5,  8, 13,  8,  9, 14, 12, 13, 15, 10, 12, 14,
        11, 12, 15, 14, 14, 15,  7,  9, 12,  9, 11, 14, 13, 14, 15,  9,
        11, 14, 11, 12, 15, 13, 14, 15, 12, 14, 15, 13, 14, 15, 15, 15,
        15, 12, 13, 14, 13, 14, 15, 15, 15, 15, 12, 13, 15, 13, 14, 15,
        15, 15, 15, 14, 14, 15, 15, 15, 15, 15, 15, 15 },
      {  0,  4, 14,  3,  8, 14, 15, 15, 15,  2,  9, 15,  7, 10, 15, 15,
        15, 15, 11, 15, 15, 15, 12, 15, 15, 15, 15,  1,  6, 15,  7, 11,
        15, 15, 15, 15,  6, 10, 15,  9, 12, 15, 15, 15, 15, 12, 15, 15,
        15, 15, 15, 15, 15, 15, 11, 11, 15, 15, 15, 15, 15, 15, 15, 12,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 12, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
        15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 14 }
    },
    {  1,  2,  3,  4,  5,  6,  8,  8,  9,  9, 10, 10, 11, 11, 12, 14,
      14, 15, 15, 15, 15, 15, 15, 15, 15, 14, 14, 14, 14, 15, 15, 14 }
  }
};

#endif /* AVCODEC_RV60VLCS_H */
