#!/usr/bin/env python
# Copyright 2013 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

"""A tool to extract minidumps from dmp crash dumps."""

import os
import sys
from cgi import parse_multipart


def ProcessDump(dump_file, minidump_file):
  """Extracts the part of the dump file that minidump_stackwalk can read.

  The dump files generated by the breakpad integration multi-part form data
  that include the minidump as file attachment.

  Args:
    dump_file: the dump file that needs to be processed.
    minidump_file: the file to write the minidump to.
  """
  try:
    dump = open(dump_file, 'rb')
    boundary = dump.readline().strip()[2:]
    data = parse_multipart(dump, {'boundary': boundary})
  except:
    print 'Failed to read dmp file %s' % dump_file
    return

  if not 'upload_file_minidump' in data:
    print 'Could not find minidump file in dump.'
    return

  f = open(minidump_file, 'w')
  f.write("\r\n".join(data['upload_file_minidump']))
  f.close()


def main():
  if len(sys.argv) != 3:
    print 'Usage: %s [dmp file] [minidump]' % sys.argv[0]
    print ''
    print 'Extracts the minidump stored in the crash dump file'
    return 1

  ProcessDump(sys.argv[1], sys.argv[2])


if '__main__' == __name__:
  sys.exit(main())
