/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.doc.number;

import org.odftoolkit.odfdom.dom.attribute.number.NumberFormatSourceAttribute;
import org.odftoolkit.odfdom.dom.element.number.NumberAmPmElement;
import org.odftoolkit.odfdom.dom.element.number.NumberHoursElement;
import org.odftoolkit.odfdom.dom.element.number.NumberMinutesElement;
import org.odftoolkit.odfdom.dom.element.number.NumberSecondsElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTextElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTimeStyleElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;

public class OdfNumberTimeStyle
extends NumberTimeStyleElement {
    private String styleName;

    public OdfNumberTimeStyle(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfNumberTimeStyle(OdfFileDom ownerDoc, String format, String styleName) {
        super(ownerDoc);
        this.styleName = styleName;
        this.buildFromFormat(format);
    }

    public void buildFromFormat(String format) {
        String actionChars = "GyQMwdEaHhms";
        int actionCount = 0;
        String textBuffer = "";
        boolean endQuote = false;
        int i = 0;
        this.setStyleNameAttribute(this.styleName);
        this.setNumberFormatSourceAttribute(NumberFormatSourceAttribute.Value.LANGUAGE.toString());
        while (i < format.length()) {
            char ch = format.charAt(i);
            if (actionChars.indexOf(ch) >= 0) {
                this.appendText(textBuffer);
                textBuffer = "";
                actionCount = 0;
                while (i < format.length() && format.charAt(i) == ch) {
                    ++actionCount;
                    ++i;
                }
                this.processChar(ch, actionCount);
                continue;
            }
            if (ch == '\'') {
                endQuote = false;
                ++i;
                while (i < format.length() && !endQuote) {
                    ch = format.charAt(i);
                    if (ch == '\'') {
                        if (i + 1 < format.length() && format.charAt(i + 1) == '\'') {
                            ++i;
                            textBuffer = textBuffer + "'";
                        } else {
                            endQuote = true;
                        }
                    } else {
                        textBuffer = textBuffer + ch;
                    }
                    ++i;
                }
                continue;
            }
            textBuffer = textBuffer + ch;
            ++i;
        }
        this.appendText(textBuffer);
    }

    private void appendText(String textBuffer) {
        NumberTextElement textElement = null;
        if (!textBuffer.equals("")) {
            textElement = new NumberTextElement((OdfFileDom)this.getOwnerDocument());
            textElement.setTextContent(textBuffer);
            this.appendChild(textElement);
        }
    }

    private void processChar(char ch, int count) {
        OdfFileDom ownerDoc = (OdfFileDom)this.getOwnerDocument();
        switch (ch) {
            case 'a': {
                NumberAmPmElement ampm = new NumberAmPmElement(ownerDoc);
                this.appendChild(ampm);
                break;
            }
            case 'H': 
            case 'h': {
                NumberHoursElement hours = new NumberHoursElement(ownerDoc);
                hours.setNumberStyleAttribute(this.isLongIf(count > 1));
                this.appendChild(hours);
                break;
            }
            case 'm': {
                NumberMinutesElement minutes = new NumberMinutesElement(ownerDoc);
                minutes.setNumberStyleAttribute(this.isLongIf(count > 1));
                this.appendChild(minutes);
                break;
            }
            case 's': {
                NumberSecondsElement seconds = new NumberSecondsElement(ownerDoc);
                seconds.setNumberStyleAttribute(this.isLongIf(count > 1));
                this.appendChild(seconds);
            }
        }
    }

    private String isLongIf(boolean isLong) {
        return isLong ? "long" : "short";
    }
}

