// -*- Mode: Go; indent-tabs-mode: t -*-

/*
 * Copyright (C) 2019 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package assertstatetest

import (
	"fmt"

	"github.com/snapcore/snapd/asserts"
	"github.com/snapcore/snapd/overlord/assertstate"
	"github.com/snapcore/snapd/overlord/state"
)

// AddMany adds the given assertions to the system assertion database,
// associated with the state.
// It is idempotent but otherwise panics on error.
func AddMany(st *state.State, assertions ...asserts.Assertion) {
	for _, a := range assertions {
		err := assertstate.Add(st, a)
		if _, ok := err.(*asserts.RevisionError); !ok {
			if err != nil {
				panic(fmt.Sprintf("cannot add test assertions: %v", err))
			}
		}
	}
}
