/*
* Copyright (c) 2024-2026, Intel Corporation
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
* OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*/
//!
//! \file     nvlMediaKernel_avcbrc_init.h
//! \brief    File holds the Firmware for the media kernels for HuC
//! \details  File holds the Firmware for the media kernels for HuC which is 
//!           a programmable Microcontroller added to the VDBox pipeline.
//!

/* Media Kernel Version - 20250916 */

#pragma once


/*==========================================================================================================================================================
Kernel begins from here. Do not remove this comment.
==========================================================================================================================================================*/

const uint32_t __MediaKernels_avcbrc_init_nvl [] = 
{
    0x00002000, 0x000000c0, 0x00002a80, 0x00000040,
    0x00002f00, 0x000020c0, 0x00002f40, 0x00000940,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x672efcfa, 0x15010f66, 0x00002ac0, 0x66c0200f,
    0x6601c883, 0xffffff25, 0xc0220f9f, 0x00b800eb,
    0xb8c08e00, 0xe88e0028, 0x8e0010b8, 0x0018b8d8,
    0x20b8d08e, 0x66e08e00, 0x000080ea, 0x90000800,
    0x2ad0002f, 0x2e660000, 0x00841f0f, 0x00000000,
    0x00000000, 0x00000000, 0x2a802f00, 0x00409b00,
    0x000029fd, 0x00409300, 0x00002000, 0x00409300,
    0x0000ffdf, 0x00cf9302, 0x2a802f00, 0x00409300,
    0x001ffcbc, 0x0b36e800, 0xb8660000, 0xebf4dead,
    0xccccf4fd, 0x006afacf, 0x2ae9006a, 0xfa000001,
    0x016a006a, 0x000120e9, 0x006afa00, 0x16e9026a,
    0xfa000001, 0x036a006a, 0x00010ce9, 0x006afa00,
    0x02e9046a, 0xfa000001, 0x056a006a, 0x0000f8e9,
    0x006afa00, 0xeee9066a, 0xfa000000, 0x076a006a,
    0x0000e4e9, 0x086afa00, 0x0000dce9, 0x006afa00,
    0xd2e9096a, 0xfa000000, 0xcae90a6a, 0xfa000000,
    0xc2e90b6a, 0xfa000000, 0xbae90c6a, 0xfa000000,
    0xb2e90d6a, 0xfa000000, 0xaae90e6a, 0xfa000000,
    0x0f6a006a, 0x0000a0e9, 0x006afa00, 0x96e9106a,
    0xfa000000, 0x8ee9116a, 0xfa000000, 0x126a006a,
    0x000084e9, 0x006afa00, 0x7deb136a, 0x6a006afa,
    0xfa76eb14, 0x156a006a, 0x6afa6feb, 0xeb166a00,
    0x006afa68, 0x61eb176a, 0x6a006afa, 0xfa5aeb18,
    0x196a006a, 0x6afa53eb, 0xeb1a6a00, 0x006afa4c,
    0x45eb1b6a, 0x6a006afa, 0xfa3eeb1c, 0x1d6a006a,
    0x6afa37eb, 0xeb1e6a00, 0x006afa30, 0x29eb1f6a,
    0xd06860fa, 0xe8000000, 0x00000074, 0x6104c483,
    0x6a60facf, 0x0956e84c, 0xc4830000, 0xfacf6104,
    0xff68006a, 0xeb000000, 0x31e8600b, 0x61000000,
    0xcf08c483, 0x0056e860, 0x83610000, 0xcccf08c4,
    0x83e58955, 0xc76608ec, 0x07fff845, 0xc0fa45c7,
    0x0f000020, 0x83f85d01, 0xc35d08c4, 0xcccccccc,
    0x83e58955, 0x458b08ec, 0x084d8d28, 0xff240c89,
    0x28c08514, 0xc4830000, 0x90c35d08, 0x90909090,
    0x5de58955, 0x909090c3, 0x90909090, 0x90909090,
    0x5de58955, 0xccccccc3, 0xcccccccc, 0xcccccccc,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0xccccccc3, 0xcccccccc,
    0xb0e58955, 0xe6a1e6ff, 0x90c35d21, 0x90909090,
    0xb8e58955, 0x00020000, 0xe00380b9, 0x64c129fe,
    0xffff01c7, 0xe0b900ff, 0x29fee003, 0x01c764c1,
    0x00000001, 0xe00320b9, 0x64c129fe, 0x00d001c7,
    0xc35d0002, 0x90909090, 0x90909090, 0x90909090,
    0xb0e58955, 0xe6a1e6ff, 0x0000b821, 0x30b90002,
    0x29fee000, 0x098b64c1, 0xe000f0b9, 0x64c129fe,
    0x01ff01c7, 0xe0b90000, 0x29fee000, 0x01c764c1,
    0xffffffff, 0xe00080b9, 0x64c129fe, 0x000001c7,
    0x80b90000, 0x29fee003, 0x01c764c1, 0x00ffffff,
    0xe003e0b9, 0x64c129fe, 0x000101c7, 0x20b90000,
    0x29fee003, 0x01c764c1, 0x000200d0, 0xccccc35d,
    0x53e58955, 0x4d8b5657, 0x08458b10, 0x890c558b,
    0x03e783c7, 0x04be4574, 0x29000000, 0x89ce39fe,
    0x890277cf, 0x89f929f7, 0x74ff85c6, 0x90909009,
    0x4f461688, 0xcf89fa75, 0x7502efc1, 0x03e18327,
    0x0010840f, 0x90900000, 0x90909090, 0x90909090,
    0x49461688, 0x5f5efa75, 0x89c35d5b, 0xc1cf89c6,
    0xd97402ef, 0xc1c2b60f, 0xc38918e2, 0x0908e3c1,
    0xc1da09c2, 0xd00910e0, 0x90909090, 0x90909090,
    0xc6830689, 0xf8754f04, 0x8b08458b, 0xe1830c55,
    0xebbd7503, 0x909090c1, 0x90909090, 0x90909090,
    0x53e58955, 0x4d8b5657, 0x0c558b10, 0x8908458b,
    0x03e683d6, 0xe783c789, 0x75fe3903, 0x74f68559,
    0x0004bb6e, 0xf3290000, 0xcf89cb39, 0xdf890277,
    0xc689f929, 0x840fff85, 0x0000000e, 0x90909090,
    0x881ab60f, 0x4f42461e, 0xcf89f675, 0x0f02efc1,
    0x00001884, 0x90909000, 0x90909090, 0x90909090,
    0x1e891a8b, 0x8304c683, 0x754f04c2, 0x03e183f3,
    0x0c75c985, 0xc68914eb, 0x840fc985, 0x0000000a,
    0x881ab60f, 0x4942461e, 0x5f5ef675, 0x89c35d5b,
    0xc1cf89c6, 0xc87502ef, 0x9090d3eb, 0x90909090,
    0x53e58955, 0x4d8b5657, 0x0c558b10, 0x3908458b,
    0x8d7d76d0, 0xd6390834, 0xca017676, 0xe783d789,
    0x83f08903, 0xc73903e0, 0xff854875, 0xcf391e74,
    0x0277c889, 0xc129f889, 0x840fc085, 0x0000000c,
    0xff5ab60f, 0x4eff5e88, 0xf475484a, 0xe8c1c889,
    0x18840f02, 0x90000000, 0x90909090, 0x90909090,
    0x89fc7a8b, 0xc683fc7e, 0xfcc283fc, 0x83f17548,
    0xc98503e1, 0x0012840f, 0x90900000, 0x90909090,
    0xff42b60f, 0x4eff4688, 0xf475494a, 0x7aebf089,
    0xe683d689, 0x83c78903, 0xfe3903e7, 0xf6855875,
    0x04bb6d74, 0x29000000, 0x89cb39f3, 0x890277cf,
    0x89f929df, 0x0fff85c6, 0x00000d84, 0x90909000,
    0x881ab60f, 0x4f42461e, 0xcf89f675, 0x0f02efc1,
    0x00001884, 0x90909000, 0x90909090, 0x90909090,
    0x1e891a8b, 0x8304c683, 0x754f04c2, 0x03e183f3,
    0x0c75c985, 0xc68914eb, 0x840fc985, 0x0000000a,
    0x881ab60f, 0x4942461e, 0x5f5ef675, 0x89c35d5b,
    0xc1cf89c6, 0xc87502ef, 0x9090d3eb, 0x90909090,
    0x53e58955, 0x8b505657, 0xc985084d, 0x000002b8,
    0xdf840f00, 0x8b000000, 0xf6850c75, 0x00d4880f,
    0x558b0000, 0x76f23914, 0x83ca8960, 0x277403e2,
    0x000004bf, 0x39d72900, 0x77f289f7, 0x29fa8902,
    0x0fd285d6, 0x00000e84, 0x90909000, 0x90909090,
    0x410001c6, 0x89f9754a, 0x02eac1f2, 0x90900e74,
    0x000001c7, 0xc1830000, 0xf4754a04, 0x0f03e683,
    0x00008184, 0x90909000, 0x90909090, 0x90909090,
    0x410001c6, 0xebf9754e, 0x105d8b6d, 0xe083c889,
    0xbe237403, 0x00000004, 0xd639c629, 0x0277d089,
    0xc229f089, 0x840fc085, 0x0000000a, 0x90909090,
    0x48411988, 0xd089fa75, 0x0f02e8c1, 0x00002784,
    0xf3b60f00, 0xe7c1df89, 0xf0758918, 0x08f065c1,
    0x7d03f709, 0x10e6c1f0, 0x9090fe09, 0x90909090,
    0xc1833189, 0xf8754804, 0xe283c031, 0x90077403,
    0x4a411988, 0xc483fa75, 0x5b5f5e04, 0x9090c35d,
    0x53e58955, 0x4d8b5657, 0xb8c98508, 0x00000002,
    0x00f1840f, 0x7d8b0000, 0x0fff850c, 0x0000e688,
    0x10758b00, 0x840ff685, 0x00000080, 0x3914558b,
    0x897977fa, 0x03e083f0, 0xe783cf89, 0x75f83903,
    0x74c0854f, 0x0004bf25, 0xc7290000, 0xd089d739,
    0xf8890277, 0xc085c229, 0x000c840f, 0x90900000,
    0x881eb60f, 0x48464119, 0xd089f675, 0x0f02e8c1,
    0x00001884, 0x90909000, 0x90909090, 0x90909090,
    0x39893e8b, 0x8304c183, 0x754804c6, 0x03e283f3,
    0xd285c031, 0x006d840f, 0x90900000, 0x90909090,
    0x881eb60f, 0x4a464119, 0x5bebf675, 0xe283ca89,
    0xbe247403, 0x00000004, 0xfe39d629, 0x0277fa89,
    0xd729f289, 0x840fd285, 0x0000000b, 0x90909090,
    0x410001c6, 0x89f9754a, 0x02eac1fa, 0x90900e74,
    0x000001c7, 0xc1830000, 0xf4754a04, 0x0f03e783,
    0x00001284, 0x90909000, 0x90909090, 0x90909090,
    0x410001c6, 0x5ef9754f, 0xc35d5b5f, 0x90909090,
    0x57e58955, 0x08558b56, 0x02b8d285, 0x0f000000,
    0x00008284, 0x0c4d8b00, 0x7b78c985, 0x8510758b,
    0x8b1974f6, 0xcf39147d, 0xec831277, 0x52565704,
    0xfffc9be8, 0x10c483ff, 0x5bebc031, 0xe683d689,
    0xbf247403, 0x00000004, 0xcf39f729, 0x0277ce89,
    0xf129fe89, 0x840ff685, 0x0000000b, 0x90909090,
    0x420002c6, 0x89f9754e, 0x02eec1ce, 0x90900e74,
    0x000002c7, 0xc2830000, 0xf4754e04, 0x0f03e183,
    0x00001284, 0x90909000, 0x90909090, 0x90909090,
    0x420002c6, 0x5ef97549, 0xccc35d5f, 0xcccccccc,
    0xb8e58955, 0x00020000, 0x100100b9, 0x64c129ff,
    0x000101c7, 0x00b90000, 0x29ff1000, 0x0004bac1,
    0xc229ff10, 0x0002c764, 0x64000200, 0x100001c7,
    0x0cb90002, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100008b9, 0x64c129ff, 0x000001c7, 0x14b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100010b9,
    0x64c129ff, 0x000001c7, 0x1cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100018b9, 0x64c129ff,
    0x000001c7, 0x24b90000, 0x29ff1000, 0x01c764c1,
    0x00000000, 0x100020b9, 0x64c129ff, 0x000001c7,
    0x2cb90000, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100028b9, 0x64c129ff, 0x000001c7, 0x34b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100030b9,
    0x64c129ff, 0x000001c7, 0x3cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100038b9, 0x64c129ff,
    0x000001c7, 0x44b90000, 0x29ff1000, 0x01c764c1,
    0x00000000, 0x100040b9, 0x64c129ff, 0x000001c7,
    0x4cb90000, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100048b9, 0x64c129ff, 0x000001c7, 0x54b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100050b9,
    0x64c129ff, 0x000001c7, 0x5cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100058b9, 0x64c129ff,
    0x000001c7, 0x64b90000, 0x29ff1000, 0x01c764c1,
    0x00000000, 0x100060b9, 0x64c129ff, 0x000001c7,
    0x6cb90000, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100068b9, 0x64c129ff, 0x000001c7, 0x74b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100070b9,
    0x64c129ff, 0x000001c7, 0x7cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100078b9, 0x64c129ff,
    0x000001c7, 0xc35d0000, 0x90909090, 0x90909090,
    0x56e58955, 0x2000a050, 0x023c0000, 0xc0840b74,
    0xd9e80c75, 0xeb000000, 0x19d2e805, 0x758d0000,
    0x56046af8, 0x006a006a, 0x001b63e8, 0x10c48300,
    0x6a56046a, 0xe8006a00, 0x00001bf4, 0x6a10c483,
    0x006a5604, 0x45e8006a, 0x8300001b, 0x00b810c4,
    0xb9000200, 0xff00008c, 0xc764c129, 0x00000401,
    0x0090b900, 0xc129ff00, 0x90909090, 0x90909090,
    0xa8018b64, 0x0df97402, 0x00007117, 0x020000b9,
    0x0090ba00, 0xca29ff00, 0xb8028964, 0xff0000bc,
    0xc764c829, 0x00000100, 0x00b0b800, 0xc829fee0,
    0x0000c764, 0x83000000, 0x5d5e04c4, 0x909090c3,
    0x83e58955, 0x15e808ec, 0xe8fffff6, 0xfffffd60,
    0xfff7dbe8, 0x0000b8ff, 0xb8b90002, 0x29ffe0d3,
    0x01c764c1, 0x0000004c, 0x90909090, 0x90909090,
    0xfcebf4fb, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0x53e58955, 0xe4835657, 0x40ec81c0, 0x8d000005,
    0x68402474, 0x000004c0, 0xc068006a, 0x56000004,
    0xfffa5be8, 0x10c483ff, 0x001d53e8, 0xe8f18900,
    0x000006ac, 0x75e8f189, 0x0f00000c, 0xf4248cb7,
    0x0f000003, 0xf62494b7, 0x8d000003, 0xb70f1104,
    0x03f824bc, 0xf8010000, 0x24b4b70f, 0x000003fa,
    0x0106448d, 0x00ffff3d, 0xb8057200, 0x0000ffff,
    0x24848966, 0x000003fc, 0x6b23d26b, 0xd10132c9,
    0x8dbf148d, 0xca019214, 0x8db60c8d, 0xf7648a4c,
    0x6a642464, 0x50525100, 0x002187e8, 0x10c48300,
    0xfa83c931, 0xf7c91901, 0xbac109d1, 0x00000064,
    0xe2f7c889, 0x6c248489, 0x71000001, 0x4005c607,
    0x01000029, 0x000032ba, 0xf7c88900, 0x248489e2,
    0x00000164, 0x05c60771, 0x00002940, 0x0023ba01,
    0xc8890000, 0x8489e2f7, 0x00016824, 0xc6077100,
    0x00294005, 0x84c70100, 0x00017024, 0x00000000,
    0xff856600, 0x19ba1974, 0x89000000, 0x89e2f7c8,
    0x01702484, 0x07710000, 0x294005c6, 0xc7010000,
    0x01742484, 0x00000000, 0x85660000, 0xba1974f6,
    0x00000014, 0xe2f7c889, 0x74248489, 0x71000001,
    0x4005c607, 0x01000029, 0x40244c8d, 0x000cffe8,
    0x24548b00, 0x24548948, 0x2454896c, 0x2444c770,
    0x00000074, 0xfffa8100, 0x897fffff, 0xb80572d0,
    0x7fffffff, 0x9c248489, 0xc7000001, 0x01982484,
    0x00000000, 0x8c8a0000, 0x00043b24, 0x02f98000,
    0x448b1b75, 0xd0296824, 0xff3d1376, 0x727fffff,
    0xffffb805, 0x84897fff, 0x00019824, 0x244c8800,
    0x2484c734, 0x00000084, 0x00000000, 0x802484c7,
    0x00000000, 0x0f000000, 0xf6248cb7, 0x89000003,
    0x0f2c244c, 0xf424b4b7, 0x89000003, 0x0f302474,
    0xf82484b7, 0x6b000003, 0x548923c9, 0xd66b2824,
    0x0fca0132, 0xfa248cb7, 0x8d000003, 0x048d8004,
    0x8bd00180, 0x8d64245c, 0x4c8d890c, 0xb70f6488,
    0x03fc24bc, 0xf8890000, 0x748be3f7, 0x006a4c24,
    0xe8505251, 0x00001ffc, 0x8910c483, 0x83c031c1,
    0x548b01fa, 0xc0192824, 0xc809d0f7, 0x30244c8b,
    0x248c8966, 0x0000046c, 0x2c244c8b, 0x248c8966,
    0x0000046e, 0x89dfaf0f, 0x0470249c, 0xf1890000,
    0xca39e9d1, 0x8c891173, 0x00008824, 0x89d62900,
    0x726c2474, 0x2923eb18, 0x24b489d6, 0x00000088,
    0x05c61473, 0x00002940, 0x24748901, 0x4005c66c,
    0x01000029, 0x748904eb, 0x32b96c24, 0xf7000000,
    0x248489e1, 0x00000478, 0x7c248489, 0x89000004,
    0x04802484, 0x84890000, 0x00048424, 0x24848900,
    0x00000488, 0x05c60771, 0x00002940, 0x2484c701,
    0x0000018c, 0x00000000, 0x248cb60f, 0x00000426,
    0x2484b60f, 0x00000427, 0x28244489, 0x3424548a,
    0x4c89d284, 0x37742c24, 0x2484b60f, 0x00000432,
    0x24bcb60f, 0x00000431, 0x7503fa80, 0x3cd23153,
    0xc3970f14, 0xfeb91e3c, 0x77ffffff, 0xf7da8806,
    0x01d189da, 0x1df983c1, 0xc183127c, 0x0f2bebfc,
    0x4d2484b6, 0x8d000004, 0x24eb0278, 0x7c1af983,
    0xfdc18305, 0xf98314eb, 0x83057c17, 0x0aebfec1,
    0xf983c031, 0xc09f0f12, 0xc889c129, 0x2c244c8b,
    0x0fc9b70f, 0x282474b7, 0xf289f039, 0x01018e0f,
    0xc8390000, 0x8d0fcb89, 0x00000103, 0xf289f739,
    0x01058e0f, 0x74890000, 0xcf393424, 0x027cc889,
    0x8488d089, 0x00042c24, 0x24448900, 0x24848838,
    0x00000431, 0x0fff438d, 0x5c89f0b6, 0xc3813c24,
    0x000000fd, 0x8bfbb60f, 0x66282454, 0x5488d639,
    0xc2892724, 0xd0890677, 0x27245488, 0x30244c89,
    0x247c3b66, 0x89047728, 0x8b28245c, 0x662c244c,
    0xcb89ce39, 0x3824448b, 0x5c8a0472, 0x4c8b2724,
    0x39662c24, 0x249c88cf, 0x0000042b, 0x4c8b0472,
    0x8c882824, 0x00042d24, 0x249c8800, 0x00000430,
    0x32248c88, 0x8b000004, 0x3934245c, 0x7fdf89da,
    0x8bd78902, 0x3930244c, 0x7f3c244c, 0x0fcf8902,
    0x432494b6, 0x83000004, 0x848804fa, 0x00043014,
    0x14848800, 0x0000042b, 0xfa805674, 0x9d850f03,
    0x01000000, 0x39ffd1c7, 0x89027fdf, 0x7ccf39fb,
    0x88d98902, 0x0431248c, 0x8c880000, 0x00042c24,
    0x897deb00, 0x89c839c2, 0xfd8c0fcb, 0x89fffffe,
    0x89f739d3, 0xfb8f0ff2, 0x89fffffe, 0x247489fa,
    0x89cf3934, 0xf58d0fc8, 0xe9fffffe, 0xfffffef2,
    0x017f148d, 0x02fac1c2, 0x0140048d, 0x02f8c1f8,
    0x5c89da39, 0x8e0f2824, 0x000001d1, 0x8e0fd839,
    0x000001d7, 0xca89ca39, 0x01d98d0f, 0xc8390000,
    0x31249488, 0x88000004, 0x042c2494, 0x027c0000,
    0x8c88d989, 0x00043324, 0x248c8800, 0x0000042e,
    0x2a2484c6, 0xff000004, 0x2484c766, 0x000003ec,
    0x84c70001, 0x00009424, 0x00000000, 0x2484c700,
    0x00000090, 0x00000000, 0x8c2484c7, 0x00000000,
    0xc7000000, 0x01282484, 0xffff0000, 0x84c7ffff,
    0x00013c24, 0xffffff00, 0x2484c7ff, 0x00000150,
    0xffffffff, 0x2c2484c7, 0xff000001, 0xc7ffffff,
    0x01402484, 0xffff0000, 0x84c7ffff, 0x00015424,
    0xffffff00, 0x2484c7ff, 0x00000130, 0xffffffff,
    0x442484c7, 0xff000001, 0xc7ffffff, 0x01582484,
    0xffff0000, 0x84c7ffff, 0x00013424, 0xffffff00,
    0x2484c7ff, 0x00000148, 0xffffffff, 0x5c2484c7,
    0xff000001, 0xc7ffffff, 0x01382484, 0xffff0000,
    0x84c7ffff, 0x00014c24, 0xffffff00, 0x2484c7ff,
    0x00000160, 0xffffffff, 0x6105b70f, 0x66000020,
    0x48248489, 0xa0000004, 0x0000205a, 0xa0248488,
    0x8a000001, 0x03ee2484, 0xe8c00000, 0x24848807,
    0x00000439, 0x00204fa0, 0x24848800, 0x00000458,
    0x00205ca0, 0x24848800, 0x0000044f, 0x00207ea0,
    0x24848800, 0x00000450, 0x5d05b70f, 0x66000020,
    0x51248489, 0xa0000004, 0x0000205f, 0x53248488,
    0xa0000004, 0x00002060, 0x54248488, 0xc7000004,
    0x041c2484, 0x01000000, 0xc7660100, 0x04202484,
    0x00e00000, 0x8605b60f, 0x66000020, 0x7208f883,
    0x84896608, 0x00042424, 0x04c06800, 0x448d0000,
    0x6a504424, 0xe8006a00, 0x00001614, 0x8510c483,
    0x314375c0, 0xf4658dc0, 0x5d5b5f5e, 0x89d689c3,
    0x39282454, 0x298f0fd8, 0x89fffffe, 0x89ca39c3,
    0x278c0fca, 0x8bfffffe, 0x39282454, 0x249488c8,
    0x00000431, 0x2c249488, 0x0f000004, 0xfffe1f8d,
    0xfe1ce9ff, 0xec83ffff, 0xe8046a0c, 0x00001690,
    0xeb10c483, 0x909090ae, 0x90909090, 0x90909090,
    0x53e58955, 0xec835657, 0xa1ce892c, 0x00002020,
    0x20a10189, 0x89000020, 0x1ca10441, 0x89000020,
    0x4189dc45, 0x2018a108, 0x45890000, 0x0c4189d8,
    0x00200ca1, 0xe8458900, 0xa1104189, 0x00002014,
    0x89d44589, 0x10a11441, 0x89000020, 0x24a11841,
    0x89000020, 0x28a11c41, 0x89000020, 0x50a02041,
    0x88000020, 0x0003af81, 0x1db70f00, 0x00002004,
    0x03ae9988, 0xb70f0000, 0x00202c15, 0x91896600,
    0x000003b4, 0x2e0db70f, 0x66000020, 0x03b68e89,
    0xb70f0000, 0x00200805, 0x86896600, 0x000003b0,
    0x0a05b70f, 0x66000020, 0x03b28689, 0xb70f0000,
    0x00208c3d, 0xff856600, 0x0fe45d89, 0x5e74dbb6,
    0x8a05b70f, 0x89000020, 0x8966f045, 0x0003b486,
    0xec7d8900, 0xb6be8966, 0x0f000003, 0x208e05b7,
    0x89660000, 0x0003b886, 0x05b70f00, 0x00002090,
    0xba868966, 0xa0000003, 0x00002089, 0x04038688,
    0xc1890000, 0x01bac9fe, 0xd3000000, 0x74c084e2,
    0x88d08902, 0x0003fa86, 0x00e5e900, 0x5d890000,
    0xd28566e0, 0xd389c889, 0xc8890774, 0xf766d231,
    0xf05d89f3, 0x66d8b70f, 0x7407fb83, 0x83d88917,
    0xf883fde0, 0x890d7401, 0xec4589c8, 0xe9e05d8b,
    0x000000af, 0xf04db70f, 0xcbaf0f43, 0x03fa9e88,
    0xdf890000, 0x00ffe781, 0xc8890000, 0xc8890674,
    0xf7f7d231, 0x00ffff3d, 0xb8057200, 0x0000ffff,
    0xb4868966, 0x80000003, 0x458901fb, 0x77c789f0,
    0x31ff3102, 0x02fb80d2, 0x80c2970f, 0x940f04fb,
    0x05fb80c0, 0x08c4970f, 0xc4b60fc4, 0x7d89d001,
    0xbe8966ec, 0x000003b6, 0x0ff0558b, 0xff3dc2af,
    0x720000ff, 0xffffb805, 0x89660000, 0x0003b886,
    0x2bd12900, 0xfb80ec4d, 0x77c28903, 0x29d23102,
    0x8e8966d1, 0x000003ba, 0x01f98366, 0xd98004b1,
    0xc0856600, 0x5d8b02b0, 0x890274e0, 0x038688c8,
    0x66000004, 0x03e886c7, 0x08080000, 0x002030a0,
    0xe6868800, 0xa0000003, 0x00002032, 0x03e78688,
    0x4fa00000, 0x88000020, 0x00041886, 0xf601b000,
    0x167510c3, 0xc3f602b0, 0xb00f7520, 0x40c3f603,
    0x458b0875, 0x05e8c0e4, 0x86880424, 0x000003fb,
    0x03f886c6, 0x3c000000, 0x207da002, 0x45880000,
    0xfb850fe4, 0x84000000, 0xf3850fc0, 0xb9000000,
    0xcccccccd, 0x89dc7d8b, 0xc1e1f7f8, 0xfa0104ea,
    0x8b085689, 0xf889d87d, 0xeac1e1f7, 0x89fa0104,
    0x7d8b0c56, 0xf7f889e8, 0x04eac1e1, 0x5689fa01,
    0xd47d8b10, 0xe1f7f889, 0x0104eac1, 0x145689fa,
    0x200c3d8b, 0x458b0000, 0x0fff85f0, 0x0000af84,
    0xc0b70f00, 0xec4db70f, 0xb70fc101, 0x0003b886,
    0x89c80100, 0xb70ff045, 0x00200805, 0x0db70f00,
    0x0000200a, 0x8dc8af0f, 0xfe254904, 0xf77fffff,
    0x00202425, 0xb9d38900, 0x00000064, 0xc189e1f7,
    0x0164db6b, 0xf7f889d3, 0x00202825, 0xbad78900,
    0x00000003, 0x3c8de2f7, 0x89d7017f, 0x0ffa09c2,
    0x03ba96b7, 0x14740000, 0x51535057, 0x11e8d789,
    0x83000018, 0xc18910c4, 0xfa89d389, 0x8df0458b,
    0xba01027c, 0x7fffffff, 0xca39c031, 0x447dd819,
    0x051fc26b, 0x00046c44, 0x6bc1900f, 0x68711fd2,
    0x7d8b6aeb, 0xf0458be8, 0x850fff85, 0xffffff51,
    0x4c15b60f, 0x0f000020, 0x204e05b6, 0x7d8b0000,
    0xfffa81ec, 0xb1000000, 0x108c0fff, 0xe9000001,
    0x000001e6, 0x000000ba, 0x00f98180, 0x83800000,
    0x0e7cffdb, 0x018ff981, 0x8f0f0000, 0x000001e2,
    0xc269ca89, 0x00000142, 0x0153d805, 0xc1900f00,
    0x0142d269, 0x04700000, 0x0774c984, 0x294005c6,
    0xb9010000, 0x68db8bad, 0xd089e9f7, 0xc11fe8c1,
    0xff830cfa, 0xf07d8901, 0xc2010775, 0xeb0ec283,
    0x02548d14, 0x0eff8302, 0x0eb80b77, 0x29000000,
    0x01e8d1f8, 0x05b70fc2, 0x00002030, 0x320db70f,
    0x39000020, 0x0fcf89ca, 0x0000d48e, 0x89c23900,
    0xd68d0fc3, 0x85000000, 0x0001badb, 0x037e0000,
    0x69da894b, 0x000466fa, 0x0affc100, 0x39015f8d,
    0x0fdf89cf, 0x0000c88d, 0x89c33900, 0xca8d0fc3,
    0x81000000, 0x012cf07d, 0xf8bf0000, 0x0fffffff,
    0x0000cc86, 0x39fa0100, 0xf04d89ca, 0x00d18e0f,
    0xfb010000, 0xc289c239, 0x00d48d0f, 0xcb390000,
    0x00d78e0f, 0xc3390000, 0x00d98d0f, 0x7d8b0000,
    0xfffa81ec, 0xb1000000, 0xdb8d0fff, 0x88000000,
    0x0003f096, 0x00ff3d00, 0x027c0000, 0x8688ffb0,
    0x000003f1, 0x03f29688, 0x558a0000, 0x0d9688e4,
    0x89000004, 0x720204d0, 0x88c18902, 0x00040e8e,
    0x02fa8000, 0x85661372, 0xfe0e74ff, 0x0d9688ca,
    0x88000004, 0x00040e96, 0x2cc48300, 0x5d5b5f5e,
    0x39d789c3, 0x0fc389c2, 0xffff2a8c, 0x85fb89ff,
    0x0001badb, 0x8f0f0000, 0xffffff24, 0xffff22e9,
    0x39cf89ff, 0x0fc389c3, 0xffff368c, 0x81fb89ff,
    0x012cf07d, 0xf8bf0000, 0x0fffffff, 0xffff3487,
    0xfffebfff, 0xfa01ffff, 0x4d89ca39, 0x2f8f0ff0,
    0x89ffffff, 0xfb01f055, 0xc289c239, 0xff2c8c0f,
    0x558bffff, 0x0fcb39f0, 0xffff298f, 0x39d989ff,
    0x278c0fc3, 0x89ffffff, 0xec7d8bc8, 0x00fffa81,
    0xffb10000, 0xff258c0f, 0xffb2ffff, 0x03f09688,
    0xff3d0000, 0x0f000000, 0xffff1f8d, 0xff1ce9ff,
    0xf981ffff, 0x000003e7, 0xc16b0d7f, 0x6d4a0572,
    0x2ce90002, 0x81fffffe, 0x0007cff9, 0x0fca8900,
    0xfffd9b8f, 0xc1c889ff, 0x848d06e0, 0x0326cc48,
    0xfe0de900, 0x9090ffff, 0x90909090, 0x90909090,
    0x53e58955, 0xec835657, 0x1c718b1c, 0x0974f685,
    0x8920518b, 0x75d285d7, 0x1c41c718, 0x0000001e,
    0x012041c7, 0xbe000000, 0x0000001e, 0x000001bf,
    0x89db3100, 0xf089ec4d, 0x7d89d231, 0x89f7f7e8,
    0xf189dc45, 0xd1e47589, 0xe04d89e9, 0x7d8bf889,
    0x1067f7ec, 0xd283c801, 0x244f8b00, 0x6af04d89,
    0x50525600, 0x00150be8, 0x10c48300, 0x8901fa83,
    0x0000bffe, 0xff190000, 0xc709d7f7, 0x8b247e89,
    0x66f7e845, 0xe0450314, 0x6a00d283, 0xe475ff00,
    0xdde85052, 0x83000014, 0xfa8310c4, 0xdc558b01,
    0xd3f7db19, 0x5e89c309, 0x1efa8328, 0x00b2830f,
    0x7fa00000, 0x84000020, 0x0fc189c0, 0x0000b484,
    0xf07d8300, 0x89027500, 0xd8b60fc8, 0xe7f7d889,
    0x758bc189, 0x688689ec, 0x71000001, 0x4005c607,
    0x01000029, 0x016c9e89, 0x80a00000, 0x88000020,
    0x00043486, 0x7886c700, 0x00000001, 0x83000000,
    0x7500f07d, 0x7086c727, 0x00000001, 0x84000000,
    0x15840fdb, 0x8d000000, 0x00026c86, 0x90909000,
    0x000000c7, 0xc0830000, 0xf4754b04, 0x8105b60f,
    0x83000020, 0x868865f8, 0x00000436, 0xc0834872,
    0x89e1f79c, 0x00017486, 0xc6077100, 0x00294005,
    0x1fb90100, 0xf751eb85, 0x05eac1e1, 0x01749689,
    0x2ceb0000, 0x7fa01eb2, 0x84000020, 0x0fc189c0,
    0xffff4c85, 0x83d189ff, 0x0f00f07d, 0xffff4684,
    0xff43e9ff, 0x86c7ffff, 0x00000174, 0x00000000,
    0x5e1cc483, 0xc35d5b5f, 0x90909090, 0x90909090,
    0x53e58955, 0xec835657, 0xbfce890c, 0xffffffcd,
    0xb910598b, 0x00000028, 0xe1f7d889, 0x31b9c739,
    0x19000000, 0xe845c7d1, 0x00000031, 0x86c71173,
    0x000000d8, 0x7fffffff, 0xffffffb8, 0x831aeb7f,
    0xd28332c0, 0x6a006a00, 0xe8505264, 0x00001384,
    0x8910c483, 0x0000d886, 0xb8868900, 0xb9000000,
    0x00000023, 0xe1f7d889, 0xffffcdb9, 0xb9c139ff,
    0x00000031, 0xffb9d119, 0x727fffff, 0x32c08316,
    0x6a00d283, 0x52646a00, 0x1346e850, 0xc4830000,
    0x89c18910, 0x0000c88e, 0x003cb900, 0xd8890000,
    0xcdb9e1f7, 0x39ffffff, 0x0031b9c1, 0xd1190000,
    0x86c71b73, 0x000000dc, 0x7fffffff, 0x00bc86c7,
    0xffff0000, 0xffb87fff, 0xeb7fffff, 0x32c08320,
    0x6a00d283, 0x52646a00, 0x12f6e850, 0xc4830000,
    0xdc868910, 0x89000000, 0x0000bc86, 0xcc868900,
    0xb9000000, 0x0000005a, 0xe1f7d889, 0xffffcdb9,
    0xb9c139ff, 0x00000031, 0xffb9d119, 0x727fffff,
    0x32c08316, 0x6a00d283, 0x52646a00, 0x12b2e850,
    0xc4830000, 0x89c18910, 0x0000e08e, 0x0050b900,
    0xd8890000, 0xcdb9e1f7, 0x39ffffff, 0x0031b9c1,
    0xd1190000, 0x86c71173, 0x000000c0, 0x7fffffff,
    0xffffffb8, 0x831aeb7f, 0xd28332c0, 0x6a006a00,
    0xe8505264, 0x0000126c, 0x8910c483, 0x0000c086,
    0xd0868900, 0xb9000000, 0x00000073, 0xe1f7d889,
    0xffffcdb9, 0xb9c139ff, 0x00000031, 0xffb9d119,
    0x727fffff, 0x32c08316, 0x6a00d283, 0x52646a00,
    0x122ee850, 0xc4830000, 0x89c18910, 0x0000e48e,
    0x0078b900, 0xd8890000, 0xcdb9e1f7, 0x39ffffff,
    0x0031b9c1, 0xd1190000, 0x86c71173, 0x000000c4,
    0x7fffffff, 0xffffffb8, 0x831aeb7f, 0xd28332c0,
    0x6a006a00, 0xe8505264, 0x000011e8, 0x8910c483,
    0x0000c486, 0xd4868900, 0x89000000, 0x7e8bf075,
    0x72df390c, 0x0fdf8902, 0x20440dbe, 0xf8890000,
    0xc389e1f7, 0x0f1ff9c1, 0x348dcfaf, 0x32c0830a,
    0x006ad111, 0x5051646a, 0x0010a7e8, 0x10c48300,
    0xff6bfb81, 0xf189ffff, 0xc7cdd983, 0x0000ec45,
    0x00b98000, 0x7c800000, 0xb8c18902, 0xffffffcd,
    0x31b8d839, 0x19000000, 0xffffb8f0, 0x027c7fff,
    0x4d8bc889, 0x988189f0, 0x0f000000, 0x203405be,
    0xc1890000, 0xf71ff9c1, 0x0fc389e7, 0x348dcfaf,
    0x32c0830a, 0x006ad111, 0x5051646a, 0x001043e8,
    0x10c48300, 0xff6bfb81, 0xf189ffff, 0xb9cdd983,
    0x80000000, 0xc189027c, 0xffffcdb8, 0xb8d839ff,
    0x00000031, 0xffb8f019, 0x7c7fffff, 0x8bc88902,
    0x4189f04d, 0x05be0f58, 0x0000203c, 0xf9c1c189,
    0x89e7f71f, 0xcfaf0fc3, 0x830a348d, 0xd11132c0,
    0x646a006a, 0xe9e85051, 0x8300000f, 0xfb8110c4,
    0xffffff6b, 0xd983f189, 0x0000b9cd, 0x027c8000,
    0xcdb8c189, 0x39ffffff, 0x0031b8d8, 0xf0190000,
    0xffffffb8, 0x89027c7f, 0xf04d8bc8, 0x0f784189,
    0x20450dbe, 0xf8890000, 0xc389e1f7, 0x0f1ff9c1,
    0x348dcfaf, 0x32c0830a, 0x006ad111, 0x5051646a,
    0x000f8fe8, 0x10c48300, 0xff6bfb81, 0xf189ffff,
    0xb9cdd983, 0x80000000, 0xc189027c, 0xffffcdb8,
    0xb8d839ff, 0x00000031, 0xffb8f019, 0x7c7fffff,
    0x8bc88902, 0x8189f04d, 0x0000009c, 0x3505be0f,
    0x89000020, 0x1ff9c1c1, 0xc389e7f7, 0x8dcfaf0f,
    0xc0830a34, 0x6ad11132, 0x51646a00, 0x0f32e850,
    0xc4830000, 0x6bfb8110, 0x89ffffff, 0xcdd983f1,
    0x000000b9, 0x89027c80, 0xffcdb8c1, 0xd839ffff,
    0x000031b8, 0xb8f01900, 0x7fffffff, 0xc889027c,
    0x89f04d8b, 0xbe0f5c41, 0x00203d05, 0xc1c18900,
    0xe7f71ff9, 0xaf0fc389, 0x0a348dcf, 0x1132c083,
    0x6a006ad1, 0xe8505164, 0x00000ed8, 0x8110c483,
    0xffff6bfb, 0x83f189ff, 0x00b9cdd9, 0x7c800000,
    0xb8c18902, 0xffffffcd, 0x31b8d839, 0x19000000,
    0xffffb8f0, 0x027c7fff, 0x4d8bc889, 0x7c4189f0,
    0x460dbe0f, 0x89000020, 0x89e1f7f8, 0x1ff9c1c3,
    0x8dcfaf0f, 0xc0830a34, 0x6ad11132, 0x51646a00,
    0x0e7ee850, 0xc4830000, 0x6bfb8110, 0x89ffffff,
    0xcdd983f1, 0x000000b9, 0x89027c80, 0xffcdb8c1,
    0xd839ffff, 0x000031b8, 0xb8f01900, 0x7fffffff,
    0xc889027c, 0x89f04d8b, 0x0000a081, 0x05be0f00,
    0x00002036, 0xf9c1c189, 0x89e7f71f, 0xcfaf0fc3,
    0x830a348d, 0xd11132c0, 0x646a006a, 0x21e85051,
    0x8300000e, 0xfb8110c4, 0xffffff6b, 0xd983f189,
    0x0000b9cd, 0x027c8000, 0xcdb8c189, 0x39ffffff,
    0x0031b8d8, 0xf0190000, 0xffffffb8, 0x89027c7f,
    0xf04d8bc8, 0x0f604189, 0x203e05be, 0xc1890000,
    0xf71ff9c1, 0x0fc389e7, 0x348dcfaf, 0x32c0830a,
    0x006ad111, 0x5051646a, 0x000dc7e8, 0x10c48300,
    0xff6bfb81, 0xf189ffff, 0xb9cdd983, 0x80000000,
    0xc189027c, 0xffffcdb8, 0xb8d839ff, 0x00000031,
    0xffb8f019, 0x7c7fffff, 0x8bc88902, 0x8189f04d,
    0x00000080, 0x470dbe0f, 0x89000020, 0x89e1f7f8,
    0x1ff9c1c3, 0x8dcfaf0f, 0xc0830a34, 0x6ad11132,
    0x51646a00, 0x0d6ae850, 0xc4830000, 0x6bfb8110,
    0x89ffffff, 0xcdd983f1, 0x000000b9, 0x89027c80,
    0xffcdb8c1, 0xd839ffff, 0x000031b8, 0xb8f01900,
    0x7fffffff, 0xc889027c, 0x89f04d8b, 0x0000a481,
    0x05be0f00, 0x00002037, 0xf9c1c189, 0x89e7f71f,
    0xcfaf0fc3, 0x830a348d, 0xd11132c0, 0x646a006a,
    0x0de85051, 0x8300000d, 0xfb8110c4, 0xffffff6b,
    0xd983f189, 0x0000b9cd, 0x027c8000, 0xcdb8c189,
    0x39ffffff, 0x0031b8d8, 0xf0190000, 0xffffffb8,
    0x89027c7f, 0xf04d8bc8, 0x0f644189, 0x203f05be,
    0xc1890000, 0xf71ff9c1, 0x0fc389e7, 0x348dcfaf,
    0x32c0830a, 0x006ad111, 0x5051646a, 0x000cb3e8,
    0x10c48300, 0xff6bfb81, 0xf189ffff, 0xb9cdd983,
    0x80000000, 0xc189027c, 0xffffcdb8, 0xb8d839ff,
    0x00000031, 0xffb8f019, 0x7c7fffff, 0x8bc88902,
    0x8189f04d, 0x00000084, 0x480dbe0f, 0x89000020,
    0x89e1f7f8, 0x1ff9c1c3, 0x8dcfaf0f, 0xc0830a34,
    0x6ad11132, 0x51646a00, 0x0c56e850, 0xc4830000,
    0x6bfb8110, 0x89ffffff, 0xcdd983f1, 0x000000b9,
    0x89027c80, 0xffcdb8c1, 0xd839ffff, 0x000031b8,
    0xb8f01900, 0x7fffffff, 0xc889027c, 0x89f04d8b,
    0x0000a881, 0x05be0f00, 0x00002038, 0xf9c1c189,
    0x89e7f71f, 0xcfaf0fc3, 0x830a348d, 0xd11132c0,
    0x646a006a, 0xf9e85051, 0x8300000b, 0xfb8110c4,
    0xffffff6b, 0xd983f189, 0x0000b9cd, 0x027c8000,
    0xcdb8c189, 0x39ffffff, 0x0031b8d8, 0xf0190000,
    0xffffffb8, 0x89027c7f, 0xf04d8bc8, 0x0f684189,
    0x204005be, 0xc1890000, 0xf71ff9c1, 0x0fc389e7,
    0x348dcfaf, 0x32c0830a, 0x006ad111, 0x5051646a,
    0x000b9fe8, 0x10c48300, 0xff6bfb81, 0xf189ffff,
    0xb9cdd983, 0x80000000, 0xc189027c, 0xffffcdb8,
    0xb8d839ff, 0x00000031, 0xffb8f019, 0x7c7fffff,
    0x8bc88902, 0x8189f04d, 0x00000088, 0x490dbe0f,
    0x89000020, 0x89e1f7f8, 0x1ff9c1c3, 0x8dcfaf0f,
    0xc0830a34, 0x6ad11132, 0x51646a00, 0x0b42e850,
    0xc4830000, 0x6bfb8110, 0x89ffffff, 0xcdd983f1,
    0x000000b9, 0x89027c80, 0xffcdb8c1, 0xd839ffff,
    0x000031b8, 0xb8f01900, 0x7fffffff, 0xc889027c,
    0x89f04d8b, 0x0000ac81, 0x05be0f00, 0x00002039,
    0xf9c1c189, 0x89e7f71f, 0xcfaf0fc3, 0x830a348d,
    0xd11132c0, 0x646a006a, 0xe5e85051, 0x8300000a,
    0xfb8110c4, 0xffffff6b, 0xd983f189, 0x0000b9cd,
    0x027c8000, 0xcdb8c189, 0x39ffffff, 0x0031b8d8,
    0xf0190000, 0xffffffb8, 0x89027c7f, 0xf04d8bc8,
    0x0f6c4189, 0x204105be, 0xc1890000, 0xf71ff9c1,
    0x0fc389e7, 0x348dcfaf, 0x32c0830a, 0x006ad111,
    0x5051646a, 0x000a8be8, 0x10c48300, 0xff6bfb81,
    0xf189ffff, 0xb9cdd983, 0x80000000, 0xc189027c,
    0xffffcdb8, 0xb8d839ff, 0x00000031, 0xffb8f019,
    0x7c7fffff, 0x8bc88902, 0x8189f04d, 0x0000008c,
    0x4a0dbe0f, 0x89000020, 0x89e1f7f8, 0x1ff9c1c3,
    0x8dcfaf0f, 0xc0830a34, 0x6ad11132, 0x51646a00,
    0x0a2ee850, 0xc4830000, 0x6bfb8110, 0x89ffffff,
    0xcdd983f1, 0x000000b9, 0x89027c80, 0xffcdb8c1,
    0xd839ffff, 0x000031b8, 0xb8f01900, 0x7fffffff,
    0xc889027c, 0x89f04d8b, 0x0000b081, 0x05be0f00,
    0x0000203a, 0xf9c1c189, 0x89e7f71f, 0xcfaf0fc3,
    0x830a348d, 0xd11132c0, 0x646a006a, 0xd1e85051,
    0x83000009, 0xfb8110c4, 0xffffff6b, 0xd983f189,
    0x0000b9cd, 0x027c8000, 0xcdb8c189, 0x39ffffff,
    0x0031b8d8, 0xf0190000, 0xffffffb8, 0x89027c7f,
    0xf04d8bc8, 0x0f704189, 0x204205be, 0xc1890000,
    0xf71ff9c1, 0x0fc389e7, 0x348dcfaf, 0x32c0830a,
    0x006ad111, 0x5051646a, 0x000977e8, 0x10c48300,
    0xff6bfb81, 0xf189ffff, 0xb9cdd983, 0x80000000,
    0xc189027c, 0xffffcdb8, 0xb8d839ff, 0x00000031,
    0xffb8f019, 0x7c7fffff, 0x8bc88902, 0x8189f04d,
    0x00000090, 0x4b0dbe0f, 0x89000020, 0x89e1f7f8,
    0x1ff9c1c3, 0x8dcfaf0f, 0xc0830a34, 0x6ad11132,
    0x51646a00, 0x091ae850, 0xc4830000, 0x6bfb8110,
    0x89ffffff, 0xcdd983f1, 0x000000b9, 0x89027c80,
    0xffcdb8c1, 0xd839ffff, 0x000031b8, 0xb8f01900,
    0x7fffffff, 0xc889027c, 0x89f04d8b, 0x0000b481,
    0x05be0f00, 0x0000203b, 0xf9c1c189, 0x89e7f71f,
    0xcfaf0fc3, 0x830a348d, 0xd11132c0, 0x646a006a,
    0xbde85051, 0x83000008, 0xfb8110c4, 0xffffff6b,
    0xd983f189, 0x0000b9cd, 0x027c8000, 0xcdb8c189,
    0x39ffffff, 0x0031b8d8, 0xf0190000, 0xffffffb8,
    0x89027c7f, 0xf04d8bc8, 0x0f744189, 0x204305be,
    0xc1890000, 0xf71ff9c1, 0x0fc389e7, 0x348dcfaf,
    0x32c0830a, 0x006ad111, 0x5051646a, 0x000863e8,
    0x10c48300, 0xff6bfb81, 0xf189ffff, 0x7ccdd983,
    0xec458903, 0xffffcdb8, 0x19d839ff, 0xffb9e875,
    0x7c7fffff, 0xec4d8b03, 0x89f0458b, 0x00009488,
    0x0cc48300, 0x5d5b5f5e, 0x909090c3, 0x90909090,
    0x53e58955, 0xe4835657, 0x00ec81c0, 0xe8000005,
    0x0000046c, 0xc068e089, 0x50000004, 0x006a006a,
    0x00017be8, 0x10c48300, 0x850fc085, 0x00000144,
    0xf189e689, 0xffeda7e8, 0xe8f189ff, 0xfffff370,
    0x248cb70f, 0x000003b4, 0x2494b70f, 0x000003b6,
    0x0f11048d, 0xb8249cb7, 0x01000003, 0xbcb70fd8,
    0x0003ba24, 0x07448d00, 0xffff3d01, 0x05720000,
    0x00ffffb8, 0x84896600, 0x0003bc24, 0x23d26b00,
    0x0132c96b, 0x9b148dd1, 0x0192148d, 0xbf0c8dca,
    0x648a4c8d, 0x242464f7, 0x5251006a, 0x0882e850,
    0xc4830000, 0x83c93110, 0xc91901fa, 0xc109d1f7,
    0x000064ba, 0xf7c88900, 0x248489e2, 0x0000012c,
    0x05c60771, 0x00002940, 0x0032ba01, 0xc8890000,
    0x8489e2f7, 0x00012424, 0xc6077100, 0x00294005,
    0x23ba0100, 0x89000000, 0x89e2f7c8, 0x01282484,
    0x07710000, 0x294005c6, 0xc7010000, 0x01302484,
    0x00000000, 0x85660000, 0xba1974db, 0x00000019,
    0xe2f7c889, 0x30248489, 0x71000001, 0x4005c607,
    0x01000029, 0x342484c7, 0x00000001, 0x66000000,
    0x1974ff85, 0x000014ba, 0xf7c88900, 0x248489e2,
    0x00000134, 0x05c60771, 0x00002940, 0xe8f18901,
    0xfffff3fc, 0x0004c068, 0x006a5600, 0x2de8006a,
    0x83000002, 0xc08510c4, 0xc0311c75, 0x5ef4658d,
    0xc35d5b5f, 0x6a0cec83, 0x02e2e804, 0xc4830000,
    0xfeaae910, 0xec83ffff, 0xe8046a0c, 0x000002d0,
    0xeb10c483, 0xccccccd5, 0xcccccccc, 0xcccccccc,
    0x53e58955, 0x4d8b5657, 0x0c7d8b14, 0x01085d8b,
    0xc60773cf, 0x00294005, 0xfb830100, 0x0002b80f,
    0x75770000, 0x8510558b, 0xbe6e74d2, 0x00020000,
    0x100000b8, 0x8bf029ff, 0x29849d34, 0xc6010000,
    0x03368b64, 0x29449d04, 0x8b640000, 0x0fde2918,
    0xfb81c092, 0x00020000, 0xc0843a72, 0xf7393675,
    0x000002b8, 0x2e870f00, 0x85000000, 0x1d840fc9,
    0x03000000, 0x00b80c5d, 0x29000200, 0x90f631c3,
    0x6433048d, 0x0489008b, 0x04c68332, 0xf072ce39,
    0x05ebc031, 0x000002b8, 0x5b5f5e00, 0x9090c35d,
    0x53e58955, 0x4d8b5657, 0x0c7d8b14, 0x01085d8b,
    0xc60773cf, 0x00294005, 0xfb830100, 0x0002b80f,
    0x75770000, 0x8510558b, 0xbe6e74d2, 0x00020000,
    0x100000b8, 0x8bf029ff, 0x29849d34, 0xc6010000,
    0x03368b64, 0x29449d04, 0x8b640000, 0x0fde2918,
    0xfb81c092, 0x00020000, 0xc0843a72, 0xf7393675,
    0x000002b8, 0x2e870f00, 0x85000000, 0x1d840fc9,
    0x03000000, 0x00b80c5d, 0x29000200, 0x90f631c3,
    0x8d32048b, 0x8964333c, 0x04c68307, 0xf072ce39,
    0x05ebc031, 0x000002b8, 0x5b5f5e00, 0x9090c35d,
    0x53e58955, 0x4d8b5657, 0x08458b14, 0x8b0c758b,
    0x29448514, 0x00bf0000, 0x29000200, 0x00c281fa,
    0x64ff1000, 0xfa893a8b, 0x920ff201, 0x72ce01c3,
    0x74db8404, 0x4005c607, 0x01000029, 0x8485048b,
    0xbb000029, 0x00020000, 0x0005d829, 0x64ff1000,
    0xfb29188b, 0x000002b8, 0x394a7200, 0x8b4677de,
    0x090f1045, 0x020000be, 0xd300bf00, 0xf729ffe0,
    0xba178964, 0xffe0d308, 0x8964f229, 0xd310b802,
    0xf029ffe0, 0xb8088964, 0xffe0d064, 0xc764f029,
    0x01800400, 0xd314b800, 0xf029ffe0, 0x0100c764,
    0x31000000, 0x5b5f5ec0, 0x9090c35d, 0x90909090,
    0x53e58955, 0x4d8b5657, 0x08458b14, 0x8b0c758b,
    0x29448514, 0x00bf0000, 0x29000200, 0x00c281fa,
    0x64ff1000, 0xfa893a8b, 0x920ff201, 0x72ce01c3,
    0x74db8404, 0x4005c607, 0x01000029, 0x8485048b,
    0xbb000029, 0x00020000, 0x0005d829, 0x64ff1000,
    0xfb29188b, 0x000002b8, 0x394a7200, 0x8b4677de,
    0x090f1045, 0x020000be, 0xd300bf00, 0xf729ffe0,
    0xba178964, 0xffe0d308, 0x8964f229, 0xd310b802,
    0xf029ffe0, 0xb8088964, 0xffe0d064, 0xc764f029,
    0x01800400, 0xd314b800, 0xf029ffe0, 0x0300c764,
    0x31000000, 0x5b5f5ec0, 0xccccc35d, 0xcccccccc,
    0x8be58955, 0xc0830845, 0xc0e08304, 0x5d40c083,
    0x909090c3, 0x90909090, 0x90909090, 0x90909090,
    0xb8e58955, 0x00020000, 0xe0d000b9, 0x64c129ff,
    0x450b018b, 0x01896408, 0x9090c35d, 0x90909090,
    0xb8e58955, 0x00020000, 0xe0d000b9, 0x64c129ff,
    0xff25018b, 0x6400ffff, 0xc35d0189, 0x90909090,
    0x56e58955, 0x8b08558b, 0x4ab60f32, 0xc1c88908,
    0x048a03e8, 0xfecc8806, 0x086288c4, 0x7508fc80,
    0x0842c607, 0x32894600, 0xe180d1f6, 0x24e8d207,
    0xc35d5e01, 0x90909090, 0x90909090, 0x90909090,
    0x53e58955, 0xf608458b, 0x74010c45, 0xb1108b10,
    0x08482a07, 0x000001bb, 0x08e3d300, 0x08488a1a,
    0x4888c1fe, 0x08f98008, 0x088b3975, 0x502bca89,
    0x02fa8304, 0x7980207c, 0x1a7500fe, 0x00ff7980,
    0x118a1475, 0x7703fa80, 0x0151880d, 0x01c6088b,
    0x41088b03, 0x518d0889, 0xc6108901, 0xc6000141,
    0x5b000840, 0x9090c35d, 0x90909090, 0x90909090,
    0x53e58955, 0x458b5657, 0x0fc08510, 0x0000a984,
    0x0c558b00, 0xe908758b, 0x00000018, 0x90909090,
    0x8901798d, 0x0141c63a, 0x0842c600, 0x840f4800,
    0x00000086, 0xb60f3e8b, 0xcb89084e, 0x0f03ebc1,
    0x881f1cb6, 0x88c7fecf, 0xff80087e, 0xc6077508,
    0x47000846, 0xd1f63e89, 0x0f07e180, 0xb60ffbb6,
    0xcfa30fc9, 0x3a8b1073, 0x4a2a07b1, 0x0001bb08,
    0xe3d30000, 0xb60f1f08, 0xc1fe084a, 0x80084a88,
    0xa97508f9, 0xcf890a8b, 0x83047a2b, 0x907c02ff,
    0x00fe7980, 0x79808a75, 0x847500ff, 0x8019b60f,
    0x870f03fb, 0xffffff78, 0x8b015988, 0x0301c60a,
    0x89410a8b, 0xff66e90a, 0x5f5effff, 0x90c35d5b,
    0x53e58955, 0x458b5657, 0x880f4810, 0x00000072,
    0x8b0c558b, 0x15e90875, 0x90000000, 0x90909090,
    0x8901798d, 0x0141c63e, 0x0846c600, 0x52784800,
    0x73c2a30f, 0xb13e8b10, 0x084e2a07, 0x000001bb,
    0x08e3d300, 0x4eb60f1f, 0x88c1fe08, 0xf980084e,
    0x8bda7508, 0x2bcf890e, 0xff83047e, 0x80c17c02,
    0x7500fe79, 0xff7980bb, 0x0fb57500, 0xfb8019b6,
    0x88ad7703, 0x0e8b0159, 0x8b0301c6, 0x0e89410e,
    0x5f5e9eeb, 0x90c35d5b, 0x90909090, 0x90909090,
    0x53e58955, 0xec835657, 0x087d8b08, 0x420c558b,
    0xffffffb9, 0xb91c747f, 0xffffffff, 0x9090d089,
    0x8541f8d1, 0x81f975c0, 0xffffffe1, 0xf4840f7f,
    0x89000000, 0xffbef055, 0xd3ffffff, 0xec4d89e6,
    0xe901598d, 0x0000001c, 0x90909090, 0x90909090,
    0x8901418d, 0x0141c607, 0x0847c600, 0x4bd23100,
    0x527edb85, 0x7501fb83, 0xb1178b10, 0x084f2a07,
    0x000001b8, 0x08e0d300, 0x57b60f02, 0x88c2fe08,
    0xfa800857, 0x8bd87508, 0x2bc8890f, 0xf8830447,
    0x80bd7c02, 0x7500fe79, 0xff7980b7, 0x0fb17500,
    0xfa8011b6, 0x88a97703, 0x078b0151, 0x8b0300c6,
    0x0f89410f, 0x75039aeb, 0xec5d8bf0, 0x9017eb4b,
    0x8901418d, 0x0141c607, 0x0847c600, 0x4bd23100,
    0x00a6880f, 0xa30f0000, 0x8b1373de, 0x2807b107,
    0x0001bad1, 0xe2d30000, 0xb60f1008, 0xc2fe0857,
    0x80085788, 0xd77508fa, 0xc8890f8b, 0x8304472b,
    0xbc7c02f8, 0x00fe7980, 0x7980b675, 0xb07500ff,
    0x8011b60f, 0xa87703fa, 0x8b015188, 0x0300c607,
    0x89410f8b, 0x8b99eb0f, 0x2a07b107, 0x01ba084f,
    0xd3000000, 0x8a1008e2, 0xc0fe0847, 0x3c084788,
    0x8b397508, 0x2bc18907, 0xf983044f, 0x80207c02,
    0x7500fe78, 0xff78801a, 0x8a147500, 0x03f98008,
    0x48880d77, 0xc6078b01, 0x078b0300, 0x8d078940,
    0x0f890148, 0x000140c6, 0x000847c6, 0x5e08c483,
    0xc35d5b5f, 0x24548b56, 0x24448b14, 0xc1d18910,
    0xc8311ff9, 0xc829ca31, 0x5489ca19, 0x44891424,
    0xce891024, 0x0c24548b, 0x0824448b, 0xf9c1d189,
    0x31c8311f, 0x19c829ca, 0x245489ca, 0x2444890c,
    0x53ce3108, 0x18245c8b, 0x0fcbbd0f, 0x00008f84,
    0x24448b00, 0xd1e8d314, 0xd3d1f7e8, 0x8bc309e3,
    0x8b102454, 0x390c2444, 0xf73773da, 0xd1f757f3,
    0xe8d3e8d1, 0x64f7c789, 0x5c8b1824, 0x4c8b1024,
    0xc3291424, 0x448bd119, 0xaf0f1c24, 0x83c129c7,
    0xd23100df, 0xf001f889, 0xf031f211, 0x5b5ff231,
    0xda29c35e, 0xf757f3f7, 0x0de8d1d1, 0x80000000,
    0xc789e8d3, 0x182464f7, 0x10245c8b, 0x14244c8b,
    0xd119c329, 0x1c24448b, 0x29c7af0f, 0x00df83c1,
    0xf889d231, 0xf211f001, 0xf231f031, 0xc35e5b5f,
    0x1024448b, 0x14244c8b, 0xf1f7d231, 0x448bc389,
    0xf1f70c24, 0xf001da89, 0xf031f211, 0x5e5bf231,
    0xccccccc3, 0x245c8b53, 0xcbbd0f14, 0x448b7d74,
    0xe8d31024, 0xd1f7e8d1, 0xc309e3d3, 0x0c24548b,
    0x0824448b, 0x2e73da39, 0xf757f3f7, 0xd3e8d1d1,
    0xf7c789e8, 0x8b142464, 0x8b0c245c, 0x2910244c,
    0x8bd119c3, 0x0f182444, 0xc129c7af, 0x3100df83,
    0x5ff889d2, 0xda29c35b, 0xf757f3f7, 0x0de8d1d1,
    0x80000000, 0xc789e8d3, 0x142464f7, 0x0c245c8b,
    0x10244c8b, 0xd119c329, 0x1824448b, 0x29c7af0f,
    0x00df83c1, 0xf889d231, 0x8bc35b5f, 0x8b0c2444,
    0x3110244c, 0x89f1f7d2, 0x24448bc3, 0x89f1f708,
    0xccc35bda, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0x00080095, 0x00008e00, 0x0008009f, 0x00008e00,
    0x000800a9, 0x00008e00, 0x000800b3, 0x00008e00,
    0x000800bd, 0x00008e00, 0x000800c7, 0x00008e00,
    0x000800d1, 0x00008e00, 0x000800db, 0x00008e00,
    0x000800e5, 0x00008e00, 0x000800ed, 0x00008e00,
    0x000800f7, 0x00008e00, 0x000800ff, 0x00008e00,
    0x00080107, 0x00008e00, 0x0008010f, 0x00008e00,
    0x00080117, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080129, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x000801b1, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x000801a0, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x000801bf, 0x00008e00,
    0x00000250, 0x00000260, 0x00000280, 0x00000270,
    0x00000290, 0x000002a0, 0x000002b0, 0x000002c0,
    0x000002d0, 0x000002e0, 0x000002f0, 0x00000300,
    0x00000310, 0x00000320, 0x00000330, 0x00000080,
    0x00000350, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000000, 0x00000004, 0x0000000c, 0x00000014,
    0x0000001c, 0x00000024, 0x0000002c, 0x00000034,
    0x0000003c, 0x00000044, 0x0000004c, 0x00000054,
    0x0000005c, 0x00000064, 0x0000006c, 0x00000074,
    0x0000007c, 0x00000000, 0x00000008, 0x00000010,
    0x00000018, 0x00000020, 0x00000028, 0x00000030,
    0x00000038, 0x00000040, 0x00000048, 0x00000050,
    0x00000058, 0x00000060, 0x00000068, 0x00000070,
    0x00000078, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
};
