/* foundry-forge-query.h
 *
 * Copyright 2025 Christian Hergert
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include <glib-object.h>

#include "foundry-types.h"
#include "foundry-version-macros.h"

G_BEGIN_DECLS

#define FOUNDRY_TYPE_FORGE_QUERY (foundry_forge_query_get_type())

FOUNDRY_AVAILABLE_IN_1_1
G_DECLARE_DERIVABLE_TYPE (FoundryForgeQuery, foundry_forge_query, FOUNDRY, FORGE_QUERY, GObject)

struct _FoundryForgeQueryClass
{
  GObjectClass parent_class;

  /*< private >*/
  gpointer _reserved[15];
};

FOUNDRY_AVAILABLE_IN_1_1
FoundryForgeQuery *foundry_forge_query_new                     (void);
FOUNDRY_AVAILABLE_IN_1_1
char              *foundry_forge_query_dup_state               (FoundryForgeQuery *self);
FOUNDRY_AVAILABLE_IN_1_1
void               foundry_forge_query_set_state               (FoundryForgeQuery *self,
                                                                const char        *state);
FOUNDRY_AVAILABLE_IN_1_1
gboolean           foundry_forge_query_contains_state          (FoundryForgeQuery *self,
                                                                const char        *state);
FOUNDRY_AVAILABLE_IN_1_1
char              *foundry_forge_query_dup_keywords_scope      (FoundryForgeQuery *self);
FOUNDRY_AVAILABLE_IN_1_1
void               foundry_forge_query_set_keywords_scope      (FoundryForgeQuery *self,
                                                                const char        *keywords_scope);
FOUNDRY_AVAILABLE_IN_1_1
gboolean           foundry_forge_query_contains_keywords_scope (FoundryForgeQuery *self,
                                                                const char        *keywords_scope);
FOUNDRY_AVAILABLE_IN_1_1
char              *foundry_forge_query_dup_keywords            (FoundryForgeQuery *self);
FOUNDRY_AVAILABLE_IN_1_1
void               foundry_forge_query_set_keywords            (FoundryForgeQuery *self,
                                                                const char        *keywords);

G_END_DECLS
