#! /bin/bash

ProgName=$1

if [ "x${ProgName}" != "xMineXpert3" ]; then
	if [ "x${ProgName}" != "xMassXpert3" ]; then
		echo "ProgName was ${ProgName}"
		echo "unique argument must be either MassXpert3 or MineXpert3."
		exit 1
	fi
fi

if [ ! -d "16x16" ]; then
	echo "Please change directory to 'development/images/icons/' for the project."
	exit 1
fi

for res in 16x16 32x32 48x48 64x64 128x128 256x256 512x512
do
	command="mkdir -p ${res}"
	#printf "Running: ${command} \n"
	eval ${command}
	command="rsvg-convert svg/${ProgName}.svg -f png -w $(echo ${res} | cut -d x -f1) -o ${res}/${ProgName}.png"
	printf "Running: ${command}\n"
	eval ${command}
	#rsvg-convert svg/${ProgName}.svg -f png -w $(echo ${res} | cut -d x -f1) -o ${res}/${ProgName}.png
done
