/* $Cambridge: hermes/src/prayer/servers/prayer.h,v 1.4 2008/10/02 07:01:56 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

/* Global state for Prayer frontend processes */

struct prayer_http_port {
    struct prayer_port *next;   /* Linked list */
    char *name;                 /* NIL */
    unsigned long port;         /* Port number */
    int sockfd;                 /* Socket descriptor bound to this port */
    BOOL use_ssl;               /* T => connections to this port will use SSL */
};

struct prayer {
    struct pool *pool;          /* Allocation pool */
    struct config *config;      /* Prayer configuration */
    struct request *request;    /* Current HTTP request to process */
    struct log *accesslog;
    struct list *http_port_list;        /* Port list */
    int select_lock_fd;         /* Prevents concurrent select() */
    /* Details about current connection */
    struct ipaddr *ipaddr;      /* IP address of peer */
    unsigned long port;         /* Port of active request    */
    BOOL use_ssl;               /* Current requests uses SSL */
    BOOL is_session;            /* _last_ request was for session URL */
    struct template_vals *template_vals; /* Filled in for each new template */
};

struct prayer *prayer_create(struct config *config);

void prayer_free(struct prayer *prayer);

char *prayer_url_prefix(struct prayer *prayer, struct pool *tpool);

void
prayer_template_setup(struct prayer *prayer);

BOOL prayer_log_open(struct prayer *prayer);

BOOL prayer_log_ping(struct prayer *prayer);

BOOL prayer_lock_open(struct prayer *prayer);

BOOL
prayer_http_port_open(struct prayer *prayer,
                      unsigned long port, BOOL use_ssl, char *interface);

BOOL prayer_http_port_close(struct prayer *prayer);

BOOL
prayer_http_port_alloc(struct prayer *prayer,
                       unsigned long port, BOOL use_ssl, int sockfd);

void prayer_accesslog(struct prayer *prayer, struct request *request);

void prayer_connection_log(struct prayer *prayer, char *fmt, ...);

void prayer_paniclog(struct prayer *prayer, char *fmt, ...);

void prayer_fatal(struct prayer *prayer, char *fmt, ...);
