% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-month-weekday.R
\name{year_month_weekday}
\alias{year_month_weekday}
\title{Calendar: year-month-weekday}
\usage{
year_month_weekday(
  year,
  month = NULL,
  day = NULL,
  index = NULL,
  hour = NULL,
  minute = NULL,
  second = NULL,
  subsecond = NULL,
  ...,
  subsecond_precision = NULL
)
}
\arguments{
\item{year}{\verb{[integer]}

The year. Values \verb{[-32767, 32767]} are generally allowed.}

\item{month}{\verb{[integer / NULL]}

The month. Values \verb{[1, 12]} are allowed.}

\item{day}{\verb{[integer / NULL]}

The weekday of the month. Values \verb{[1, 7]} are allowed, where \code{1} is
Sunday and \code{7} is Saturday.}

\item{index}{\verb{[integer / "last" / NULL]}

The index specifying that \code{day} is the n-th weekday of the month.
Values \verb{[1, 5]} are allowed.

If \code{"last"}, then the last instance of \code{day} in the current month
is returned.}

\item{hour}{\verb{[integer / NULL]}

The hour. Values \verb{[0, 23]} are allowed.}

\item{minute}{\verb{[integer / NULL]}

The minute. Values \verb{[0, 59]} are allowed.}

\item{second}{\verb{[integer / NULL]}

The second. Values \verb{[0, 59]} are allowed.}

\item{subsecond}{\verb{[integer / NULL]}

The subsecond. If specified, \code{subsecond_precision} must also be specified
to determine how to interpret the \code{subsecond}.

If using milliseconds, values \verb{[0, 999]} are allowed.

If using microseconds, values \verb{[0, 999999]} are allowed.

If using nanoseconds, values \verb{[0, 999999999]} are allowed.}

\item{...}{These dots are for future extensions and must be empty.}

\item{subsecond_precision}{\verb{[character(1) / NULL]}

The precision to interpret \code{subsecond} as. One of: \code{"millisecond"},
\code{"microsecond"}, or \code{"nanosecond"}.}
}
\value{
A year-month-weekday calendar vector.
}
\description{
\code{year_month_weekday()} constructs a calendar vector from the Gregorian
year, month, weekday, and index specifying that this is the n-th weekday
of the month.
}
\details{
Fields are recycled against each other using
\link[vctrs:theory-faq-recycling]{tidyverse recycling rules}.

Fields are collected in order until the first \code{NULL} field is located. No
fields after the first \code{NULL} field are used.
}
\examples{
# All Fridays in January, 2019
# Note that there was no 5th Friday in January
x <- year_month_weekday(
  2019,
  clock_months$january,
  clock_weekdays$friday,
  1:5
)
x

invalid_detect(x)

# Resolve this invalid date by using the previous valid date
invalid_resolve(x, invalid = "previous")
}
