/**
 * HTML export.
 *
 * Wraps a StrBuf, and automatically escapes HTML characters as necessary.
 */
class Html {
	// Output buffer.
	private StrBuf out;

	// Characters we need to escape.
	private Char->Str escape;

	// Indentation level.
	private Nat indentLevel;

	// Create.
	init() {
		init { indentLevel = 0; }

		// For text:
		escape.put('&', "&amp;");
		escape.put('<', "&lt;");
		escape.put('>', "&gt;");
		// Inside string attributes:
		escape.put('"', "&quot;");
		escape.put('\'', "&#39;");
	}

	// To string.
	Str toS() {
		out.toS;
	}

	// Indent output.
	void indent() {
		indentLevel++;
		out.indent();
	}

	void dedent() {
		if (indentLevel > 0)
			indentLevel--;
		out.dedent();
	}

	// Temporarily set indent to 0.
	void pauseIndent() {
		for (Nat i = 0; i < indentLevel; i++)
			out.dedent();
	}

	// Restore indentation.
	void restoreIndent() {
		for (Nat i = 0; i < indentLevel; i++)
			out.indent();
	}

	// Append text. Escapes HTML characters.
	Html text(Str text) {
		for (ch in text) {
			if (replace = escape.at(ch))
				out << replace;
			else
				out << ch;
		}
		this;
	}

	// Append plain HTML. No escapes.
	Html html(Str html) {
		out << html;
		this;
	}
}
