.\" @(#)$RCSfile: gfal_write.man,v $ $Revision: 1.1.1.1 $ $Date: 2003/11/19 12:56:29 $ CERN Jean-Philippe Baud
.\" Copyright (C) 2003 by CERN
.\" All rights reserved
.\"
.TH GFAL_WRITE 3 "$Date: 2003/11/19 12:56:29 $" GFAL "Library Functions"
.SH NAME
gfal_write \- write to a file
.SH SYNOPSIS
\fB#include "gfal_api.h"\fR
.sp
.BI "int gfal_write (int" fd ,
.BI "void *" buf ,
.BI "size_t " size );
.SH DESCRIPTION
.B gfal_write
writes
.I size
bytes from the buffer pointed by
.I buf
to the file descriptor
.IR fd .
.SH RETURN VALUE
This routine returns the number of bytes actually written if the operation was
successful or -1 if the operation failed. In the latter case,
.B errno
is set appropriately.
.SH ERRORS
.TP 1.3i
.B EBADF
.I fd
is not a valid file descriptor.
.TP
.B ENOSPC
No space left on device.
.TP
.B ECOMM
Communication error.
.TP
.B EPROTONOSUPPORT
Access method not supported.
.SH SEE ALSO
.B gfal(3)
