SetFactory("OpenCASCADE");

Block(1) = {0,5,5, 100,40,90};

// splitting plane
Point(9) = {18.933866024017334,5.0,5.0};
Point(10) = {60.122737884521484,5.0,95.0};
Point(11) = {18.933866024017334,45.0,5.0};
Point(12) = {60.122737884521484,45.0,95.0};
Line(13) = {11, 9};
Line(14) = {11, 12};
Line(15) = {12, 10};
Line(16) = {10, 9};
Curve Loop(9) = {13, 14, 15, 16};
Plane Surface(9) = {9};

// 2nd splitting plane
Point(109) = {23.933866024017334,5.0,5.0};
Point(110) = {81.122737884521484,5.0,95.0};
Point(111) = {23.933866024017334,45.0,5.0};
Point(112) = {81.122737884521484,45.0,95.0};
Line(113) = {111, 109};
Line(114) = {111, 112};
Line(115) = {112, 110};
Line(116) = {110, 109};
Curve Loop(109) = {113, 114, 115, 116};
Plane Surface(109) = {109};

// points to embed
Point(13) = {5.0,5.0,70.00040531158447};
Point(14) = {5.0,15.0,70.00040531158447};
Point(15) = {15.0,5.0,70.00017166137695};
Point(16) = {15.0,15.0,70.00020027160645};
Point(17) = {5.0,25.0,70.00040054321289};
Point(18) = {15.0,25.0,70.00021934509277};
Point(19) = {5.0,35.0,70.00039577484131};
Point(20) = {15.0,35.0,70.00024318695068};
Point(21) = {5.0,45.0,70.00040054321289};
Point(22) = {15.0,45.0,70.00026226043701};
Point(23) = {25.0,5.0,69.99989032745361};
Point(24) = {25.0,15.0,69.9999475479126};
Point(25) = {25.0,25.0,70.00000953674316};
Point(26) = {25.0,35.0,70.00005722045898};
Point(27) = {25.0,45.0,70.00010967254639};
Point(28) = {35.0,5.0,69.99966144561768};
Point(29) = {35.0,15.0,69.9997329711914};
Point(30) = {35.0,25.0,69.99980926513672};
Point(31) = {35.0,35.0,69.99988079071045};
Point(32) = {35.0,45.0,69.99995708465576};
Point(33) = {45.0,5.0,40.000243186950684};
Point(34) = {45.0,15.0,40.00028133392334};
Point(35) = {45.0,5.0,69.99949932098389};
Point(36) = {45.0,15.0,69.99956607818604};
Point(37) = {45.0,25.0,40.000314712524414};
Point(38) = {45.0,25.0,69.99964714050293};
Point(39) = {45.0,35.0,40.00034809112549};
Point(40) = {45.0,35.0,69.9997329711914};
Point(41) = {45.0,45.0,40.000386238098145};
Point(42) = {45.0,45.0,69.99981880187988};
Point(43) = {55.0,5.0,40.000128746032715};
Point(44) = {55.0,15.0,40.00017166137695};
Point(45) = {55.0,25.0,40.00021457672119};
Point(46) = {55.0,35.0,40.00026226043701};
Point(47) = {55.0,45.0,40.00030994415283};
Point(48) = {65.0,5.0,40.0000524520874};
Point(49) = {65.0,15.0,40.00010013580322};
Point(50) = {65.0,25.0,40.00014781951904};
Point(51) = {65.0,35.0,40.000200271606445};
Point(52) = {65.0,45.0,40.000243186950684};
Point(53) = {75.0,5.0,40.000014305114746};
Point(54) = {75.0,15.0,40.000057220458984};
Point(55) = {75.0,25.0,40.00010013580322};
Point(56) = {75.0,35.0,40.000152587890625};
Point(57) = {75.0,45.0,40.000200271606445};
Point(58) = {85.0,5.0,40.000009536743164};
Point(59) = {85.0,15.0,40.00004291534424};
Point(60) = {85.0,25.0,40.00008583068848};
Point(61) = {85.0,35.0,40.000128746032715};
Point(62) = {85.0,45.0,40.00016689300537};
Point(63) = {95.0,5.0,40.000014305114746};
Point(64) = {95.0,15.0,40.00004768371582};
Point(65) = {95.0,25.0,40.000081062316895};
Point(66) = {95.0,35.0,40.00011444091797};
Point(67) = {95.0,45.0,40.00014781951904};

// fragment all entities: this will create 3 volumes (split by the 2 planes) and
// embed the points in the surfaces or the volumes
BooleanFragments{ Point{13:67}; Surface{9,109}; Delete; }{ Volume{1}; Delete; }

// size field related to distance to these points
Field[1] = Distance;
Field[1].NodesList = {13:67};

// set mesh size to LcMin if dist<DistMin and LcMax if dist>DistMax
Field[2] = Threshold;
Field[2].IField = 1;
Field[2].LcMin = 1;
Field[2].LcMax = 8;
Field[2].DistMin = 8;
Field[2].DistMax = 12;
Background Field = 2;

Mesh.CharacteristicLengthExtendFromBoundary = 0;
Mesh.CharacteristicLengthFromPoints = 0;

Mesh.Algorithm = 5; // 2D delaunay
//Mesh.Algorithm3D = 10; // 3D hxt - experimental
