#!/usr/bin/perl

use strict;
use warnings;
use FindBin;
use lib "$FindBin::Bin/../lib";

print "=== Version Synchronization Demo ===\n\n";

# Load modules
use Crypt::TimestampedData;
use Crypt::TSD;

print "1. After loading both modules:\n";
print "   Crypt::TimestampedData version: " . ($Crypt::TimestampedData::VERSION || 'undef') . "\n";
print "   Crypt::TSD version: " . ($Crypt::TSD::VERSION || 'undef') . "\n";

# Check if versions are synchronized
if (defined $Crypt::TimestampedData::VERSION && defined $Crypt::TSD::VERSION) {
    if ($Crypt::TimestampedData::VERSION eq $Crypt::TSD::VERSION) {
        print "   ✓ Versions are synchronized!\n";
    } else {
        print "   ✗ Versions don't match!\n";
    }
} else {
    print "   ℹ Versions undefined during development (normal)\n";
}

print "\n2. Testing different loading order:\n";

# Clear modules and reload in different order
delete $INC{'Crypt/TimestampedData.pm'};
delete $INC{'Crypt/TSD.pm'};

use Crypt::TSD;
use Crypt::TimestampedData;

print "   After loading Crypt::TSD first, then Crypt::TimestampedData:\n";
print "   Crypt::TimestampedData version: " . ($Crypt::TimestampedData::VERSION || 'undef') . "\n";
print "   Crypt::TSD version: " . ($Crypt::TSD::VERSION || 'undef') . "\n";

if (defined $Crypt::TimestampedData::VERSION && defined $Crypt::TSD::VERSION) {
    if ($Crypt::TimestampedData::VERSION eq $Crypt::TSD::VERSION) {
        print "   ✓ Versions are still synchronized!\n";
    } else {
        print "   ✗ Versions don't match!\n";
    }
} else {
    print "   ℹ Versions undefined during development (normal)\n";
}

print "\n3. How it works:\n";
print "   - Both modules start with VERSION = '0.01'\n";
print "   - After both are loaded, Crypt::TSD checks if Crypt::TimestampedData::VERSION is defined\n";
print "   - If yes, it updates its own VERSION to match\n";
print "   - This ensures they stay synchronized automatically\n";

print "\n4. Benefits:\n";
print "   - No need to manually update versions in both files\n";
print "   - Automatic synchronization when modules are loaded\n";
print "   - Works regardless of loading order\n";
print "   - PkgVersion plugin handles the initial version setting\n";

print "\n=== Demo Complete ===\n";
