// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package codecommit provides a client for AWS CodeCommit.
package codecommit

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchGetRepositories = "BatchGetRepositories"

// BatchGetRepositoriesRequest generates a request for the BatchGetRepositories operation.
func (c *CodeCommit) BatchGetRepositoriesRequest(input *BatchGetRepositoriesInput) (req *request.Request, output *BatchGetRepositoriesOutput) {
	op := &request.Operation{
		Name:       opBatchGetRepositories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetRepositoriesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &BatchGetRepositoriesOutput{}
	req.Data = output
	return
}

// Returns information about one or more repositories.
//
// The description field for a repository accepts all HTML characters and all
// valid Unicode characters. Applications that do not HTML-encode the description
// and display it in a web page could expose users to potentially malicious
// code. Make sure that you HTML-encode the description field in any application
// that uses this API to display the repository description on a web page.
func (c *CodeCommit) BatchGetRepositories(input *BatchGetRepositoriesInput) (*BatchGetRepositoriesOutput, error) {
	req, out := c.BatchGetRepositoriesRequest(input)
	err := req.Send()
	return out, err
}

const opCreateBranch = "CreateBranch"

// CreateBranchRequest generates a request for the CreateBranch operation.
func (c *CodeCommit) CreateBranchRequest(input *CreateBranchInput) (req *request.Request, output *CreateBranchOutput) {
	op := &request.Operation{
		Name:       opCreateBranch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBranchInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &CreateBranchOutput{}
	req.Data = output
	return
}

// Creates a new branch in a repository and points the branch to a commit.
//
// Calling the create branch operation does not set a repository's default
// branch. To do this, call the update default branch operation.
func (c *CodeCommit) CreateBranch(input *CreateBranchInput) (*CreateBranchOutput, error) {
	req, out := c.CreateBranchRequest(input)
	err := req.Send()
	return out, err
}

const opCreateRepository = "CreateRepository"

// CreateRepositoryRequest generates a request for the CreateRepository operation.
func (c *CodeCommit) CreateRepositoryRequest(input *CreateRepositoryInput) (req *request.Request, output *CreateRepositoryOutput) {
	op := &request.Operation{
		Name:       opCreateRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRepositoryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateRepositoryOutput{}
	req.Data = output
	return
}

// Creates a new, empty repository.
func (c *CodeCommit) CreateRepository(input *CreateRepositoryInput) (*CreateRepositoryOutput, error) {
	req, out := c.CreateRepositoryRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteRepository = "DeleteRepository"

// DeleteRepositoryRequest generates a request for the DeleteRepository operation.
func (c *CodeCommit) DeleteRepositoryRequest(input *DeleteRepositoryInput) (req *request.Request, output *DeleteRepositoryOutput) {
	op := &request.Operation{
		Name:       opDeleteRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRepositoryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteRepositoryOutput{}
	req.Data = output
	return
}

// Deletes a repository. If a specified repository was already deleted, a null
// repository ID will be returned.
//
// Deleting a repository also deletes all associated objects and metadata.
// After a repository is deleted, all future push calls to the deleted repository
// will fail.
func (c *CodeCommit) DeleteRepository(input *DeleteRepositoryInput) (*DeleteRepositoryOutput, error) {
	req, out := c.DeleteRepositoryRequest(input)
	err := req.Send()
	return out, err
}

const opGetBranch = "GetBranch"

// GetBranchRequest generates a request for the GetBranch operation.
func (c *CodeCommit) GetBranchRequest(input *GetBranchInput) (req *request.Request, output *GetBranchOutput) {
	op := &request.Operation{
		Name:       opGetBranch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBranchInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBranchOutput{}
	req.Data = output
	return
}

// Returns information about a repository branch, including its name and the
// last commit ID.
func (c *CodeCommit) GetBranch(input *GetBranchInput) (*GetBranchOutput, error) {
	req, out := c.GetBranchRequest(input)
	err := req.Send()
	return out, err
}

const opGetCommit = "GetCommit"

// GetCommitRequest generates a request for the GetCommit operation.
func (c *CodeCommit) GetCommitRequest(input *GetCommitInput) (req *request.Request, output *GetCommitOutput) {
	op := &request.Operation{
		Name:       opGetCommit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCommitInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetCommitOutput{}
	req.Data = output
	return
}

// Returns information about a commit, including commit message and committer
// information.
func (c *CodeCommit) GetCommit(input *GetCommitInput) (*GetCommitOutput, error) {
	req, out := c.GetCommitRequest(input)
	err := req.Send()
	return out, err
}

const opGetRepository = "GetRepository"

// GetRepositoryRequest generates a request for the GetRepository operation.
func (c *CodeCommit) GetRepositoryRequest(input *GetRepositoryInput) (req *request.Request, output *GetRepositoryOutput) {
	op := &request.Operation{
		Name:       opGetRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRepositoryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetRepositoryOutput{}
	req.Data = output
	return
}

// Returns information about a repository.
//
// The description field for a repository accepts all HTML characters and all
// valid Unicode characters. Applications that do not HTML-encode the description
// and display it in a web page could expose users to potentially malicious
// code. Make sure that you HTML-encode the description field in any application
// that uses this API to display the repository description on a web page.
func (c *CodeCommit) GetRepository(input *GetRepositoryInput) (*GetRepositoryOutput, error) {
	req, out := c.GetRepositoryRequest(input)
	err := req.Send()
	return out, err
}

const opGetRepositoryTriggers = "GetRepositoryTriggers"

// GetRepositoryTriggersRequest generates a request for the GetRepositoryTriggers operation.
func (c *CodeCommit) GetRepositoryTriggersRequest(input *GetRepositoryTriggersInput) (req *request.Request, output *GetRepositoryTriggersOutput) {
	op := &request.Operation{
		Name:       opGetRepositoryTriggers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRepositoryTriggersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetRepositoryTriggersOutput{}
	req.Data = output
	return
}

// Gets information about triggers configured for a repository.
func (c *CodeCommit) GetRepositoryTriggers(input *GetRepositoryTriggersInput) (*GetRepositoryTriggersOutput, error) {
	req, out := c.GetRepositoryTriggersRequest(input)
	err := req.Send()
	return out, err
}

const opListBranches = "ListBranches"

// ListBranchesRequest generates a request for the ListBranches operation.
func (c *CodeCommit) ListBranchesRequest(input *ListBranchesInput) (req *request.Request, output *ListBranchesOutput) {
	op := &request.Operation{
		Name:       opListBranches,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBranchesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListBranchesOutput{}
	req.Data = output
	return
}

// Gets information about one or more branches in a repository.
func (c *CodeCommit) ListBranches(input *ListBranchesInput) (*ListBranchesOutput, error) {
	req, out := c.ListBranchesRequest(input)
	err := req.Send()
	return out, err
}

func (c *CodeCommit) ListBranchesPages(input *ListBranchesInput, fn func(p *ListBranchesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListBranchesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListBranchesOutput), lastPage)
	})
}

const opListRepositories = "ListRepositories"

// ListRepositoriesRequest generates a request for the ListRepositories operation.
func (c *CodeCommit) ListRepositoriesRequest(input *ListRepositoriesInput) (req *request.Request, output *ListRepositoriesOutput) {
	op := &request.Operation{
		Name:       opListRepositories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRepositoriesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListRepositoriesOutput{}
	req.Data = output
	return
}

// Gets information about one or more repositories.
func (c *CodeCommit) ListRepositories(input *ListRepositoriesInput) (*ListRepositoriesOutput, error) {
	req, out := c.ListRepositoriesRequest(input)
	err := req.Send()
	return out, err
}

func (c *CodeCommit) ListRepositoriesPages(input *ListRepositoriesInput, fn func(p *ListRepositoriesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListRepositoriesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListRepositoriesOutput), lastPage)
	})
}

const opPutRepositoryTriggers = "PutRepositoryTriggers"

// PutRepositoryTriggersRequest generates a request for the PutRepositoryTriggers operation.
func (c *CodeCommit) PutRepositoryTriggersRequest(input *PutRepositoryTriggersInput) (req *request.Request, output *PutRepositoryTriggersOutput) {
	op := &request.Operation{
		Name:       opPutRepositoryTriggers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRepositoryTriggersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutRepositoryTriggersOutput{}
	req.Data = output
	return
}

// Replaces all triggers for a repository. This can be used to create or delete
// triggers.
func (c *CodeCommit) PutRepositoryTriggers(input *PutRepositoryTriggersInput) (*PutRepositoryTriggersOutput, error) {
	req, out := c.PutRepositoryTriggersRequest(input)
	err := req.Send()
	return out, err
}

const opTestRepositoryTriggers = "TestRepositoryTriggers"

// TestRepositoryTriggersRequest generates a request for the TestRepositoryTriggers operation.
func (c *CodeCommit) TestRepositoryTriggersRequest(input *TestRepositoryTriggersInput) (req *request.Request, output *TestRepositoryTriggersOutput) {
	op := &request.Operation{
		Name:       opTestRepositoryTriggers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestRepositoryTriggersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &TestRepositoryTriggersOutput{}
	req.Data = output
	return
}

// Tests the functionality of repository triggers by sending information to
// the trigger target. If real data is available in the repository, the test
// will send data from the last commit. If no data is available, sample data
// will be generated.
func (c *CodeCommit) TestRepositoryTriggers(input *TestRepositoryTriggersInput) (*TestRepositoryTriggersOutput, error) {
	req, out := c.TestRepositoryTriggersRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateDefaultBranch = "UpdateDefaultBranch"

// UpdateDefaultBranchRequest generates a request for the UpdateDefaultBranch operation.
func (c *CodeCommit) UpdateDefaultBranchRequest(input *UpdateDefaultBranchInput) (req *request.Request, output *UpdateDefaultBranchOutput) {
	op := &request.Operation{
		Name:       opUpdateDefaultBranch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDefaultBranchInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &UpdateDefaultBranchOutput{}
	req.Data = output
	return
}

// Sets or changes the default branch name for the specified repository.
//
// If you use this operation to change the default branch name to the current
// default branch name, a success message is returned even though the default
// branch did not change.
func (c *CodeCommit) UpdateDefaultBranch(input *UpdateDefaultBranchInput) (*UpdateDefaultBranchOutput, error) {
	req, out := c.UpdateDefaultBranchRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateRepositoryDescription = "UpdateRepositoryDescription"

// UpdateRepositoryDescriptionRequest generates a request for the UpdateRepositoryDescription operation.
func (c *CodeCommit) UpdateRepositoryDescriptionRequest(input *UpdateRepositoryDescriptionInput) (req *request.Request, output *UpdateRepositoryDescriptionOutput) {
	op := &request.Operation{
		Name:       opUpdateRepositoryDescription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRepositoryDescriptionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &UpdateRepositoryDescriptionOutput{}
	req.Data = output
	return
}

// Sets or changes the comment or description for a repository.
//
// The description field for a repository accepts all HTML characters and all
// valid Unicode characters. Applications that do not HTML-encode the description
// and display it in a web page could expose users to potentially malicious
// code. Make sure that you HTML-encode the description field in any application
// that uses this API to display the repository description on a web page.
func (c *CodeCommit) UpdateRepositoryDescription(input *UpdateRepositoryDescriptionInput) (*UpdateRepositoryDescriptionOutput, error) {
	req, out := c.UpdateRepositoryDescriptionRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateRepositoryName = "UpdateRepositoryName"

// UpdateRepositoryNameRequest generates a request for the UpdateRepositoryName operation.
func (c *CodeCommit) UpdateRepositoryNameRequest(input *UpdateRepositoryNameInput) (req *request.Request, output *UpdateRepositoryNameOutput) {
	op := &request.Operation{
		Name:       opUpdateRepositoryName,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRepositoryNameInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &UpdateRepositoryNameOutput{}
	req.Data = output
	return
}

// Renames a repository. The repository name must be unique across the calling
// AWS account. In addition, repository names are limited to 100 alphanumeric,
// dash, and underscore characters, and cannot include certain characters. The
// suffix ".git" is prohibited. For a full description of the limits on repository
// names, see Limits (http://docs.aws.amazon.com/codecommit/latest/userguide/limits.html)
// in the AWS CodeCommit User Guide.
func (c *CodeCommit) UpdateRepositoryName(input *UpdateRepositoryNameInput) (*UpdateRepositoryNameOutput, error) {
	req, out := c.UpdateRepositoryNameRequest(input)
	err := req.Send()
	return out, err
}

// Represents the input of a batch get repositories operation.
type BatchGetRepositoriesInput struct {
	_ struct{} `type:"structure"`

	// The names of the repositories to get information about.
	RepositoryNames []*string `locationName:"repositoryNames" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetRepositoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetRepositoriesInput) GoString() string {
	return s.String()
}

// Represents the output of a batch get repositories operation.
type BatchGetRepositoriesOutput struct {
	_ struct{} `type:"structure"`

	// A list of repositories returned by the batch get repositories operation.
	Repositories []*RepositoryMetadata `locationName:"repositories" type:"list"`

	// Returns a list of repository names for which information could not be found.
	RepositoriesNotFound []*string `locationName:"repositoriesNotFound" type:"list"`
}

// String returns the string representation
func (s BatchGetRepositoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetRepositoriesOutput) GoString() string {
	return s.String()
}

// Returns information about a branch.
type BranchInfo struct {
	_ struct{} `type:"structure"`

	// The name of the branch.
	BranchName *string `locationName:"branchName" min:"1" type:"string"`

	// The ID of the last commit made to the branch.
	CommitId *string `locationName:"commitId" type:"string"`
}

// String returns the string representation
func (s BranchInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BranchInfo) GoString() string {
	return s.String()
}

// Returns information about a specific commit.
type Commit struct {
	_ struct{} `type:"structure"`

	// Any additional data associated with the specified commit.
	AdditionalData *string `locationName:"additionalData" type:"string"`

	// Information about the author of the specified commit.
	Author *UserInfo `locationName:"author" type:"structure"`

	// Information about the person who committed the specified commit, also known
	// as the committer. For more information about the difference between an author
	// and a committer in Git, see Viewing the Commit History (http://git-scm.com/book/ch2-3.html)
	// in Pro Git by Scott Chacon and Ben Straub.
	Committer *UserInfo `locationName:"committer" type:"structure"`

	// The message associated with the specified commit.
	Message *string `locationName:"message" type:"string"`

	// The parent list for the specified commit.
	Parents []*string `locationName:"parents" type:"list"`

	// Tree information for the specified commit.
	TreeId *string `locationName:"treeId" type:"string"`
}

// String returns the string representation
func (s Commit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Commit) GoString() string {
	return s.String()
}

// Represents the input of a create branch operation.
type CreateBranchInput struct {
	_ struct{} `type:"structure"`

	// The name of the new branch to create.
	BranchName *string `locationName:"branchName" min:"1" type:"string" required:"true"`

	// The ID of the commit to point the new branch to.
	CommitId *string `locationName:"commitId" type:"string" required:"true"`

	// The name of the repository in which you want to create the new branch.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateBranchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBranchInput) GoString() string {
	return s.String()
}

type CreateBranchOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateBranchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBranchOutput) GoString() string {
	return s.String()
}

// Represents the input of a create repository operation.
type CreateRepositoryInput struct {
	_ struct{} `type:"structure"`

	// A comment or description about the new repository.
	//
	// The description field for a repository accepts all HTML characters and all
	// valid Unicode characters. Applications that do not HTML-encode the description
	// and display it in a web page could expose users to potentially malicious
	// code. Make sure that you HTML-encode the description field in any application
	// that uses this API to display the repository description on a web page.
	RepositoryDescription *string `locationName:"repositoryDescription" type:"string"`

	// The name of the new repository to be created.
	//
	// The repository name must be unique across the calling AWS account. In addition,
	// repository names are limited to 100 alphanumeric, dash, and underscore characters,
	// and cannot include certain characters. For a full description of the limits
	// on repository names, see Limits (http://docs.aws.amazon.com/codecommit/latest/userguide/limits.html)
	// in the AWS CodeCommit User Guide. The suffix ".git" is prohibited.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRepositoryInput) GoString() string {
	return s.String()
}

// Represents the output of a create repository operation.
type CreateRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the newly created repository.
	RepositoryMetadata *RepositoryMetadata `locationName:"repositoryMetadata" type:"structure"`
}

// String returns the string representation
func (s CreateRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRepositoryOutput) GoString() string {
	return s.String()
}

// Represents the input of a delete repository operation.
type DeleteRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the repository to delete.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRepositoryInput) GoString() string {
	return s.String()
}

// Represents the output of a delete repository operation.
type DeleteRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the repository that was deleted.
	RepositoryId *string `locationName:"repositoryId" type:"string"`
}

// String returns the string representation
func (s DeleteRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRepositoryOutput) GoString() string {
	return s.String()
}

// Represents the input of a get branch operation.
type GetBranchInput struct {
	_ struct{} `type:"structure"`

	// The name of the branch for which you want to retrieve information.
	BranchName *string `locationName:"branchName" min:"1" type:"string"`

	// The name of the repository that contains the branch for which you want to
	// retrieve information.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s GetBranchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBranchInput) GoString() string {
	return s.String()
}

// Represents the output of a get branch operation.
type GetBranchOutput struct {
	_ struct{} `type:"structure"`

	// The name of the branch.
	Branch *BranchInfo `locationName:"branch" type:"structure"`
}

// String returns the string representation
func (s GetBranchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBranchOutput) GoString() string {
	return s.String()
}

// Represents the input of a get commit operation.
type GetCommitInput struct {
	_ struct{} `type:"structure"`

	// The commit ID.
	CommitId *string `locationName:"commitId" type:"string" required:"true"`

	// The name of the repository to which the commit was made.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCommitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCommitInput) GoString() string {
	return s.String()
}

// Represents the output of a get commit operation.
type GetCommitOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specified commit.
	Commit *Commit `locationName:"commit" type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCommitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCommitOutput) GoString() string {
	return s.String()
}

// Represents the input of a get repository operation.
type GetRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the repository to get information about.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRepositoryInput) GoString() string {
	return s.String()
}

// Represents the output of a get repository operation.
type GetRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the repository.
	RepositoryMetadata *RepositoryMetadata `locationName:"repositoryMetadata" type:"structure"`
}

// String returns the string representation
func (s GetRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRepositoryOutput) GoString() string {
	return s.String()
}

// Represents the input of a get repository triggers operation.
type GetRepositoryTriggersInput struct {
	_ struct{} `type:"structure"`

	// The name of the repository for which the trigger is configured.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s GetRepositoryTriggersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRepositoryTriggersInput) GoString() string {
	return s.String()
}

// Represents the output of a get repository triggers operation.
type GetRepositoryTriggersOutput struct {
	_ struct{} `type:"structure"`

	// The system-generated unique ID for the trigger.
	ConfigurationId *string `locationName:"configurationId" type:"string"`

	// The JSON block of configuration information for each trigger.
	Triggers []*RepositoryTrigger `locationName:"triggers" type:"list"`
}

// String returns the string representation
func (s GetRepositoryTriggersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRepositoryTriggersOutput) GoString() string {
	return s.String()
}

// Represents the input of a list branches operation.
type ListBranchesInput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that allows the operation to batch the results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of the repository that contains the branches.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListBranchesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBranchesInput) GoString() string {
	return s.String()
}

// Represents the output of a list branches operation.
type ListBranchesOutput struct {
	_ struct{} `type:"structure"`

	// The list of branch names.
	Branches []*string `locationName:"branches" type:"list"`

	// An enumeration token that returns the batch of the results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBranchesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBranchesOutput) GoString() string {
	return s.String()
}

// Represents the input of a list repositories operation.
type ListRepositoriesInput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that allows the operation to batch the results of the
	// operation. Batch sizes are 1,000 for list repository operations. When the
	// client sends the token back to AWS CodeCommit, another page of 1,000 records
	// is retrieved.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The order in which to sort the results of a list repositories operation.
	Order *string `locationName:"order" type:"string" enum:"OrderEnum"`

	// The criteria used to sort the results of a list repositories operation.
	SortBy *string `locationName:"sortBy" type:"string" enum:"SortByEnum"`
}

// String returns the string representation
func (s ListRepositoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRepositoriesInput) GoString() string {
	return s.String()
}

// Represents the output of a list repositories operation.
type ListRepositoriesOutput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that allows the operation to batch the results of the
	// operation. Batch sizes are 1,000 for list repository operations. When the
	// client sends the token back to AWS CodeCommit, another page of 1,000 records
	// is retrieved.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Lists the repositories called by the list repositories operation.
	Repositories []*RepositoryNameIdPair `locationName:"repositories" type:"list"`
}

// String returns the string representation
func (s ListRepositoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRepositoriesOutput) GoString() string {
	return s.String()
}

// Represents the input ofa put repository triggers operation.
type PutRepositoryTriggersInput struct {
	_ struct{} `type:"structure"`

	// The name of the repository where you want to create or update the trigger.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`

	// The JSON block of configuration information for each trigger.
	Triggers []*RepositoryTrigger `locationName:"triggers" type:"list"`
}

// String returns the string representation
func (s PutRepositoryTriggersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRepositoryTriggersInput) GoString() string {
	return s.String()
}

// Represents the output of a put repository triggers operation.
type PutRepositoryTriggersOutput struct {
	_ struct{} `type:"structure"`

	// The system-generated unique ID for the create or update operation.
	ConfigurationId *string `locationName:"configurationId" type:"string"`
}

// String returns the string representation
func (s PutRepositoryTriggersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRepositoryTriggersOutput) GoString() string {
	return s.String()
}

// Information about a repository.
type RepositoryMetadata struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account associated with the repository.
	AccountId *string `locationName:"accountId" type:"string"`

	// The Amazon Resource Name (ARN) of the repository.
	Arn *string `type:"string"`

	// The URL to use for cloning the repository over HTTPS.
	CloneUrlHttp *string `locationName:"cloneUrlHttp" type:"string"`

	// The URL to use for cloning the repository over SSH.
	CloneUrlSsh *string `locationName:"cloneUrlSsh" type:"string"`

	// The date and time the repository was created, in timestamp format.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The repository's default branch name.
	DefaultBranch *string `locationName:"defaultBranch" min:"1" type:"string"`

	// The date and time the repository was last modified, in timestamp format.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp" timestampFormat:"unix"`

	// A comment or description about the repository.
	RepositoryDescription *string `locationName:"repositoryDescription" type:"string"`

	// The ID of the repository.
	RepositoryId *string `locationName:"repositoryId" type:"string"`

	// The repository's name.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s RepositoryMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RepositoryMetadata) GoString() string {
	return s.String()
}

// Information about a repository name and ID.
type RepositoryNameIdPair struct {
	_ struct{} `type:"structure"`

	// The ID associated with the repository.
	RepositoryId *string `locationName:"repositoryId" type:"string"`

	// The name associated with the repository.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s RepositoryNameIdPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RepositoryNameIdPair) GoString() string {
	return s.String()
}

// Information about a trigger for a repository.
type RepositoryTrigger struct {
	_ struct{} `type:"structure"`

	// The branches that will be included in the trigger configuration. If no branches
	// are specified, the trigger will apply to all branches.
	Branches []*string `locationName:"branches" type:"list"`

	// Any custom data associated with the trigger that will be included in the
	// information sent to the target of the trigger.
	CustomData *string `locationName:"customData" type:"string"`

	// The ARN of the resource that is the target for a trigger. For example, the
	// ARN of a topic in Amazon Simple Notification Service (SNS).
	DestinationArn *string `locationName:"destinationArn" type:"string"`

	// The repository events that will cause the trigger to run actions in another
	// service, such as sending a notification through Amazon Simple Notification
	// Service (SNS). If no events are specified, the trigger will run for all repository
	// events.
	Events []*string `locationName:"events" type:"list"`

	// The name of the trigger.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s RepositoryTrigger) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RepositoryTrigger) GoString() string {
	return s.String()
}

// A trigger failed to run.
type RepositoryTriggerExecutionFailure struct {
	_ struct{} `type:"structure"`

	// Additional message information about the trigger that did not run.
	FailureMessage *string `locationName:"failureMessage" type:"string"`

	// The name of the trigger that did not run.
	Trigger *string `locationName:"trigger" type:"string"`
}

// String returns the string representation
func (s RepositoryTriggerExecutionFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RepositoryTriggerExecutionFailure) GoString() string {
	return s.String()
}

// Represents the input of a test repository triggers operation.
type TestRepositoryTriggersInput struct {
	_ struct{} `type:"structure"`

	// The name of the repository in which to test the triggers.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`

	// The list of triggers to test.
	Triggers []*RepositoryTrigger `locationName:"triggers" type:"list"`
}

// String returns the string representation
func (s TestRepositoryTriggersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestRepositoryTriggersInput) GoString() string {
	return s.String()
}

// Represents the output of a test repository triggers operation.
type TestRepositoryTriggersOutput struct {
	_ struct{} `type:"structure"`

	// The list of triggers that were not able to be tested. This list provides
	// the names of the triggers that could not be tested, separated by commas.
	FailedExecutions []*RepositoryTriggerExecutionFailure `locationName:"failedExecutions" type:"list"`

	// The list of triggers that were successfully tested. This list provides the
	// names of the triggers that were successfully tested, separated by commas.
	SuccessfulExecutions []*string `locationName:"successfulExecutions" type:"list"`
}

// String returns the string representation
func (s TestRepositoryTriggersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestRepositoryTriggersOutput) GoString() string {
	return s.String()
}

// Represents the input of an update default branch operation.
type UpdateDefaultBranchInput struct {
	_ struct{} `type:"structure"`

	// The name of the branch to set as the default.
	DefaultBranchName *string `locationName:"defaultBranchName" min:"1" type:"string" required:"true"`

	// The name of the repository to set or change the default branch for.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDefaultBranchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDefaultBranchInput) GoString() string {
	return s.String()
}

type UpdateDefaultBranchOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDefaultBranchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDefaultBranchOutput) GoString() string {
	return s.String()
}

// Represents the input of an update repository description operation.
type UpdateRepositoryDescriptionInput struct {
	_ struct{} `type:"structure"`

	// The new comment or description for the specified repository. Repository descriptions
	// are limited to 1,000 characters.
	RepositoryDescription *string `locationName:"repositoryDescription" type:"string"`

	// The name of the repository to set or change the comment or description for.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRepositoryDescriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRepositoryDescriptionInput) GoString() string {
	return s.String()
}

type UpdateRepositoryDescriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRepositoryDescriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRepositoryDescriptionOutput) GoString() string {
	return s.String()
}

// Represents the input of an update repository description operation.
type UpdateRepositoryNameInput struct {
	_ struct{} `type:"structure"`

	// The new name for the repository.
	NewName *string `locationName:"newName" min:"1" type:"string" required:"true"`

	// The existing name of the repository.
	OldName *string `locationName:"oldName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRepositoryNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRepositoryNameInput) GoString() string {
	return s.String()
}

type UpdateRepositoryNameOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRepositoryNameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRepositoryNameOutput) GoString() string {
	return s.String()
}

// Information about the user who made a specified commit.
type UserInfo struct {
	_ struct{} `type:"structure"`

	// The date when the specified commit was pushed to the repository.
	Date *string `locationName:"date" type:"string"`

	// The email address associated with the user who made the commit, if any.
	Email *string `locationName:"email" type:"string"`

	// The name of the user who made the specified commit.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s UserInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserInfo) GoString() string {
	return s.String()
}

const (
	// @enum OrderEnum
	OrderEnumAscending = "ascending"
	// @enum OrderEnum
	OrderEnumDescending = "descending"
)

const (
	// @enum RepositoryTriggerEventEnum
	RepositoryTriggerEventEnumAll = "all"
	// @enum RepositoryTriggerEventEnum
	RepositoryTriggerEventEnumUpdateReference = "updateReference"
	// @enum RepositoryTriggerEventEnum
	RepositoryTriggerEventEnumCreateReference = "createReference"
	// @enum RepositoryTriggerEventEnum
	RepositoryTriggerEventEnumDeleteReference = "deleteReference"
)

const (
	// @enum SortByEnum
	SortByEnumRepositoryName = "repositoryName"
	// @enum SortByEnum
	SortByEnumLastModifiedDate = "lastModifiedDate"
)
