// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package waf provides a client for AWS WAF.
package waf

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateByteMatchSet = "CreateByteMatchSet"

// CreateByteMatchSetRequest generates a request for the CreateByteMatchSet operation.
func (c *WAF) CreateByteMatchSetRequest(input *CreateByteMatchSetInput) (req *request.Request, output *CreateByteMatchSetOutput) {
	op := &request.Operation{
		Name:       opCreateByteMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateByteMatchSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateByteMatchSetOutput{}
	req.Data = output
	return
}

// Creates a ByteMatchSet. You then use UpdateByteMatchSet to identify the part
// of a web request that you want AWS WAF to inspect, such as the values of
// the User-Agent header or the query string. For example, you can create a
// ByteMatchSet that matches any requests with User-Agent headers that contain
// the string BadBot. You can then configure AWS WAF to reject those requests.
//
// To create and configure a ByteMatchSet, perform the following steps:
//
//  Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateByteMatchSet request. Submit a CreateByteMatchSet request.
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateByteMatchSet request. Submit an UpdateByteMatchSet
// request to specify the part of the request that you want AWS WAF to inspect
// (for example, the header or the URI) and the value that you want AWS WAF
// to watch for.  For more information about how to use the AWS WAF API to allow
// or block HTTP requests, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
func (c *WAF) CreateByteMatchSet(input *CreateByteMatchSetInput) (*CreateByteMatchSetOutput, error) {
	req, out := c.CreateByteMatchSetRequest(input)
	err := req.Send()
	return out, err
}

const opCreateIPSet = "CreateIPSet"

// CreateIPSetRequest generates a request for the CreateIPSet operation.
func (c *WAF) CreateIPSetRequest(input *CreateIPSetInput) (req *request.Request, output *CreateIPSetOutput) {
	op := &request.Operation{
		Name:       opCreateIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateIPSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateIPSetOutput{}
	req.Data = output
	return
}

// Creates an IPSet, which you use to specify which web requests you want to
// allow or block based on the IP addresses that the requests originate from.
// For example, if you're receiving a lot of requests from one or more individual
// IP addresses or one or more ranges of IP addresses and you want to block
// the requests, you can create an IPSet that contains those IP addresses and
// then configure AWS WAF to block the requests.
//
// To create and configure an IPSet, perform the following steps:
//
//  Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateIPSet request. Submit a CreateIPSet request. Use GetChangeToken
// to get the change token that you provide in the ChangeToken parameter of
// an UpdateIPSet request. Submit an UpdateIPSet request to specify the IP addresses
// that you want AWS WAF to watch for.  For more information about how to use
// the AWS WAF API to allow or block HTTP requests, see the AWS WAF Developer
// Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
func (c *WAF) CreateIPSet(input *CreateIPSetInput) (*CreateIPSetOutput, error) {
	req, out := c.CreateIPSetRequest(input)
	err := req.Send()
	return out, err
}

const opCreateRule = "CreateRule"

// CreateRuleRequest generates a request for the CreateRule operation.
func (c *WAF) CreateRuleRequest(input *CreateRuleInput) (req *request.Request, output *CreateRuleOutput) {
	op := &request.Operation{
		Name:       opCreateRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRuleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateRuleOutput{}
	req.Data = output
	return
}

// Creates a Rule, which contains the IPSet objects, ByteMatchSet objects, and
// other predicates that identify the requests that you want to block. If you
// add more than one predicate to a Rule, a request must match all of the specifications
// to be allowed or blocked. For example, suppose you add the following to a
// Rule:
//
//  An IPSet that matches the IP address 192.0.2.44/32 A ByteMatchSet that
// matches BadBot in the User-Agent header  You then add the Rule to a WebACL
// and specify that you want to blocks requests that satisfy the Rule. For a
// request to be blocked, it must come from the IP address 192.0.2.44 and the
// User-Agent header in the request must contain the value BadBot.
//
// To create and configure a Rule, perform the following steps:
//
//  Create and update the predicates that you want to include in the Rule.
// For more information, see CreateByteMatchSet, CreateIPSet, and CreateSqlInjectionMatchSet.
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateRule request. Submit a CreateRule request. Use GetChangeToken
// to get the change token that you provide in the ChangeToken parameter of
// an UpdateRule request. Submit an UpdateRule request to specify the predicates
// that you want to include in the Rule. Create and update a WebACL that contains
// the Rule. For more information, see CreateWebACL.  For more information about
// how to use the AWS WAF API to allow or block HTTP requests, see the AWS WAF
// Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
func (c *WAF) CreateRule(input *CreateRuleInput) (*CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSizeConstraintSet = "CreateSizeConstraintSet"

// CreateSizeConstraintSetRequest generates a request for the CreateSizeConstraintSet operation.
func (c *WAF) CreateSizeConstraintSetRequest(input *CreateSizeConstraintSetInput) (req *request.Request, output *CreateSizeConstraintSetOutput) {
	op := &request.Operation{
		Name:       opCreateSizeConstraintSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSizeConstraintSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateSizeConstraintSetOutput{}
	req.Data = output
	return
}

// Creates a SizeConstraintSet. You then use UpdateSizeConstraintSet to identify
// the part of a web request that you want AWS WAF to check for length, such
// as the length of the User-Agent header or the length of the query string.
// For example, you can create a SizeConstraintSet that matches any requests
// that have a query string that is longer than 100 bytes. You can then configure
// AWS WAF to reject those requests.
//
// To create and configure a SizeConstraintSet, perform the following steps:
//
//  Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateSizeConstraintSet request. Submit a CreateSizeConstraintSet
// request. Use GetChangeToken to get the change token that you provide in the
// ChangeToken parameter of an UpdateSizeConstraintSet request. Submit an UpdateSizeConstraintSet
// request to specify the part of the request that you want AWS WAF to inspect
// (for example, the header or the URI) and the value that you want AWS WAF
// to watch for.  For more information about how to use the AWS WAF API to allow
// or block HTTP requests, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
func (c *WAF) CreateSizeConstraintSet(input *CreateSizeConstraintSetInput) (*CreateSizeConstraintSetOutput, error) {
	req, out := c.CreateSizeConstraintSetRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSqlInjectionMatchSet = "CreateSqlInjectionMatchSet"

// CreateSqlInjectionMatchSetRequest generates a request for the CreateSqlInjectionMatchSet operation.
func (c *WAF) CreateSqlInjectionMatchSetRequest(input *CreateSqlInjectionMatchSetInput) (req *request.Request, output *CreateSqlInjectionMatchSetOutput) {
	op := &request.Operation{
		Name:       opCreateSqlInjectionMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSqlInjectionMatchSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateSqlInjectionMatchSetOutput{}
	req.Data = output
	return
}

// Creates a SqlInjectionMatchSet, which you use to allow, block, or count requests
// that contain snippets of SQL code in a specified part of web requests. AWS
// WAF searches for character sequences that are likely to be malicious strings.
//
// To create and configure a SqlInjectionMatchSet, perform the following steps:
//
//  Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateSqlInjectionMatchSet request. Submit a CreateSqlInjectionMatchSet
// request. Use GetChangeToken to get the change token that you provide in the
// ChangeToken parameter of an UpdateSqlInjectionMatchSet request. Submit an
// UpdateSqlInjectionMatchSet request to specify the parts of web requests in
// which you want to allow, block, or count malicious SQL code.  For more information
// about how to use the AWS WAF API to allow or block HTTP requests, see the
// AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
func (c *WAF) CreateSqlInjectionMatchSet(input *CreateSqlInjectionMatchSetInput) (*CreateSqlInjectionMatchSetOutput, error) {
	req, out := c.CreateSqlInjectionMatchSetRequest(input)
	err := req.Send()
	return out, err
}

const opCreateWebACL = "CreateWebACL"

// CreateWebACLRequest generates a request for the CreateWebACL operation.
func (c *WAF) CreateWebACLRequest(input *CreateWebACLInput) (req *request.Request, output *CreateWebACLOutput) {
	op := &request.Operation{
		Name:       opCreateWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWebACLInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateWebACLOutput{}
	req.Data = output
	return
}

// Creates a WebACL, which contains the Rules that identify the CloudFront web
// requests that you want to allow, block, or count. AWS WAF evaluates Rules
// in order based on the value of Priority for each Rule.
//
// You also specify a default action, either ALLOW or BLOCK. If a web request
// doesn't match any of the Rules in a WebACL, AWS WAF responds to the request
// with the default action.
//
// To create and configure a WebACL, perform the following steps:
//
//  Create and update the ByteMatchSet objects and other predicates that you
// want to include in Rules. For more information, see CreateByteMatchSet, UpdateByteMatchSet,
// CreateIPSet, UpdateIPSet, CreateSqlInjectionMatchSet, and UpdateSqlInjectionMatchSet.
// Create and update the Rules that you want to include in the WebACL. For more
// information, see CreateRule and UpdateRule. Use GetChangeToken to get the
// change token that you provide in the ChangeToken parameter of a CreateWebACL
// request. Submit a CreateWebACL request. Use GetChangeToken to get the change
// token that you provide in the ChangeToken parameter of an UpdateWebACL request.
// Submit an UpdateWebACL request to specify the Rules that you want to include
// in the WebACL, to specify the default action, and to associate the WebACL
// with a CloudFront distribution.  For more information about how to use the
// AWS WAF API, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
func (c *WAF) CreateWebACL(input *CreateWebACLInput) (*CreateWebACLOutput, error) {
	req, out := c.CreateWebACLRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteByteMatchSet = "DeleteByteMatchSet"

// DeleteByteMatchSetRequest generates a request for the DeleteByteMatchSet operation.
func (c *WAF) DeleteByteMatchSetRequest(input *DeleteByteMatchSetInput) (req *request.Request, output *DeleteByteMatchSetOutput) {
	op := &request.Operation{
		Name:       opDeleteByteMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteByteMatchSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteByteMatchSetOutput{}
	req.Data = output
	return
}

// Permanently deletes a ByteMatchSet. You can't delete a ByteMatchSet if it's
// still used in any Rules or if it still includes any ByteMatchTuple objects
// (any filters).
//
// If you just want to remove a ByteMatchSet from a Rule, use UpdateRule.
//
// To permanently delete a ByteMatchSet, perform the following steps:
//
//  Update the ByteMatchSet to remove filters, if any. For more information,
// see UpdateByteMatchSet. Use GetChangeToken to get the change token that you
// provide in the ChangeToken parameter of a DeleteByteMatchSet request. Submit
// a DeleteByteMatchSet request.
func (c *WAF) DeleteByteMatchSet(input *DeleteByteMatchSetInput) (*DeleteByteMatchSetOutput, error) {
	req, out := c.DeleteByteMatchSetRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteIPSet = "DeleteIPSet"

// DeleteIPSetRequest generates a request for the DeleteIPSet operation.
func (c *WAF) DeleteIPSetRequest(input *DeleteIPSetInput) (req *request.Request, output *DeleteIPSetOutput) {
	op := &request.Operation{
		Name:       opDeleteIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIPSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteIPSetOutput{}
	req.Data = output
	return
}

// Permanently deletes an IPSet. You can't delete an IPSet if it's still used
// in any Rules or if it still includes any IP addresses.
//
// If you just want to remove an IPSet from a Rule, use UpdateRule.
//
// To permanently delete an IPSet from AWS WAF, perform the following steps:
//
//  Update the IPSet to remove IP address ranges, if any. For more information,
// see UpdateIPSet. Use GetChangeToken to get the change token that you provide
// in the ChangeToken parameter of a DeleteIPSet request. Submit a DeleteIPSet
// request.
func (c *WAF) DeleteIPSet(input *DeleteIPSetInput) (*DeleteIPSetOutput, error) {
	req, out := c.DeleteIPSetRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteRule = "DeleteRule"

// DeleteRuleRequest generates a request for the DeleteRule operation.
func (c *WAF) DeleteRuleRequest(input *DeleteRuleInput) (req *request.Request, output *DeleteRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRuleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteRuleOutput{}
	req.Data = output
	return
}

// Permanently deletes a Rule. You can't delete a Rule if it's still used in
// any WebACL objects or if it still includes any predicates, such as ByteMatchSet
// objects.
//
// If you just want to remove a Rule from a WebACL, use UpdateWebACL.
//
// To permanently delete a Rule from AWS WAF, perform the following steps:
//
//  Update the Rule to remove predicates, if any. For more information, see
// UpdateRule. Use GetChangeToken to get the change token that you provide in
// the ChangeToken parameter of a DeleteRule request. Submit a DeleteRule request.
func (c *WAF) DeleteRule(input *DeleteRuleInput) (*DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSizeConstraintSet = "DeleteSizeConstraintSet"

// DeleteSizeConstraintSetRequest generates a request for the DeleteSizeConstraintSet operation.
func (c *WAF) DeleteSizeConstraintSetRequest(input *DeleteSizeConstraintSetInput) (req *request.Request, output *DeleteSizeConstraintSetOutput) {
	op := &request.Operation{
		Name:       opDeleteSizeConstraintSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSizeConstraintSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteSizeConstraintSetOutput{}
	req.Data = output
	return
}

// Permanently deletes a SizeConstraintSet. You can't delete a SizeConstraintSet
// if it's still used in any Rules or if it still includes any SizeConstraint
// objects (any filters).
//
// If you just want to remove a SizeConstraintSet from a Rule, use UpdateRule.
//
// To permanently delete a SizeConstraintSet, perform the following steps:
//
//  Update the SizeConstraintSet to remove filters, if any. For more information,
// see UpdateSizeConstraintSet. Use GetChangeToken to get the change token that
// you provide in the ChangeToken parameter of a DeleteSizeConstraintSet request.
// Submit a DeleteSizeConstraintSet request.
func (c *WAF) DeleteSizeConstraintSet(input *DeleteSizeConstraintSetInput) (*DeleteSizeConstraintSetOutput, error) {
	req, out := c.DeleteSizeConstraintSetRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSqlInjectionMatchSet = "DeleteSqlInjectionMatchSet"

// DeleteSqlInjectionMatchSetRequest generates a request for the DeleteSqlInjectionMatchSet operation.
func (c *WAF) DeleteSqlInjectionMatchSetRequest(input *DeleteSqlInjectionMatchSetInput) (req *request.Request, output *DeleteSqlInjectionMatchSetOutput) {
	op := &request.Operation{
		Name:       opDeleteSqlInjectionMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSqlInjectionMatchSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteSqlInjectionMatchSetOutput{}
	req.Data = output
	return
}

// Permanently deletes a SqlInjectionMatchSet. You can't delete a SqlInjectionMatchSet
// if it's still used in any Rules or if it still contains any SqlInjectionMatchTuple
// objects.
//
// If you just want to remove a SqlInjectionMatchSet from a Rule, use UpdateRule.
//
// To permanently delete a SqlInjectionMatchSet from AWS WAF, perform the following
// steps:
//
//  Update the SqlInjectionMatchSet to remove filters, if any. For more information,
// see UpdateSqlInjectionMatchSet. Use GetChangeToken to get the change token
// that you provide in the ChangeToken parameter of a DeleteSqlInjectionMatchSet
// request. Submit a DeleteSqlInjectionMatchSet request.
func (c *WAF) DeleteSqlInjectionMatchSet(input *DeleteSqlInjectionMatchSetInput) (*DeleteSqlInjectionMatchSetOutput, error) {
	req, out := c.DeleteSqlInjectionMatchSetRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteWebACL = "DeleteWebACL"

// DeleteWebACLRequest generates a request for the DeleteWebACL operation.
func (c *WAF) DeleteWebACLRequest(input *DeleteWebACLInput) (req *request.Request, output *DeleteWebACLOutput) {
	op := &request.Operation{
		Name:       opDeleteWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWebACLInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteWebACLOutput{}
	req.Data = output
	return
}

// Permanently deletes a WebACL. You can't delete a WebACL if it still contains
// any Rules.
//
// To delete a WebACL, perform the following steps:
//
//  Update the WebACL to remove Rules, if any. For more information, see UpdateWebACL.
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteWebACL request. Submit a DeleteWebACL request.
func (c *WAF) DeleteWebACL(input *DeleteWebACLInput) (*DeleteWebACLOutput, error) {
	req, out := c.DeleteWebACLRequest(input)
	err := req.Send()
	return out, err
}

const opGetByteMatchSet = "GetByteMatchSet"

// GetByteMatchSetRequest generates a request for the GetByteMatchSet operation.
func (c *WAF) GetByteMatchSetRequest(input *GetByteMatchSetInput) (req *request.Request, output *GetByteMatchSetOutput) {
	op := &request.Operation{
		Name:       opGetByteMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetByteMatchSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetByteMatchSetOutput{}
	req.Data = output
	return
}

// Returns the ByteMatchSet specified by ByteMatchSetId.
func (c *WAF) GetByteMatchSet(input *GetByteMatchSetInput) (*GetByteMatchSetOutput, error) {
	req, out := c.GetByteMatchSetRequest(input)
	err := req.Send()
	return out, err
}

const opGetChangeToken = "GetChangeToken"

// GetChangeTokenRequest generates a request for the GetChangeToken operation.
func (c *WAF) GetChangeTokenRequest(input *GetChangeTokenInput) (req *request.Request, output *GetChangeTokenOutput) {
	op := &request.Operation{
		Name:       opGetChangeToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetChangeTokenInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetChangeTokenOutput{}
	req.Data = output
	return
}

// When you want to create, update, or delete AWS WAF objects, get a change
// token and include the change token in the create, update, or delete request.
// Change tokens ensure that your application doesn't submit conflicting requests
// to AWS WAF.
//
// Each create, update, or delete request must use a unique change token. If
// your application submits a GetChangeToken request and then submits a second
// GetChangeToken request before submitting a create, update, or delete request,
// the second GetChangeToken request returns the same value as the first GetChangeToken
// request.
//
// When you use a change token in a create, update, or delete request, the
// status of the change token changes to PENDING, which indicates that AWS WAF
// is propagating the change to all AWS WAF servers. Use GetChangeTokenStatus
// to determine the status of your change token.
func (c *WAF) GetChangeToken(input *GetChangeTokenInput) (*GetChangeTokenOutput, error) {
	req, out := c.GetChangeTokenRequest(input)
	err := req.Send()
	return out, err
}

const opGetChangeTokenStatus = "GetChangeTokenStatus"

// GetChangeTokenStatusRequest generates a request for the GetChangeTokenStatus operation.
func (c *WAF) GetChangeTokenStatusRequest(input *GetChangeTokenStatusInput) (req *request.Request, output *GetChangeTokenStatusOutput) {
	op := &request.Operation{
		Name:       opGetChangeTokenStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetChangeTokenStatusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetChangeTokenStatusOutput{}
	req.Data = output
	return
}

// Returns the status of a ChangeToken that you got by calling GetChangeToken.
// ChangeTokenStatus is one of the following values:
//
//  PROVISIONED: You requested the change token by calling GetChangeToken,
// but you haven't used it yet in a call to create, update, or delete an AWS
// WAF object. PENDING: AWS WAF is propagating the create, update, or delete
// request to all AWS WAF servers. IN_SYNC: Propagation is complete.
func (c *WAF) GetChangeTokenStatus(input *GetChangeTokenStatusInput) (*GetChangeTokenStatusOutput, error) {
	req, out := c.GetChangeTokenStatusRequest(input)
	err := req.Send()
	return out, err
}

const opGetIPSet = "GetIPSet"

// GetIPSetRequest generates a request for the GetIPSet operation.
func (c *WAF) GetIPSetRequest(input *GetIPSetInput) (req *request.Request, output *GetIPSetOutput) {
	op := &request.Operation{
		Name:       opGetIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIPSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetIPSetOutput{}
	req.Data = output
	return
}

// Returns the IPSet that is specified by IPSetId.
func (c *WAF) GetIPSet(input *GetIPSetInput) (*GetIPSetOutput, error) {
	req, out := c.GetIPSetRequest(input)
	err := req.Send()
	return out, err
}

const opGetRule = "GetRule"

// GetRuleRequest generates a request for the GetRule operation.
func (c *WAF) GetRuleRequest(input *GetRuleInput) (req *request.Request, output *GetRuleOutput) {
	op := &request.Operation{
		Name:       opGetRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRuleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetRuleOutput{}
	req.Data = output
	return
}

// Returns the Rule that is specified by the RuleId that you included in the
// GetRule request.
func (c *WAF) GetRule(input *GetRuleInput) (*GetRuleOutput, error) {
	req, out := c.GetRuleRequest(input)
	err := req.Send()
	return out, err
}

const opGetSampledRequests = "GetSampledRequests"

// GetSampledRequestsRequest generates a request for the GetSampledRequests operation.
func (c *WAF) GetSampledRequestsRequest(input *GetSampledRequestsInput) (req *request.Request, output *GetSampledRequestsOutput) {
	op := &request.Operation{
		Name:       opGetSampledRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSampledRequestsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetSampledRequestsOutput{}
	req.Data = output
	return
}

// Gets detailed information about a specified number of requests--a sample--that
// AWS WAF randomly selects from among the first 5,000 requests that your AWS
// resource received during a time range that you choose. You can specify a
// sample size of up to 100 requests, and you can specify any time range in
// the previous three hours.
//
// GetSampledRequests returns a time range, which is usually the time range
// that you specified. However, if your resource (such as a CloudFront distribution)
// received 5,000 requests before the specified time range elapsed, GetSampledRequests
// returns an updated time range. This new time range indicates the actual period
// during which AWS WAF selected the requests in the sample.
func (c *WAF) GetSampledRequests(input *GetSampledRequestsInput) (*GetSampledRequestsOutput, error) {
	req, out := c.GetSampledRequestsRequest(input)
	err := req.Send()
	return out, err
}

const opGetSizeConstraintSet = "GetSizeConstraintSet"

// GetSizeConstraintSetRequest generates a request for the GetSizeConstraintSet operation.
func (c *WAF) GetSizeConstraintSetRequest(input *GetSizeConstraintSetInput) (req *request.Request, output *GetSizeConstraintSetOutput) {
	op := &request.Operation{
		Name:       opGetSizeConstraintSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSizeConstraintSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetSizeConstraintSetOutput{}
	req.Data = output
	return
}

// Returns the SizeConstraintSet specified by SizeConstraintSetId.
func (c *WAF) GetSizeConstraintSet(input *GetSizeConstraintSetInput) (*GetSizeConstraintSetOutput, error) {
	req, out := c.GetSizeConstraintSetRequest(input)
	err := req.Send()
	return out, err
}

const opGetSqlInjectionMatchSet = "GetSqlInjectionMatchSet"

// GetSqlInjectionMatchSetRequest generates a request for the GetSqlInjectionMatchSet operation.
func (c *WAF) GetSqlInjectionMatchSetRequest(input *GetSqlInjectionMatchSetInput) (req *request.Request, output *GetSqlInjectionMatchSetOutput) {
	op := &request.Operation{
		Name:       opGetSqlInjectionMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSqlInjectionMatchSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetSqlInjectionMatchSetOutput{}
	req.Data = output
	return
}

// Returns the SqlInjectionMatchSet that is specified by SqlInjectionMatchSetId.
func (c *WAF) GetSqlInjectionMatchSet(input *GetSqlInjectionMatchSetInput) (*GetSqlInjectionMatchSetOutput, error) {
	req, out := c.GetSqlInjectionMatchSetRequest(input)
	err := req.Send()
	return out, err
}

const opGetWebACL = "GetWebACL"

// GetWebACLRequest generates a request for the GetWebACL operation.
func (c *WAF) GetWebACLRequest(input *GetWebACLInput) (req *request.Request, output *GetWebACLOutput) {
	op := &request.Operation{
		Name:       opGetWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetWebACLInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetWebACLOutput{}
	req.Data = output
	return
}

// Returns the WebACL that is specified by WebACLId.
func (c *WAF) GetWebACL(input *GetWebACLInput) (*GetWebACLOutput, error) {
	req, out := c.GetWebACLRequest(input)
	err := req.Send()
	return out, err
}

const opListByteMatchSets = "ListByteMatchSets"

// ListByteMatchSetsRequest generates a request for the ListByteMatchSets operation.
func (c *WAF) ListByteMatchSetsRequest(input *ListByteMatchSetsInput) (req *request.Request, output *ListByteMatchSetsOutput) {
	op := &request.Operation{
		Name:       opListByteMatchSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListByteMatchSetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListByteMatchSetsOutput{}
	req.Data = output
	return
}

// Returns an array of ByteMatchSetSummary objects.
func (c *WAF) ListByteMatchSets(input *ListByteMatchSetsInput) (*ListByteMatchSetsOutput, error) {
	req, out := c.ListByteMatchSetsRequest(input)
	err := req.Send()
	return out, err
}

const opListIPSets = "ListIPSets"

// ListIPSetsRequest generates a request for the ListIPSets operation.
func (c *WAF) ListIPSetsRequest(input *ListIPSetsInput) (req *request.Request, output *ListIPSetsOutput) {
	op := &request.Operation{
		Name:       opListIPSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListIPSetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListIPSetsOutput{}
	req.Data = output
	return
}

// Returns an array of IPSetSummary objects in the response.
func (c *WAF) ListIPSets(input *ListIPSetsInput) (*ListIPSetsOutput, error) {
	req, out := c.ListIPSetsRequest(input)
	err := req.Send()
	return out, err
}

const opListRules = "ListRules"

// ListRulesRequest generates a request for the ListRules operation.
func (c *WAF) ListRulesRequest(input *ListRulesInput) (req *request.Request, output *ListRulesOutput) {
	op := &request.Operation{
		Name:       opListRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRulesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListRulesOutput{}
	req.Data = output
	return
}

// Returns an array of RuleSummary objects.
func (c *WAF) ListRules(input *ListRulesInput) (*ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	err := req.Send()
	return out, err
}

const opListSizeConstraintSets = "ListSizeConstraintSets"

// ListSizeConstraintSetsRequest generates a request for the ListSizeConstraintSets operation.
func (c *WAF) ListSizeConstraintSetsRequest(input *ListSizeConstraintSetsInput) (req *request.Request, output *ListSizeConstraintSetsOutput) {
	op := &request.Operation{
		Name:       opListSizeConstraintSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListSizeConstraintSetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListSizeConstraintSetsOutput{}
	req.Data = output
	return
}

// Returns an array of SizeConstraintSetSummary objects.
func (c *WAF) ListSizeConstraintSets(input *ListSizeConstraintSetsInput) (*ListSizeConstraintSetsOutput, error) {
	req, out := c.ListSizeConstraintSetsRequest(input)
	err := req.Send()
	return out, err
}

const opListSqlInjectionMatchSets = "ListSqlInjectionMatchSets"

// ListSqlInjectionMatchSetsRequest generates a request for the ListSqlInjectionMatchSets operation.
func (c *WAF) ListSqlInjectionMatchSetsRequest(input *ListSqlInjectionMatchSetsInput) (req *request.Request, output *ListSqlInjectionMatchSetsOutput) {
	op := &request.Operation{
		Name:       opListSqlInjectionMatchSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListSqlInjectionMatchSetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListSqlInjectionMatchSetsOutput{}
	req.Data = output
	return
}

// Returns an array of SqlInjectionMatchSet objects.
func (c *WAF) ListSqlInjectionMatchSets(input *ListSqlInjectionMatchSetsInput) (*ListSqlInjectionMatchSetsOutput, error) {
	req, out := c.ListSqlInjectionMatchSetsRequest(input)
	err := req.Send()
	return out, err
}

const opListWebACLs = "ListWebACLs"

// ListWebACLsRequest generates a request for the ListWebACLs operation.
func (c *WAF) ListWebACLsRequest(input *ListWebACLsInput) (req *request.Request, output *ListWebACLsOutput) {
	op := &request.Operation{
		Name:       opListWebACLs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListWebACLsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListWebACLsOutput{}
	req.Data = output
	return
}

// Returns an array of WebACLSummary objects in the response.
func (c *WAF) ListWebACLs(input *ListWebACLsInput) (*ListWebACLsOutput, error) {
	req, out := c.ListWebACLsRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateByteMatchSet = "UpdateByteMatchSet"

// UpdateByteMatchSetRequest generates a request for the UpdateByteMatchSet operation.
func (c *WAF) UpdateByteMatchSetRequest(input *UpdateByteMatchSetInput) (req *request.Request, output *UpdateByteMatchSetOutput) {
	op := &request.Operation{
		Name:       opUpdateByteMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateByteMatchSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateByteMatchSetOutput{}
	req.Data = output
	return
}

// Inserts or deletes ByteMatchTuple objects (filters) in a ByteMatchSet. For
// each ByteMatchTuple object, you specify the following values:
//
//  Whether to insert or delete the object from the array. If you want to change
// a ByteMatchSetUpdate object, you delete the existing object and add a new
// one. The part of a web request that you want AWS WAF to inspect, such as
// a query string or the value of the User-Agent header.  The bytes (typically
// a string that corresponds with ASCII characters) that you want AWS WAF to
// look for. For more information, including how you specify the values for
// the AWS WAF API and the AWS CLI or SDKs, see TargetString in the ByteMatchTuple
// data type.  Where to look, such as at the beginning or the end of a query
// string. Whether to perform any conversions on the request, such as converting
// it to lowercase, before inspecting it for the specified string.  For example,
// you can add a ByteMatchSetUpdate object that matches web requests in which
// User-Agent headers contain the string BadBot. You can then configure AWS
// WAF to block those requests.
//
// To create and configure a ByteMatchSet, perform the following steps:
//
//  Create a ByteMatchSet. For more information, see CreateByteMatchSet. Use
// GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateByteMatchSet request. Submit an UpdateByteMatchSet
// request to specify the part of the request that you want AWS WAF to inspect
// (for example, the header or the URI) and the value that you want AWS WAF
// to watch for.  For more information about how to use the AWS WAF API to allow
// or block HTTP requests, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
func (c *WAF) UpdateByteMatchSet(input *UpdateByteMatchSetInput) (*UpdateByteMatchSetOutput, error) {
	req, out := c.UpdateByteMatchSetRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateIPSet = "UpdateIPSet"

// UpdateIPSetRequest generates a request for the UpdateIPSet operation.
func (c *WAF) UpdateIPSetRequest(input *UpdateIPSetInput) (req *request.Request, output *UpdateIPSetOutput) {
	op := &request.Operation{
		Name:       opUpdateIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateIPSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateIPSetOutput{}
	req.Data = output
	return
}

// Inserts or deletes IPSetDescriptor objects in an IPSet. For each IPSetDescriptor
// object, you specify the following values:
//
//  Whether to insert or delete the object from the array. If you want to change
// an IPSetDescriptor object, you delete the existing object and add a new one.
// The IP address version, IPv4.  The IP address in CIDR notation, for example,
// 192.0.2.0/24 (for the range of IP addresses from 192.0.2.0 to 192.0.2.255)
// or 192.0.2.44/32 (for the individual IP address 192.0.2.44).   AWS WAF supports
// /8, /16, /24, and /32 IP address ranges. For more information about CIDR
// notation, see the Wikipedia entry Classless Inter-Domain Routing (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
//
// You use an IPSet to specify which web requests you want to allow or block
// based on the IP addresses that the requests originated from. For example,
// if you're receiving a lot of requests from one or a small number of IP addresses
// and you want to block the requests, you can create an IPSet that specifies
// those IP addresses, and then configure AWS WAF to block the requests.
//
// To create and configure an IPSet, perform the following steps:
//
//  Submit a CreateIPSet request. Use GetChangeToken to get the change token
// that you provide in the ChangeToken parameter of an UpdateIPSet request.
// Submit an UpdateIPSet request to specify the IP addresses that you want AWS
// WAF to watch for.  When you update an IPSet, you specify the IP addresses
// that you want to add and/or the IP addresses that you want to delete. If
// you want to change an IP address, you delete the existing IP address and
// add the new one.
//
// For more information about how to use the AWS WAF API to allow or block
// HTTP requests, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
func (c *WAF) UpdateIPSet(input *UpdateIPSetInput) (*UpdateIPSetOutput, error) {
	req, out := c.UpdateIPSetRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateRule = "UpdateRule"

// UpdateRuleRequest generates a request for the UpdateRule operation.
func (c *WAF) UpdateRuleRequest(input *UpdateRuleInput) (req *request.Request, output *UpdateRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRuleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateRuleOutput{}
	req.Data = output
	return
}

// Inserts or deletes Predicate objects in a Rule. Each Predicate object identifies
// a predicate, such as a ByteMatchSet or an IPSet, that specifies the web requests
// that you want to allow, block, or count. If you add more than one predicate
// to a Rule, a request must match all of the specifications to be allowed,
// blocked, or counted. For example, suppose you add the following to a Rule:
//
//  A ByteMatchSet that matches the value BadBot in the User-Agent header An
// IPSet that matches the IP address 192.0.2.44  You then add the Rule to a
// WebACL and specify that you want to block requests that satisfy the Rule.
// For a request to be blocked, the User-Agent header in the request must contain
// the value BadBot and the request must originate from the IP address 192.0.2.44.
//
// To create and configure a Rule, perform the following steps:
//
//  Create and update the predicates that you want to include in the Rule.
// Create the Rule. See CreateRule. Use GetChangeToken to get the change token
// that you provide in the ChangeToken parameter of an UpdateRule request. Submit
// an UpdateRule request to add predicates to the Rule. Create and update a
// WebACL that contains the Rule. See CreateWebACL.  If you want to replace
// one ByteMatchSet or IPSet with another, you delete the existing one and add
// the new one.
//
// For more information about how to use the AWS WAF API to allow or block
// HTTP requests, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
func (c *WAF) UpdateRule(input *UpdateRuleInput) (*UpdateRuleOutput, error) {
	req, out := c.UpdateRuleRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateSizeConstraintSet = "UpdateSizeConstraintSet"

// UpdateSizeConstraintSetRequest generates a request for the UpdateSizeConstraintSet operation.
func (c *WAF) UpdateSizeConstraintSetRequest(input *UpdateSizeConstraintSetInput) (req *request.Request, output *UpdateSizeConstraintSetOutput) {
	op := &request.Operation{
		Name:       opUpdateSizeConstraintSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSizeConstraintSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateSizeConstraintSetOutput{}
	req.Data = output
	return
}

// Inserts or deletes SizeConstraint objects (filters) in a SizeConstraintSet.
// For each SizeConstraint object, you specify the following values:
//
//  Whether to insert or delete the object from the array. If you want to change
// a SizeConstraintSetUpdate object, you delete the existing object and add
// a new one. The part of a web request that you want AWS WAF to evaluate, such
// as the length of a query string or the length of the User-Agent header. Whether
// to perform any transformations on the request, such as converting it to lowercase,
// before checking its length. Note that transformations of the request body
// are not supported because the AWS resource forwards only the first 8192 bytes
// of your request to AWS WAF. A ComparisonOperator used for evaluating the
// selected part of the request against the specified Size, such as equals,
// greater than, less than, and so on. The length, in bytes, that you want AWS
// WAF to watch for in selected part of the request. The length is computed
// after applying the transformation.  For example, you can add a SizeConstraintSetUpdate
// object that matches web requests in which the length of the User-Agent header
// is greater than 100 bytes. You can then configure AWS WAF to block those
// requests.
//
// To create and configure a SizeConstraintSet, perform the following steps:
//
//  Create a SizeConstraintSet. For more information, see CreateSizeConstraintSet.
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateSizeConstraintSet request. Submit an UpdateSizeConstraintSet
// request to specify the part of the request that you want AWS WAF to inspect
// (for example, the header or the URI) and the value that you want AWS WAF
// to watch for.  For more information about how to use the AWS WAF API to allow
// or block HTTP requests, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
func (c *WAF) UpdateSizeConstraintSet(input *UpdateSizeConstraintSetInput) (*UpdateSizeConstraintSetOutput, error) {
	req, out := c.UpdateSizeConstraintSetRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateSqlInjectionMatchSet = "UpdateSqlInjectionMatchSet"

// UpdateSqlInjectionMatchSetRequest generates a request for the UpdateSqlInjectionMatchSet operation.
func (c *WAF) UpdateSqlInjectionMatchSetRequest(input *UpdateSqlInjectionMatchSetInput) (req *request.Request, output *UpdateSqlInjectionMatchSetOutput) {
	op := &request.Operation{
		Name:       opUpdateSqlInjectionMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSqlInjectionMatchSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateSqlInjectionMatchSetOutput{}
	req.Data = output
	return
}

// Inserts or deletes SqlInjectionMatchTuple objects (filters) in a SqlInjectionMatchSet.
// For each SqlInjectionMatchTuple object, you specify the following values:
//
//  Action: Whether to insert the object into or delete the object from the
// array. To change a SqlInjectionMatchTuple, you delete the existing object
// and add a new one. FieldToMatch: The part of web requests that you want AWS
// WAF to inspect and, if you want AWS WAF to inspect a header, the name of
// the header. TextTransformation: Which text transformation, if any, to perform
// on the web request before inspecting the request for snippets of malicious
// SQL code.  You use SqlInjectionMatchSet objects to specify which CloudFront
// requests you want to allow, block, or count. For example, if you're receiving
// requests that contain snippets of SQL code in the query string and you want
// to block the requests, you can create a SqlInjectionMatchSet with the applicable
// settings, and then configure AWS WAF to block the requests.
//
// To create and configure a SqlInjectionMatchSet, perform the following steps:
//
//  Submit a CreateSqlInjectionMatchSet request. Use GetChangeToken to get
// the change token that you provide in the ChangeToken parameter of an UpdateIPSet
// request. Submit an UpdateSqlInjectionMatchSet request to specify the parts
// of web requests that you want AWS WAF to inspect for snippets of SQL code.
//  For more information about how to use the AWS WAF API to allow or block
// HTTP requests, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
func (c *WAF) UpdateSqlInjectionMatchSet(input *UpdateSqlInjectionMatchSetInput) (*UpdateSqlInjectionMatchSetOutput, error) {
	req, out := c.UpdateSqlInjectionMatchSetRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateWebACL = "UpdateWebACL"

// UpdateWebACLRequest generates a request for the UpdateWebACL operation.
func (c *WAF) UpdateWebACLRequest(input *UpdateWebACLInput) (req *request.Request, output *UpdateWebACLOutput) {
	op := &request.Operation{
		Name:       opUpdateWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWebACLInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateWebACLOutput{}
	req.Data = output
	return
}

// Inserts or deletes ActivatedRule objects in a WebACL. Each Rule identifies
// web requests that you want to allow, block, or count. When you update a WebACL,
// you specify the following values:
//
//  A default action for the WebACL, either ALLOW or BLOCK. AWS WAF performs
// the default action if a request doesn't match the criteria in any of the
// Rules in a WebACL. The Rules that you want to add and/or delete. If you want
// to replace one Rule with another, you delete the existing Rule and add the
// new one. For each Rule, whether you want AWS WAF to allow requests, block
// requests, or count requests that match the conditions in the Rule. The order
// in which you want AWS WAF to evaluate the Rules in a WebACL. If you add more
// than one Rule to a WebACL, AWS WAF evaluates each request against the Rules
// in order based on the value of Priority. (The Rule that has the lowest value
// for Priority is evaluated first.) When a web request matches all of the predicates
// (such as ByteMatchSets and IPSets) in a Rule, AWS WAF immediately takes the
// corresponding action, allow or block, and doesn't evaluate the request against
// the remaining Rules in the WebACL, if any.  The CloudFront distribution that
// you want to associate with the WebACL.  To create and configure a WebACL,
// perform the following steps:
//
//  Create and update the predicates that you want to include in Rules. For
// more information, see CreateByteMatchSet, UpdateByteMatchSet, CreateIPSet,
// UpdateIPSet, CreateSqlInjectionMatchSet, and UpdateSqlInjectionMatchSet.
// Create and update the Rules that you want to include in the WebACL. For more
// information, see CreateRule and UpdateRule. Create a WebACL. See CreateWebACL.
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateWebACL request. Submit an UpdateWebACL request to specify
// the Rules that you want to include in the WebACL, to specify the default
// action, and to associate the WebACL with a CloudFront distribution.   For
// more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
func (c *WAF) UpdateWebACL(input *UpdateWebACLInput) (*UpdateWebACLOutput, error) {
	req, out := c.UpdateWebACLRequest(input)
	err := req.Send()
	return out, err
}

// The ActivatedRule object in an UpdateWebACL request specifies a Rule that
// you want to insert or delete, the priority of the Rule in the WebACL, and
// the action that you want AWS WAF to take when a web request matches the Rule
// (ALLOW, BLOCK, or COUNT).
//
// To specify whether to insert or delete a Rule, use the Action parameter
// in the WebACLUpdate data type.
type ActivatedRule struct {
	_ struct{} `type:"structure"`

	// Specifies the action that CloudFront or AWS WAF takes when a web request
	// matches the conditions in the Rule. Valid values for Action include the following:
	//
	//  ALLOW: CloudFront responds with the requested object. BLOCK: CloudFront
	// responds with an HTTP 403 (Forbidden) status code. COUNT: AWS WAF increments
	// a counter of requests that match the conditions in the rule and then continues
	// to inspect the web request based on the remaining rules in the web ACL.
	Action *WafAction `type:"structure" required:"true"`

	// Specifies the order in which the Rules in a WebACL are evaluated. Rules with
	// a lower value for Priority are evaluated before Rules with a higher value.
	// The value must be a unique integer. If you add multiple Rules to a WebACL,
	// the values don't need to be consecutive.
	Priority *int64 `type:"integer" required:"true"`

	// The RuleId for a Rule. You use RuleId to get more information about a Rule
	// (see GetRule), update a Rule (see UpdateRule), insert a Rule into a WebACL
	// or delete a one from a WebACL (see UpdateWebACL), or delete a Rule from AWS
	// WAF (see DeleteRule).
	//
	// RuleId is returned by CreateRule and by ListRules.
	RuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ActivatedRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivatedRule) GoString() string {
	return s.String()
}

// In a GetByteMatchSet request, ByteMatchSet is a complex type that contains
// the ByteMatchSetId and Name of a ByteMatchSet, and the values that you specified
// when you updated the ByteMatchSet.
//
// A complex type that contains ByteMatchTuple objects, which specify the parts
// of web requests that you want AWS WAF to inspect and the values that you
// want AWS WAF to search for. If a ByteMatchSet contains more than one ByteMatchTuple
// object, a request needs to match the settings in only one ByteMatchTuple
// to be considered a match.
type ByteMatchSet struct {
	_ struct{} `type:"structure"`

	// The ByteMatchSetId for a ByteMatchSet. You use ByteMatchSetId to get information
	// about a ByteMatchSet (see GetByteMatchSet), update a ByteMatchSet (see UpdateByteMatchSet,
	// insert a ByteMatchSet into a Rule or delete one from a Rule (see UpdateRule),
	// and delete a ByteMatchSet from AWS WAF (see DeleteByteMatchSet).
	//
	// ByteMatchSetId is returned by CreateByteMatchSet and by ListByteMatchSets.
	ByteMatchSetId *string `min:"1" type:"string" required:"true"`

	// Specifies the bytes (typically a string that corresponds with ASCII characters)
	// that you want AWS WAF to search for in web requests, the location in requests
	// that you want AWS WAF to search, and other settings.
	ByteMatchTuples []*ByteMatchTuple `type:"list" required:"true"`

	// A friendly name or description of the ByteMatchSet. You can't change Name
	// after you create a ByteMatchSet.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ByteMatchSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ByteMatchSet) GoString() string {
	return s.String()
}

// Returned by ListByteMatchSets. Each ByteMatchSetSummary object includes the
// Name and ByteMatchSetId for one ByteMatchSet.
type ByteMatchSetSummary struct {
	_ struct{} `type:"structure"`

	// The ByteMatchSetId for a ByteMatchSet. You use ByteMatchSetId to get information
	// about a ByteMatchSet, update a ByteMatchSet, remove a ByteMatchSet from a
	// Rule, and delete a ByteMatchSet from AWS WAF.
	//
	// ByteMatchSetId is returned by CreateByteMatchSet and by ListByteMatchSets.
	ByteMatchSetId *string `min:"1" type:"string" required:"true"`

	// A friendly name or description of the ByteMatchSet. You can't change Name
	// after you create a ByteMatchSet.
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ByteMatchSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ByteMatchSetSummary) GoString() string {
	return s.String()
}

// In an UpdateByteMatchSet request, ByteMatchSetUpdate specifies whether to
// insert or delete a ByteMatchTuple and includes the settings for the ByteMatchTuple.
type ByteMatchSetUpdate struct {
	_ struct{} `type:"structure"`

	// Specifies whether to insert or delete a ByteMatchTuple.
	Action *string `type:"string" required:"true" enum:"ChangeAction"`

	// Information about the part of a web request that you want AWS WAF to inspect
	// and the value that you want AWS WAF to search for. If you specify DELETE
	// for the value of Action, the ByteMatchTuple values must exactly match the
	// values in the ByteMatchTuple that you want to delete from the ByteMatchSet.
	ByteMatchTuple *ByteMatchTuple `type:"structure" required:"true"`
}

// String returns the string representation
func (s ByteMatchSetUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ByteMatchSetUpdate) GoString() string {
	return s.String()
}

// The bytes (typically a string that corresponds with ASCII characters) that
// you want AWS WAF to search for in web requests, the location in requests
// that you want AWS WAF to search, and other settings.
type ByteMatchTuple struct {
	_ struct{} `type:"structure"`

	// The part of a web request that you want AWS WAF to search, such as a specified
	// header or a query string. For more information, see FieldToMatch.
	FieldToMatch *FieldToMatch `type:"structure" required:"true"`

	// Within the portion of a web request that you want to search (for example,
	// in the query string, if any), specify where you want AWS WAF to search. Valid
	// values include the following:
	//
	// CONTAINS
	//
	// The specified part of the web request must include the value of TargetString,
	// but the location doesn't matter.
	//
	// CONTAINS_WORD
	//
	// The specified part of the web request must include the value of TargetString,
	// and TargetString must contain only alphanumeric characters or underscore
	// (A-Z, a-z, 0-9, or _). In addition, TargetString must be a word, which means
	// one of the following:
	//
	//  TargetString exactly matches the value of the specified part of the web
	// request, such as the value of a header. TargetString is at the beginning
	// of the specified part of the web request and is followed by a character other
	// than an alphanumeric character or underscore (_), for example, BadBot;. TargetString
	// is at the end of the specified part of the web request and is preceded by
	// a character other than an alphanumeric character or underscore (_), for example,
	// ;BadBot. TargetString is in the middle of the specified part of the web request
	// and is preceded and followed by characters other than alphanumeric characters
	// or underscore (_), for example, -BadBot;.  EXACTLY
	//
	// The value of the specified part of the web request must exactly match the
	// value of TargetString.
	//
	// STARTS_WITH
	//
	// The value of TargetString must appear at the beginning of the specified
	// part of the web request.
	//
	// ENDS_WITH
	//
	// The value of TargetString must appear at the end of the specified part of
	// the web request.
	PositionalConstraint *string `type:"string" required:"true" enum:"PositionalConstraint"`

	// The value that you want AWS WAF to search for. AWS WAF searches for the specified
	// string in the part of web requests that you specified in FieldToMatch. The
	// maximum length of the value is 50 bytes.
	//
	// Valid values depend on the values that you specified for FieldToMatch:
	//
	//  HEADER: The value that you want AWS WAF to search for in the request header
	// that you specified in FieldToMatch, for example, the value of the User-Agent
	// or Referer header. METHOD: The HTTP method, which indicates the type of operation
	// specified in the request. CloudFront supports the following methods: DELETE,
	// GET, HEAD, OPTIONS, PATCH, POST, and PUT. QUERY_STRING: The value that you
	// want AWS WAF to search for in the query string, which is the part of a URL
	// that appears after a ? character. URI: The value that you want AWS WAF to
	// search for in the part of a URL that identifies a resource, for example,
	// /images/daily-ad.jpg. BODY: The part of a request that contains any additional
	// data that you want to send to your web server as the HTTP request body, such
	// as data from a form. The request body immediately follows the request headers.
	// Note that only the first 8192 bytes of the request body are forwarded to
	// AWS WAF for inspection. To allow or block requests based on the length of
	// the body, you can create a size constraint set. For more information, see
	// CreateSizeConstraintSet.   If TargetString includes alphabetic characters
	// A-Z and a-z, note that the value is case sensitive.
	//
	// If you're using the AWS WAF API
	//
	// Specify a base64-encoded version of the value. The maximum length of the
	// value before you base64-encode it is 50 bytes.
	//
	// For example, suppose the value of Type is HEADER and the value of Data is
	// User-Agent. If you want to search the User-Agent header for the value BadBot,
	// you base64-encode BadBot using MIME base64 encoding and include the resulting
	// value, QmFkQm90, in the value of TargetString.
	//
	// If you're using the AWS CLI or one of the AWS SDKs
	//
	// The value that you want AWS WAF to search for. The SDK automatically base64
	// encodes the value.
	//
	// TargetString is automatically base64 encoded/decoded by the SDK.
	TargetString []byte `type:"blob" required:"true"`

	// Text transformations eliminate some of the unusual formatting that attackers
	// use in web requests in an effort to bypass AWS WAF. If you specify a transformation,
	// AWS WAF performs the transformation on TargetString before inspecting a request
	// for a match.
	//
	// CMD_LINE
	//
	// When you're concerned that attackers are injecting an operating system commandline
	// command and using unusual formatting to disguise some or all of the command,
	// use this option to perform the following transformations:
	//
	//  Delete the following characters: \ " ' ^ Delete spaces before the following
	// characters: / ( Replace the following characters with a space: , ; Replace
	// multiple spaces with one space Convert uppercase letters (A-Z) to lowercase
	// (a-z)  COMPRESS_WHITE_SPACE
	//
	// Use this option to replace the following characters with a space character
	// (decimal 32):
	//
	//  \f, formfeed, decimal 12 \t, tab, decimal 9 \n, newline, decimal 10 \r,
	// carriage return, decimal 13 \v, vertical tab, decimal 11 non-breaking space,
	// decimal 160  COMPRESS_WHITE_SPACE also replaces multiple spaces with one
	// space.
	//
	// HTML_ENTITY_DECODE
	//
	// Use this option to replace HTML-encoded characters with unencoded characters.
	// HTML_ENTITY_DECODE performs the following operations:
	//
	//  Replaces (ampersand)quot; with " Replaces (ampersand)nbsp; with a non-breaking
	// space, decimal 160 Replaces (ampersand)lt; with a "less than" symbol Replaces
	// (ampersand)gt; with > Replaces characters that are represented in hexadecimal
	// format, (ampersand)#xhhhh;, with the corresponding characters Replaces characters
	// that are represented in decimal format, (ampersand)#nnnn;, with the corresponding
	// characters  LOWERCASE
	//
	// Use this option to convert uppercase letters (A-Z) to lowercase (a-z).
	//
	// URL_DECODE
	//
	// Use this option to decode a URL-encoded value.
	//
	// NONE
	//
	// Specify NONE if you don't want to perform any text transformations.
	TextTransformation *string `type:"string" required:"true" enum:"TextTransformation"`
}

// String returns the string representation
func (s ByteMatchTuple) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ByteMatchTuple) GoString() string {
	return s.String()
}

type CreateByteMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	ChangeToken *string `type:"string" required:"true"`

	// A friendly name or description of the ByteMatchSet. You can't change Name
	// after you create a ByteMatchSet.
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateByteMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateByteMatchSetInput) GoString() string {
	return s.String()
}

type CreateByteMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// A ByteMatchSet that contains no ByteMatchTuple objects.
	ByteMatchSet *ByteMatchSet `type:"structure"`

	// The ChangeToken that you used to submit the CreateByteMatchSet request. You
	// can also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `type:"string"`
}

// String returns the string representation
func (s CreateByteMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateByteMatchSetOutput) GoString() string {
	return s.String()
}

type CreateIPSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	ChangeToken *string `type:"string" required:"true"`

	// A friendly name or description of the IPSet. You can't change Name after
	// you create the IPSet.
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateIPSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIPSetInput) GoString() string {
	return s.String()
}

type CreateIPSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the CreateIPSet request. You can
	// also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `type:"string"`

	// The IPSet returned in the CreateIPSet response.
	IPSet *IPSet `type:"structure"`
}

// String returns the string representation
func (s CreateIPSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIPSetOutput) GoString() string {
	return s.String()
}

type CreateRuleInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	ChangeToken *string `type:"string" required:"true"`

	// A friendly name or description for the metrics for this Rule. The name can
	// contain only alphanumeric characters (A-Z, a-z, 0-9); the name can't contain
	// whitespace. You can't change the name of the metric after you create the
	// Rule.
	MetricName *string `type:"string" required:"true"`

	// A friendly name or description of the Rule. You can't change the name of
	// a Rule after you create it.
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRuleInput) GoString() string {
	return s.String()
}

type CreateRuleOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the CreateRule request. You can also
	// use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `type:"string"`

	// The Rule returned in the CreateRule response.
	Rule *Rule `type:"structure"`
}

// String returns the string representation
func (s CreateRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRuleOutput) GoString() string {
	return s.String()
}

type CreateSizeConstraintSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	ChangeToken *string `type:"string" required:"true"`

	// A friendly name or description of the SizeConstraintSet. You can't change
	// Name after you create a SizeConstraintSet.
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSizeConstraintSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSizeConstraintSetInput) GoString() string {
	return s.String()
}

type CreateSizeConstraintSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the CreateSizeConstraintSet request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `type:"string"`

	// A SizeConstraintSet that contains no SizeConstraint objects.
	SizeConstraintSet *SizeConstraintSet `type:"structure"`
}

// String returns the string representation
func (s CreateSizeConstraintSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSizeConstraintSetOutput) GoString() string {
	return s.String()
}

// A request to create a SqlInjectionMatchSet.
type CreateSqlInjectionMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	ChangeToken *string `type:"string" required:"true"`

	// A friendly name or description for the SqlInjectionMatchSet that you're creating.
	// You can't change Name after you create the SqlInjectionMatchSet.
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSqlInjectionMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSqlInjectionMatchSetInput) GoString() string {
	return s.String()
}

// The response to a CreateSqlInjectionMatchSet request.
type CreateSqlInjectionMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the CreateSqlInjectionMatchSet request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `type:"string"`

	// A SqlInjectionMatchSet.
	SqlInjectionMatchSet *SqlInjectionMatchSet `type:"structure"`
}

// String returns the string representation
func (s CreateSqlInjectionMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSqlInjectionMatchSetOutput) GoString() string {
	return s.String()
}

type CreateWebACLInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	ChangeToken *string `type:"string" required:"true"`

	// The action that you want AWS WAF to take when a request doesn't match the
	// criteria specified in any of the Rule objects that are associated with the
	// WebACL.
	DefaultAction *WafAction `type:"structure" required:"true"`

	// A friendly name or description for the metrics for this WebACL. The name
	// can contain only alphanumeric characters (A-Z, a-z, 0-9); the name can't
	// contain whitespace. You can't change MetricName after you create the WebACL.
	MetricName *string `type:"string" required:"true"`

	// A friendly name or description of the WebACL. You can't change Name after
	// you create the WebACL.
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWebACLInput) GoString() string {
	return s.String()
}

type CreateWebACLOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the CreateWebACL request. You can
	// also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `type:"string"`

	// The WebACL returned in the CreateWebACL response.
	WebACL *WebACL `type:"structure"`
}

// String returns the string representation
func (s CreateWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWebACLOutput) GoString() string {
	return s.String()
}

type DeleteByteMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The ByteMatchSetId of the ByteMatchSet that you want to delete. ByteMatchSetId
	// is returned by CreateByteMatchSet and by ListByteMatchSets.
	ByteMatchSetId *string `min:"1" type:"string" required:"true"`

	// The value returned by the most recent call to GetChangeToken.
	ChangeToken *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteByteMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteByteMatchSetInput) GoString() string {
	return s.String()
}

type DeleteByteMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteByteMatchSet request. You
	// can also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `type:"string"`
}

// String returns the string representation
func (s DeleteByteMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteByteMatchSetOutput) GoString() string {
	return s.String()
}

type DeleteIPSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	ChangeToken *string `type:"string" required:"true"`

	// The IPSetId of the IPSet that you want to delete. IPSetId is returned by
	// CreateIPSet and by ListIPSets.
	IPSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIPSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIPSetInput) GoString() string {
	return s.String()
}

type DeleteIPSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteIPSet request. You can
	// also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `type:"string"`
}

// String returns the string representation
func (s DeleteIPSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIPSetOutput) GoString() string {
	return s.String()
}

type DeleteRuleInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	ChangeToken *string `type:"string" required:"true"`

	// The RuleId of the Rule that you want to delete. RuleId is returned by CreateRule
	// and by ListRules.
	RuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRuleInput) GoString() string {
	return s.String()
}

type DeleteRuleOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteRule request. You can also
	// use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `type:"string"`
}

// String returns the string representation
func (s DeleteRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRuleOutput) GoString() string {
	return s.String()
}

type DeleteSizeConstraintSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	ChangeToken *string `type:"string" required:"true"`

	// The SizeConstraintSetId of the SizeConstraintSet that you want to delete.
	// SizeConstraintSetId is returned by CreateSizeConstraintSet and by ListSizeConstraintSets.
	SizeConstraintSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSizeConstraintSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSizeConstraintSetInput) GoString() string {
	return s.String()
}

type DeleteSizeConstraintSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteSizeConstraintSet request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `type:"string"`
}

// String returns the string representation
func (s DeleteSizeConstraintSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSizeConstraintSetOutput) GoString() string {
	return s.String()
}

// A request to delete a SqlInjectionMatchSet from AWS WAF.
type DeleteSqlInjectionMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	ChangeToken *string `type:"string" required:"true"`

	// The SqlInjectionMatchSetId of the SqlInjectionMatchSet that you want to delete.
	// SqlInjectionMatchSetId is returned by CreateSqlInjectionMatchSet and by ListSqlInjectionMatchSets.
	SqlInjectionMatchSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSqlInjectionMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSqlInjectionMatchSetInput) GoString() string {
	return s.String()
}

// The response to a request to delete a SqlInjectionMatchSet from AWS WAF.
type DeleteSqlInjectionMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteSqlInjectionMatchSet request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `type:"string"`
}

// String returns the string representation
func (s DeleteSqlInjectionMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSqlInjectionMatchSetOutput) GoString() string {
	return s.String()
}

type DeleteWebACLInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	ChangeToken *string `type:"string" required:"true"`

	// The WebACLId of the WebACL that you want to delete. WebACLId is returned
	// by CreateWebACL and by ListWebACLs.
	WebACLId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWebACLInput) GoString() string {
	return s.String()
}

type DeleteWebACLOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteWebACL request. You can
	// also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `type:"string"`
}

// String returns the string representation
func (s DeleteWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWebACLOutput) GoString() string {
	return s.String()
}

// Specifies where in a web request to look for TargetString.
type FieldToMatch struct {
	_ struct{} `type:"structure"`

	// When the value of Type is HEADER, enter the name of the header that you want
	// AWS WAF to search, for example, User-Agent or Referer. If the value of Type
	// is any other value, omit Data.
	//
	// The name of the header is not case sensitive.
	Data *string `type:"string"`

	// The part of the web request that you want AWS WAF to search for a specified
	// string. Parts of a request that you can search include the following:
	//
	//  HEADER: A specified request header, for example, the value of the User-Agent
	// or Referer header. If you choose HEADER for the type, specify the name of
	// the header in Data. METHOD: The HTTP method, which indicated the type of
	// operation that the request is asking the origin to perform. Amazon CloudFront
	// supports the following methods: DELETE, GET, HEAD, OPTIONS, PATCH, POST,
	// and PUT. QUERY_STRING: A query string, which is the part of a URL that appears
	// after a ? character, if any. URI: The part of a web request that identifies
	// a resource, for example, /images/daily-ad.jpg. BODY: The part of a request
	// that contains any additional data that you want to send to your web server
	// as the HTTP request body, such as data from a form. The request body immediately
	// follows the request headers. Note that only the first 8192 bytes of the request
	// body are forwarded to AWS WAF for inspection. To allow or block requests
	// based on the length of the body, you can create a size constraint set. For
	// more information, see CreateSizeConstraintSet.
	Type *string `type:"string" required:"true" enum:"MatchFieldType"`
}

// String returns the string representation
func (s FieldToMatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldToMatch) GoString() string {
	return s.String()
}

type GetByteMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The ByteMatchSetId of the ByteMatchSet that you want to get. ByteMatchSetId
	// is returned by CreateByteMatchSet and by ListByteMatchSets.
	ByteMatchSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetByteMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetByteMatchSetInput) GoString() string {
	return s.String()
}

type GetByteMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the ByteMatchSet that you specified in the GetByteMatchSet
	// request. For more information, see the following topics:
	//
	//  ByteMatchSet: Contains ByteMatchSetId, ByteMatchTuples, and Name ByteMatchTuples:
	// Contains an array of ByteMatchTuple objects. Each ByteMatchTuple object contains
	// FieldToMatch, PositionalConstraint, TargetString, and TextTransformation
	// FieldToMatch: Contains Data and Type
	ByteMatchSet *ByteMatchSet `type:"structure"`
}

// String returns the string representation
func (s GetByteMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetByteMatchSetOutput) GoString() string {
	return s.String()
}

type GetChangeTokenInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetChangeTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeTokenInput) GoString() string {
	return s.String()
}

type GetChangeTokenOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used in the request. Use this value in a GetChangeTokenStatus
	// request to get the current status of the request.
	ChangeToken *string `type:"string"`
}

// String returns the string representation
func (s GetChangeTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeTokenOutput) GoString() string {
	return s.String()
}

type GetChangeTokenStatusInput struct {
	_ struct{} `type:"structure"`

	// The change token for which you want to get the status. This change token
	// was previously returned in the GetChangeToken response.
	ChangeToken *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetChangeTokenStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeTokenStatusInput) GoString() string {
	return s.String()
}

type GetChangeTokenStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status of the change token.
	ChangeTokenStatus *string `type:"string" enum:"ChangeTokenStatus"`
}

// String returns the string representation
func (s GetChangeTokenStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeTokenStatusOutput) GoString() string {
	return s.String()
}

type GetIPSetInput struct {
	_ struct{} `type:"structure"`

	// The IPSetId of the IPSet that you want to get. IPSetId is returned by CreateIPSet
	// and by ListIPSets.
	IPSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetIPSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIPSetInput) GoString() string {
	return s.String()
}

type GetIPSetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the IPSet that you specified in the GetIPSet request. For
	// more information, see the following topics:
	//
	//  IPSet: Contains IPSetDescriptors, IPSetId, and Name IPSetDescriptors: Contains
	// an array of IPSetDescriptor objects. Each IPSetDescriptor object contains
	// Type and Value
	IPSet *IPSet `type:"structure"`
}

// String returns the string representation
func (s GetIPSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIPSetOutput) GoString() string {
	return s.String()
}

type GetRuleInput struct {
	_ struct{} `type:"structure"`

	// The RuleId of the Rule that you want to get. RuleId is returned by CreateRule
	// and by ListRules.
	RuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRuleInput) GoString() string {
	return s.String()
}

type GetRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Rule that you specified in the GetRule request. For
	// more information, see the following topics:
	//
	//  Rule: Contains MetricName, Name, an array of Predicate objects, and RuleId
	// Predicate: Each Predicate object contains DataId, Negated, and Type
	Rule *Rule `type:"structure"`
}

// String returns the string representation
func (s GetRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRuleOutput) GoString() string {
	return s.String()
}

type GetSampledRequestsInput struct {
	_ struct{} `type:"structure"`

	// The number of requests that you want AWS WAF to return from among the first
	// 5,000 requests that your AWS resource received during the time range. If
	// your resource received fewer requests than the value of MaxItems, GetSampledRequests
	// returns information about all of them.
	MaxItems *int64 `min:"1" type:"long" required:"true"`

	// RuleId is one of two values:
	//
	//  The RuleId of the Rule for which you want GetSampledRequests to return
	// a sample of requests. Default_Action, which causes GetSampledRequests to
	// return a sample of the requests that didn't match any of the rules in the
	// specified WebACL.
	RuleId *string `min:"1" type:"string" required:"true"`

	// The start date and time and the end date and time of the range for which
	// you want GetSampledRequests to return a sample of requests. Specify the date
	// and time in Unix time format (in seconds). You can specify any time range
	// in the previous three hours.
	TimeWindow *TimeWindow `type:"structure" required:"true"`

	// The WebACLId of the WebACL for which you want GetSampledRequests to return
	// a sample of requests.
	WebAclId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSampledRequestsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSampledRequestsInput) GoString() string {
	return s.String()
}

type GetSampledRequestsOutput struct {
	_ struct{} `type:"structure"`

	// The total number of requests from which GetSampledRequests got a sample of
	// MaxItems requests. If PopulationSize is less than MaxItems, the sample includes
	// every request that your AWS resource received during the specified time range.
	PopulationSize *int64 `type:"long"`

	// A complex type that contains detailed information about each of the requests
	// in the sample.
	SampledRequests []*SampledHTTPRequest `type:"list"`

	// Usually, TimeWindow is the time range that you specified in the GetSampledRequests
	// request. However, if your AWS resource received more than 5,000 requests
	// during the time range that you specified in the request, GetSampledRequests
	// returns the time range for the first 5,000 requests.
	TimeWindow *TimeWindow `type:"structure"`
}

// String returns the string representation
func (s GetSampledRequestsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSampledRequestsOutput) GoString() string {
	return s.String()
}

type GetSizeConstraintSetInput struct {
	_ struct{} `type:"structure"`

	// The SizeConstraintSetId of the SizeConstraintSet that you want to get. SizeConstraintSetId
	// is returned by CreateSizeConstraintSet and by ListSizeConstraintSets.
	SizeConstraintSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSizeConstraintSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSizeConstraintSetInput) GoString() string {
	return s.String()
}

type GetSizeConstraintSetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the SizeConstraintSet that you specified in the GetSizeConstraintSet
	// request. For more information, see the following topics:
	//
	//  SizeConstraintSet: Contains SizeConstraintSetId, SizeConstraints, and Name
	// SizeConstraints: Contains an array of SizeConstraint objects. Each SizeConstraint
	// object contains FieldToMatch, TextTransformation, ComparisonOperator, and
	// Size FieldToMatch: Contains Data and Type
	SizeConstraintSet *SizeConstraintSet `type:"structure"`
}

// String returns the string representation
func (s GetSizeConstraintSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSizeConstraintSetOutput) GoString() string {
	return s.String()
}

// A request to get a SqlInjectionMatchSet.
type GetSqlInjectionMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The SqlInjectionMatchSetId of the SqlInjectionMatchSet that you want to get.
	// SqlInjectionMatchSetId is returned by CreateSqlInjectionMatchSet and by ListSqlInjectionMatchSets.
	SqlInjectionMatchSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSqlInjectionMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSqlInjectionMatchSetInput) GoString() string {
	return s.String()
}

// The response to a GetSqlInjectionMatchSet request.
type GetSqlInjectionMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the SqlInjectionMatchSet that you specified in the GetSqlInjectionMatchSet
	// request. For more information, see the following topics:
	//
	//  SqlInjectionMatchSet: Contains Name, SqlInjectionMatchSetId, and an array
	// of SqlInjectionMatchTuple objects SqlInjectionMatchTuple: Each SqlInjectionMatchTuple
	// object contains FieldToMatch and TextTransformation FieldToMatch: Contains
	// Data and Type
	SqlInjectionMatchSet *SqlInjectionMatchSet `type:"structure"`
}

// String returns the string representation
func (s GetSqlInjectionMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSqlInjectionMatchSetOutput) GoString() string {
	return s.String()
}

type GetWebACLInput struct {
	_ struct{} `type:"structure"`

	// The WebACLId of the WebACL that you want to get. WebACLId is returned by
	// CreateWebACL and by ListWebACLs.
	WebACLId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWebACLInput) GoString() string {
	return s.String()
}

type GetWebACLOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WebACL that you specified in the GetWebACL request.
	// For more information, see the following topics:
	//
	//  WebACL: Contains DefaultAction, MetricName, Name, an array of Rule objects,
	// and WebACLId DefaultAction (Data type is WafAction): Contains Type Rules:
	// Contains an array of ActivatedRule objects, which contain Action, Priority,
	// and RuleId Action: Contains Type
	WebACL *WebACL `type:"structure"`
}

// String returns the string representation
func (s GetWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWebACLOutput) GoString() string {
	return s.String()
}

// The response from a GetSampledRequests request includes an HTTPHeader complex
// type that appears as Headers in the response syntax. HTTPHeader contains
// the names and values of all of the headers that appear in one of the web
// requests that were returned by GetSampledRequests.
type HTTPHeader struct {
	_ struct{} `type:"structure"`

	// The name of one of the headers in the sampled web request.
	Name *string `type:"string"`

	// The value of one of the headers in the sampled web request.
	Value *string `type:"string"`
}

// String returns the string representation
func (s HTTPHeader) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HTTPHeader) GoString() string {
	return s.String()
}

// The response from a GetSampledRequests request includes an HTTPRequest complex
// type that appears as Request in the response syntax. HTTPRequest contains
// information about one of the web requests that were returned by GetSampledRequests.
type HTTPRequest struct {
	_ struct{} `type:"structure"`

	// The IP address that the request originated from. If the WebACL is associated
	// with a CloudFront distribution, this is the value of one of the following
	// fields in CloudFront access logs:
	//
	//  c-ip, if the viewer did not use an HTTP proxy or a load balancer to send
	// the request x-forwarded-for, if the viewer did use an HTTP proxy or a load
	// balancer to send the request
	ClientIP *string `type:"string"`

	// The two-letter country code for the country that the request originated from.
	// For a current list of country codes, see the Wikipedia entry ISO 3166-1 alpha-2
	// (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
	Country *string `type:"string"`

	// The HTTP version specified in the sampled web request, for example, HTTP/1.1.
	HTTPVersion *string `type:"string"`

	// A complex type that contains two values for each header in the sampled web
	// request: the name of the header and the value of the header.
	Headers []*HTTPHeader `type:"list"`

	// The HTTP method specified in the sampled web request. CloudFront supports
	// the following methods: DELETE, GET, HEAD, OPTIONS, PATCH, POST, and PUT.
	Method *string `type:"string"`

	// The part of a web request that identifies the resource, for example, /images/daily-ad.jpg.
	URI *string `type:"string"`
}

// String returns the string representation
func (s HTTPRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HTTPRequest) GoString() string {
	return s.String()
}

// Contains one or more IP addresses or blocks of IP addresses specified in
// Classless Inter-Domain Routing (CIDR) notation. To specify an individual
// IP address, you specify the four-part IP address followed by a /32, for example,
// 192.0.2.0/31. To block a range of IP addresses, you can specify a /24, a
// /16, or a /8 CIDR. For more information about CIDR notation, perform an Internet
// search on cidr notation.
type IPSet struct {
	_ struct{} `type:"structure"`

	// The IP address type (IPV4) and the IP address range (in CIDR notation) that
	// web requests originate from. If the WebACL is associated with a CloudFront
	// distribution, this is the value of one of the following fields in CloudFront
	// access logs:
	//
	//  c-ip, if the viewer did not use an HTTP proxy or a load balancer to send
	// the request x-forwarded-for, if the viewer did use an HTTP proxy or a load
	// balancer to send the request
	IPSetDescriptors []*IPSetDescriptor `type:"list" required:"true"`

	// The IPSetId for an IPSet. You use IPSetId to get information about an IPSet
	// (see GetIPSet), update an IPSet (see UpdateIPSet), insert an IPSet into a
	// Rule or delete one from a Rule (see UpdateRule), and delete an IPSet from
	// AWS WAF (see DeleteIPSet).
	//
	// IPSetId is returned by CreateIPSet and by ListIPSets.
	IPSetId *string `min:"1" type:"string" required:"true"`

	// A friendly name or description of the IPSet. You can't change the name of
	// an IPSet after you create it.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s IPSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IPSet) GoString() string {
	return s.String()
}

// Specifies the IP address type (IPV4) and the IP address range (in CIDR format)
// that web requests originate from.
type IPSetDescriptor struct {
	_ struct{} `type:"structure"`

	// Specify IPV4.
	Type *string `type:"string" required:"true" enum:"IPSetDescriptorType"`

	// Specify an IPv4 address by using CIDR notation. For example:
	//
	//  To configure AWS WAF to allow, block, or count requests that originated
	// from the IP address 192.0.2.44, specify 192.0.2.44/32. To configure AWS WAF
	// to allow, block, or count requests that originated from IP addresses from
	// 192.0.2.0 to 192.0.2.255, specify 192.0.2.0/24.  AWS WAF supports only /8,
	// /16, /24, and /32 IP addresses.
	//
	// For more information about CIDR notation, see the Wikipedia entry Classless
	// Inter-Domain Routing (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s IPSetDescriptor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IPSetDescriptor) GoString() string {
	return s.String()
}

// Contains the identifier and the name of the IPSet.
type IPSetSummary struct {
	_ struct{} `type:"structure"`

	// The IPSetId for an IPSet. You can use IPSetId in a GetIPSet request to get
	// detailed information about an IPSet.
	IPSetId *string `min:"1" type:"string" required:"true"`

	// A friendly name or description of the IPSet. You can't change the name of
	// an IPSet after you create it.
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s IPSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IPSetSummary) GoString() string {
	return s.String()
}

// Specifies the type of update to perform to an IPSet with UpdateIPSet.
type IPSetUpdate struct {
	_ struct{} `type:"structure"`

	// Specifies whether to insert or delete an IP address with UpdateIPSet.
	Action *string `type:"string" required:"true" enum:"ChangeAction"`

	// The IP address type (IPV4) and the IP address range (in CIDR notation) that
	// web requests originate from.
	IPSetDescriptor *IPSetDescriptor `type:"structure" required:"true"`
}

// String returns the string representation
func (s IPSetUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IPSetUpdate) GoString() string {
	return s.String()
}

type ListByteMatchSetsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of ByteMatchSet objects that you want AWS WAF to return
	// for this request. If you have more ByteMatchSets objects than the number
	// you specify for Limit, the response includes a NextMarker value that you
	// can use to get another batch of ByteMatchSet objects.
	Limit *int64 `min:"1" type:"integer" required:"true"`

	// If you specify a value for Limit and you have more ByteMatchSets than the
	// value of Limit, AWS WAF returns a NextMarker value in the response that allows
	// you to list another group of ByteMatchSets. For the second and subsequent
	// ListByteMatchSets requests, specify the value of NextMarker from the previous
	// response to get information about another batch of ByteMatchSets.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListByteMatchSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListByteMatchSetsInput) GoString() string {
	return s.String()
}

type ListByteMatchSetsOutput struct {
	_ struct{} `type:"structure"`

	// An array of ByteMatchSetSummary objects.
	ByteMatchSets []*ByteMatchSetSummary `type:"list"`

	// If you have more ByteMatchSet objects than the number that you specified
	// for Limit in the request, the response includes a NextMarker value. To list
	// more ByteMatchSet objects, submit another ListByteMatchSets request, and
	// specify the NextMarker value from the response in the NextMarker value in
	// the next request.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListByteMatchSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListByteMatchSetsOutput) GoString() string {
	return s.String()
}

type ListIPSetsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of IPSet objects that you want AWS WAF to return for
	// this request. If you have more IPSet objects than the number you specify
	// for Limit, the response includes a NextMarker value that you can use to get
	// another batch of IPSet objects.
	Limit *int64 `min:"1" type:"integer" required:"true"`

	// If you specify a value for Limit and you have more IPSets than the value
	// of Limit, AWS WAF returns a NextMarker value in the response that allows
	// you to list another group of IPSets. For the second and subsequent ListIPSets
	// requests, specify the value of NextMarker from the previous response to get
	// information about another batch of ByteMatchSets.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListIPSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIPSetsInput) GoString() string {
	return s.String()
}

type ListIPSetsOutput struct {
	_ struct{} `type:"structure"`

	// An array of IPSetSummary objects.
	IPSets []*IPSetSummary `type:"list"`

	// If you have more IPSet objects than the number that you specified for Limit
	// in the request, the response includes a NextMarker value. To list more IPSet
	// objects, submit another ListIPSets request, and specify the NextMarker value
	// from the response in the NextMarker value in the next request.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListIPSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIPSetsOutput) GoString() string {
	return s.String()
}

type ListRulesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of Rules that you want AWS WAF to return for this request.
	// If you have more Rules than the number that you specify for Limit, the response
	// includes a NextMarker value that you can use to get another batch of Rules.
	Limit *int64 `min:"1" type:"integer" required:"true"`

	// If you specify a value for Limit and you have more Rules than the value of
	// Limit, AWS WAF returns a NextMarker value in the response that allows you
	// to list another group of Rules. For the second and subsequent ListRules requests,
	// specify the value of NextMarker from the previous response to get information
	// about another batch of Rules.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRulesInput) GoString() string {
	return s.String()
}

type ListRulesOutput struct {
	_ struct{} `type:"structure"`

	// If you have more Rules than the number that you specified for Limit in the
	// request, the response includes a NextMarker value. To list more Rules, submit
	// another ListRules request, and specify the NextMarker value from the response
	// in the NextMarker value in the next request.
	NextMarker *string `min:"1" type:"string"`

	// An array of RuleSummary objects.
	Rules []*RuleSummary `type:"list"`
}

// String returns the string representation
func (s ListRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRulesOutput) GoString() string {
	return s.String()
}

type ListSizeConstraintSetsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of SizeConstraintSet objects that you want AWS WAF to
	// return for this request. If you have more SizeConstraintSets objects than
	// the number you specify for Limit, the response includes a NextMarker value
	// that you can use to get another batch of SizeConstraintSet objects.
	Limit *int64 `min:"1" type:"integer" required:"true"`

	// If you specify a value for Limit and you have more SizeConstraintSets than
	// the value of Limit, AWS WAF returns a NextMarker value in the response that
	// allows you to list another group of SizeConstraintSets. For the second and
	// subsequent ListSizeConstraintSets requests, specify the value of NextMarker
	// from the previous response to get information about another batch of SizeConstraintSets.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListSizeConstraintSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSizeConstraintSetsInput) GoString() string {
	return s.String()
}

type ListSizeConstraintSetsOutput struct {
	_ struct{} `type:"structure"`

	// If you have more SizeConstraintSet objects than the number that you specified
	// for Limit in the request, the response includes a NextMarker value. To list
	// more SizeConstraintSet objects, submit another ListSizeConstraintSets request,
	// and specify the NextMarker value from the response in the NextMarker value
	// in the next request.
	NextMarker *string `min:"1" type:"string"`

	// An array of SizeConstraintSetSummary objects.
	SizeConstraintSets []*SizeConstraintSetSummary `type:"list"`
}

// String returns the string representation
func (s ListSizeConstraintSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSizeConstraintSetsOutput) GoString() string {
	return s.String()
}

// A request to list the SqlInjectionMatchSet objects created by the current
// AWS account.
type ListSqlInjectionMatchSetsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of SqlInjectionMatchSet objects that you want AWS WAF
	// to return for this request. If you have more SqlInjectionMatchSet objects
	// than the number you specify for Limit, the response includes a NextMarker
	// value that you can use to get another batch of Rules.
	Limit *int64 `min:"1" type:"integer" required:"true"`

	// If you specify a value for Limit and you have more SqlInjectionMatchSet objects
	// than the value of Limit, AWS WAF returns a NextMarker value in the response
	// that allows you to list another group of SqlInjectionMatchSets. For the second
	// and subsequent ListSqlInjectionMatchSets requests, specify the value of NextMarker
	// from the previous response to get information about another batch of SqlInjectionMatchSets.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListSqlInjectionMatchSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSqlInjectionMatchSetsInput) GoString() string {
	return s.String()
}

// The response to a ListSqlInjectionMatchSets request.
type ListSqlInjectionMatchSetsOutput struct {
	_ struct{} `type:"structure"`

	// If you have more SqlInjectionMatchSet objects than the number that you specified
	// for Limit in the request, the response includes a NextMarker value. To list
	// more SqlInjectionMatchSet objects, submit another ListSqlInjectionMatchSets
	// request, and specify the NextMarker value from the response in the NextMarker
	// value in the next request.
	NextMarker *string `min:"1" type:"string"`

	// An array of SqlInjectionMatchSetSummary objects.
	SqlInjectionMatchSets []*SqlInjectionMatchSetSummary `type:"list"`
}

// String returns the string representation
func (s ListSqlInjectionMatchSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSqlInjectionMatchSetsOutput) GoString() string {
	return s.String()
}

type ListWebACLsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of WebACL objects that you want AWS WAF to return for
	// this request. If you have more WebACL objects than the number that you specify
	// for Limit, the response includes a NextMarker value that you can use to get
	// another batch of WebACL objects.
	Limit *int64 `min:"1" type:"integer" required:"true"`

	// If you specify a value for Limit and you have more WebACL objects than the
	// number that you specify for Limit, AWS WAF returns a NextMarker value in
	// the response that allows you to list another group of WebACL objects. For
	// the second and subsequent ListWebACLs requests, specify the value of NextMarker
	// from the previous response to get information about another batch of WebACL
	// objects.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListWebACLsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWebACLsInput) GoString() string {
	return s.String()
}

type ListWebACLsOutput struct {
	_ struct{} `type:"structure"`

	// If you have more WebACL objects than the number that you specified for Limit
	// in the request, the response includes a NextMarker value. To list more WebACL
	// objects, submit another ListWebACLs request, and specify the NextMarker value
	// from the response in the NextMarker value in the next request.
	NextMarker *string `min:"1" type:"string"`

	// An array of WebACLSummary objects.
	WebACLs []*WebACLSummary `type:"list"`
}

// String returns the string representation
func (s ListWebACLsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWebACLsOutput) GoString() string {
	return s.String()
}

// Specifies the ByteMatchSet, IPSet, and SqlInjectionMatchSet objects that
// you want to add to a Rule and, for each object, indicates whether you want
// to negate the settings, for example, requests that do NOT originate from
// the IP address 192.0.2.44.
type Predicate struct {
	_ struct{} `type:"structure"`

	// A unique identifier for a predicate in a Rule, such as ByteMatchSetId or
	// IPSetId. The ID is returned by the corresponding Create or List command.
	DataId *string `min:"1" type:"string" required:"true"`

	// Set Negated to False if you want AWS WAF to allow, block, or count requests
	// based on the settings in the specified ByteMatchSet, IPSet, or SqlInjectionMatchSet.
	// For example, if an IPSet includes the IP address 192.0.2.44, AWS WAF will
	// allow or block requests based on that IP address.
	//
	// Set Negated to True if you want AWS WAF to allow or block a request based
	// on the negation of the settings in the ByteMatchSet, IPSet, or SqlInjectionMatchSet.
	// For example, if an IPSet includes the IP address 192.0.2.44, AWS WAF will
	// allow, block, or count requests based on all IP addresses except 192.0.2.44.
	Negated *bool `type:"boolean" required:"true"`

	// The type of predicate in a Rule, such as ByteMatchSet or IPSet.
	Type *string `type:"string" required:"true" enum:"PredicateType"`
}

// String returns the string representation
func (s Predicate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Predicate) GoString() string {
	return s.String()
}

// A combination of ByteMatchSet, IPSet, and/or SqlInjectionMatchSet objects
// that identify the web requests that you want to allow, block, or count. For
// example, you might create a Rule that includes the following predicates:
//
//  An IPSet that causes AWS WAF to search for web requests that originate
// from the IP address 192.0.2.44 A ByteMatchSet that causes AWS WAF to search
// for web requests for which the value of the User-Agent header is BadBot.
//  To match the settings in this Rule, a request must originate from 192.0.2.44
// AND include a User-Agent header for which the value is BadBot.
type Rule struct {
	_ struct{} `type:"structure"`

	MetricName *string `type:"string"`

	// The friendly name or description for the Rule. You can't change the name
	// of a Rule after you create it.
	Name *string `min:"1" type:"string"`

	// The Predicates object contains one Predicate element for each ByteMatchSet,
	// IPSet, or SqlInjectionMatchSet object that you want to include in a Rule.
	Predicates []*Predicate `type:"list" required:"true"`

	// A unique identifier for a Rule. You use RuleId to get more information about
	// a Rule (see GetRule), update a Rule (see UpdateRule), insert a Rule into
	// a WebACL or delete a one from a WebACL (see UpdateWebACL), or delete a Rule
	// from AWS WAF (see DeleteRule).
	//
	// RuleId is returned by CreateRule and by ListRules.
	RuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Rule) GoString() string {
	return s.String()
}

// Contains the identifier and the friendly name or description of the Rule.
type RuleSummary struct {
	_ struct{} `type:"structure"`

	// A friendly name or description of the Rule. You can't change the name of
	// a Rule after you create it.
	Name *string `min:"1" type:"string" required:"true"`

	// A unique identifier for a Rule. You use RuleId to get more information about
	// a Rule (see GetRule), update a Rule (see UpdateRule), insert a Rule into
	// a WebACL or delete one from a WebACL (see UpdateWebACL), or delete a Rule
	// from AWS WAF (see DeleteRule).
	//
	// RuleId is returned by CreateRule and by ListRules.
	RuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RuleSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleSummary) GoString() string {
	return s.String()
}

// Specifies a Predicate (such as an IPSet) and indicates whether you want to
// add it to a Rule or delete it from a Rule.
type RuleUpdate struct {
	_ struct{} `type:"structure"`

	// Specify INSERT to add a Predicate to a Rule. Use DELETE to remove a Predicate
	// from a Rule.
	Action *string `type:"string" required:"true" enum:"ChangeAction"`

	// The ID of the Predicate (such as an IPSet) that you want to add to a Rule.
	Predicate *Predicate `type:"structure" required:"true"`
}

// String returns the string representation
func (s RuleUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleUpdate) GoString() string {
	return s.String()
}

// The response from a GetSampledRequests request includes a SampledHTTPRequests
// complex type that appears as SampledRequests in the response syntax. SampledHTTPRequests
// contains one SampledHTTPRequest object for each web request that is returned
// by GetSampledRequests.
type SampledHTTPRequest struct {
	_ struct{} `type:"structure"`

	// The action for the Rule that the request matched: ALLOW, BLOCK, or COUNT.
	Action *string `type:"string"`

	// A complex type that contains detailed information about the request.
	Request *HTTPRequest `type:"structure" required:"true"`

	// The time at which AWS WAF received the request from your AWS resource, in
	// Unix time format (in seconds).
	Timestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A value that indicates how one result in the response relates proportionally
	// to other results in the response. A result that has a weight of 2 represents
	// roughly twice as many CloudFront web requests as a result that has a weight
	// of 1.
	Weight *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s SampledHTTPRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SampledHTTPRequest) GoString() string {
	return s.String()
}

// Specifies a constraint on the size of a part of the web request. AWS WAF
// uses the Size, ComparisonOperator, and FieldToMatch to build an expression
// in the form of "Size ComparisonOperator size in bytes of FieldToMatch". If
// that expression is true, the SizeConstraint is considered to match.
type SizeConstraint struct {
	_ struct{} `type:"structure"`

	// The type of comparison you want AWS WAF to perform. AWS WAF uses this in
	// combination with the provided Size and FieldToMatch to build an expression
	// in the form of "Size ComparisonOperator size in bytes of FieldToMatch". If
	// that expression is true, the SizeConstraint is considered to match.
	//
	// EQ: Used to test if the Size is equal to the size of the FieldToMatch
	//
	// NE: Used to test if the Size is not equal to the size of the FieldToMatch
	//
	// LE: Used to test if the Size is less than or equal to the size of the FieldToMatch
	//
	// LT: Used to test if the Size is strictly less than the size of the FieldToMatch
	//
	// GE: Used to test if the Size is greater than or equal to the size of the
	// FieldToMatch
	//
	// GT: Used to test if the Size is strictly greater than the size of the FieldToMatch
	ComparisonOperator *string `type:"string" required:"true" enum:"ComparisonOperator"`

	// Specifies where in a web request to look for TargetString.
	FieldToMatch *FieldToMatch `type:"structure" required:"true"`

	// The size in bytes that you want AWS WAF to compare against the size of the
	// specified FieldToMatch. AWS WAF uses this in combination with ComparisonOperator
	// and FieldToMatch to build an expression in the form of "Size ComparisonOperator
	// size in bytes of FieldToMatch". If that expression is true, the SizeConstraint
	// is considered to match.
	//
	// Valid values for size are 0 - 21474836480 bytes (0 - 20 GB).
	//
	// If you specify URI for the value of Type, the / in the URI counts as one
	// character. For example, the URI /logo.jpg is nine characters long.
	Size *int64 `type:"long" required:"true"`

	// Text transformations eliminate some of the unusual formatting that attackers
	// use in web requests in an effort to bypass AWS WAF. If you specify a transformation,
	// AWS WAF performs the transformation on FieldToMatch before inspecting a request
	// for a match.
	//
	// Note that if you choose BODY for the value of Type, you must choose NONE
	// for TextTransformation because CloudFront forwards only the first 8192 bytes
	// for inspection.
	//
	// NONE
	//
	// Specify NONE if you don't want to perform any text transformations.
	//
	// CMD_LINE
	//
	// When you're concerned that attackers are injecting an operating system command
	// line command and using unusual formatting to disguise some or all of the
	// command, use this option to perform the following transformations:
	//
	//  Delete the following characters: \ " ' ^ Delete spaces before the following
	// characters: / ( Replace the following characters with a space: , ; Replace
	// multiple spaces with one space Convert uppercase letters (A-Z) to lowercase
	// (a-z)  COMPRESS_WHITE_SPACE
	//
	// Use this option to replace the following characters with a space character
	// (decimal 32):
	//
	//  \f, formfeed, decimal 12 \t, tab, decimal 9 \n, newline, decimal 10 \r,
	// carriage return, decimal 13 \v, vertical tab, decimal 11 non-breaking space,
	// decimal 160  COMPRESS_WHITE_SPACE also replaces multiple spaces with one
	// space.
	//
	// HTML_ENTITY_DECODE
	//
	// Use this option to replace HTML-encoded characters with unencoded characters.
	// HTML_ENTITY_DECODE performs the following operations:
	//
	//  Replaces (ampersand)quot; with " Replaces (ampersand)nbsp; with a non-breaking
	// space, decimal 160 Replaces (ampersand)lt; with a "less than" symbol Replaces
	// (ampersand)gt; with > Replaces characters that are represented in hexadecimal
	// format, (ampersand)#xhhhh;, with the corresponding characters Replaces characters
	// that are represented in decimal format, (ampersand)#nnnn;, with the corresponding
	// characters  LOWERCASE
	//
	// Use this option to convert uppercase letters (A-Z) to lowercase (a-z).
	//
	// URL_DECODE
	//
	// Use this option to decode a URL-encoded value.
	TextTransformation *string `type:"string" required:"true" enum:"TextTransformation"`
}

// String returns the string representation
func (s SizeConstraint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SizeConstraint) GoString() string {
	return s.String()
}

// A complex type that contains SizeConstraint objects, which specify the parts
// of web requests that you want AWS WAF to inspect the size of. If a SizeConstraintSet
// contains more than one SizeConstraint object, a request only needs to match
// one constraint to be considered a match.
type SizeConstraintSet struct {
	_ struct{} `type:"structure"`

	// The name, if any, of the SizeConstraintSet.
	Name *string `min:"1" type:"string"`

	// A unique identifier for a SizeConstraintSet. You use SizeConstraintSetId
	// to get information about a SizeConstraintSet (see GetSizeConstraintSet),
	// update a SizeConstraintSet (see UpdateSizeConstraintSet, insert a SizeConstraintSet
	// into a Rule or delete one from a Rule (see UpdateRule), and delete a SizeConstraintSet
	// from AWS WAF (see DeleteSizeConstraintSet).
	//
	// SizeConstraintSetId is returned by CreateSizeConstraintSet and by ListSizeConstraintSets.
	SizeConstraintSetId *string `min:"1" type:"string" required:"true"`

	// Specifies the parts of web requests that you want to inspect the size of.
	SizeConstraints []*SizeConstraint `type:"list" required:"true"`
}

// String returns the string representation
func (s SizeConstraintSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SizeConstraintSet) GoString() string {
	return s.String()
}

// The Id and Name of a SizeConstraintSet.
type SizeConstraintSetSummary struct {
	_ struct{} `type:"structure"`

	// The name of the SizeConstraintSet, if any.
	Name *string `min:"1" type:"string" required:"true"`

	// A unique identifier for a SizeConstraintSet. You use SizeConstraintSetId
	// to get information about a SizeConstraintSet (see GetSizeConstraintSet),
	// update a SizeConstraintSet (see UpdateSizeConstraintSet, insert a SizeConstraintSet
	// into a Rule or delete one from a Rule (see UpdateRule), and delete a SizeConstraintSet
	// from AWS WAF (see DeleteSizeConstraintSet).
	//
	// SizeConstraintSetId is returned by CreateSizeConstraintSet and by ListSizeConstraintSets.
	SizeConstraintSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SizeConstraintSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SizeConstraintSetSummary) GoString() string {
	return s.String()
}

// Specifies the part of a web request that you want to inspect the size of
// and indicates whether you want to add the specification to a SizeConstraintSet
// or delete it from a SizeConstraintSet.
type SizeConstraintSetUpdate struct {
	_ struct{} `type:"structure"`

	// Specify INSERT to add a SizeConstraintSetUpdate to a SizeConstraintSet. Use
	// DELETE to remove a SizeConstraintSetUpdate from a SizeConstraintSet.
	Action *string `type:"string" required:"true" enum:"ChangeAction"`

	// Specifies a constraint on the size of a part of the web request. AWS WAF
	// uses the Size, ComparisonOperator, and FieldToMatch to build an expression
	// in the form of "Size ComparisonOperator size in bytes of FieldToMatch". If
	// that expression is true, the SizeConstraint is considered to match.
	SizeConstraint *SizeConstraint `type:"structure" required:"true"`
}

// String returns the string representation
func (s SizeConstraintSetUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SizeConstraintSetUpdate) GoString() string {
	return s.String()
}

// A complex type that contains SqlInjectionMatchTuple objects, which specify
// the parts of web requests that you want AWS WAF to inspect for snippets of
// malicious SQL code and, if you want AWS WAF to inspect a header, the name
// of the header. If a SqlInjectionMatchSet contains more than one SqlInjectionMatchTuple
// object, a request needs to include snippets of SQL code in only one of the
// specified parts of the request to be considered a match.
type SqlInjectionMatchSet struct {
	_ struct{} `type:"structure"`

	// The name, if any, of the SqlInjectionMatchSet.
	Name *string `min:"1" type:"string"`

	// A unique identifier for a SqlInjectionMatchSet. You use SqlInjectionMatchSetId
	// to get information about a SqlInjectionMatchSet (see GetSqlInjectionMatchSet),
	// update a SqlInjectionMatchSet (see UpdateSqlInjectionMatchSet, insert a SqlInjectionMatchSet
	// into a Rule or delete one from a Rule (see UpdateRule), and delete a SqlInjectionMatchSet
	// from AWS WAF (see DeleteSqlInjectionMatchSet).
	//
	// SqlInjectionMatchSetId is returned by CreateSqlInjectionMatchSet and by
	// ListSqlInjectionMatchSets.
	SqlInjectionMatchSetId *string `min:"1" type:"string" required:"true"`

	// Specifies the parts of web requests that you want to inspect for snippets
	// of malicious SQL code.
	SqlInjectionMatchTuples []*SqlInjectionMatchTuple `type:"list" required:"true"`
}

// String returns the string representation
func (s SqlInjectionMatchSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SqlInjectionMatchSet) GoString() string {
	return s.String()
}

// The Id and Name of a SqlInjectionMatchSet.
type SqlInjectionMatchSetSummary struct {
	_ struct{} `type:"structure"`

	// The name of the SqlInjectionMatchSet, if any, specified by Id.
	Name *string `min:"1" type:"string" required:"true"`

	// A unique identifier for a SqlInjectionMatchSet. You use SqlInjectionMatchSetId
	// to get information about a SqlInjectionMatchSet (see GetSqlInjectionMatchSet),
	// update a SqlInjectionMatchSet (see UpdateSqlInjectionMatchSet, insert a SqlInjectionMatchSet
	// into a Rule or delete one from a Rule (see UpdateRule), and delete a SqlInjectionMatchSet
	// from AWS WAF (see DeleteSqlInjectionMatchSet).
	//
	// SqlInjectionMatchSetId is returned by CreateSqlInjectionMatchSet and by
	// ListSqlInjectionMatchSets.
	SqlInjectionMatchSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SqlInjectionMatchSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SqlInjectionMatchSetSummary) GoString() string {
	return s.String()
}

// Specifies the part of a web request that you want to inspect for snippets
// of malicious SQL code and indicates whether you want to add the specification
// to a SqlInjectionMatchSet or delete it from a SqlInjectionMatchSet.
type SqlInjectionMatchSetUpdate struct {
	_ struct{} `type:"structure"`

	// Specify INSERT to add a SqlInjectionMatchSetUpdate to a SqlInjectionMatchSet.
	// Use DELETE to remove a SqlInjectionMatchSetUpdate from a SqlInjectionMatchSet.
	Action *string `type:"string" required:"true" enum:"ChangeAction"`

	// Specifies the part of a web request that you want AWS WAF to inspect for
	// snippets of malicious SQL code and, if you want AWS WAF to inspect a header,
	// the name of the header.
	SqlInjectionMatchTuple *SqlInjectionMatchTuple `type:"structure" required:"true"`
}

// String returns the string representation
func (s SqlInjectionMatchSetUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SqlInjectionMatchSetUpdate) GoString() string {
	return s.String()
}

// Specifies the part of a web request that you want AWS WAF to inspect for
// snippets of malicious SQL code and, if you want AWS WAF to inspect a header,
// the name of the header.
type SqlInjectionMatchTuple struct {
	_ struct{} `type:"structure"`

	// Specifies where in a web request to look for TargetString.
	FieldToMatch *FieldToMatch `type:"structure" required:"true"`

	// Text transformations eliminate some of the unusual formatting that attackers
	// use in web requests in an effort to bypass AWS WAF. If you specify a transformation,
	// AWS WAF performs the transformation on FieldToMatch before inspecting a request
	// for a match.
	//
	// CMD_LINE
	//
	// When you're concerned that attackers are injecting an operating system commandline
	// command and using unusual formatting to disguise some or all of the command,
	// use this option to perform the following transformations:
	//
	//  Delete the following characters: \ " ' ^ Delete spaces before the following
	// characters: / ( Replace the following characters with a space: , ; Replace
	// multiple spaces with one space Convert uppercase letters (A-Z) to lowercase
	// (a-z)  COMPRESS_WHITE_SPACE
	//
	// Use this option to replace the following characters with a space character
	// (decimal 32):
	//
	//  \f, formfeed, decimal 12 \t, tab, decimal 9 \n, newline, decimal 10 \r,
	// carriage return, decimal 13 \v, vertical tab, decimal 11 non-breaking space,
	// decimal 160  COMPRESS_WHITE_SPACE also replaces multiple spaces with one
	// space.
	//
	// HTML_ENTITY_DECODE
	//
	// Use this option to replace HTML-encoded characters with unencoded characters.
	// HTML_ENTITY_DECODE performs the following operations:
	//
	//  Replaces (ampersand)quot; with " Replaces (ampersand)nbsp; with a non-breaking
	// space, decimal 160 Replaces (ampersand)lt; with a "less than" symbol Replaces
	// (ampersand)gt; with > Replaces characters that are represented in hexadecimal
	// format, (ampersand)#xhhhh;, with the corresponding characters Replaces characters
	// that are represented in decimal format, (ampersand)#nnnn;, with the corresponding
	// characters  LOWERCASE
	//
	// Use this option to convert uppercase letters (A-Z) to lowercase (a-z).
	//
	// URL_DECODE
	//
	// Use this option to decode a URL-encoded value.
	//
	// NONE
	//
	// Specify NONE if you don't want to perform any text transformations.
	TextTransformation *string `type:"string" required:"true" enum:"TextTransformation"`
}

// String returns the string representation
func (s SqlInjectionMatchTuple) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SqlInjectionMatchTuple) GoString() string {
	return s.String()
}

// In a GetSampledRequests request, the StartTime and EndTime objects specify
// the time range for which you want AWS WAF to return a sample of web requests.
//
// In a GetSampledRequests response, the StartTime and EndTime objects specify
// the time range for which AWS WAF actually returned a sample of web requests.
// AWS WAF gets the specified number of requests from among the first 5,000
// requests that your AWS resource receives during the specified time period.
// If your resource receives more than 5,000 requests during that period, AWS
// WAF stops sampling after the 5,000th request. In that case, EndTime is the
// time that AWS WAF received the 5,000th request.
type TimeWindow struct {
	_ struct{} `type:"structure"`

	// The end of the time range from which you want GetSampledRequests to return
	// a sample of the requests that your AWS resource received. You can specify
	// any time range in the previous three hours.
	EndTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The beginning of the time range from which you want GetSampledRequests to
	// return a sample of the requests that your AWS resource received. You can
	// specify any time range in the previous three hours.
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`
}

// String returns the string representation
func (s TimeWindow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeWindow) GoString() string {
	return s.String()
}

type UpdateByteMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The ByteMatchSetId of the ByteMatchSet that you want to update. ByteMatchSetId
	// is returned by CreateByteMatchSet and by ListByteMatchSets.
	ByteMatchSetId *string `min:"1" type:"string" required:"true"`

	// The value returned by the most recent call to GetChangeToken.
	ChangeToken *string `type:"string" required:"true"`

	// An array of ByteMatchSetUpdate objects that you want to insert into or delete
	// from a ByteMatchSet. For more information, see the applicable data types:
	//
	//  ByteMatchSetUpdate: Contains Action and ByteMatchTuple ByteMatchTuple:
	// Contains FieldToMatch, PositionalConstraint, TargetString, and TextTransformation
	// FieldToMatch: Contains Data and Type
	Updates []*ByteMatchSetUpdate `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateByteMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateByteMatchSetInput) GoString() string {
	return s.String()
}

type UpdateByteMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateByteMatchSet request. You
	// can also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `type:"string"`
}

// String returns the string representation
func (s UpdateByteMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateByteMatchSetOutput) GoString() string {
	return s.String()
}

type UpdateIPSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	ChangeToken *string `type:"string" required:"true"`

	// The IPSetId of the IPSet that you want to update. IPSetId is returned by
	// CreateIPSet and by ListIPSets.
	IPSetId *string `min:"1" type:"string" required:"true"`

	// An array of IPSetUpdate objects that you want to insert into or delete from
	// an IPSet. For more information, see the applicable data types:
	//
	//  IPSetUpdate: Contains Action and IPSetDescriptor IPSetDescriptor: Contains
	// Type and Value
	Updates []*IPSetUpdate `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateIPSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIPSetInput) GoString() string {
	return s.String()
}

type UpdateIPSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateIPSet request. You can
	// also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `type:"string"`
}

// String returns the string representation
func (s UpdateIPSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIPSetOutput) GoString() string {
	return s.String()
}

type UpdateRuleInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	ChangeToken *string `type:"string" required:"true"`

	// The RuleId of the Rule that you want to update. RuleId is returned by CreateRule
	// and by ListRules.
	RuleId *string `min:"1" type:"string" required:"true"`

	// An array of RuleUpdate objects that you want to insert into or delete from
	// a Rule. For more information, see the applicable data types:
	//
	//  RuleUpdate: Contains Action and Predicate Predicate: Contains DataId, Negated,
	// and Type FieldToMatch: Contains Data and Type
	Updates []*RuleUpdate `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuleInput) GoString() string {
	return s.String()
}

type UpdateRuleOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateRule request. You can also
	// use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `type:"string"`
}

// String returns the string representation
func (s UpdateRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuleOutput) GoString() string {
	return s.String()
}

type UpdateSizeConstraintSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	ChangeToken *string `type:"string" required:"true"`

	// The SizeConstraintSetId of the SizeConstraintSet that you want to update.
	// SizeConstraintSetId is returned by CreateSizeConstraintSet and by ListSizeConstraintSets.
	SizeConstraintSetId *string `min:"1" type:"string" required:"true"`

	// An array of SizeConstraintSetUpdate objects that you want to insert into
	// or delete from a SizeConstraintSet. For more information, see the applicable
	// data types:
	//
	//  SizeConstraintSetUpdate: Contains Action and SizeConstraint SizeConstraint:
	// Contains FieldToMatch, TextTransformation, ComparisonOperator, and Size FieldToMatch:
	// Contains Data and Type
	Updates []*SizeConstraintSetUpdate `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateSizeConstraintSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSizeConstraintSetInput) GoString() string {
	return s.String()
}

type UpdateSizeConstraintSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateSizeConstraintSet request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `type:"string"`
}

// String returns the string representation
func (s UpdateSizeConstraintSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSizeConstraintSetOutput) GoString() string {
	return s.String()
}

// A request to update a SqlInjectionMatchSet.
type UpdateSqlInjectionMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	ChangeToken *string `type:"string" required:"true"`

	// The SqlInjectionMatchSetId of the SqlInjectionMatchSet that you want to update.
	// SqlInjectionMatchSetId is returned by CreateSqlInjectionMatchSet and by ListSqlInjectionMatchSets.
	SqlInjectionMatchSetId *string `min:"1" type:"string" required:"true"`

	// An array of SqlInjectionMatchSetUpdate objects that you want to insert into
	// or delete from a SqlInjectionMatchSet. For more information, see the applicable
	// data types:
	//
	//  SqlInjectionMatchSetUpdate: Contains Action and SqlInjectionMatchTuple
	// SqlInjectionMatchTuple: Contains FieldToMatch and TextTransformation FieldToMatch:
	// Contains Data and Type
	Updates []*SqlInjectionMatchSetUpdate `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateSqlInjectionMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSqlInjectionMatchSetInput) GoString() string {
	return s.String()
}

// The response to an UpdateSqlInjectionMatchSets request.
type UpdateSqlInjectionMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateSqlInjectionMatchSet request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `type:"string"`
}

// String returns the string representation
func (s UpdateSqlInjectionMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSqlInjectionMatchSetOutput) GoString() string {
	return s.String()
}

type UpdateWebACLInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	ChangeToken *string `type:"string" required:"true"`

	// For the action that is associated with a rule in a WebACL, specifies the
	// action that you want AWS WAF to perform when a web request matches all of
	// the conditions in a rule. For the default action in a WebACL, specifies the
	// action that you want AWS WAF to take when a web request doesn't match all
	// of the conditions in any of the rules in a WebACL.
	DefaultAction *WafAction `type:"structure"`

	// An array of updates to make to the WebACL.
	//
	// An array of WebACLUpdate objects that you want to insert into or delete
	// from a WebACL. For more information, see the applicable data types:
	//
	//  WebACLUpdate: Contains Action and ActivatedRule ActivatedRule: Contains
	// Action, Priority, and RuleId WafAction: Contains Type
	Updates []*WebACLUpdate `type:"list"`

	// The WebACLId of the WebACL that you want to update. WebACLId is returned
	// by CreateWebACL and by ListWebACLs.
	WebACLId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWebACLInput) GoString() string {
	return s.String()
}

type UpdateWebACLOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateWebACL request. You can
	// also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `type:"string"`
}

// String returns the string representation
func (s UpdateWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWebACLOutput) GoString() string {
	return s.String()
}

// For the action that is associated with a rule in a WebACL, specifies the
// action that you want AWS WAF to perform when a web request matches all of
// the conditions in a rule. For the default action in a WebACL, specifies the
// action that you want AWS WAF to take when a web request doesn't match all
// of the conditions in any of the rules in a WebACL.
type WafAction struct {
	_ struct{} `type:"structure"`

	// Specifies how you want AWS WAF to respond to requests that match the settings
	// in a Rule. Valid settings include the following:
	//
	//  ALLOW: AWS WAF allows requests BLOCK: AWS WAF blocks requests COUNT: AWS
	// WAF increments a counter of the requests that match all of the conditions
	// in the rule. AWS WAF then continues to inspect the web request based on the
	// remaining rules in the web ACL. You can't specify COUNT for the default action
	// for a WebACL.
	Type *string `type:"string" required:"true" enum:"WafActionType"`
}

// String returns the string representation
func (s WafAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WafAction) GoString() string {
	return s.String()
}

// Contains the Rules that identify the requests that you want to allow, block,
// or count. In a WebACL, you also specify a default action (ALLOW or BLOCK),
// and the action for each Rule that you add to a WebACL, for example, block
// requests from specified IP addresses or block requests from specified referrers.
// You also associate the WebACL with a CloudFront distribution to identify
// the requests that you want AWS WAF to filter. If you add more than one Rule
// to a WebACL, a request needs to match only one of the specifications to be
// allowed, blocked, or counted. For more information, see UpdateWebACL.
type WebACL struct {
	_ struct{} `type:"structure"`

	// The action to perform if none of the Rules contained in the WebACL match.
	// The action is specified by the WafAction object.
	DefaultAction *WafAction `type:"structure" required:"true"`

	MetricName *string `type:"string"`

	// A friendly name or description of the WebACL. You can't change the name of
	// a WebACL after you create it.
	Name *string `min:"1" type:"string"`

	// An array that contains the action for each Rule in a WebACL, the priority
	// of the Rule, and the ID of the Rule.
	Rules []*ActivatedRule `type:"list" required:"true"`

	// A unique identifier for a WebACL. You use WebACLId to get information about
	// a WebACL (see GetWebACL), update a WebACL (see UpdateWebACL, and delete a
	// WebACL from AWS WAF (see DeleteWebACL).
	//
	// WebACLId is returned by CreateWebACL and by ListWebACLs.
	WebACLId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s WebACL) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WebACL) GoString() string {
	return s.String()
}

// Contains the identifier and the name or description of the WebACL.
type WebACLSummary struct {
	_ struct{} `type:"structure"`

	// A friendly name or description of the WebACL. You can't change the name of
	// a WebACL after you create it.
	Name *string `min:"1" type:"string" required:"true"`

	// A unique identifier for a WebACL. You use WebACLId to get information about
	// a WebACL (see GetWebACL), update a WebACL (see UpdateWebACL, and delete a
	// WebACL from AWS WAF (see DeleteWebACL).
	//
	// WebACLId is returned by CreateWebACL and by ListWebACLs.
	WebACLId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s WebACLSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WebACLSummary) GoString() string {
	return s.String()
}

// Specifies whether to insert a Rule into or delete a Rule from a WebACL.
type WebACLUpdate struct {
	_ struct{} `type:"structure"`

	// Specifies whether to insert a Rule into or delete a Rule from a WebACL.
	Action *string `type:"string" required:"true" enum:"ChangeAction"`

	// The ActivatedRule object in an UpdateWebACL request specifies a Rule that
	// you want to insert or delete, the priority of the Rule in the WebACL, and
	// the action that you want AWS WAF to take when a web request matches the Rule
	// (ALLOW, BLOCK, or COUNT).
	//
	// To specify whether to insert or delete a Rule, use the Action parameter
	// in the WebACLUpdate data type.
	ActivatedRule *ActivatedRule `type:"structure" required:"true"`
}

// String returns the string representation
func (s WebACLUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WebACLUpdate) GoString() string {
	return s.String()
}

const (
	// @enum ChangeAction
	ChangeActionInsert = "INSERT"
	// @enum ChangeAction
	ChangeActionDelete = "DELETE"
)

const (
	// @enum ChangeTokenStatus
	ChangeTokenStatusProvisioned = "PROVISIONED"
	// @enum ChangeTokenStatus
	ChangeTokenStatusPending = "PENDING"
	// @enum ChangeTokenStatus
	ChangeTokenStatusInsync = "INSYNC"
)

const (
	// @enum ComparisonOperator
	ComparisonOperatorEq = "EQ"
	// @enum ComparisonOperator
	ComparisonOperatorNe = "NE"
	// @enum ComparisonOperator
	ComparisonOperatorLe = "LE"
	// @enum ComparisonOperator
	ComparisonOperatorLt = "LT"
	// @enum ComparisonOperator
	ComparisonOperatorGe = "GE"
	// @enum ComparisonOperator
	ComparisonOperatorGt = "GT"
)

const (
	// @enum IPSetDescriptorType
	IPSetDescriptorTypeIpv4 = "IPV4"
)

const (
	// @enum MatchFieldType
	MatchFieldTypeUri = "URI"
	// @enum MatchFieldType
	MatchFieldTypeQueryString = "QUERY_STRING"
	// @enum MatchFieldType
	MatchFieldTypeHeader = "HEADER"
	// @enum MatchFieldType
	MatchFieldTypeMethod = "METHOD"
	// @enum MatchFieldType
	MatchFieldTypeBody = "BODY"
)

const (
	// @enum ParameterExceptionField
	ParameterExceptionFieldChangeAction = "CHANGE_ACTION"
	// @enum ParameterExceptionField
	ParameterExceptionFieldWafAction = "WAF_ACTION"
	// @enum ParameterExceptionField
	ParameterExceptionFieldPredicateType = "PREDICATE_TYPE"
	// @enum ParameterExceptionField
	ParameterExceptionFieldIpsetType = "IPSET_TYPE"
	// @enum ParameterExceptionField
	ParameterExceptionFieldByteMatchFieldType = "BYTE_MATCH_FIELD_TYPE"
	// @enum ParameterExceptionField
	ParameterExceptionFieldSqlInjectionMatchFieldType = "SQL_INJECTION_MATCH_FIELD_TYPE"
	// @enum ParameterExceptionField
	ParameterExceptionFieldByteMatchTextTransformation = "BYTE_MATCH_TEXT_TRANSFORMATION"
	// @enum ParameterExceptionField
	ParameterExceptionFieldByteMatchPositionalConstraint = "BYTE_MATCH_POSITIONAL_CONSTRAINT"
	// @enum ParameterExceptionField
	ParameterExceptionFieldSizeConstraintComparisonOperator = "SIZE_CONSTRAINT_COMPARISON_OPERATOR"
)

const (
	// @enum ParameterExceptionReason
	ParameterExceptionReasonInvalidOption = "INVALID_OPTION"
	// @enum ParameterExceptionReason
	ParameterExceptionReasonIllegalCombination = "ILLEGAL_COMBINATION"
)

const (
	// @enum PositionalConstraint
	PositionalConstraintExactly = "EXACTLY"
	// @enum PositionalConstraint
	PositionalConstraintStartsWith = "STARTS_WITH"
	// @enum PositionalConstraint
	PositionalConstraintEndsWith = "ENDS_WITH"
	// @enum PositionalConstraint
	PositionalConstraintContains = "CONTAINS"
	// @enum PositionalConstraint
	PositionalConstraintContainsWord = "CONTAINS_WORD"
)

const (
	// @enum PredicateType
	PredicateTypeIpmatch = "IPMatch"
	// @enum PredicateType
	PredicateTypeByteMatch = "ByteMatch"
	// @enum PredicateType
	PredicateTypeSqlInjectionMatch = "SqlInjectionMatch"
	// @enum PredicateType
	PredicateTypeSizeConstraint = "SizeConstraint"
)

const (
	// @enum TextTransformation
	TextTransformationNone = "NONE"
	// @enum TextTransformation
	TextTransformationCompressWhiteSpace = "COMPRESS_WHITE_SPACE"
	// @enum TextTransformation
	TextTransformationHtmlEntityDecode = "HTML_ENTITY_DECODE"
	// @enum TextTransformation
	TextTransformationLowercase = "LOWERCASE"
	// @enum TextTransformation
	TextTransformationCmdLine = "CMD_LINE"
	// @enum TextTransformation
	TextTransformationUrlDecode = "URL_DECODE"
)

const (
	// @enum WafActionType
	WafActionTypeBlock = "BLOCK"
	// @enum WafActionType
	WafActionTypeAllow = "ALLOW"
	// @enum WafActionType
	WafActionTypeCount = "COUNT"
)
