/*
 * CDefFile.h, part of VCMI engine
 *
 * Authors: listed in file AUTHORS in main folder
 *
 * License: GNU General Public License v2.0 or later
 * Full text of license available in license.txt file, in main folder
 *
 */
#pragma once

#include "../../lib/vcmi_endian.h"
#include "../../lib/filesystem/ResourcePath.h"

VCMI_LIB_NAMESPACE_BEGIN
class Point;
VCMI_LIB_NAMESPACE_END

class IImageLoader;
struct SDL_Color;

/// Class for def loading
/// After loading will store general info (palette and frame offsets) and pointer to file itself
class CDefFile
{
public:
	PACKED_STRUCT_BEGIN
	struct SSpriteDef
	{
		ui32 size;
		ui32 format;    /// format in which pixel data is stored
		ui32 fullWidth; /// full width and height of frame, including borders
		ui32 fullHeight;
		ui32 width;     /// width and height of pixel data, borders excluded
		ui32 height;
		si32 leftMargin;
		si32 topMargin;
	} PACKED_STRUCT_END;
private:

	//offset[group][frame] - offset of frame data in file
	std::map<size_t, std::vector <size_t> > offset;
	//name[group][frame] - name of frame data in file
	std::map<size_t, std::vector <std::string> > name;

	std::unique_ptr<ui8[]>       data;
	std::unique_ptr<SDL_Color[]> palette;

public:
	CDefFile(const AnimationPath & Name);
	~CDefFile();

	//load frame as SDL_Surface
	void loadFrame(size_t frame, size_t group, IImageLoader &loader) const;
	bool hasFrame(size_t frame, size_t group) const;
	std::string getName(size_t frame, size_t group) const;
	SSpriteDef getFrameInfo(size_t frame, size_t group) const;

	const std::map<size_t, size_t> getEntries() const;
};


