// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __version_h__
#define __version_h__

#include "infos.h"

static inline const char *ac_version() {return AC_VERSION;}
static inline const char *ac_program() {return "ac++";}

// Version management helpers:
// Returns a version number that can be compared by using >, >=, ==, ...
#define GET_VERSION_NUMBER(MAJOR, MINOR, PATCHLEVEL) \
                            MAJOR * 10000 \
                            + MINOR * 100 \
                            + PATCHLEVEL

#ifdef FRONTEND_CLANG
// Clang version:
#include "clang/Basic/Version.h"
#define CLANG_VERSION_NUMBER GET_VERSION_NUMBER(CLANG_VERSION_MAJOR, \
                                                CLANG_VERSION_MINOR, \
                                                CLANG_VERSION_PATCHLEVEL)

// Some version numbers:
#define VERSION_NUMBER_3_5_2 GET_VERSION_NUMBER(3, 5, 2)
#define VERSION_NUMBER_3_6_2 GET_VERSION_NUMBER(3, 6, 2)
#define VERSION_NUMBER_3_7_1 GET_VERSION_NUMBER(3, 7, 1)
#define VERSION_NUMBER_3_8_0 GET_VERSION_NUMBER(3, 8, 0)
#define VERSION_NUMBER_3_9_1 GET_VERSION_NUMBER(3, 9, 1)
#define VERSION_NUMBER_4_0_0 GET_VERSION_NUMBER(4, 0, 0)
#define VERSION_NUMBER_5_0_0 GET_VERSION_NUMBER(5, 0, 0)
#define VERSION_NUMBER_6_0_0 GET_VERSION_NUMBER(6, 0, 0)
#define VERSION_NUMBER_7_0_0 GET_VERSION_NUMBER(7, 0, 0)
#define VERSION_NUMBER_9_0_0 GET_VERSION_NUMBER(9, 0, 0)
#define VERSION_NUMBER_10_0_0 GET_VERSION_NUMBER(10, 0, 0)
// The following versions are currently supported ...
#define VERSION_NUMBER_11_0_0 GET_VERSION_NUMBER(11, 0, 0)
#define VERSION_NUMBER_11_0_1 GET_VERSION_NUMBER(11, 0, 1)
#define VERSION_NUMBER_11_1_0 GET_VERSION_NUMBER(11, 1, 0)
#define VERSION_NUMBER_12_0_0 GET_VERSION_NUMBER(12, 0, 0) // not supported, but needed
#define VERSION_NUMBER_12_0_1 GET_VERSION_NUMBER(12, 0, 1)
#define VERSION_NUMBER_14_0_0 GET_VERSION_NUMBER(14, 0, 0)
#define VERSION_NUMBER_14_0_6 GET_VERSION_NUMBER(14, 0, 6)
#define VERSION_NUMBER_18_1_3 GET_VERSION_NUMBER(18, 1, 3)
#define VERSION_NUMBER_18_1_8 GET_VERSION_NUMBER(18, 1, 8)
#define VERSION_NUMBER_19_1_6 GET_VERSION_NUMBER(19, 1, 6)
#define VERSION_NUMBER_20_0_0 GET_VERSION_NUMBER(20, 0, 0)
#define VERSION_NUMBER_20_1_2 GET_VERSION_NUMBER(20, 1, 2)
#define VERSION_NUMBER_21_0_0 GET_VERSION_NUMBER(21, 0, 0)
#define VERSION_NUMBER_21_1_6 GET_VERSION_NUMBER(21, 1, 6)

// StartLoc and EndLoc API change
#define CLANG_GET_LOC_END(ptr) ((ptr)->getEndLoc())
#define CLANG_GET_START_LOC(ptr) ((ptr)->getBeginLoc())
#define CLANG_GET_LOC_START(ptr) ((ptr)->getBeginLoc())

// String API changes after Clang 19
#if CLANG_VERSION_NUMBER >= VERSION_NUMBER_19_1_6
#define CLANG_STR_STARTS_WITH(OBJ,SUBSTR) OBJ.starts_with(SUBSTR)
#define CLANG_STR_ENDS_WITH(OBJ,SUBSTR) OBJ.ends_with(SUBSTR)
#else
#define CLANG_STR_STARTS_WITH(OBJ,SUBSTR) OBJ.startswith(SUBSTR)
#define CLANG_STR_ENDS_WITH(OBJ,SUBSTR) OBJ.endswith(SUBSTR)
#endif

#endif // FRONTEND_CLANG

#endif // __version_h__
