/*****************************************************************************
 *
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 ****************************************************************************/
#include "AddTransformation.h"

// CamiTK includes
#include <Property.h>
#include <ActionWidget.h>
#include <Log.h>

// includes for specific types
#include <Application.h>
#include <TransformationManager.h>
#include <TransformationExplorer.h>
#include <FrameOfReference.h>
#include <Property.h>

using namespace camitk;

// -------------------- init --------------------
void AddTransformation::init() {
    refreshFrames();

    auto refreshComboBox = [this]() {
        refreshFrames();
        ActionWidget* defaultWidget = dynamic_cast<ActionWidget*>(getWidget());
        if (defaultWidget != nullptr) {
            defaultWidget->update();
        }
    };

    TransformationExplorer* transfoExplorer = dynamic_cast<TransformationExplorer*>(Application::getViewer("Transformation Explorer"));
    if (transfoExplorer != nullptr) {
        connect(transfoExplorer, &TransformationExplorer::framesUpdated, this, refreshComboBox);
    }
}

// -------------------- process --------------------
Action::ApplyStatus AddTransformation::process() {
    int origIndex = getParameterValue("Origin Frame").toInt();
    int destIndex = getParameterValue("Destination Frame").toInt();
    if (origIndex >= 0 && destIndex >= 0 && allFrames.size() > 0) {
        if (TransformationManager::addTransformation(
                    TransformationManager::getFrameOfReferenceOwnership(allFrames[origIndex]),
                    TransformationManager::getFrameOfReferenceOwnership(allFrames[destIndex])
                )) {
            refreshApplication();
            return SUCCESS;
        }
        else {
            return ERROR;
        }
    }
    else {
        CAMITK_WARNING("You must select two frames to create a Transformation between them!");
        return ERROR;
    }
}

// -------------------- refreshFrames --------------------
void AddTransformation::refreshFrames() {
    allFrames = TransformationManager::getFramesOfReference();
    QStringList frameNames;
    for (const auto& frame : allFrames) {
        frameNames.push_back(QString("%1 - %2").arg(frame->getIndex()).arg(frame->getName()));
    }
    getProperty("Origin Frame")->setAttribute("enumNames", frameNames);
    getProperty("Destination Frame")->setAttribute("enumNames", frameNames);
}

// -------------------- targetDefined --------------------
void AddTransformation::targetDefined() {


}

// -------------------- parameterChanged --------------------
void AddTransformation::parameterChanged(QString parameterName) {
    if (parameterName == "Origin Frame" || parameterName == "Destination Frame") {
        refreshFrames();
    }
}

