We're proud to announce the bug-fix release of darktable, 5.4.1!

The github release is here: [https://github.com/darktable-org/darktable/releases/tag/release-5.4.1](https://github.com/darktable-org/darktable/releases/tag/release-5.4.1).

To build from source, do not use the autogenerated tarball provided by GitHub on the release page, download our tar.xz file instead. If you're just building for yourself without creating a package for some distribution, then using source code cloning in git is an even more convenient way.

The checksums are:

```
$ sha256sum darktable-5.4.1.tar.xz
???  darktable-5.4.1.tar.xz

$ sha256sum darktable-5.4.1-arm64.dmg
???  darktable-5.4.1-arm64.dmg

$ sha256sum darktable-5.4.1-x86_64.dmg
???  darktable-5.4.1-x86_64.dmg

$ sha256sum darktable-5.4.1-win64.exe
???  darktable-5.4.1-win64.exe

$ sha256sum Darktable-5.4.1-x86_64.AppImage
???  Darktable-5.4.1-x86_64.AppImage
```

When updating from the stable 5.2 series, please bear in mind that your edits will be preserved during this process, but the new library and configuration will no longer be usable with 5.2.

You are strongly advised to take a backup first.

#### Important note: to make sure that darktable can keep on supporting the raw file format for your camera, *please* read [this post](https://discuss.pixls.us/t/raw-samples-wanted/5420?u=lebedevri) on how/what raw samples you can contribute to ensure that we have the *full* raw sample set for your camera under CC0 license!

Since darktable 5.4.0:

- 124 commits to darktable+rawspeed
-  74 pull requests handled
-  25 issues closed

_Please note that the darktable documentation is not currently complete for release 5.4
and contributions are greatly appreciated. Please see the
[project documentation](https://github.com/darktable-org/dtdocs#contributing)
for more information on how to contribute._

## The Big Ones

The following is a summary of the main features added to darktable
5.4. Please see the user manual for more details of the individual
changes (where available).

- N/A

## UI/UX Improvements

- N/A

## Performance Improvements

- N/A

## Other Changes

- N/A

## Bug Fixes

- Fixed wrong handling of scaling factor during multi-preset export.

- Fixed missing help URL, pointing to the online documentation, for
  the new AgX module.

- Fixed wrong handling of overwrite if changed in export.

- Fixed images exported with wrong settings when using multi-preset
  export.

- Fixed wrong RAW specific auto-applied preset being applied to non
  RAW images.

- Fixed subtle color casts in bayer dual demosaicers.

- RustiCL gets the default optimizing compiler flags as other
  platforms.

- Fixed loading some Olympus ORF files (e.g. E-410 and E-510)
  due to a possible crash or memory corruption when parsing
  highlight-preservation Exif tag.

- Fixed the mask support in scale pixels module.

- Fixed a possible crash when using workspace due to the non
  deterministic ordering of the list of workspace read on disk.

- The list of the allowed tags in the metadata editor preferences has
  been restricted to tags which are supposed to be user-editable.

- Fixed the thumbnail information update in the overlay or the tooltip
  when some metadata variable are used. That is, when changing the
  metadata we need to recompute the thumbnail information.

- Fixed a possibly standstill while discarding history on fast
  systems.

- Fixed a possible crash in the way the Color Equalizer module GUI is
  initialized.

- Fixed an issue in culling layout where switching to the darkroom
  sometimes failed with an error message.

- Fixed an inconsistency in the styles module UI when shown in the
  darkroom view. It is not possible to create a duplicate to which the
  style is applied, and the setting of the corresponding checkbox has
  just been ignored. To avoid confusion, the checkbox is now hidden in
  the darkroom view.

- Fixes resets to default OpenCL per device setting.

- Fixed possibly outdated metadata when returning from darkroom. For
  example if the image is cropped in darkroom, the metadata $(WIDTH.x)
  and $(HEIGHT.x) where not correct on lighttable.

- Fixed a missing thumbnail overlays with $(CATEGORY[n,m]) variables
  update when a tag is assigned.

- Fixed jumping of curvature slider when used on the mask manager.

- Fixed a crash when mounting a camera from Darktable due to the
  current locale. Mounting is now done using the C locale.

## Lua

### API Version

- API version is now 9.6.0

### New Features

- N/A

### Bug Fixes

- N/A

### Add action support for Lua

### Other Lua changes

- N/A

## Notes

- When exporting to AVIF, EXR, JPEG XL, or XCF, selecting specific
  metadata (e.g. geo-tag or creator) is not currently possible. For
  AVIF, EXR, JPEG XL, and XCF formats, darktable will not include any
  metadata fields unless the user selects all of the checkboxes in the
  export module's preference options.

- Starting with release 5.4, macOS versions older than 14.0 are no
  longer supported on Apple Silicon Macs, nor older than macOS 15 on
  Intel Macs.

## Changed Dependencies

### Mandatory

- N/A

### Optional

- N/A

## RawSpeed changes

- N/A

## Camera support, compared to 5.4.0

### Base Support

- N/A

### White Balance Presets

- N/A

### Noise Profiles

- Canon EOS 10D
- Sony ILCE-7CR

### Missing Compression Mode Support

- Apple ProRAW DNGs
- CinemaDNG lossless (Blackmagic, some DJI, etc.) and lossy (Blackmagic)
- DNG 1.7 using JPEG XL (Adobe enhanced, Samsung Expert RAW)
- Fujifilm lossy RAFs
- Nikon high efficiency NEFs
- Phase One other than IIQ L
- Sony ARW 4.0/5.0 downsized lossless ("M" for full-frame, "S" for full-frame & APS-C) and ARW 6.0 lossy

### Suspended Support

Support for the following cameras is suspended because no samples are available on https://raw.pixls.us:

- Creo/Leaf Aptus 22(LF3779)/Hasselblad H1
- Fujifilm IS-1
- Kodak EasyShare Z980
- Leaf Aptus-II 5(LI300059)/Mamiya 645 AFD
- Leaf Credo 60
- Leaf Credo 80
- Olympus SP320
- Phase One IQ250
- ST Micro STV680

## Translations

- Czech
- German
- European Spanish
- Finnish
- French
- Hungarian
- Italian
- Japanese
- Korean
- Dutch
- Polish
- Brazilian Portuguese
- Slovenian
- Albanian
- Swedish
- Ukrainian
- Chinese (Simplified)
- Chinese (Traditional)
