// Any copyright is dedicated to the Public Domain.
// http://creativecommons.org/publicdomain/zero/1.0/
"use strict";

// Get a profile directory and ensure PSM initializes NSS,
// to ensure the error string tables are installed.
do_get_profile();
Cc["@mozilla.org/psm;1"].getService(Ci.nsISupports);

function run_test() {
  let nssErrorsService = Cc["@mozilla.org/nss_errors_service;1"].getService(
    Ci.nsINSSErrorsService
  );

  let xpcom = nssErrorsService.getXPCOMFromNSSError(SEC_ERROR_UNTRUSTED_CERT);
  let name = nssErrorsService.getErrorName(xpcom);

  equal(
    name,
    "SEC_ERROR_UNTRUSTED_CERT",
    "GetErrorName should work for SEC errors"
  );

  xpcom = nssErrorsService.getXPCOMFromNSSError(SSL_ERROR_BAD_CERT_DOMAIN);
  name = nssErrorsService.getErrorName(xpcom);

  equal(
    name,
    "SSL_ERROR_BAD_CERT_DOMAIN",
    "GetErrorName should work for SSL errors"
  );

  xpcom = nssErrorsService.getXPCOMFromNSSError(
    MOZILLA_PKIX_ERROR_INSUFFICIENT_CERTIFICATE_TRANSPARENCY
  );
  name = nssErrorsService.getErrorName(xpcom);

  equal(
    name,
    "MOZILLA_PKIX_ERROR_INSUFFICIENT_CERTIFICATE_TRANSPARENCY",
    "GetErrorName should work for PKIX errors"
  );

  xpcom = nssErrorsService.getXPCOMFromNSSError(SEC_ERROR_EXPIRED_CERTIFICATE);
  Assert.ok(
    nssErrorsService.isErrorOverridable(xpcom),
    "SEC_ERROR_EXPIRED_CERTIFICATE should be overridable"
  );

  xpcom = nssErrorsService.getXPCOMFromNSSError(SSL_ERROR_BAD_CERT_DOMAIN);
  Assert.ok(
    nssErrorsService.isErrorOverridable(xpcom),
    "SSL_ERROR_BAD_CERT_DOMAIN should be overridable"
  );

  xpcom = nssErrorsService.getXPCOMFromNSSError(
    MOZILLA_PKIX_ERROR_SELF_SIGNED_CERT
  );
  Assert.ok(
    nssErrorsService.isErrorOverridable(xpcom),
    "MOZILLA_PKIX_ERROR_SELF_SIGNED_CERT should be overridable"
  );

  xpcom = nssErrorsService.getXPCOMFromNSSError(SEC_ERROR_BAD_SIGNATURE);
  Assert.ok(
    !nssErrorsService.isErrorOverridable(xpcom),
    "SEC_ERROR_BAD_SIGNATURE should NOT be overridable"
  );

  Assert.throws(
    () => nssErrorsService.isErrorOverridable(Cr.NS_ERROR_NET_TIMEOUT),
    /NS_ERROR_FAILURE/,
    "testing a non-security error code should throw"
  );
}
