"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReferencesNotSupported = exports.UnknownToken = exports.ShouldHaveFdArray = exports.MissingPrivateDict = exports.ShouldHaveStrings = exports.StringsDisallowed = exports.SubroutineNotFound = exports.TransientInvalid = exports.FdIdOverflow = exports.FdSelect4NotSupported = exports.FdSelectSentinelMismatch = exports.NotVariable = exports.StackInsufficient = exports.OperatorNotSupported = void 0;
const OperatorNotSupported = (opCode) => new TypeError(`OpCode 0x${opCode.toString(16)} is not supported here`);
exports.OperatorNotSupported = OperatorNotSupported;
const StackInsufficient = (actual, expected) => new RangeError(`Stack height insufficient: Expected ${expected}, Actual ${actual}`);
exports.StackInsufficient = StackInsufficient;
const NotVariable = () => new RangeError(`Cannot use variation here`);
exports.NotVariable = NotVariable;
const FdSelectSentinelMismatch = (actual, expected) => new RangeError(`FDSelect sentinel mismatch: ${actual} ~ ${expected}`);
exports.FdSelectSentinelMismatch = FdSelectSentinelMismatch;
const FdSelect4NotSupported = () => new TypeError("This font requires format 4 FDSelect, but it is not supported in CFF version 1.");
exports.FdSelect4NotSupported = FdSelect4NotSupported;
const FdIdOverflow = (actual, limit) => new RangeError(`FDSelect FD Id overflow: ${actual} >= ${limit}`);
exports.FdIdOverflow = FdIdOverflow;
const TransientInvalid = (index) => new TypeError("Transient[" + index + "] is invalid.");
exports.TransientInvalid = TransientInvalid;
const SubroutineNotFound = (kind, index) => new RangeError(`CFF subroutine not found: ${kind} ${index}`);
exports.SubroutineNotFound = SubroutineNotFound;
const StringsDisallowed = () => new TypeError("Cannot use string in newer CFF version");
exports.StringsDisallowed = StringsDisallowed;
const ShouldHaveStrings = () => new TypeError("Unreachable. Should support strings.");
exports.ShouldHaveStrings = ShouldHaveStrings;
const MissingPrivateDict = (fdId) => new Error(`Private dict missing for FD ${fdId}`);
exports.MissingPrivateDict = MissingPrivateDict;
const ShouldHaveFdArray = () => new Error(`FDArray should be present`);
exports.ShouldHaveFdArray = ShouldHaveFdArray;
const UnknownToken = () => new TypeError("Unrecognized token type");
exports.UnknownToken = UnknownToken;
const ReferencesNotSupported = () => new TypeError("CFF does not support references.");
exports.ReferencesNotSupported = ReferencesNotSupported;
//# sourceMappingURL=cff.js.map