/*
 * fspy - Linux filesystem activity monitor
 *
 * Copyright (C) 2007  Richard Sammet (e-axe) <richard.sammet@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#ifndef _FSPY_H
#define _FSPY_H

#include <sys/stat.h> /* required -> struct stat */
#include <sys/types.h> /* required -> pid_t, uid_t */
#include "enumdirs.h" /* needed -> ELEMENT_SIZE */

#define AUTHOR           "Richard Sammet (e-axe) <richard.sammet@gmail.com>"
#define LICENSE          "GPL v2+"

#define TRUE  1
#define FALSE 0

/* how long could a regex be? */
#define MAXREGEXLEN     128
/* how long could a typestring be? */
#define MAXTYPELEN      128
/* how long could a output string be? */
#define MAXOUTSTRLEN    128
/* how long could a diff string be? */
#define MAXDIFFSTRLEN   MAXOUTSTRLEN
/* how deep you wanna look into your folder hirachie? */
#define MINRECURDEPTH   1
#define MAXRECURDEPTH   99
/* size of the event structure, not counting name */
#define EVENT_SIZE      (sizeof(struct inotify_event))
/* reasonable guess as to size of 1024 events */
#define BUF_LEN         (1024 * (EVENT_SIZE + 16))

typedef int boolean_t;

struct felement {
	unsigned int id;
	unsigned int wd;
	char path[ELEMENT_SIZE];
};

struct festat {
	unsigned int id;
	char path[ELEMENT_SIZE];
	struct stat statdat;
};

struct diffprint {
	unsigned int s;
	unsigned int A;
	unsigned int M;
	unsigned int S;
	unsigned int O;
	unsigned int U;
	unsigned int G;
	unsigned int I;
	unsigned int D;
};

/* Process info structure */
typedef struct {
	pid_t pid;
	char cmdline[256];
	uid_t uid;
} process_info_t;

/* Global show_process flag */
extern int show_process;

#endif
