MATCH (n) DETACH DELETE n;
CREATE
  (user1:User:Admin {UUID: 1, username: 'admin', full_name: "Admin Sliter", email: "admin@verket.se", hashed_password: "$2a$10$SyekXmrbf9rEd9KrfcXQd.gNWM8iRl228nPTrxqJq0wlDamlHzDly", disabled: false}),
  (user2:User:Officer {UUID: 2, username: 'kommun', full_name: "Kalle Nitisk", email: "kalle.nitisk@kommunen.se", hashed_password: "$2a$10$lX1BIZZuBGOIEiHCxXwrf.IoeHOAWgB3ri6vX10xtMVEmzVH/GbCu", disabled: false}),
  (user3:User:Developer {UUID: 3, username: 'byggherre', full_name: "Byggherre Stolt", email: "stolt@byggfirman.com", hashed_password: "$2a$10$i08DcyX2r9CeWBPaUykDeeynvI5/Aa9scRfi.MfbTgCGm/XqcpGcG", disabled: false}),
  (user4:User:Auditor {UUID: 4, username: 'kontrollansvarig', full_name: "Kontrollansvarig Tapper", email: "kontrollansvarig@ansvaret.se", hashed_password: "$2a$10$OlfSbVqpOmuNNf8KHxFXhONU70nxbrMSH5vL2uc9ydCDfJVAP/gl6", disabled: false}),
  (user5:User:Tester {UUID: 5, username: 'kontrollant', full_name: "Finn Failer", email: "finn.failer@byggfirman.com", hashed_password: "$2a$10$lX1BIZZuBGOIEiHCxXwrf.IoeHOAWgB3ri6vX10xtMVEmzVH/GbCu", disabled: false}),
  (municipality1:Municipality {UUID: 6, name: 'Karlskrona'}),
  (building1:Building {UUID: 7, status: "Under construction"}),
  (project1:Project {project_id: 'c8e9ccce-a4af-11ed-b9df-0242ac120003', name: 'Bygglov'}),
  (project2:Project {project_id: 'd1842bfe-a4af-11ed-b9df-0242ac120003', name: 'Rivningslov'}),
  (document1:Document {
  	document_id: '78860d3c-14db-11ee-be56-0242ac120002',
		session_file_id: '',
		version_index: 1,
		version_number: 'Första',
	  creation_date: '2023-01-01T01:01:01.111',
	  title: 'Solibri building',
		original_file_name: 'Solibri_building.ifc',
		file_ending: '.ifc',
		mime_type: 'application/x-step',
		file_type: 'STEP Physical File (SPF)',
		name: '78860d3c-14db-11ee-be56-0242ac120002.ifc',
	  size_in_bytes: 16962975,
		ifc_project: "0g8GxLEzP459ZWW6_RGsez"
  }),
  (document2:Document {
  	document_id: '6dbd4d52-14db-11ee-be56-0242ac120002',
		session_file_id: '',
		version_index: 2,
	  version_number: 'Andra',
	  creation_date: '2023-01-01T01:01:01.111',
	  title: 'Office building',
		original_file_name: 'Office_building.ifc',
		file_ending: '.ifc',
		mime_type: 'application/x-step',
		file_type: 'STEP Physical File (SPF)',
	  name: '6dbd4d52-14db-11ee-be56-0242ac120002.ifc',
	  size_in_bytes: 8332380,
		ifc_project: "2gszwez3bE580ABnUBdjoQ"
  }),
  (document3:Document {
  	document_id: '78860e68-14db-11ee-be56-0242ac120002',
		session_file_id: '',
		version_index: 3,
		version_number: 'Tredje',
	  creation_date: '2023-01-01T01:01:01:01.111',
	  title: 'Solibri structural',
		original_file_name: 'Solibri_structural.ifc',
		file_ending: '.ifc',
		mime_type: 'application/x-step',
		file_type: 'STEP Physical File (SPF)',
	  name: '78860e68-14db-11ee-be56-0242ac120002.ifc',
	  size_in_bytes: 146606,
		ifc_project: "19sOQo3B98PAcnw01BM8Xo"
  }),
  (user2)-[r4:HAS_ACTIONS_ON {
    read: True,
    update: True,
    createTopic: True,
    createDocument: True,
    createViewpoint: True,
    createComment: True
  }]->(project1),
  (user2)-[r8:HAS_ACTIONS_ON {
    read: True,
    update: True,
    createTopic: True,
    createDocument: True,
    createViewpoint: True,
    createComment: True
  }]->(project2),
  (user3)-[r9:HAS_ACTIONS_ON {
    read: True,
    update: True,
    createTopic: True,
    createDocument: True,
    createViewpoint: True,
    createComment: True
  }]->(project1),
  (project1)-[r10:HAS]->(e1:Extensions {
    topic_type: ["Information", "Error"],
		custom_information: ["Custom value 1", "Custom value 2"],
    topic_status: ["Open", "Closed", "ReOpened", "Custom test status"],
    topic_label: ["Architecture", "Structural", "MEP"],
    snippet_type: [".ifc", ".csv"],
    priority: ["Low", "Medium", "High"],
    users: ["kommun", "byggherre", "kontrollansvarig", "kontrollant", "martin@wiss.se"],
    stage: ["Preliminary Planning End", "Construction Start", "Construction End"],
    project_actions: ["update", "createTopic", "createDocument"],
    topic_actions: ["update", "updateBimSnippet", "updateRelatedTopics", "updateDocumentReferences", "updateFiles", "createComment", "createViewpoint"],
    comment_actions: ["update"]}),
  (project1)-[r11:CONTAINS]->(document1),
  (project1)-[r12:CONTAINS]->(document2);
