#/!bin/bash
set -euo pipefail

# underlays/basewiki is a collection of symlinks, pointing into
# ./doc/.  The files pointed at are licensed under a permissive
# license. Lintian and/or DEP5 do not follow symlinks.
# This script is used to build a stanza suitable for inclusion
# in debian/copyright, and to check the generated stanza against
# the current copyright file.

tmpfile="$(mktemp -t ikiwiki-debian-copyright.XXXXXX)"
test -f "$tmpfile"
trap "rm -f \"$tmpfile\"" QUIT EXIT

# generate new stanza
{
    echo -n "Files: "
    find underlays/basewiki -type l | while read f; do
        l="$(readlink $f)"
        m="doc/${l#*doc/}"
        if [ -d "$m" ]; then
            m="$m/*"
        fi
        echo "$m"
    done | sort | tr "\n" " "
    echo
    echo "Copyright: © 2006-2010 Joey Hess <joey@ikiwiki.info>"
    echo "License: permissive"

} > "$tmpfile"

existingStanza()
{
    awk -v RS='' '/doc\/basewiki\/index.mdwn/ { print }' debian/copyright
}

if cmp -s <(existingStanza) "$tmpfile"; then
    echo basewiki stanza in debian/copyright is up-to-date
else
    echo basewiki stanza needs updating:
    diff --color -u <(existingStanza) "$tmpfile" || true
fi
