import {expectType} from 'tsd';
import type {IsNumeric} from '../../source/internal/index.d.ts';

expectType<IsNumeric<''>>(false);
expectType<IsNumeric<'0'>>(true);
expectType<IsNumeric<'1'>>(true);
expectType<IsNumeric<'-1'>>(true);
expectType<IsNumeric<'123'>>(true);
expectType<IsNumeric<'1e2'>>(true);
expectType<IsNumeric<'1.23'>>(true);
expectType<IsNumeric<'123.456'>>(true);
expectType<IsNumeric<'1.23e4'>>(true);
expectType<IsNumeric<'1.23e-4'>>(true);
expectType<IsNumeric<' '>>(false);
expectType<IsNumeric<'\n'>>(false);
expectType<IsNumeric<'\u{9}'>>(false);
expectType<IsNumeric<' 1.2'>>(false);
expectType<IsNumeric<'1 2'>>(false);
expectType<IsNumeric<'1_200'>>(false);
expectType<IsNumeric<' 1 '>>(false);
