/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 * This file is based on WME Lite.
 * http://dead-code.org/redir.php?target=wmelite
 * Copyright (c) 2011 Jan Nedoma
 */

#ifndef WINTERMUTE_ADRESPONSEBOX_H
#define WINTERMUTE_ADRESPONSEBOX_H


#include "engines/wintermute/base/base_object.h"

namespace Wintermute {

class UIButton;
class UIWindow;
class UIObject;
class AdResponse;
class AdResponseBox : public BaseObject {
public:
	BaseObject *getNextAccessObject(BaseObject *currObject);
	BaseObject *getPrevAccessObject(BaseObject *currObject);
	bool getObjects(BaseArray<UIObject *> &objects, bool interactiveOnly);

	bool handleResponse(AdResponse *response);
	void setLastResponseText(const char *text, const char *textOrig);
	char *_lastResponseText;
	char *_lastResponseTextOrig;
	DECLARE_PERSISTENT(AdResponseBox, BaseObject)
	ScScript *_waitingScript;
	bool listen(BaseScriptHolder *param1, uint32 param2) override;
	typedef enum {
		EVENT_PREV,
		EVENT_NEXT,
		EVENT_RESPONSE
	} TResponseEvent;

	bool weedResponses();
	bool display() override;
	int32 _spacing;
	int32 _scrollOffset;
	BaseFont *_fontHover;
	BaseFont *_font;
	bool createButtons();
	bool invalidateButtons();
	void clearButtons();
	void clearResponses();
	AdResponseBox(BaseGame *inGame);
	~AdResponseBox() override;
	BaseArray<AdResponse *> _responses;
	BaseArray<UIButton *> _respButtons;
	UIWindow *_window;
	UIWindow *_shieldWindow;
	bool _horizontal;
	Common::Rect32 _responseArea;
	int32 _verticalAlign;
	TTextAlign _align;
	bool loadFile(const char *filename);
	bool loadBuffer(char *buffer, bool complete = true);
	bool saveAsText(BaseDynamicBuffer *buffer, int indent) override;
};

} // End of namespace Wintermute

#endif
